/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;

public class WrapperFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix1D content;

    public WrapperFComplexMatrix1D(FComplexMatrix1D newContent) {
        if (newContent != null) {
            this.setUp((int)newContent.size());
        }
        this.content = newContent;
    }

    @Override
    protected FComplexMatrix1D getContent() {
        return this.content;
    }

    @Override
    public synchronized float[] getQuick(int index) {
        return this.content.getQuick(index);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public FComplexMatrix1D like(int size) {
        return this.content.like(size);
    }

    @Override
    public FComplexMatrix2D like2D(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    @Override
    public FComplexMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public FComplexMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public synchronized void setQuick(int index, float[] value) {
        this.content.setQuick(index, value);
    }

    @Override
    public synchronized void setQuick(int index, float re, float im) {
        this.content.setQuick(index, re, im);
    }

    @Override
    public FComplexMatrix1D viewFlip() {
        WrapperFComplexMatrix1D view = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int index) {
                return this.content.getQuick(this.size - 1 - index);
            }

            @Override
            public synchronized void setQuick(int index, float[] value) {
                this.content.setQuick(this.size - 1 - index, value);
            }

            @Override
            public synchronized void setQuick(int index, float re, float im) {
                this.content.setQuick(this.size - 1 - index, re, im);
            }

            @Override
            public synchronized float[] get(int index) {
                return this.content.get(this.size - 1 - index);
            }

            @Override
            public synchronized void set(int index, float[] value) {
                this.content.set(this.size - 1 - index, value);
            }

            @Override
            public synchronized void set(int index, float re, float im) {
                this.content.set(this.size - 1 - index, re, im);
            }
        };
        return view;
    }

    @Override
    public FComplexMatrix1D viewPart(final int index, int width) {
        this.checkRange(index, width);
        WrapperFComplexMatrix1D view = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int i) {
                return this.content.getQuick(index + i);
            }

            @Override
            public synchronized void setQuick(int i, float[] value) {
                this.content.setQuick(index + i, value);
            }

            @Override
            public synchronized void setQuick(int i, float re, float im) {
                this.content.setQuick(index + i, re, im);
            }

            @Override
            public synchronized float[] get(int i) {
                return this.content.get(index + i);
            }

            @Override
            public synchronized void set(int i, float[] value) {
                this.content.set(index + i, value);
            }

            @Override
            public synchronized void set(int i, float re, float im) {
                this.content.set(index + i, re, im);
            }
        };
        view.size = width;
        return view;
    }

    @Override
    public FComplexMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        final int[] idx = indexes;
        WrapperFComplexMatrix1D view = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int i) {
                return this.content.getQuick(idx[i]);
            }

            @Override
            public synchronized void setQuick(int i, float[] value) {
                this.content.setQuick(idx[i], value);
            }

            @Override
            public synchronized void setQuick(int i, float re, float im) {
                this.content.setQuick(idx[i], re, im);
            }

            @Override
            public synchronized float[] get(int i) {
                return this.content.get(idx[i]);
            }

            @Override
            public synchronized void set(int i, float[] value) {
                this.content.set(idx[i], value);
            }

            @Override
            public synchronized void set(int i, float re, float im) {
                this.content.set(idx[i], re, im);
            }
        };
        view.size = indexes.length;
        return view;
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }

    @Override
    public FComplexMatrix1D viewStrides(final int _stride) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperFComplexMatrix1D view = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int index) {
                return this.content.getQuick(index * _stride);
            }

            @Override
            public synchronized void setQuick(int index, float[] value) {
                this.content.setQuick(index * _stride, value);
            }

            @Override
            public synchronized void setQuick(int index, float re, float im) {
                this.content.setQuick(index * _stride, re, im);
            }

            @Override
            public synchronized float[] get(int index) {
                return this.content.get(index * _stride);
            }

            @Override
            public synchronized void set(int index, float[] value) {
                this.content.set(index * _stride, value);
            }

            @Override
            public synchronized void set(int index, float re, float im) {
                this.content.set(index * _stride, re, im);
            }
        };
        if (this.size != 0) {
            view.size = (this.size - 1) / _stride + 1;
        }
        return view;
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        return this.content.getImaginaryPart();
    }

    @Override
    public FloatMatrix1D getRealPart() {
        return this.content.getRealPart();
    }
}

