/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.IJ;
import ij.gui.GenericDialog;
import loci.formats.UpgradeChecker;
import loci.plugins.BF;
import loci.plugins.Updater;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;

public class UpgradeDialog
extends ImporterDialog {
    private static boolean checkPerformed = false;

    public UpgradeDialog(ImportProcess process) {
        super(process);
    }

    @Override
    protected boolean needPrompt() {
        return !this.options.isQuiet() && !this.process.isWindowless();
    }

    @Override
    protected GenericDialog constructDialog() {
        return null;
    }

    @Override
    protected boolean displayDialog(GenericDialog gd) {
        if (checkPerformed) {
            return true;
        }
        if (!this.options.isQuiet() && this.options.isFirstTime()) {
            gd = new GenericDialog("Bio-Formats Upgrade Checker");
            gd.addMessage("One-time notice: The Bio-Formats plugins for ImageJ can automatically check for upgrades\neach time they are run. If you wish to disable this feature, uncheck the box below.\nYou can toggle this behavior later in the Bio-Formats Plugins Configuration's \"Upgrade\" tab.");
            this.addCheckbox(gd, "upgradeCheck");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            boolean checkForUpgrades = gd.getNextBoolean();
            this.options.setUpgradeCheck(checkForUpgrades);
            if (!checkForUpgrades) {
                return true;
            }
        }
        if (this.options.doUpgradeCheck()) {
            boolean doUpgrade;
            UpgradeChecker checker = new UpgradeChecker();
            checkPerformed = true;
            BF.status(false, "Checking for new stable version...");
            if (checker.newVersionAvailable("ImageJ") && !Updater.isFiji() && (doUpgrade = IJ.showMessageWithCancel((String)"", (String)"A new stable version of Bio-Formats is available.\nClick 'OK' to upgrade now, or 'Cancel' to skip for now."))) {
                Updater.install("http://downloads.openmicroscopy.org/bio-formats/5.9.2/artifacts/bioformats_package.jar");
            }
        }
        return true;
    }

    @Override
    protected boolean harvestResults(GenericDialog gd) {
        return true;
    }
}

