/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util.listenable;

import com.ochafik.util.listenable.CollectionEvent;
import com.ochafik.util.listenable.CollectionListener;
import com.ochafik.util.listenable.ListenableCollection;
import java.util.ArrayList;
import java.util.Collection;

public class ListenableSupport<T> {
    protected Collection<CollectionListener<T>> listeners;

    public void addCollectionListener(CollectionListener<T> l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CollectionListener<T>>(1);
        }
        this.listeners.add(l);
    }

    public void removeCollectionListener(CollectionListener<T> l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void fireEvent(ListenableCollection<T> source, Collection<T> elements, CollectionEvent.EventType type, int firstIndex, int lastIndex) {
        if (this.listeners == null || this.listeners.isEmpty() || elements.isEmpty()) {
            return;
        }
        CollectionEvent<T> event = new CollectionEvent<T>(source, elements, type, firstIndex, lastIndex);
        for (CollectionListener<T> listener : this.listeners) {
            listener.collectionChanged(event);
        }
    }

    public void fireAdded(ListenableCollection<T> source, Collection<T> elements) {
        this.fireEvent(source, elements, CollectionEvent.EventType.ADDED, -1, -1);
    }

    public void fireAdded(ListenableCollection<T> source, Collection<T> elements, int firstIndex, int lastIndex) {
        this.fireEvent(source, elements, CollectionEvent.EventType.ADDED, firstIndex, lastIndex);
    }

    public void fireRemoved(ListenableCollection<T> source, Collection<T> elements) {
        this.fireEvent(source, elements, CollectionEvent.EventType.REMOVED, -1, -1);
    }

    public void fireRemoved(ListenableCollection<T> source, Collection<T> elements, int firstIndex, int lastIndex) {
        this.fireEvent(source, elements, CollectionEvent.EventType.REMOVED, firstIndex, lastIndex);
    }

    public void fireUpdated(ListenableCollection<T> source, Collection<T> elements) {
        this.fireEvent(source, elements, CollectionEvent.EventType.UPDATED, -1, -1);
    }

    public void fireUpdated(ListenableCollection<T> source, Collection<T> elements, int firstIndex, int lastIndex) {
        this.fireEvent(source, elements, CollectionEvent.EventType.UPDATED, firstIndex, lastIndex);
    }
}

