/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedBin;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;

class OrderedGroupRetained
extends GroupRetained {
    int[] orderedChildIdTable;
    private int orderedChildIdCount = 0;
    private ArrayList orderedChildIdFreeList = new ArrayList();
    OrderedBin[] orderedBin = new OrderedBin[0];
    Integer newChildId;
    int childCount = 0;
    ArrayList childrenOrderedPaths = new ArrayList(1);
    int[] userChildIndexOrder = null;
    int[] childIndexOrder = null;

    OrderedGroupRetained() {
        this.nodeType = 20;
    }

    void setChildIndexOrder(int[] nArray) {
        if (nArray != null) {
            if (this.userChildIndexOrder == null || this.userChildIndexOrder.length != nArray.length) {
                this.userChildIndexOrder = new int[nArray.length];
            }
            System.arraycopy(nArray, 0, this.userChildIndexOrder, 0, this.userChildIndexOrder.length);
        } else {
            this.userChildIndexOrder = null;
        }
        if (this.source.isLive()) {
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 59;
            j3dMessage.universe = this.universe;
            j3dMessage.args[3] = this;
            j3dMessage.args[4] = nArray2;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    int[] getChildIndexOrder() {
        if (this.userChildIndexOrder == null) {
            return null;
        }
        int[] nArray = new int[this.userChildIndexOrder.length];
        System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getOrderedChildId() {
        Integer n;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            if (this.orderedChildIdFreeList.size() == 0) {
                n = new Integer(this.orderedChildIdCount);
                ++this.orderedChildIdCount;
            } else {
                n = (Integer)this.orderedChildIdFreeList.remove(0);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeOrderedChildId(int n) {
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            this.orderedChildIdFreeList.add(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOrderedChildCount() {
        int n;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            n = this.orderedChildIdCount;
        }
        return n;
    }

    void addChild(Node node) {
        if (this.userChildIndexOrder != null) {
            this.doAddChildIndexEntry();
        }
        super.addChild(node);
    }

    void addChild(Node node, int[] nArray) {
        if (nArray != null) {
            this.userChildIndexOrder = new int[nArray.length];
            System.arraycopy(nArray, 0, this.userChildIndexOrder, 0, this.userChildIndexOrder.length);
        } else {
            this.userChildIndexOrder = null;
        }
        super.addChild(node);
    }

    void moveTo(BranchGroup branchGroup) {
        if (this.userChildIndexOrder != null) {
            this.doAddChildIndexEntry();
        }
        super.moveTo(branchGroup);
    }

    void doRemoveChildIndexEntry(int n) {
        int[] nArray = new int[this.userChildIndexOrder.length - 1];
        int n2 = 0;
        for (int i = 0; i < this.userChildIndexOrder.length; ++i) {
            if (this.userChildIndexOrder[i] > n) {
                nArray[n2] = this.userChildIndexOrder[i] - 1;
                ++n2;
                continue;
            }
            if (this.userChildIndexOrder[i] >= n) continue;
            nArray[n2] = this.userChildIndexOrder[i];
            ++n2;
        }
        this.userChildIndexOrder = nArray;
    }

    void doAddChildIndexEntry() {
        int[] nArray = new int[this.userChildIndexOrder.length + 1];
        System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
        nArray[this.userChildIndexOrder.length] = this.userChildIndexOrder.length;
        this.userChildIndexOrder = nArray;
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        this.mergeFlag = 0;
        if (J3dDebug.debug) {
            ++compileState.numOrderedGroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOrderedBin(OrderedBin orderedBin, int n) {
        OrderedBin[] orderedBinArray = this.orderedBin;
        synchronized (this.orderedBin) {
            this.orderedBin[n] = orderedBin;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrderedBin getOrderedBin(int n) {
        OrderedBin[] orderedBinArray = this.orderedBin;
        synchronized (this.orderedBin) {
            if (n >= this.orderedBin.length) {
                OrderedBin[] orderedBinArray2 = new OrderedBin[n + 1];
                for (int i = 0; i < this.orderedBin.length; ++i) {
                    orderedBinArray2[i] = this.orderedBin[i];
                }
                orderedBinArray2[n] = null;
                this.orderedBin = orderedBinArray2;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return this.orderedBin[n];
        }
    }

    void updateChildIdTableInserted(int n, int n2) {
        int n3;
        int n4 = 0;
        if (this.orderedChildIdTable != null) {
            n4 = this.orderedChildIdTable.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.orderedChildIdTable[n3] == -1 || this.orderedChildIdTable[n3] < n) continue;
                int n5 = n3;
                this.orderedChildIdTable[n5] = this.orderedChildIdTable[n5] + 1;
            }
        }
        if (n2 >= n4) {
            int[] nArray = new int[n2 + 1];
            if (n4 > 0) {
                System.arraycopy(this.orderedChildIdTable, 0, nArray, 0, this.orderedChildIdTable.length);
            } else {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    nArray[n3] = -1;
                }
            }
            this.orderedChildIdTable = nArray;
        }
        this.orderedChildIdTable[n2] = n;
    }

    void updateChildIdTableRemoved(int n) {
        if (this.orderedChildIdTable == null) {
            return;
        }
        for (int i = 0; i < this.orderedChildIdTable.length; ++i) {
            if (this.orderedChildIdTable[i] == -1) continue;
            if (this.orderedChildIdTable[i] > n) {
                int n2 = i;
                this.orderedChildIdTable[n2] = this.orderedChildIdTable[n2] - 1;
                continue;
            }
            if (this.orderedChildIdTable[i] != n) continue;
            this.orderedChildIdTable[i] = -1;
            this.freeOrderedChildId(i);
        }
    }

    void setAuxData(SetLiveState setLiveState, int n, int n2) {
        OrderedPath orderedPath = (OrderedPath)setLiveState.orderedPaths.get(n2);
        for (int i = 0; i < this.children.size(); ++i) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(i);
            if (this.refCount == setLiveState.refCount) {
                nodeRetained.orderedId = this.getOrderedChildId();
            }
            OrderedPath orderedPath2 = orderedPath.clonePath();
            orderedPath2.addElementToPath(this, nodeRetained.orderedId);
            ArrayList arrayList = (ArrayList)this.childrenOrderedPaths.get(i);
            arrayList.add(n2, orderedPath2);
        }
    }

    void setLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
        setLiveState.orderedPaths = this.orderedPaths;
        if (this.userChildIndexOrder != null && this.refCount == 1) {
            int[] nArray = new int[this.userChildIndexOrder.length];
            System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
            this.childIndexOrder = nArray;
        }
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (this.refCount == 0) {
            setLiveState.notifyThreads |= 0x1000;
            setLiveState.nodeList.add(this);
            setLiveState.ogCIOList.add(this);
            setLiveState.ogCIOTableList.add(null);
            this.userChildIndexOrder = null;
        }
        setLiveState.orderedPaths = this.orderedPaths;
    }

    void setNodeData(SetLiveState setLiveState) {
        super.setNodeData(setLiveState);
        if (!this.inSharedGroup) {
            this.setAuxData(setLiveState, 0, 0);
        } else {
            for (int i = 0; i < setLiveState.keys.length; ++i) {
                int n = setLiveState.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n >= 0) {
                    this.setAuxData(setLiveState, i, n);
                    continue;
                }
                MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
            }
        }
    }

    void removeNodeData(SetLiveState setLiveState) {
        if (this.inSharedGroup && setLiveState.keys.length != this.localToVworld.length) {
            for (int i = setLiveState.keys.length - 1; i >= 0; --i) {
                int n = setLiveState.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n < 0) continue;
                for (int j = 0; j < this.children.size(); ++j) {
                    ArrayList arrayList = (ArrayList)this.childrenOrderedPaths.get(j);
                    arrayList.remove(n);
                }
            }
        }
        super.removeNodeData(setLiveState);
    }

    void clearDerivedDataStructures() {
        int n;
        for (n = 0; n < this.orderedBin.length; ++n) {
            if (this.orderedBin[n] == null) continue;
            this.orderedBin[n].source = null;
            this.orderedBin[n] = null;
        }
        if (this.orderedChildIdTable != null) {
            for (n = 0; n < this.orderedChildIdTable.length; ++n) {
                if (this.orderedChildIdTable[n] == -1) continue;
                this.orderedChildIdTable[n] = -1;
                this.freeOrderedChildId(n);
            }
            this.orderedChildIdTable = null;
        }
    }

    void incrChildCount() {
        ++this.childCount;
    }

    void decrChildCount() {
        --this.childCount;
    }

    void printTable(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            System.err.print(" " + nArray[i]);
        }
        System.err.println("");
    }

    void insertChildrenData(int n) {
        this.childrenOrderedPaths.add(n, new ArrayList(1));
    }

    void appendChildrenData() {
        this.childrenOrderedPaths.add(new ArrayList(1));
    }

    void doRemoveChild(int n, J3dMessage[] j3dMessageArray, int n2) {
        if (this.userChildIndexOrder != null) {
            this.doRemoveChildIndexEntry(n);
        }
        super.doRemoveChild(n, j3dMessageArray, n2);
    }

    void removeChildrenData(int n) {
        this.childrenOrderedPaths.remove(n);
    }

    void childDoSetLive(NodeRetained nodeRetained, int n, SetLiveState setLiveState) {
        if (this.refCount == setLiveState.refCount) {
            setLiveState.ogList.add(this);
            setLiveState.ogChildIdList.add(new Integer(n));
            setLiveState.ogOrderedIdList.add(nodeRetained.orderedId);
        }
        setLiveState.orderedPaths = (ArrayList)this.childrenOrderedPaths.get(n);
        if (nodeRetained != null) {
            nodeRetained.setLive(setLiveState);
        }
    }

    void childCheckSetLive(NodeRetained nodeRetained, int n, SetLiveState setLiveState, NodeRetained nodeRetained2) {
        ArrayList arrayList;
        if (nodeRetained2 != null) {
            int n2 = this.children.indexOf(nodeRetained2);
            arrayList = (ArrayList)this.childrenOrderedPaths.get(n2);
        } else {
            nodeRetained.orderedId = this.getOrderedChildId();
            setLiveState.ogList.add(this);
            setLiveState.ogChildIdList.add(new Integer(n));
            setLiveState.ogOrderedIdList.add(nodeRetained.orderedId);
            if (this.userChildIndexOrder != null) {
                setLiveState.ogCIOList.add(this);
                int[] nArray = new int[this.userChildIndexOrder.length];
                System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
                setLiveState.ogCIOTableList.add(nArray);
            }
            arrayList = (ArrayList)this.childrenOrderedPaths.get(n);
            for (int i = 0; i < this.orderedPaths.size(); ++i) {
                OrderedPath orderedPath = ((OrderedPath)this.orderedPaths.get(i)).clonePath();
                orderedPath.addElementToPath(this, nodeRetained.orderedId);
                arrayList.add(orderedPath);
            }
        }
        setLiveState.orderedPaths = arrayList;
        nodeRetained.setLive(setLiveState);
    }
}

