/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.microUtils;

import microTiPi.microscopy.MicroscopeModel;
import microTiPi.microscopy.PSF_Estimation;
import mitiv.array.ArrayUtils;
import mitiv.array.ShapedArray;
import mitiv.jobs.DeconvolutionJob;

public class BlindDeconvJob {
    private int totalNbOfBlindDecLoop;
    private ShapedArray psfArray;
    private boolean debug = false;
    private PSF_Estimation psfEstimation;
    private DeconvolutionJob deconvolver;
    private int[] parametersFlags;
    private boolean run = false;
    private int[] maxIter;

    public BlindDeconvJob(int totalNbOfBlindDecLoop, int[] parametersFlags, int[] maxIter, PSF_Estimation psfEstimation, DeconvolutionJob deconvolver, boolean debug) {
        this.totalNbOfBlindDecLoop = totalNbOfBlindDecLoop;
        this.parametersFlags = parametersFlags;
        this.maxIter = maxIter;
        this.psfEstimation = psfEstimation;
        this.deconvolver = deconvolver;
        this.debug = debug;
    }

    public ShapedArray blindDeconv(ShapedArray objArray) {
        this.run = true;
        for (int i = 0; i < this.totalNbOfBlindDecLoop; ++i) {
            this.psfArray = ArrayUtils.roll((ShapedArray)this.psfEstimation.getPupil().getPsf());
            this.psfEstimation.freeMem();
            this.deconvolver.updatePsf(this.psfArray);
            objArray = this.deconvolver.deconv(objArray);
            if (!this.run) {
                return objArray;
            }
            this.psfEstimation.setObj(objArray);
            for (int j = 0; j < this.parametersFlags.length; ++j) {
                if (this.debug) {
                    System.out.println("------------------");
                    System.out.println("  " + j + " estimation");
                    System.out.println("------------------");
                }
                this.psfEstimation.setRelativeTolerance(0.0);
                this.psfEstimation.setMaximumIterations(this.maxIter[j]);
                this.psfEstimation.fitPSF(this.parametersFlags[j]);
                if (this.run) continue;
                return objArray;
            }
        }
        this.run = false;
        return objArray;
    }

    public boolean isRunning() {
        return this.run;
    }

    public void abort() {
        System.out.println("abort");
        this.run = false;
        this.deconvolver.abort();
        this.psfEstimation.abort();
    }

    public ShapedArray getPsf() {
        return this.psfArray;
    }

    public MicroscopeModel getPupil() {
        return this.psfEstimation.getPupil();
    }
}

