/* The following code was generated by JFlex 1.4.1 on 2/1/08 1:33 PM */

/*
 * 12/06/2004
 *
 * AssemblerX86TokenMaker.java - An object that can take a chunk of text and
 * return a linked list of tokens representing X86 assembler.
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * This class takes plain text and returns tokens representing x86
 * assembler.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated AssemblerX86TokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.2
 *
 */

public class AssemblerX86TokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\10\1\7\1\0\1\10\23\0\1\10\1\14\1\4\2\0"+
    "\1\13\1\14\1\5\2\0\1\12\1\12\1\3\1\12\1\15\1\12"+
    "\1\27\1\16\1\21\1\24\1\25\1\26\1\20\1\23\1\17\1\2"+
    "\1\11\1\6\1\14\1\14\1\14\1\50\1\0\1\30\1\33\1\40"+
    "\1\42\1\35\1\47\1\51\1\32\1\45\1\1\1\36\1\31\1\55"+
    "\1\43\1\41\1\22\1\56\1\34\1\37\1\44\1\46\1\61\1\52"+
    "\1\54\1\60\1\53\1\3\1\0\1\3\1\14\1\57\1\0\1\30"+
    "\1\33\1\40\1\42\1\35\1\47\1\51\1\32\1\45\1\1\1\36"+
    "\1\31\1\55\1\43\1\41\1\22\1\56\1\34\1\37\1\44\1\46"+
    "\1\61\1\52\1\54\1\60\1\53\1\0\1\14\1\0\1\14\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\2\1\1\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\32\1\1\11\1\1\1\12\5\13\2\1\1\14"+
    "\1\15\25\0\16\1\2\16\23\1\1\13\11\1\1\16"+
    "\14\1\2\16\7\1\1\16\10\1\1\13\4\1\1\11"+
    "\3\1\1\16\1\1\1\11\15\1\1\13\1\12\13\1"+
    "\1\16\42\1\31\0\1\12\11\0\20\1\1\13\1\12"+
    "\14\1\2\13\3\1\1\13\4\1\1\12\6\1\1\13"+
    "\3\1\1\13\5\1\1\12\5\1\1\13\4\1\1\12"+
    "\1\1\1\13\2\1\1\13\10\1\1\13\4\1\1\13"+
    "\4\1\1\13\5\1\1\12\3\1\3\13\24\1\1\13"+
    "\37\1\1\13\3\1\1\13\3\1\1\0\1\12\10\0"+
    "\1\12\17\0\3\1\1\13\11\1\1\13\14\1\2\13"+
    "\1\1\1\17\1\13\3\1\2\12\10\1\1\12\7\1"+
    "\1\12\1\13\12\1\1\12\15\1\1\13\5\1\2\13"+
    "\1\1\1\13\14\1\1\13\3\1\1\13\4\1\1\0"+
    "\1\12\3\0\1\12\5\0\1\12\5\0\16\1\1\12"+
    "\5\1\1\12\16\1\1\12\1\1\1\13\4\1\1\13"+
    "\1\1\1\13\4\1\7\0\1\12\7\1\2\12\10\1"+
    "\1\0\1\12\2\0\1\12\1\0\4\1\1\12\1\1"+
    "\3\0\2\1\2\0\1\1\1\12\2\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[668];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\62\0\144\0\226\0\310\0\372\0\u012c\0\u015e"+
    "\0\144\0\u0190\0\144\0\u01c2\0\u01f4\0\u0226\0\u0258\0\u028a"+
    "\0\u02bc\0\u02ee\0\u0320\0\u0352\0\u0384\0\u03b6\0\u03e8\0\u041a"+
    "\0\u044c\0\u047e\0\u04b0\0\u04e2\0\u0514\0\u0546\0\u0578\0\u05aa"+
    "\0\u05dc\0\u060e\0\u0640\0\u0672\0\u06a4\0\u06d6\0\u0708\0\u0708"+
    "\0\u073a\0\u076c\0\u079e\0\u0352\0\u07d0\0\u0802\0\u0834\0\144"+
    "\0\144\0\u0866\0\u0898\0\u08ca\0\u08fc\0\u092e\0\u0960\0\u0992"+
    "\0\u09c4\0\u09f6\0\u0a28\0\u0a5a\0\u0a8c\0\u0abe\0\u0af0\0\u0b22"+
    "\0\u0b54\0\u0b86\0\u0bb8\0\u0bea\0\u0c1c\0\u0c4e\0\u0c80\0\u0cb2"+
    "\0\u0ce4\0\u0d16\0\u0d48\0\u0d7a\0\u0dac\0\u0dde\0\u0e10\0\u0e42"+
    "\0\u0e74\0\u0ea6\0\u0ed8\0\u0f0a\0\u0f3c\0\u0352\0\u0f6e\0\u0fa0"+
    "\0\u0fd2\0\u1004\0\u1036\0\u1068\0\u109a\0\u10cc\0\u10fe\0\u1130"+
    "\0\u1162\0\u1194\0\u11c6\0\u11f8\0\u122a\0\u125c\0\u128e\0\u12c0"+
    "\0\u12f2\0\u1324\0\u1356\0\u1388\0\u13ba\0\u13ec\0\u141e\0\u1450"+
    "\0\u1482\0\u14b4\0\u14e6\0\u1518\0\u154a\0\u157c\0\u15ae\0\u15e0"+
    "\0\u1612\0\u1644\0\u1676\0\u16a8\0\u16da\0\u170c\0\u173e\0\u1770"+
    "\0\u17a2\0\u17d4\0\u1806\0\u1838\0\u186a\0\u189c\0\u18ce\0\u1900"+
    "\0\u1932\0\u1964\0\u1996\0\u19c8\0\u19fa\0\u1a2c\0\u1a5e\0\u1a90"+
    "\0\u1ac2\0\u1af4\0\u1b26\0\u1b58\0\u1b8a\0\u1bbc\0\u1bee\0\u0352"+
    "\0\u1c20\0\u1c52\0\u1c84\0\u1cb6\0\u1ce8\0\u186a\0\u1d1a\0\u1d4c"+
    "\0\u1d7e\0\u1db0\0\u1de2\0\u1e14\0\u1e46\0\u1e78\0\u1eaa\0\u1edc"+
    "\0\u1f0e\0\u1f40\0\u1f72\0\u1fa4\0\u1fd6\0\u2008\0\u203a\0\u206c"+
    "\0\u209e\0\u20d0\0\u2102\0\u2134\0\u2166\0\u2198\0\u21ca\0\u21fc"+
    "\0\u222e\0\u2260\0\u2292\0\u22c4\0\u22f6\0\u2328\0\u235a\0\u238c"+
    "\0\u23be\0\u23f0\0\u2422\0\u2454\0\u2486\0\u24b8\0\u24ea\0\u251c"+
    "\0\u254e\0\u2580\0\u25b2\0\u25e4\0\u2616\0\u2648\0\u267a\0\u26ac"+
    "\0\u26de\0\u2710\0\u2742\0\u2774\0\u27a6\0\u27d8\0\u280a\0\u283c"+
    "\0\u286e\0\u07d0\0\u28a0\0\u28d2\0\u2904\0\u2936\0\u2968\0\u299a"+
    "\0\u29cc\0\u29fe\0\u2a30\0\u2a62\0\u2a94\0\u2ac6\0\u2af8\0\u2b2a"+
    "\0\u2b5c\0\u2b8e\0\u2bc0\0\u2bf2\0\u2c24\0\u2c56\0\u2c88\0\u2cba"+
    "\0\u2cec\0\u2d1e\0\u2d50\0\u2d82\0\144\0\u2db4\0\u2de6\0\u2e18"+
    "\0\u2e4a\0\u2e7c\0\u2eae\0\u2ee0\0\u2f12\0\u2f44\0\u2f76\0\u2fa8"+
    "\0\u2fda\0\u300c\0\u303e\0\u3070\0\u30a2\0\u30d4\0\u3106\0\u3138"+
    "\0\u316a\0\u319c\0\u31ce\0\u3200\0\u3232\0\u3264\0\u3296\0\u0352"+
    "\0\u32c8\0\u32fa\0\u332c\0\u335e\0\u3390\0\u33c2\0\u33f4\0\u3426"+
    "\0\u3458\0\u348a\0\u34bc\0\u34ee\0\u3520\0\u3552\0\u3584\0\u35b6"+
    "\0\u35e8\0\u361a\0\u364c\0\u367e\0\u36b0\0\u36e2\0\u3714\0\u3746"+
    "\0\u3778\0\u37aa\0\u37dc\0\u380e\0\u3840\0\u3872\0\u38a4\0\u38d6"+
    "\0\u3908\0\u393a\0\u396c\0\u399e\0\u39d0\0\u3a02\0\u3a34\0\u3a66"+
    "\0\u3a98\0\u3aca\0\u3afc\0\u3b2e\0\u3b60\0\u3b92\0\u3bc4\0\u3bf6"+
    "\0\u3c28\0\u3c5a\0\u3c8c\0\u3cbe\0\u3cf0\0\u3d22\0\u3d54\0\u3d86"+
    "\0\u3db8\0\u3dea\0\u3e1c\0\u3e4e\0\u3e80\0\u3eb2\0\u3ee4\0\u3f16"+
    "\0\u3f48\0\u3f7a\0\u3fac\0\u3fde\0\u4010\0\u36e2\0\u4042\0\u4074"+
    "\0\u40a6\0\u40d8\0\u410a\0\u413c\0\u416e\0\u41a0\0\u41d2\0\u4204"+
    "\0\u4236\0\u4268\0\u429a\0\u42cc\0\u42fe\0\u4330\0\u4362\0\u4394"+
    "\0\u43c6\0\u43f8\0\u442a\0\u445c\0\u448e\0\u44c0\0\u44f2\0\u4524"+
    "\0\u4556\0\u4588\0\u45ba\0\u45ec\0\u461e\0\u3b92\0\u4650\0\u4682"+
    "\0\u46b4\0\u361a\0\u46e6\0\u4718\0\u474a\0\u477c\0\u47ae\0\u47e0"+
    "\0\u4812\0\u4844\0\u4876\0\u48a8\0\u48da\0\u490c\0\u493e\0\u4970"+
    "\0\u49a2\0\u49d4\0\u4a06\0\u4a38\0\u4a6a\0\u4a9c\0\u4ace\0\u4b00"+
    "\0\u4b32\0\u4b64\0\u4b96\0\u4bc8\0\u4bfa\0\u4c2c\0\u4c5e\0\u4c90"+
    "\0\u4cc2\0\u4cf4\0\u4d26\0\u4d58\0\u4d8a\0\u4dbc\0\u410a\0\u4dee"+
    "\0\u4e20\0\u4e52\0\u4e84\0\u4eb6\0\u4ee8\0\u4f1a\0\u4f4c\0\u4f7e"+
    "\0\u4fb0\0\u4fe2\0\u5014\0\u5046\0\u5078\0\u50aa\0\u50dc\0\u510e"+
    "\0\u5140\0\u5172\0\u51a4\0\u51d6\0\u5208\0\u523a\0\u526c\0\u529e"+
    "\0\u52d0\0\u5302\0\u5334\0\u5366\0\u5398\0\u53ca\0\u53fc\0\u542e"+
    "\0\u5460\0\u5492\0\u54c4\0\u54f6\0\u5528\0\u555a\0\u558c\0\u55be"+
    "\0\u55f0\0\u5622\0\u55f0\0\u5654\0\u5686\0\u56b8\0\u56ea\0\u571c"+
    "\0\u574e\0\u5780\0\u57b2\0\u4d58\0\u57e4\0\u076c\0\u5816\0\u5848"+
    "\0\u587a\0\u58ac\0\u0352\0\u58de\0\u5910\0\u5942\0\u5974\0\u59a6"+
    "\0\u1f40\0\u59d8\0\u5a0a\0\u5a3c\0\u5a6e\0\u5aa0\0\u5ad2\0\u5b04"+
    "\0\u5b36\0\u5b68\0\u5b9a\0\u5bcc\0\u5bfe\0\u5c30\0\u5c62\0\u5c94"+
    "\0\u5cc6\0\u5cf8\0\u5d2a\0\u5d5c\0\u5d8e\0\u5dc0\0\u5df2\0\u5e24"+
    "\0\u5e56\0\u5e88\0\u5eba\0\u5eec\0\u5f1e\0\u5f50\0\u5f82\0\u5fb4"+
    "\0\u5fe6\0\u6018\0\u604a\0\u607c\0\u60ae\0\u60e0\0\u6112\0\u6144"+
    "\0\u6176\0\u61a8\0\u5460\0\u0834\0\u61da\0\u620c\0\u623e\0\u6270"+
    "\0\u62a2\0\u62d4\0\u6306\0\u6338\0\u636a\0\u639c\0\u63ce\0\u6400"+
    "\0\u6432\0\u6464\0\u6496\0\u64c8\0\u64fa\0\u652c\0\u655e\0\u6590"+
    "\0\u65c2\0\u65f4\0\u6626\0\u6658\0\u668a\0\u66bc\0\u66ee\0\u6720"+
    "\0\u6752\0\u6784\0\u67b6\0\u67e8\0\u681a\0\u684c\0\u687e\0\u68b0"+
    "\0\u68e2\0\u6914\0\u6946\0\u6978\0\u69aa\0\u69dc\0\u6a0e\0\u6a40"+
    "\0\u6a72\0\u6aa4\0\u6ad6\0\u6b08\0\u6b3a\0\u6b6c\0\u6b9e\0\u6bd0"+
    "\0\u6c02\0\u6c34\0\u6c66\0\u4236\0\u6c98\0\u6cca\0\u65f4\0\u6cfc"+
    "\0\u6d2e\0\u6d60\0\u6d92\0\u6dc4\0\u6df6\0\u6e28\0\u6e5a\0\u5a6e"+
    "\0\u6e8c\0\u6ebe\0\u6ef0\0\u6f22\0\u6f54\0\u6f86\0\u6fb8\0\u6fea"+
    "\0\u701c\0\u704e\0\u7080\0\u70b2\0\u70e4\0\u7116\0\u7148\0\u717a"+
    "\0\u61da\0\u71ac\0\u71de\0\u7210\0\u7242\0\u1194\0\u7274\0\u72a6"+
    "\0\u72d8\0\u730a\0\u733c\0\u736e\0\u73a0\0\u73d2\0\u7404\0\u7436"+
    "\0\u7468\0\u749a\0\u74cc\0\u74fe\0\u7530\0\u7562\0\u7594\0\u587a"+
    "\0\u75c6\0\u75f8\0\u762a\0\u765c\0\u768e\0\u76c0\0\u76f2\0\u7724"+
    "\0\u7756\0\u7788\0\u77ba\0\u77ec\0\u781e\0\u7850\0\u7882\0\u4ee8"+
    "\0\u78b4\0\u78e6\0\u7918\0\u794a\0\u797c\0\u79ae\0\u79e0\0\u7a12"+
    "\0\u7a44\0\u7a76\0\u7aa8\0\u7ada\0\u7b0c\0\u7b3e\0\u7b70\0\u7ba2"+
    "\0\u6d60\0\u7bd4\0\u7c06\0\u7c38";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[668];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\1\5\1\3\1\6\1\7\1\10\1\11"+
    "\1\12\1\3\3\13\1\14\4\5\1\15\5\5\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\3"+
    "\1\36\1\37\1\40\1\41\1\42\1\43\1\44\1\24"+
    "\1\45\1\3\1\4\1\5\1\3\1\6\1\7\1\10"+
    "\1\11\1\12\1\3\1\13\1\46\1\13\1\14\4\5"+
    "\1\15\5\5\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\30\1\31\1\32\1\33"+
    "\1\34\1\35\1\3\1\36\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\24\1\45\62\0\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\4\24\1\51"+
    "\5\24\2\52\1\24\1\52\1\24\1\53\1\24\1\54"+
    "\1\55\1\54\1\24\1\56\4\24\1\47\1\52\1\24"+
    "\1\54\1\24\1\57\4\24\1\47\1\24\1\5\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\4\5\1\24"+
    "\5\5\20\24\1\47\11\24\4\6\1\60\55\6\5\7"+
    "\1\61\54\7\7\10\1\0\52\10\10\0\1\12\67\0"+
    "\1\62\1\63\1\64\1\65\2\0\1\65\2\64\1\0"+
    "\1\66\1\67\1\0\1\70\1\71\1\72\1\73\1\74"+
    "\1\75\1\0\1\76\1\77\1\100\1\101\1\102\1\103"+
    "\2\0\1\104\1\0\1\105\1\106\4\0\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\12\24"+
    "\1\107\3\24\1\110\1\111\1\24\1\112\1\113\1\114"+
    "\2\24\1\115\1\116\1\117\1\24\1\47\3\24\1\120"+
    "\1\121\4\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\1\122\5\24\1\123\3\24\1\124"+
    "\1\125\1\126\1\24\1\127\2\24\1\130\2\24\1\131"+
    "\1\132\4\24\1\47\3\24\1\126\5\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\12\24"+
    "\1\133\1\134\2\24\1\135\1\136\1\24\1\137\1\24"+
    "\1\140\1\141\1\24\1\142\1\134\1\24\1\143\1\47"+
    "\1\144\3\24\1\145\4\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\13\24\1\146\13\24"+
    "\1\147\2\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\4\24\1\126\6\24"+
    "\2\126\4\24\1\150\1\24\1\151\2\24\1\152\1\153"+
    "\2\24\1\47\3\24\1\126\3\24\1\154\1\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\17\24\1\155\1\24\1\156\2\157\1\160\5\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\12\24\1\161\1\162\1\24\1\163\3\24"+
    "\1\164\1\165\1\24\1\166\1\167\4\24\1\47\3\24"+
    "\1\170\1\171\1\172\2\24\1\173\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\32\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\4\24\1\126\5\24\1\174\1\134\1\175"+
    "\1\176\1\24\1\177\1\24\1\126\1\200\1\24\1\43"+
    "\1\24\1\201\1\202\1\203\1\204\1\47\1\134\1\205"+
    "\2\24\1\145\1\206\1\24\1\207\1\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\4\24"+
    "\1\210\5\24\1\211\1\212\1\126\1\213\1\214\2\24"+
    "\1\126\1\24\1\215\1\216\5\24\1\47\1\24\1\217"+
    "\1\24\1\126\1\220\3\24\1\221\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\1\122\3\24"+
    "\1\222\1\24\1\123\7\24\1\223\11\24\1\224\1\225"+
    "\1\47\10\24\1\226\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\12\24\1\227\2\126\1\230"+
    "\1\231\1\232\1\24\1\126\1\24\1\233\1\230\1\24"+
    "\1\230\1\234\1\235\1\230\1\47\1\24\1\236\1\24"+
    "\1\126\1\24\1\230\3\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\12\24\1\237\4\24"+
    "\1\240\3\24\1\241\6\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\14\24"+
    "\1\242\1\243\1\244\1\245\7\24\1\246\2\24\1\47"+
    "\1\24\1\205\5\24\1\247\1\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\16\24\1\250"+
    "\1\251\1\24\1\252\2\24\1\253\1\254\3\24\1\255"+
    "\1\47\4\24\1\256\4\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\15\24\1\257\3\24"+
    "\1\260\1\261\2\24\1\262\4\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\3\24\1\263\1\264\5\24\1\265\1\266\1\24\1\267"+
    "\1\270\2\24\1\271\1\272\1\273\1\274\1\275\1\276"+
    "\1\277\1\300\1\301\1\47\1\24\1\302\1\24\1\303"+
    "\1\304\2\24\1\305\1\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\13\24\1\306\2\24"+
    "\1\307\2\24\1\126\1\24\1\310\6\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\12\24\1\311\1\24\1\312\1\313\1\314\4\24"+
    "\1\315\6\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\17\24\1\316\12\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\12\24\1\317\1\320\6\24\1\321"+
    "\1\322\6\24\1\47\4\24\1\323\4\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\12\24"+
    "\1\324\10\24\1\325\3\24\1\326\1\327\1\24\1\47"+
    "\4\24\1\231\4\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\1\24\1\205"+
    "\7\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\32\24\1\47\6\24\1\330\2\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\17\24\1\331\12\24\1\47\11\24\1\0\2\46\13\0"+
    "\32\46\1\0\11\46\3\47\1\0\3\47\2\0\1\47"+
    "\2\0\1\47\1\0\45\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\17\24\1\54\3\24\1\54"+
    "\6\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\17\24\1\54\12\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\22\24\1\332\7\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\32\24\1\47\3\24\1\333\5\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\4\24\1\54"+
    "\5\24\2\52\1\24\1\52\1\24\1\54\1\24\3\54"+
    "\6\24\1\47\1\52\1\24\1\54\6\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\4\24"+
    "\1\54\25\24\1\47\11\24\17\0\1\334\71\0\1\335"+
    "\51\0\1\336\61\0\1\337\73\0\1\340\60\0\1\341"+
    "\14\0\1\342\1\0\1\343\46\0\1\344\2\0\1\345"+
    "\52\0\1\346\4\0\1\347\55\0\1\350\2\0\1\351"+
    "\6\0\1\352\10\0\1\353\31\0\1\354\65\0\1\341"+
    "\4\0\1\355\6\0\1\356\2\0\1\343\46\0\1\357"+
    "\4\0\1\360\50\0\1\361\10\0\1\362\61\0\1\363"+
    "\55\0\1\364\11\0\1\343\61\0\1\365\55\0\1\366"+
    "\46\0\1\367\63\0\1\370\57\0\1\341\1\371\6\0"+
    "\1\372\14\0\1\373\43\0\1\374\1\0\1\375\13\0"+
    "\1\376\4\0\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\16\24\1\377\3\24\1\u0100\1\24"+
    "\1\u0101\1\u0102\4\24\1\47\1\u0103\7\24\1\u0104\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\17\24\1\u0105\3\24\1\u0106\3\24\1\u0107\2\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\32\24\1\47\3\24\1\u0108\5\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\12\24\1\u0109\1\u010a\1\u010b\1\24\1\u010c\11\24\1\u010d"+
    "\1\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\4\24\1\u010e"+
    "\4\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\4\24\1\u010f\11\24\1\54\13\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\16\24\1\u0110\13\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\25\24\1\u0111\4\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\15\24\1\u0112"+
    "\1\u0113\2\24\1\u0114\3\24\1\u0115\4\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\23\24\1\142\6\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\12\24"+
    "\1\u0116\10\24\1\u0117\3\24\1\u0118\1\u0119\1\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\2\24\1\u0110\27\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\3\24\1\u0110\26\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\12\24\1\54"+
    "\6\24\1\54\2\24\1\54\5\24\1\47\4\24\1\54"+
    "\4\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\27\24\1\u011a\2\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\4\24\1\u011b\25\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\21\24\1\u011c"+
    "\10\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\22\24\1\54\1\24\1\u011d"+
    "\5\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\24\24\1\u011e\5\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\14\24\1\u011f\1\u0120\1\54\13\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\24\24\1\146\5\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\23\24\1\u0121\6\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\12\24\1\u0122"+
    "\6\24\1\54\3\24\1\u0123\4\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\13\24\1\54\5\24\1\54\10\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\22\24\1\u0124\1\u0125\1\u0126\5\24\1\47\1\24\1\u0127"+
    "\7\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\21\24\1\54\10\24\1\47\4\24\1\u0128"+
    "\4\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\16\24\1\54\13\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\21\24\1\54\10\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\21\24\1\54"+
    "\2\24\1\146\5\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\21\24\1\213"+
    "\10\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\26\24\1\54\3\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\32\24\1\47\1\u0129\10\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\16\24"+
    "\1\54\12\24\1\54\1\47\1\24\1\u012a\7\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\30\24\1\u012b\1\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\16\24\1\54"+
    "\2\24\2\54\7\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\26\24\1\u012c"+
    "\3\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\26\24\1\u012d\3\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\4\24\1\u012e\5\24\1\u012f\6\24\1\u0130"+
    "\1\u0131\3\24\1\u0132\3\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\32\24"+
    "\1\47\4\24\1\54\4\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\13\24\1\54\2\24"+
    "\1\54\13\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\4\24\1\u0133\21\24"+
    "\1\u0134\3\24\1\47\4\24\1\u0135\4\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\32\24"+
    "\1\47\3\24\1\126\5\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\21\24\1\u0136\10\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\4\24\1\126\25\24\1\47\3\24"+
    "\1\126\5\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\4\24\1\126\22\24\1\126\2\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\14\24\1\u0137\15\24\1\47\3\24"+
    "\1\126\5\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\27\24\1\126\2\24\1\47\3\24"+
    "\1\126\5\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\24\24\1\u0138\1\24\1\u0139\3\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\4\24\1\u013a\21\24\1\u013b\1\u013c"+
    "\2\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\4\24\1\143"+
    "\4\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\30\24\1\230\1\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\17\24\1\u013d\12\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\13\24\1\54"+
    "\1\u011f\1\24\1\54\13\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\13\24"+
    "\1\u013e\2\24\1\u013e\4\24\1\u013f\4\24\1\u0140\1\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\15\24\1\54\14\24\1\47\7\24"+
    "\1\154\1\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\22\24\1\u0141\3\24\1\u0142\3\24"+
    "\1\47\1\u0143\10\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\12\24\1\u0126\17\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\1\126\1\24\2\126\1\24\5\126\1\u0144"+
    "\3\24\1\u0145\3\24\1\54\1\u0126\1\54\2\24\1\54"+
    "\2\24\1\47\4\24\1\u0128\4\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\24\24\1\146"+
    "\5\24\1\47\1\u0146\1\24\1\u0147\6\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\15\24"+
    "\1\u0148\14\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\17\24\1\u0149\12\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\23\24\1\315\6\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\16\24\1\u014a\13\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\21\24"+
    "\1\u014b\10\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\30\24\1\u014c\1\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\13\24\1\u011b\2\24\1\u014d\7\24"+
    "\1\u014e\3\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\22\24\1\54\1\24"+
    "\1\54\1\24\1\143\1\54\2\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\32\24\1\47\1\24\1\54\7\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\3\24\1\126"+
    "\2\24\2\126\1\24\1\126\20\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\24\24\1\u014f\5\24\1\47\4\24\1\u0150\4\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\32\24\1\47\5\24\1\54\3\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\24\24\1\52"+
    "\5\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\4\24\1\u0151\15\24\1\54"+
    "\1\u0152\6\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\26\24\1\u0153\3\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\12\24\1\u0154\13\24\1\u0155\3\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\4\24\1\143\25\24\1\47\1\u0110"+
    "\10\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\26\24\1\u0156\3\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\31\24\1\u0157\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\17\24\1\u0158\12\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\12\24\1\54\6\24\1\54\4\24"+
    "\1\u0159\3\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\1\126\1\24\2\126"+
    "\1\24\5\126\20\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\22\24\1\54"+
    "\7\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\21\24\1\u015a\10\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\32\24\1\47\10\24\1\u015b\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\4\24"+
    "\1\230\25\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\32\24\1\47\4\24"+
    "\1\u0103\4\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\12\24\1\115\17\24\1\47\1\54"+
    "\10\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\4\24\1\54\14\24\1\u015c\4\24\1\54"+
    "\3\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\27\24\1\u012c\2\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\32\24\1\47\7\24\1\154\1\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\2\24\1\126\2\24\4\126\21\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\21\24\1\146\10\24\1\47\3\24\1\u015d\5\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\26\24\1\u015e\3\24\1\47\4\24\1\u015f\4\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\4\24\1\u0160\25\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\4\24\1\u0161"+
    "\12\24\1\146\12\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\25\24\1\u0162"+
    "\4\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\26\24\1\u0163\3\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\27\24\1\u0164\2\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\21\24\1\u0165\1\u0166\3\24\1\u0167\3\24\1\47\10\24"+
    "\1\u0168\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\1\u0110\2\24\1\u0110\11\24\1\u0110\1\24"+
    "\1\u0110\4\24\1\u0169\1\u016a\1\24\1\u016b\2\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\4\24\1\u013a\23\24\1\u011b\1\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\3\24\1\54\26\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\17\24\1\u016c\12\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\23\24\1\u016d"+
    "\6\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\4\24\1\u016e\22\24\1\u016f"+
    "\2\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\3\24\1\u0170"+
    "\5\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\12\24\1\u0171\3\24\1\u0172\7\24\1\u0173"+
    "\3\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\15\24\1\143\1\u0110\5\24"+
    "\1\u0174\5\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\24\24\1\u0175\5\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\13\24\1\u0176\5\24\1\u0177\10\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\21\24\1\u0178\3\24\1\u0179\4\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\12\24\1\u017a\7\24\1\u017b\3\24"+
    "\1\u017c\1\u017d\1\u017e\1\24\1\47\5\24\1\u017f\3\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\13\24\1\u0180\1\143\6\24\1\u0181\6\24\1\47"+
    "\4\24\1\u0182\4\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\16\24\1\u0161\13\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\17\24\1\u0183\7\24\1\u0184\2\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\21\24\1\u0185\1\u0186\1\57\3\24\1\u0187"+
    "\2\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\21\24\1\146\10\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\12\24\1\317\1\u0176\5\24\1\u0188\1\u0189"+
    "\1\24\1\u018a\1\u018b\4\24\1\47\4\24\1\u018c\4\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\22\24\1\u018d\7\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\16\24"+
    "\1\u018e\13\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\12\24\1\311\10\24"+
    "\1\315\6\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\12\24\1\156\3\24"+
    "\1\u018f\2\24\1\u0190\1\u0191\3\24\1\u0192\3\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\30\24\1\u0193\1\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\13\24\1\u0194\16\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\23\24\1\u0195"+
    "\6\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\23\24\1\u0196\6\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\26\24\1\u0137\3\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\27\24\1\146\2\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\27\24\1\u015e"+
    "\2\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\27\24\1\u0197\2\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\26\24\1\u0110\3\24\1\47\4\24\1\u0135"+
    "\4\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\16\24\1\u0198\13\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\16\24\1\u0199\13\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\24\24\1\u0176"+
    "\5\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\12\24\1\u019a\17\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\14\24\1\u019b\15\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\16\24\1\u019c\13\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\32\24\1\47"+
    "\4\24\1\231\4\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\21\24\1\u019d\1\u019e\7\24"+
    "\1\47\3\24\1\u019f\5\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\32\24\1\47\10\24"+
    "\1\u01a0\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\25\24\1\u019f\4\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\13\24\1\u015b\16\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\13\24\1\u01a1"+
    "\15\24\1\u01a2\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\16\24\1\u01a3\13\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\32\24\1\47\2\24\1\54\6\24"+
    "\20\0\1\365\60\0\1\u01a4\62\0\1\u01a5\61\0\1\u01a5"+
    "\2\0\1\365\60\0\1\u01a6\70\0\1\u01a7\67\0\1\u01a8"+
    "\62\0\1\u01a9\56\0\1\u01aa\63\0\1\365\64\0\1\u01ab"+
    "\41\0\1\u01ac\76\0\1\u01ad\56\0\1\u01ae\67\0\1\u01af"+
    "\64\0\1\u01b0\56\0\1\365\75\0\1\365\33\0\1\u01b1"+
    "\66\0\1\101\66\0\1\u01b2\1\u01b3\62\0\1\u01b4\54\0"+
    "\1\u01b5\41\0\1\u01b6\11\0\1\u01b7\6\0\1\372\75\0"+
    "\1\u01b0\51\0\1\u01b8\51\0\1\u01b9\72\0\1\u01ba\61\0"+
    "\1\u01bb\50\0\1\357\102\0\1\365\53\0\1\u01bc\54\0"+
    "\1\u01bd\73\0\1\365\5\0\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\27\24\1\u01be\2\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\20\24\1\u01bf\11\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\24\24\1\u01c0\5\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\24\24"+
    "\1\u01c1\5\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\17\24\1\u0110\12\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\32\24\1\47\1\u01c2\10\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\31\24\1\u01c3\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\22\24\1\u0110\3\24"+
    "\1\u0137\3\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\32\24\1\47\10\24"+
    "\1\u01c4\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\26\24\1\u01c5\3\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\24\24\1\u01c6\5\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\13\24\1\u01c7"+
    "\16\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\30\24\1\u01c8\1\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\12\24\1\u01c9\1\u01c7\16\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\15\24\1\u01c0\14\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\4\24"+
    "\1\u01ca\25\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\12\24\1\u01cb\7\24"+
    "\1\u01cc\6\24\1\u01cb\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\21\24\1\u01c5"+
    "\10\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\13\24\1\u01cd\16\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\32\24\1\47\1\u0103\10\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\14\24"+
    "\1\u010f\15\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\4\24\1\u01ce\25\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\24\24\1\u01cf\5\24\1\47\3\24"+
    "\1\u01d0\5\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\32\24\1\47\10\24\1\u01d1\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\25\24\1\u01d0\4\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\13\24\1\u01d2"+
    "\16\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\1\u01d3\10\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\13\24\1\54\16\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\30\24"+
    "\1\237\1\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\4\24\1\143\11\24"+
    "\1\u0110\2\24\1\143\10\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\4\24"+
    "\1\143\20\24\1\u01d4\4\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\31\24"+
    "\1\54\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\17\24\1\u01d5\12\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\31\24\1\225\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\32\24"+
    "\1\47\10\24\1\u01d6\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\1\u01d7\10\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\12\24\1\u01d5\5\24\1\54\11\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\4\24\1\u01d8\25\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\21\24"+
    "\1\u01d9\10\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\32\24\1\47\1\24"+
    "\1\u0131\7\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\32\24\1\47\3\24\1\u01da\5\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\14\24\1\u0127\15\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\12\24"+
    "\1\57\17\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\25\24\1\u0176\4\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\21\24\1\u0110\10\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\17\24\1\u01db\12\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\17\24"+
    "\1\u01dc\5\24\1\u01dd\1\u0110\3\24\1\47\2\24\1\54"+
    "\6\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\13\24\1\u01de\16\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\15\24\1\230\6\24\1\230\1\24\1\230\3\24\1\47"+
    "\1\24\1\230\3\24\1\230\3\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\23\24\1\u01df"+
    "\6\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\25\24\1\54\3\24\1\54"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\32\24\1\47\4\24\1\232\4\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\21\24\1\232\10\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\21\24"+
    "\1\142\10\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\17\24\1\u01e0\12\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\23\24\1\u0110\6\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\4\24\1\u0110\14\24\1\u01e1\5\24\1\u01e2\2\24"+
    "\1\47\4\24\1\u0110\4\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\17\24\1\142\12\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\23\24\1\u013f\6\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\16\24\1\u013d\1\u01e3\12\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\26\24\1\u01e4\3\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\25\24\1\u0110"+
    "\4\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\24\24\1\54\5\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\16\24\1\u01e5\13\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\31\24\1\u01d4\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\26\24\1\u0155\3\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\4\24\1\51\5\24\2\52\1\24"+
    "\1\52\1\24\1\54\1\24\3\54\1\24\1\56\4\24"+
    "\1\47\1\52\1\24\1\54\6\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\32\24\1\47"+
    "\4\24\1\u01e6\4\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\22\24\1\u01e7\7\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\30\24\1\u01e8\1\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\25\24\1\u01e9\4\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\17\24\1\u01ea"+
    "\12\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\4\24\1\143\14\24\1\u01eb"+
    "\4\24\1\u01ec\3\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\25\24\1\u01ed"+
    "\4\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\26\24\1\u019f\3\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\17\24\1\u01ee\12\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\27\24\1\u0176\2\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\16\24\1\u01ef"+
    "\13\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\21\24\1\u01f0\10\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\17\24\1\u015a\12\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\27\24\1\u01f1\2\24\1\47\4\24\1\u01f2\4\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\4\24\1\143\14\24\1\u01f3\10\24\1\47\3\24\1\u01f4"+
    "\5\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\32\24\1\47\10\24\1\u0142\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\4\24"+
    "\1\u01f5\14\24\1\u01f6\4\24\1\u01f7\3\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\26\24\1\u01f0\3\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\27\24"+
    "\1\u016f\2\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\21\24\1\u01f8\10\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\16\24\1\u01f9\13\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\12\24\1\u015a\17\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\21\24"+
    "\1\u01fa\10\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\4\24\1\143\14\24"+
    "\1\143\10\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\4\24\1\u01fb\25\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\26\24\1\u01fc\3\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\13\24\1\u0103\16\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\17\24"+
    "\1\u01fd\12\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\17\24\1\u01fe\12\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\22\24\1\u0110\7\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\24\24\1\u0110\5\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\16\24"+
    "\1\u01ff\13\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\32\24\1\47\10\24"+
    "\1\54\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\15\24\1\54\6\24\1\54\1\24\1\115"+
    "\3\24\1\47\1\24\1\54\7\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\13\24\1\u0200"+
    "\1\24\1\u0201\14\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\23\24\1\54"+
    "\6\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\13\24\1\u0202\7\24\1\u0203"+
    "\1\54\5\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\17\24\1\u01e2\7\24"+
    "\1\u0204\2\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\15\24\1\u0110\6\24"+
    "\1\u0205\5\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\24\24\1\u0206\5\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\1\122\5\24\1\123\12\24\1\u0110"+
    "\10\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\4\24\1\u0207"+
    "\4\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\22\24\1\u0208\7\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\23\24\1\u013d\6\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\32\24\1\47"+
    "\4\24\1\u0209\4\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\26\24\1\u0173\3\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\17\24\1\u020a\12\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\12\24\1\u020b\17\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\24\24\1\u020c"+
    "\5\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\1\54\3\24\1\u020d\6\24"+
    "\1\u020e\3\24\1\u020f\2\24\1\213\7\24\1\47\2\24"+
    "\1\54\6\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\26\24\1\57\3\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\26\24\1\120\3\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\24\24"+
    "\1\u0210\5\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\12\24\1\u0211\17\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\4\24\1\54\12\24\1\u020f\1\24"+
    "\2\213\7\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\25\24\1\u0212\4\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\15\24\1\u0213\14\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\16\24\1\146\13\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\17\24"+
    "\1\u0214\12\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\21\24\1\54\10\24"+
    "\1\47\4\24\1\u0215\4\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\23\24\1\u0216\6\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\22\24\1\u0217\7\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\32\24\1\47\10\24\1\u0213\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\12\24\1\u017a"+
    "\13\24\1\u0218\3\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\13\24\1\u0180"+
    "\16\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\25\24\1\311\4\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\26\24\1\u020c\1\24\1\u0219\1\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\23\24\1\u021a\6\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\27\24\1\u021b\2\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\22\24\1\u0217"+
    "\4\24\1\146\2\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\30\24\1\u011b"+
    "\1\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\23\24\1\u021c\6\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\17\24\1\u01d6\12\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\21\24\1\u0178\10\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\12\24\1\u017a"+
    "\17\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\14\24\1\54\15\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\16\24\1\u021d\13\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\13\24\1\u020c\16\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\3\24\1\u021e"+
    "\26\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\15\24\1\u021f\14\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\30\24\1\u0220\1\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\25\24\1\u0221\4\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\24\24\1\u01db"+
    "\5\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\23\24\1\u01e9\6\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\26\24\1\u0222\3\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\32\24\1\47\1\54\10\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\4\24\1\143\25\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\20\24\1\u0223\11\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\16\24\1\u0137\13\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\12\24"+
    "\1\u01d4\1\u0224\1\u0225\4\24\1\u0226\2\24\1\54\1\u0227"+
    "\2\24\1\u01d4\1\24\1\47\2\24\1\u0214\1\24\1\u0228"+
    "\1\54\3\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\27\24\1\u0229\2\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\27\24\1\u022a\2\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\16\24"+
    "\1\54\13\24\1\47\1\24\1\54\7\24\20\0\1\365"+
    "\2\0\1\365\60\0\1\365\71\0\1\u022b\60\0\1\365"+
    "\74\0\1\u022c\56\0\1\u022d\50\0\1\u022e\76\0\1\376"+
    "\51\0\1\u022f\61\0\1\u0230\42\0\1\365\2\0\1\365"+
    "\11\0\1\365\1\0\1\365\4\0\1\u0231\1\u0232\1\0"+
    "\1\u0233\61\0\1\101\4\0\1\365\53\0\1\365\51\0"+
    "\1\u0234\3\0\1\u022e\56\0\1\365\63\0\1\u01b0\4\0"+
    "\1\u0235\45\0\1\u0236\70\0\1\u0237\45\0\1\365\103\0"+
    "\1\u0238\61\0\1\u0239\56\0\1\u023a\50\0\1\u01b2\67\0"+
    "\1\u01b0\53\0\1\u023b\65\0\1\u01a7\24\0\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\26\24"+
    "\1\u01ef\3\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\21\24\1\u023c\6\24"+
    "\1\u023d\1\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\15\24\1\54\3\24"+
    "\1\u01c2\2\24\1\54\3\24\1\u023e\1\24\1\47\1\24"+
    "\1\54\7\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\25\24\1\54\4\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\15\24\1\54\14\24\1\47\1\24\1\54\7\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\17\24\1\u023f\12\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\12\24"+
    "\1\u0240\17\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\16\24\1\213\13\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\15\24\1\213\14\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\24\24\1\54\5\24\1\47\1\24\1\54\3\24"+
    "\1\54\3\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\31\24\1\213\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\24\24\1\54\5\24\1\47\1\24\1\54\7\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\17\24\1\u0241\12\24\1\47\1\u0242\10\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\23\24"+
    "\1\u0243\6\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\27\24\1\u0244\2\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\22\24\1\u0245\7\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\24\24\1\u0246\5\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\21\24"+
    "\1\213\6\24\1\u0247\1\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\32\24"+
    "\1\47\4\24\1\u0248\4\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\13\24\1\213\1\u0249"+
    "\15\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\25\24\1\u024a\4\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\13\24\1\u0110\16\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\26\24\1\u024b\3\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\17\24\1\54"+
    "\5\24\1\u01dd\4\24\1\47\2\24\1\54\6\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\15\24\1\54\6\24\1\54\5\24\1\47\1\24\1\54"+
    "\7\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\22\24\1\u0135\7\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\12\24\1\u01e5\17\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\17\24\1\54"+
    "\12\24\1\47\2\24\1\54\6\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\1\u024c\1\u01db"+
    "\5\24\1\u01db\22\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\16\24\1\u0162"+
    "\13\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\27\24\1\u024d\2\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\31\24\1\u0110\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\16\24"+
    "\1\u024e\13\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\32\24\1\47\4\24"+
    "\1\u0110\4\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\26\24\1\u0110\3\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\17\24\1\u024f\12\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\20\24"+
    "\1\u0110\11\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\22\24\1\u0250\7\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\32\24\1\50\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\21\24"+
    "\1\u01f0\1\24\1\u01e2\6\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\21\24"+
    "\1\54\4\24\1\115\3\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\26\24"+
    "\1\u01d5\1\u0251\2\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\22\24\1\u01d6"+
    "\7\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\25\24\1\u0252\4\24\1\47"+
    "\3\24\1\311\5\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\7\24\1\u01e9"+
    "\1\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\26\24\1\115\3\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\21\24\1\143\10\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\17\24\1\u024f"+
    "\3\24\1\u013d\6\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\15\24\1\54"+
    "\3\24\1\54\2\24\1\54\5\24\1\47\1\24\1\54"+
    "\7\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\22\24\1\u0253\7\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\21\24\1\u0254\5\24\1\u0255\2\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\21\24\1\u0256\5\24\1\u0257\2\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\4\24\1\u0258\14\24\1\u0259\10\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\17\24\1\u01e5\12\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\31\24\1\u025a"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\17\24\1\u025b\12\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\13\24\1\u025c\16\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\17\24"+
    "\1\u025d\12\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\21\24\1\230\10\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\24\24\1\u0205\5\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\30\24\1\u0244\1\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\30\24"+
    "\1\u025e\1\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\27\24\1\u013d\2\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\4\24\1\u019b\25\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\20\24\1\u0103\11\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\31\24"+
    "\1\u025f\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\17\24\1\u01e2\12\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\25\24\1\u025f\4\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\27\24\1\u01f1\2\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\20\24\1\u0260"+
    "\11\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\1\54\31\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\32\24\1\47\4\24\1\u0261\4\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\27\24"+
    "\1\54\2\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\3\24\1\u0262\21\24"+
    "\1\257\4\24\1\47\1\257\10\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\25\24\1\u0164"+
    "\4\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\27\24\1\u0263\2\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\13\24\1\u01d6\16\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\22\24\1\u0264\7\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\4\24\1\54"+
    "\11\24\1\u020c\13\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\32\24\1\47"+
    "\3\24\1\54\5\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\4\24\1\u020c\22\24\1\u020c"+
    "\2\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\10\24\1\u0265"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\21\24\1\u0177\10\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\17\24"+
    "\1\u020f\1\24\2\213\7\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\15\24"+
    "\1\u0266\14\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\32\24\1\47\4\24"+
    "\1\u020c\4\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\32\24\1\47\10\24\1\u0266\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\32\24\1\47\4\24\1\u0215\4\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\12\24\1\u0267"+
    "\17\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\32\24\1\47\3\24\1\u0268"+
    "\5\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\12\24\1\u01d5\17\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\4\24\1\u0110\25\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\32\24\1\47"+
    "\10\24\1\u0176\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\15\24\1\54\14\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\32\24\1\47\4\24\1\u0269\4\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\4\24"+
    "\1\143\7\24\1\u01d4\15\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\4\24"+
    "\1\143\6\24\1\u01d4\16\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\15\24"+
    "\1\54\3\24\1\54\2\24\1\54\5\24\1\47\1\24"+
    "\1\54\1\24\1\54\5\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\26\24\1\u026a\3\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\21\24\1\u026b\10\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\25\24\1\u026c\4\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\13\24"+
    "\1\u026c\16\24\1\47\11\24\30\0\1\365\61\0\1\341"+
    "\14\0\1\101\7\0\1\u026d\47\0\1\354\54\0\1\365"+
    "\53\0\1\u01b0\76\0\1\101\51\0\1\101\7\0\1\u026e"+
    "\47\0\1\365\6\0\1\357\10\0\1\365\50\0\1\u026f"+
    "\63\0\1\u0270\62\0\1\u0271\64\0\1\365\46\0\1\u0272"+
    "\63\0\1\u0273\53\0\1\u0274\60\0\1\361\72\0\1\u022f"+
    "\20\0\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\21\24\1\u0275\10\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\21\24\1\u0276\10\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\21\24\1\u01c2"+
    "\10\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\26\24\1\u0277\3\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\26\24\1\u0103\3\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\32\24\1\47\5\24\1\u0278\3\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\26\24\1\u0278"+
    "\3\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\25\24\1\u0279\4\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\20\24\1\u027a\11\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\32\24\1\47\1\24\1\u0176\7\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\21\24\1\u027b"+
    "\10\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\30\24\1\213\1\24\1\47"+
    "\1\24\1\54\7\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\15\24\1\u0110\14\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\14\24\1\u027c\15\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\11\24\1\u01db\20\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\31\24\1\u027d"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\25\24\1\u01fe\4\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\25\24\1\u01e5\4\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\26\24"+
    "\1\u015e\3\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\26\24\1\u0139\3\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\14\24\1\u027e\15\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\3\24\1\u027f\26\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\3\24"+
    "\1\u01d4\26\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\3\24\1\u0280\26\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\3\24\1\u01f1\26\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\21\24\1\u0254\10\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\21\24"+
    "\1\u0256\10\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\13\24\1\u0281\16\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\32\24\1\47\1\u0110\10\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\27\24\1\u01e5\2\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\32\24\1\47"+
    "\5\24\1\172\3\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\24\24\1\u0282\5\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\27\24\1\u0110\2\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\13\24\2\u01d4\15\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\17\24\1\54"+
    "\6\24\1\54\3\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\25\24\1\146"+
    "\4\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\23\24\1\143\6\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\15\24\1\52\1\24\1\54\5\24\1\u0283"+
    "\2\24\1\54\1\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\22\24\1\146"+
    "\7\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\4\24\1\u0209\25\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\23\24\1\u0284\6\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\4\24\1\143\25\24\1\47\5\24\1\54\3\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\20\24\1\u01d4\11\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\17\24\1\u0285"+
    "\12\24\1\47\11\24\30\0\1\u0286\100\0\1\u0287\55\0"+
    "\1\u0287\64\0\1\u0288\56\0\1\u0289\67\0\1\365\54\0"+
    "\1\u028a\55\0\1\u028b\21\0\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\24\24\1\213\5\24"+
    "\1\47\1\24\1\u0247\7\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\32\24\1\47\1\24"+
    "\1\u0247\7\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\22\24\1\u0191\7\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\26\24\1\u028c\3\24\1\47\11\24\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\13\24"+
    "\2\u028d\15\24\1\47\11\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\20\24\1\u0247\11\24"+
    "\1\47\11\24\1\47\2\24\1\0\3\47\2\0\1\50"+
    "\2\0\1\47\1\0\23\24\1\u01e2\6\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\1\u0110\2\24\1\u0110\11\24\1\u0110\1\24\1\u0110"+
    "\4\24\1\u0205\1\u016a\1\24\1\u028e\2\24\1\47\11\24"+
    "\1\47\2\24\1\0\3\47\2\0\1\50\2\0\1\47"+
    "\1\0\32\24\1\47\1\u0222\10\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\4\24\1\u020d"+
    "\25\24\1\47\11\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\21\24\1\u020d\10\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\23\24\1\u028f\6\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\17\24\1\u0290\12\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\15\24\1\52"+
    "\1\24\1\54\10\24\1\54\1\24\1\47\11\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\32\24\1\47\10\24\1\216\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\32\24\1\47\6\24"+
    "\1\u0291\2\24\40\0\1\u0292\66\0\1\365\62\0\1\u01b2"+
    "\60\0\1\101\7\0\1\u0293\60\0\1\u0294\5\0\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\17\24\1\u0295\12\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\15\24\1\213"+
    "\6\24\1\216\5\24\1\47\1\24\1\u0176\7\24\1\47"+
    "\2\24\1\0\3\47\2\0\1\50\2\0\1\47\1\0"+
    "\24\24\1\u013d\5\24\1\47\11\24\1\47\2\24\1\0"+
    "\3\47\2\0\1\50\2\0\1\47\1\0\32\24\1\47"+
    "\1\24\1\u01e9\7\24\1\47\2\24\1\0\3\47\2\0"+
    "\1\50\2\0\1\47\1\0\13\24\1\u0296\16\24\1\47"+
    "\11\24\1\47\2\24\1\0\3\47\2\0\1\50\2\0"+
    "\1\47\1\0\32\24\1\47\6\24\1\u0110\2\24\34\0"+
    "\1\u0297\55\0\1\u0298\104\0\1\365\6\0\1\47\2\24"+
    "\1\0\3\47\2\0\1\50\2\0\1\47\1\0\32\24"+
    "\1\47\3\24\1\u01e5\5\24\1\47\2\24\1\0\3\47"+
    "\2\0\1\50\2\0\1\47\1\0\27\24\1\u0299\2\24"+
    "\1\47\11\24\41\0\1\u029a\60\0\1\u029b\51\0\1\341"+
    "\65\0\1\u029c\66\0\1\365\20\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[31850];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\11\5\1\1\11\1\1\1\11\44\1\2\11"+
    "\25\0\225\1\31\0\1\11\11\0\245\1\1\0\1\1"+
    "\10\0\1\1\17\0\155\1\1\0\1\1\3\0\1\1"+
    "\5\0\1\1\5\0\61\1\7\0\22\1\1\0\1\1"+
    "\2\0\1\1\1\0\6\1\3\0\2\1\2\0\2\1"+
    "\2\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[668];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  We must have this here as JFLex does not generate a
	 * no parameter constructor.
	 */
	public AssemblerX86TokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { ";", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *                    <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 * @exception   IOException  if any I/O-Error occurs.
	 */
	private boolean zzRefill() throws java.io.IOException {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) throws java.io.IOException {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtBOL  = true;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public AssemblerX86TokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public AssemblerX86TokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 200) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 11: 
          { addToken(Token.RESERVED_WORD);
          }
        case 16: break;
        case 1: 
          { addToken(Token.IDENTIFIER);
          }
        case 17: break;
        case 12: 
          { addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 18: break;
        case 9: 
          { addToken(Token.FUNCTION);
          }
        case 19: break;
        case 5: 
          { addToken(Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 20: break;
        case 14: 
          { addToken(Token.VARIABLE);
          }
        case 21: break;
        case 7: 
          { addToken(Token.WHITESPACE);
          }
        case 22: break;
        case 10: 
          { addToken(Token.PREPROCESSOR);
          }
        case 23: break;
        case 15: 
          { addToken(Token.DATA_TYPE);
          }
        case 24: break;
        case 4: 
          { addToken(Token.ERROR_CHAR); /*addNullToken(); return firstToken;*/
          }
        case 25: break;
        case 8: 
          { addToken(Token.OPERATOR);
          }
        case 26: break;
        case 2: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 27: break;
        case 13: 
          { addToken(Token.LITERAL_CHAR);
          }
        case 28: break;
        case 3: 
          { addToken(Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 29: break;
        case 6: 
          { addNullToken(); return firstToken;
          }
        case 30: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 669: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
