package plugins.ylemontag.sequencecomparator.blocks;

import icy.sequence.Sequence;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.ylemontag.sequencecomparator.ErrorMeasure;
import plugins.ylemontag.sequencecomparator.GlobalComparator;
import plugins.ylemontag.sequencecomparator.LocalComparator;


/**
 * 
 * @author Yoann Le Montagner
 * 
 * Compare a list of sequences with against a reference sequence (i.e. a ground truth)
 */
public class ComparisonsBlock extends AbstractComparisonBlock
{
	private VarSequence          _ref       = new VarSequence         ("Reference"     , null);
	private VarArray<Sequence>   _seq       = new VarArray<Sequence>  ("Sequences"     , Sequence[].class, null);
	private VarErrorMeasureArray _outGlobal = new VarErrorMeasureArray("Error measures", null);
	private VarArray<Sequence>   _outLocal  = new VarArray<Sequence>  ("Error maps"    , Sequence[].class, null);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		super.declareInput(inputMap);
		inputMap.add(_ref);
		inputMap.add(_seq);
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_outGlobal);
		outputMap.add(_outLocal );
	}
	
	@Override
	public String getName()
	{
		return "Comparisons";
	}

	@Override
	public String getDescription()
	{
		return "Compare a list of sequences to a reference (ground truth)";
	}
	
	@Override
	protected void executeComparison(GlobalComparator globalComparator, LocalComparator localComparator)
	{
		// If the compared sequence input points to null
		Sequence[] seq = _seq.getValue();
		if(seq==null) {
			_outGlobal.setValue(null);
			_outLocal .setValue(null);
			return;
		}
		
		// Comparison loop
		Sequence ref = _ref.getValue();
		ErrorMeasure[] globalResult = new ErrorMeasure[seq.length];
		Sequence    [] localResult  = new Sequence    [seq.length];
		for(int k=0; k<seq.length; ++k) {
			globalResult[k] = globalComparator.compare(ref, seq[k]);
			localResult [k] = localComparator .compare(ref, seq[k]);
			globalResult[k].label = seq[k].getName(); // Simplify the labeling
		}
		_outGlobal.setValue(globalResult);
		_outLocal .setValue(localResult );
	}
}
