/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;

class SelectedDenseDComplexMatrix3D
extends DComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseDComplexMatrix3D(double[] elements, int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets, int offset) {
        int slices = sliceOffsets.length;
        int rows = rowOffsets.length;
        int columns = columnOffsets.length;
        this.setUp(slices, rows, columns);
        this.elements = elements;
        this.sliceOffsets = sliceOffsets;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    @Override
    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    @Override
    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    @Override
    protected int _sliceOffset(int absRank) {
        return this.sliceOffsets[absRank];
    }

    @Override
    public double[] getQuick(int slice, int row, int column) {
        int idxs = this.sliceZero + slice * this.sliceStride;
        int idxr = this.rowZero + row * this.rowStride;
        int idxc = this.columnZero + column * this.columnStride;
        return new double[]{this.elements[this.offset + this.sliceOffsets[idxs] + this.rowOffsets[idxr] + this.columnOffsets[idxc]], this.elements[this.offset + this.sliceOffsets[idxs] + this.rowOffsets[idxr] + this.columnOffsets[idxc] + 1]};
    }

    public double[] elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix3D other) {
        if (other instanceof SelectedDenseDComplexMatrix3D) {
            SelectedDenseDComplexMatrix3D otherMatrix = (SelectedDenseDComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDComplexMatrix3D) {
            DenseDComplexMatrix3D otherMatrix = (DenseDComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int slice, int row, int column) {
        return this.offset + this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    @Override
    public DComplexMatrix3D like(int slices, int rows, int columns) {
        return new DenseDComplexMatrix3D(slices, rows, columns);
    }

    @Override
    protected DComplexMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        throw new InternalError();
    }

    @Override
    public DComplexMatrix2D like2D(int rows, int columns) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int slice, int row, int column, double[] value) {
        int idxs = this.sliceZero + slice * this.sliceStride;
        int idxr = this.rowZero + row * this.rowStride;
        int idxc = this.columnZero + column * this.columnStride;
        this.elements[this.offset + this.sliceOffsets[idxs] + this.rowOffsets[idxr] + this.columnOffsets[idxc]] = value[0];
        this.elements[this.offset + this.sliceOffsets[idxs] + this.rowOffsets[idxr] + this.columnOffsets[idxc] + 1] = value[1];
    }

    @Override
    public void setQuick(int slice, int row, int column, double re, double im) {
        int idxs = this.sliceZero + slice * this.sliceStride;
        int idxr = this.rowZero + row * this.rowStride;
        int idxc = this.columnZero + column * this.columnStride;
        this.elements[this.offset + this.sliceOffsets[idxs] + this.rowOffsets[idxr] + this.columnOffsets[idxc]] = re;
        this.elements[this.offset + this.sliceOffsets[idxs] + this.rowOffsets[idxr] + this.columnOffsets[idxc] + 1] = im;
    }

    @Override
    protected void setUp(int slices, int rows, int columns) {
        super.setUp(slices, rows, columns);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix3D vDice(int axis0, int axis1, int axis2) {
        super.vDice(axis0, axis1, axis2);
        int[][] offsets = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = offsets[axis0];
        this.rowOffsets = offsets[axis1];
        this.columnOffsets = offsets[axis2];
        return this;
    }

    @Override
    public DComplexMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int viewRows = this.slices;
        int viewColumns = this.rows;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.rowZero;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.rowStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.rowOffsets;
        return new SelectedDenseDComplexMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    @Override
    public DComplexMatrix2D viewRow(int row) {
        this.checkRow(row);
        int viewRows = this.slices;
        int viewColumns = this.columns;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedDenseDComplexMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    @Override
    protected DComplexMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseDComplexMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, this.offset);
    }

    @Override
    public DComplexMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int viewRows = this.rows;
        int viewColumns = this.columns;
        int viewRowZero = this.rowZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._sliceOffset(this._sliceRank(slice));
        int viewRowStride = this.rowStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.rowOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedDenseDComplexMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    @Override
    public DComplexMatrix1D vectorize() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public DoubleMatrix3D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public DoubleMatrix3D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

