/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalDoubleMatrix2D(double[][] values, int dindex) {
        this(values.length, values.length == 0 ? 0 : values[0].length, dindex);
        this.assign(values);
    }

    public DiagonalDoubleMatrix2D(int rows, int columns, int dindex) {
        int diff;
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (dindex < -rows + 1 || dindex > columns - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = dindex;
        this.dlength = dindex == 0 ? Math.min(rows, columns) : (dindex > 0 ? (rows >= columns ? columns - dindex : (dindex <= (diff = columns - rows) ? rows : rows - (dindex - diff))) : (rows >= columns ? (-dindex <= (diff = rows - columns) ? columns : columns + dindex + diff) : rows + dindex));
        this.elements = new double[this.dlength];
    }

    @Override
    public DoubleMatrix2D assign(DoubleFunction function) {
        if (function instanceof DoubleMult) {
            double alpha = ((DoubleMult)function).multiplicator;
            if (alpha == 1.0) {
                return this;
            }
            if (alpha == 0.0) {
                return this.assign(0.0);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            int j = this.dlength;
            while (--j >= 0) {
                int n = j;
                this.elements[n] = this.elements[n] * alpha;
            }
        } else {
            int j = this.dlength;
            while (--j >= 0) {
                this.elements[j] = function.apply(this.elements[j]);
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(double value) {
        int i = this.dlength;
        while (--i >= 0) {
            this.elements[i] = value;
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(final double[] values) {
        if (values.length != this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " dlength=" + this.dlength);
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            int k = this.dlength / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            DiagonalDoubleMatrix2D.this.elements[r] = values[r];
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = this.dlength;
            while (--r >= 0) {
                this.elements[r] = values[r];
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(double[][] values) {
        int c;
        int r;
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            r = 0;
            c = this.dindex;
        } else {
            r = -this.dindex;
            c = 0;
        }
        int i = 0;
        while (i < this.dlength) {
            if (values[i].length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + values[r].length + "columns()=" + this.columns());
            }
            this.elements[i] = values[r++][c++];
            ++i;
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof DiagonalDoubleMatrix2D) {
            DiagonalDoubleMatrix2D other = (DiagonalDoubleMatrix2D)source;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("source is DiagonalDoubleMatrix2D with different diagonal stored.");
            }
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D y, final DoubleDoubleFunction function) {
        this.checkShape(y);
        if (y instanceof DiagonalDoubleMatrix2D) {
            double alpha;
            DiagonalDoubleMatrix2D other = (DiagonalDoubleMatrix2D)y;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("y is DiagonalDoubleMatrix2D with different diagonal stored.");
            }
            if (function instanceof DoublePlusMultSecond && (alpha = ((DoublePlusMultSecond)function).multiplicator) == 0.0) {
                return this;
            }
            final double[] otherElements = other.elements;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.dlength);
                Future[] futures = new Future[nthreads];
                int k = this.dlength / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (function instanceof DoublePlusMultSecond) {
                                double alpha = ((DoublePlusMultSecond)function).multiplicator;
                                if (alpha == 1.0) {
                                    int j = firstRow;
                                    while (j < lastRow) {
                                        int n = j;
                                        DiagonalDoubleMatrix2D.this.elements[n] = DiagonalDoubleMatrix2D.this.elements[n] + otherElements[j];
                                        ++j;
                                    }
                                } else {
                                    int j = firstRow;
                                    while (j < lastRow) {
                                        DiagonalDoubleMatrix2D.this.elements[j] = DiagonalDoubleMatrix2D.this.elements[j] + alpha * otherElements[j];
                                        ++j;
                                    }
                                }
                            } else if (function == DoubleFunctions.mult) {
                                int j = firstRow;
                                while (j < lastRow) {
                                    DiagonalDoubleMatrix2D.this.elements[j] = DiagonalDoubleMatrix2D.this.elements[j] * otherElements[j];
                                    ++j;
                                }
                            } else if (function == DoubleFunctions.div) {
                                int j = firstRow;
                                while (j < lastRow) {
                                    DiagonalDoubleMatrix2D.this.elements[j] = DiagonalDoubleMatrix2D.this.elements[j] / otherElements[j];
                                    ++j;
                                }
                            } else {
                                int j = firstRow;
                                while (j < lastRow) {
                                    DiagonalDoubleMatrix2D.this.elements[j] = function.apply(DiagonalDoubleMatrix2D.this.elements[j], otherElements[j]);
                                    ++j;
                                }
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else if (function instanceof DoublePlusMultSecond) {
                double alpha2 = ((DoublePlusMultSecond)function).multiplicator;
                if (alpha2 == 1.0) {
                    int j = this.dlength;
                    while (--j >= 0) {
                        int n = j;
                        this.elements[n] = this.elements[n] + otherElements[j];
                    }
                } else {
                    int j = this.dlength;
                    while (--j >= 0) {
                        this.elements[j] = this.elements[j] + alpha2 * otherElements[j];
                    }
                }
            } else if (function == DoubleFunctions.mult) {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = this.elements[j] * otherElements[j];
                }
            } else if (function == DoubleFunctions.div) {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = this.elements[j] / otherElements[j];
                }
            } else {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = function.apply(this.elements[j], otherElements[j]);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.dlength / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int r = firstRow;
                        while (r < lastRow) {
                            if (DiagonalDoubleMatrix2D.this.elements[r] != 0.0) {
                                ++cardinality;
                            }
                            ++r;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int r = 0;
            while (r < this.dlength) {
                if (this.elements[r] != 0.0) {
                    ++cardinality;
                }
                ++r;
            }
        }
        return cardinality;
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public boolean equals(double value) {
        double epsilon = DoubleProperty.DEFAULT.tolerance();
        int r = 0;
        while (r < this.dlength) {
            double x = this.elements[r];
            double diff = Math.abs(value - x);
            if (diff != diff && (value != value && x != x || value == x)) {
                diff = 0.0;
            }
            if (!(diff <= epsilon)) {
                return false;
            }
            ++r;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DiagonalDoubleMatrix2D) {
            DiagonalDoubleMatrix2D other = (DiagonalDoubleMatrix2D)obj;
            double epsilon = DoubleProperty.DEFAULT.tolerance();
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            int rows = this.rows();
            int columns = this.columns();
            if (columns != other.columns() || rows != other.rows()) {
                return false;
            }
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                return false;
            }
            double[] otherElements = other.elements;
            int r = 0;
            while (r < this.dlength) {
                double value = otherElements[r];
                double x = this.elements[r];
                double diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0;
                }
                if (!(diff <= epsilon)) {
                    return false;
                }
                ++r;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction function) {
        int j = this.dlength;
        while (--j >= 0) {
            double value = this.elements[j];
            if (value == 0.0) continue;
            this.elements[j] = function.apply(j, j, value);
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    @Override
    public double[] getMaxLocation() {
        int columnLocation;
        int rowLocation;
        int location = 0;
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.dlength / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int location = firstRow;
                        double maxValue = DiagonalDoubleMatrix2D.this.elements[location];
                        int r = firstRow + 1;
                        while (r < lastRow) {
                            double elem = DiagonalDoubleMatrix2D.this.elements[r];
                            if (maxValue < elem) {
                                maxValue = elem;
                                location = r;
                            }
                            ++r;
                        }
                        return new double[]{maxValue, location, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[0];
            int r = 1;
            while (r < this.dlength) {
                double elem = this.elements[r];
                if (maxValue < elem) {
                    maxValue = elem;
                    location = r;
                }
                ++r;
            }
        }
        if (this.dindex > 0) {
            rowLocation = location;
            columnLocation = location + this.dindex;
        } else if (this.dindex < 0) {
            rowLocation = location - this.dindex;
            columnLocation = location;
        } else {
            rowLocation = location;
            columnLocation = location;
        }
        return new double[]{maxValue, rowLocation, columnLocation};
    }

    @Override
    public double[] getMinLocation() {
        int columnLocation;
        int rowLocation;
        int location = 0;
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.dlength / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int location = firstRow;
                        double minValue = DiagonalDoubleMatrix2D.this.elements[location];
                        int r = firstRow + 1;
                        while (r < lastRow) {
                            double elem = DiagonalDoubleMatrix2D.this.elements[r];
                            if (minValue > elem) {
                                minValue = elem;
                                location = r;
                            }
                            ++r;
                        }
                        return new double[]{minValue, location, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[0];
            int r = 1;
            while (r < this.dlength) {
                double elem = this.elements[r];
                if (minValue > elem) {
                    minValue = elem;
                    location = r;
                }
                ++r;
            }
        }
        if (this.dindex > 0) {
            rowLocation = location;
            columnLocation = location + this.dindex;
        } else if (this.dindex < 0) {
            rowLocation = location - this.dindex;
            columnLocation = location;
        } else {
            rowLocation = location;
            columnLocation = location;
        }
        return new double[]{minValue, rowLocation, columnLocation};
    }

    @Override
    public double getQuick(int row, int column) {
        if (this.dindex >= 0) {
            if (column < this.dindex) {
                return 0.0;
            }
            if (row < this.dlength && row + this.dindex == column) {
                return this.elements[row];
            }
            return 0.0;
        }
        if (row < -this.dindex) {
            return 0.0;
        }
        if (column < this.dlength && row + this.dindex == column) {
            return this.elements[column];
        }
        return 0.0;
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return new SparseDoubleMatrix2D(rows, columns);
    }

    @Override
    public DoubleMatrix1D like1D(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        if (this.dindex >= 0) {
            if (column >= this.dindex && row < this.dlength && row + this.dindex == column) {
                this.elements[row] = value;
            }
        } else if (row >= -this.dindex && column < this.dlength && row + this.dindex == column) {
            this.elements[column] = value;
        }
    }

    @Override
    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseDoubleMatrix1D(rowsA);
        }
        if (!(this.isNoView && y instanceof DenseDoubleMatrix1D && z instanceof DenseDoubleMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!ignore && beta != 1.0) {
            z.assign(DoubleFunctions.mult(beta));
        }
        DenseDoubleMatrix1D zz = (DenseDoubleMatrix1D)z;
        double[] elementsZ = zz.elements;
        int strideZ = zz.stride();
        int zeroZ = (int)z.index(0);
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        double[] elementsY = yy.elements;
        int strideY = yy.stride();
        int zeroY = (int)y.index(0);
        if (elementsY == null || elementsZ == null) {
            throw new InternalError();
        }
        if (!transposeA) {
            if (this.dindex >= 0) {
                int i = this.dlength;
                while (--i >= 0) {
                    int n = zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[this.dindex + zeroY + strideY * i];
                }
            } else {
                int i = this.dlength;
                while (--i >= 0) {
                    int n = -this.dindex + zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[zeroY + strideY * i];
                }
            }
        } else if (this.dindex >= 0) {
            int i = this.dlength;
            while (--i >= 0) {
                int n = this.dindex + zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[zeroY + strideY * i];
            }
        } else {
            int i = this.dlength;
            while (--i >= 0) {
                int n = zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[-this.dindex + zeroY + strideY * i];
            }
        }
        return z;
    }

    @Override
    protected DoubleMatrix2D getContent() {
        return this;
    }
}

