/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;

class DelegateFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix2D content;
    protected int row;

    public DelegateFComplexMatrix1D(FComplexMatrix2D newContent, int row) {
        if (row < 0 || row >= newContent.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(newContent.columns());
        this.row = row;
        this.content = newContent;
    }

    @Override
    public synchronized float[] getQuick(int index) {
        return this.content.getQuick(this.row, index);
    }

    @Override
    public FComplexMatrix1D like(int size) {
        return this.content.like1D(size);
    }

    @Override
    public FComplexMatrix2D like2D(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public synchronized void setQuick(int index, float[] value) {
        this.content.setQuick(this.row, index, value);
    }

    @Override
    public synchronized void setQuick(int index, float re, float im) {
        this.content.setQuick(this.row, index, re, im);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public FComplexMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public FComplexMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] offsets) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        return this.content.viewRow(this.row).getImaginaryPart();
    }

    @Override
    public FloatMatrix1D getRealPart() {
        return this.content.viewRow(this.row).getRealPart();
    }
}

