/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractPlayer;
import javax.sound.midi.MidiChannel;

class MixerMidiChannel
implements MidiChannel {
    protected static final boolean defaultMute = false;
    protected static final boolean defaultLocal = true;
    protected static final boolean defaultMono = false;
    protected static final boolean defaultOmni = false;
    protected static final boolean defaultSolo = false;
    protected static final int defaultProgram = 0;
    private int channelNumber;
    protected boolean mute;
    protected boolean local;
    protected boolean mono;
    protected boolean omni;
    protected boolean solo;
    protected int program;
    protected AbstractPlayer player;
    private int id = 0;

    MixerMidiChannel(AbstractPlayer player, int channelNumber) {
        this.player = player;
        this.mute = false;
        this.local = true;
        this.mono = false;
        this.omni = false;
        this.solo = false;
        this.program = 0;
        this.channelNumber = channelNumber;
    }

    public void noteOn(int noteNumber, int velocity) {
        if (this.id != 0) {
            this.nNoteOn(this.id, this.channelNumber, noteNumber, velocity, this.player.getTimeStamp());
        }
    }

    public void noteOff(int noteNumber, int velocity) {
        if (this.id != 0) {
            this.nNoteOff(this.id, this.channelNumber, noteNumber, velocity, this.player.getTimeStamp());
        }
    }

    public void noteOff(int noteNumber) {
        this.noteOff(noteNumber, 0);
    }

    public void setPolyPressure(int noteNumber, int pressure) {
    }

    public int getPolyPressure(int noteNumber) {
        return 0;
    }

    public void setChannelPressure(int pressure) {
    }

    public int getChannelPressure() {
        return 0;
    }

    public void controlChange(int controller, int value) {
        if (this.id != 0) {
            this.nControlChange(this.id, this.channelNumber, controller, value, this.player.getTimeStamp());
        }
    }

    public int getController(int controller) {
        if (this.id != 0) {
            return this.nGetController(this.id, this.channelNumber, controller);
        }
        return 0;
    }

    public void programChange(int program) {
        if (this.id != 0) {
            this.nProgramChange(this.id, this.channelNumber, program, this.player.getTimeStamp());
            this.program = program;
        }
    }

    public void programChange(int bank, int program) {
        if (this.id != 0) {
            this.nProgramChange(this.id, this.channelNumber, bank, program, this.player.getTimeStamp());
            this.program = program;
        }
    }

    public int getProgram() {
        return this.program;
    }

    public void setPitchBend(int bend) {
        if (this.id != 0) {
            this.nSetPitchBend(this.id, this.channelNumber, bend / 128, bend % 128, this.player.getTimeStamp());
        }
    }

    public int getPitchBend() {
        if (this.id != 0) {
            return this.nGetPitchBend(this.id, this.channelNumber);
        }
        return 0;
    }

    public void resetAllControllers() {
        if (this.id != 0) {
            this.nResetAllControllers(this.id, this.channelNumber);
        }
    }

    public void allNotesOff() {
        if (this.id != 0) {
            this.nAllNotesOff(this.id, this.channelNumber, this.player.getTimeStamp());
        }
    }

    public void allSoundOff() {
    }

    public boolean localControl(boolean on) {
        return this.local;
    }

    public void setMono(boolean on) {
    }

    public boolean getMono() {
        return this.mono;
    }

    public void setOmni(boolean on) {
    }

    public boolean getOmni() {
        return this.omni;
    }

    public void setMute(boolean muteState) {
        if (this.id != 0 && this.mute != muteState) {
            this.mute = this.nSetMute(this.id, this.channelNumber, muteState);
        }
    }

    public boolean getMute() {
        return this.mute;
    }

    public void setSolo(boolean soloState) {
        if (this.id != 0 && this.solo != soloState) {
            this.solo = this.nSetSolo(this.id, this.channelNumber, soloState);
        }
    }

    public boolean getSolo() {
        return this.solo;
    }

    void setId(int id) {
        this.id = id;
    }

    protected native boolean nSetSolo(int var1, int var2, boolean var3);

    protected native boolean nGetSolo(int var1, int var2);

    protected native int nGetController(int var1, int var2, int var3);

    protected native int nGetPitchBend(int var1, int var2);

    protected native void nNoteOn(int var1, int var2, int var3, int var4, long var5);

    protected native void nNoteOff(int var1, int var2, int var3, int var4, long var5);

    protected native void nControlChange(int var1, int var2, int var3, int var4, long var5);

    protected native void nProgramChange(int var1, int var2, int var3, long var4);

    protected native void nProgramChange(int var1, int var2, int var3, int var4, long var5);

    protected native void nSetPitchBend(int var1, int var2, int var3, int var4, long var5);

    protected native void nAllNotesOff(int var1, int var2, long var3);

    protected native void nResetAllControllers(int var1, int var2);

    protected native boolean nSetMute(int var1, int var2, boolean var3);
}

