/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonUI;

public class JRibbon
extends JComponent {
    public static final String PROPERTY_APPLICATION_ICON = "ribbon.icon";
    public static final String PROPERTY_APPLICATION_MENU_RICH_TOOLTIP = "applicationMenuRichTooltip";
    public static final String PROPERTY_APPLICATION_MENU = "applicationMenu";
    public static final String PROPERTY_APPLICATION_MENU_KEY_TIP = "applicationMenuKeyTip";
    public static final String PROPERTY_SELECTED_TASK = "selectedTask";
    public static final String PROPERTY_MINIMIZED = "minimized";
    private List<RibbonTask> tasks = new LinkedList<RibbonTask>();
    private List<RibbonContextualTaskGroup> contextualTaskGroups = new ArrayList<RibbonContextualTaskGroup>();
    private List<Component> taskbarComponents = new ArrayList<Component>();
    private RibbonTask currentlySelectedTask = null;
    private ResizableIcon helpIcon;
    private ActionListener helpActionListener;
    private RichTooltip helpRichTooltip;
    private Map<RibbonContextualTaskGroup, Boolean> groupVisibilityMap = new HashMap<RibbonContextualTaskGroup, Boolean>();
    private RibbonApplicationMenu applicationMenu;
    private RichTooltip applicationMenuRichTooltip;
    private String applicationMenuKeyTip;
    private boolean isMinimized;
    @Deprecated
    private JRibbonFrame ribbonFrame;
    public static final String uiClassID = "RibbonUI";
    public ResizableIcon applicationIcon;

    public JRibbon() {
        this((ResizableIcon)null);
    }

    public JRibbon(ResizableIcon appIcon) {
        this.updateUI();
        this.getUI().setApplicationIcon(appIcon);
    }

    @Deprecated
    JRibbon(JRibbonFrame ribbonFrame) {
        this();
        this.ribbonFrame = ribbonFrame;
    }

    public synchronized void addTaskbarComponent(Component comp) {
        if (comp instanceof AbstractCommandButton) {
            AbstractCommandButton button = (AbstractCommandButton)comp;
            button.setDisplayState(CommandButtonDisplayState.SMALL);
            button.setGapScaleFactor(0.5);
            button.setFocusable(false);
        }
        this.taskbarComponents.add(comp);
        this.fireStateChanged();
    }

    public synchronized void removeTaskbarComponent(Component comp) {
        this.taskbarComponents.remove(comp);
        this.fireStateChanged();
    }

    public void removeAllTaskbarComponents() {
        this.taskbarComponents.clear();
        this.fireStateChanged();
    }

    public synchronized void addTask(RibbonTask task) {
        task.setRibbon(this);
        this.tasks.add(task);
        if (this.tasks.size() == 1) {
            this.setSelectedTask(task);
        }
        this.fireStateChanged();
    }

    public void removeTask(int pos) {
        if (pos >= this.getTaskCount()) {
            throw new IndexOutOfBoundsException("task position  '" + pos + "' exceeds number of tasks in ribbon ('" + this.getTaskCount() + "')");
        }
        this.removeTask(this.getTask(pos));
    }

    public void removeTask(RibbonTask task) {
        if (task == null) {
            throw new IllegalArgumentException("RibbonTask can not be null");
        }
        int posOfTask = this.tasks.indexOf(task);
        this.tasks.remove(task);
        if (this.getSelectedTask().equals(task) && this.tasks.size() > 0) {
            RibbonTask newTask = this.getTask(posOfTask == 0 ? 1 : posOfTask - 1);
            this.setSelectedTask(newTask);
        }
        this.fireStateChanged();
    }

    public void removeAllTasks() {
        this.tasks.clear();
        this.contextualTaskGroups.clear();
        this.fireStateChanged();
    }

    public synchronized void configureHelp(ResizableIcon helpIcon, ActionListener helpActionListener) {
        this.helpIcon = helpIcon;
        this.helpActionListener = helpActionListener;
        this.fireStateChanged();
    }

    public ResizableIcon getHelpIcon() {
        return this.helpIcon;
    }

    public ActionListener getHelpActionListener() {
        return this.helpActionListener;
    }

    public synchronized void setHelpRichTooltip(RichTooltip tooltip) {
        RichTooltip old = this.helpRichTooltip;
        this.helpRichTooltip = tooltip;
        this.fireStateChanged();
    }

    public synchronized RichTooltip getHelpRichTooltip() {
        return this.helpRichTooltip;
    }

    public void addHelpPanelComponent(Component comp) {
        if (comp == null) {
            return;
        }
        try {
            List existingHelpPanelComponents = (List)this.getClientProperty("HelpPanelComponents");
            if (existingHelpPanelComponents != null) {
                if (!existingHelpPanelComponents.contains(comp)) {
                    existingHelpPanelComponents.add(comp);
                }
            } else {
                ArrayList<Component> helpComps = new ArrayList<Component>();
                helpComps.add(comp);
                this.putClientProperty("HelpPanelComponents", helpComps);
            }
        }
        catch (RuntimeException re) {
            ArrayList<Component> helpComps = new ArrayList<Component>();
            helpComps.add(comp);
            this.putClientProperty("HelpPanelComponents", helpComps);
        }
        this.fireStateChanged();
    }

    public void removeHelpPanelComponent(Component comp) {
        try {
            List existingHelpPanelComponents = (List)this.getClientProperty("HelpPanelComponents");
            if (existingHelpPanelComponents != null && existingHelpPanelComponents.remove(comp)) {
                this.fireStateChanged();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void removeAllHelpPanelComponents() {
        try {
            List existingHelpPanelComponents = (List)this.getClientProperty("HelpPanelComponents");
            if (existingHelpPanelComponents != null) {
                existingHelpPanelComponents.clear();
                this.fireStateChanged();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public synchronized void addContextualTaskGroup(RibbonContextualTaskGroup group) {
        group.setRibbon(this);
        this.contextualTaskGroups.add(group);
        this.groupVisibilityMap.put(group, false);
        this.fireStateChanged();
    }

    public synchronized int getTaskCount() {
        return this.tasks.size();
    }

    public synchronized RibbonTask getTask(int index) {
        return this.tasks.get(index);
    }

    public synchronized int getContextualTaskGroupCount() {
        return this.contextualTaskGroups.size();
    }

    public synchronized RibbonContextualTaskGroup getContextualTaskGroup(int index) {
        return this.contextualTaskGroups.get(index);
    }

    public synchronized void setSelectedTask(RibbonTask task) {
        int i;
        boolean valid = this.tasks.contains(task);
        if (!valid) {
            for (i = 0; i < this.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup group = this.getContextualTaskGroup(i);
                if (!this.isVisible(group)) continue;
                for (int j = 0; j < group.getTaskCount(); ++j) {
                    if (group.getTask(j) != task) continue;
                    valid = true;
                    break;
                }
                if (valid) break;
            }
        }
        if (!valid) {
            throw new IllegalArgumentException("The specified task to be selected is either not part of this ribbon or not marked as visible");
        }
        if (this.currentlySelectedTask != null) {
            for (AbstractRibbonBand<?> ribbonBand : this.currentlySelectedTask.getBands()) {
                ribbonBand.setVisible(false);
            }
        }
        for (i = 0; i < task.getBandCount(); ++i) {
            AbstractRibbonBand<?> ribbonBand;
            ribbonBand = task.getBand(i);
            ribbonBand.setVisible(true);
        }
        RibbonTask old = this.currentlySelectedTask;
        this.currentlySelectedTask = task;
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTED_TASK, old, this.currentlySelectedTask);
    }

    public synchronized RibbonTask getSelectedTask() {
        return this.currentlySelectedTask;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else {
            this.setUI(new BasicRibbonUI());
        }
        for (Component comp : this.taskbarComponents) {
            SwingUtilities.updateComponentTreeUI(comp);
        }
    }

    @Override
    public RibbonUI getUI() {
        return (RibbonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized List<Component> getTaskbarComponents() {
        return Collections.unmodifiableList(this.taskbarComponents);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public synchronized void setVisible(RibbonContextualTaskGroup group, boolean isVisible) {
        this.groupVisibilityMap.put(group, isVisible);
        if (!isVisible) {
            boolean isSelectedBeingHidden = false;
            for (int i = 0; i < group.getTaskCount(); ++i) {
                if (this.getSelectedTask() != group.getTask(i)) continue;
                isSelectedBeingHidden = true;
                break;
            }
            if (isSelectedBeingHidden) {
                this.setSelectedTask(this.getTask(0));
            }
        }
        this.fireStateChanged();
        this.revalidate();
        SwingUtilities.getWindowAncestor(this).repaint();
    }

    public synchronized boolean isVisible(RibbonContextualTaskGroup group) {
        return this.groupVisibilityMap.get(group);
    }

    public synchronized void setApplicationMenu(RibbonApplicationMenu applicationMenu) {
        RibbonApplicationMenu old = this.applicationMenu;
        if (old != applicationMenu) {
            this.applicationMenu = applicationMenu;
            if (this.applicationMenu != null) {
                this.applicationMenu.setFrozen();
            }
            this.firePropertyChange(PROPERTY_APPLICATION_MENU, old, this.applicationMenu);
        }
    }

    public synchronized RibbonApplicationMenu getApplicationMenu() {
        return this.applicationMenu;
    }

    public synchronized void setApplicationMenuRichTooltip(RichTooltip tooltip) {
        RichTooltip old = this.applicationMenuRichTooltip;
        this.applicationMenuRichTooltip = tooltip;
        this.firePropertyChange(PROPERTY_APPLICATION_MENU_RICH_TOOLTIP, old, this.applicationMenuRichTooltip);
    }

    public synchronized RichTooltip getApplicationMenuRichTooltip() {
        return this.applicationMenuRichTooltip;
    }

    public synchronized void setApplicationMenuKeyTip(String keyTip) {
        String old = this.applicationMenuKeyTip;
        this.applicationMenuKeyTip = keyTip;
        this.firePropertyChange(PROPERTY_APPLICATION_MENU_KEY_TIP, old, this.applicationMenuKeyTip);
    }

    public synchronized String getApplicationMenuKeyTip() {
        return this.applicationMenuKeyTip;
    }

    public synchronized boolean isMinimized() {
        return this.isMinimized;
    }

    public synchronized void setMinimized(boolean isMinimized) {
        boolean old = this.isMinimized;
        if (old != isMinimized) {
            this.isMinimized = isMinimized;
            this.firePropertyChange(PROPERTY_MINIMIZED, old, this.isMinimized);
        }
    }

    @Deprecated
    public JRibbonFrame getRibbonFrame() {
        return this.ribbonFrame;
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag && this.getRibbonFrame() != null) {
            throw new IllegalArgumentException("Can't hide ribbon on JRibbonFrame");
        }
        super.setVisible(flag);
    }

    public synchronized ResizableIcon getApplicationIcon() {
        return this.getUI().getApplicationIcon();
    }

    public synchronized void setApplicationIcon(ResizableIcon applicationIcon) {
        ResizableIcon old = this.getUI().getApplicationIcon();
        this.getUI().setApplicationIcon(applicationIcon);
        this.firePropertyChange(PROPERTY_APPLICATION_ICON, old, this.applicationIcon);
    }
}

