/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.JPEGXRCodec;
import loci.formats.codec.LZWCodec;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ZeissCZIReader
extends FormatReader {
    public static final String ALLOW_AUTOSTITCHING_KEY = "zeissczi.autostitch";
    public static final boolean ALLOW_AUTOSTITCHING_DEFAULT = true;
    public static final String INCLUDE_ATTACHMENTS_KEY = "zeissczi.attachments";
    public static final boolean INCLUDE_ATTACHMENTS_DEFAULT = true;
    private static final int ALIGNMENT = 32;
    private static final int HEADER_SIZE = 32;
    private static final String CZI_MAGIC_STRING = "ZISRAWFILE";
    private static final int BUFFER_SIZE = 512;
    private static final int UNCOMPRESSED = 0;
    private static final int JPEG = 1;
    private static final int LZW = 2;
    private static final int JPEGXR = 4;
    private static final int GRAY8 = 0;
    private static final int GRAY16 = 1;
    private static final int GRAY_FLOAT = 2;
    private static final int BGR_24 = 3;
    private static final int BGR_48 = 4;
    private static final int BGR_FLOAT = 8;
    private static final int BGRA_8 = 9;
    private static final int COMPLEX = 10;
    private static final int COMPLEX_FLOAT = 11;
    private static final int GRAY32 = 12;
    private static final int GRAY_DOUBLE = 13;
    private MetadataStore store;
    private HashMap<Integer, String> pixels;
    private ArrayList<Segment> segments;
    private ArrayList<SubBlock> planes;
    private HashMap<Coordinate, ArrayList<Integer>> indexIntoPlanes = new HashMap();
    private int rotations = 1;
    private int positions = 1;
    private int illuminations = 1;
    private int acquisitions = 1;
    private int mosaics = 1;
    private int phases = 1;
    private int angles = 1;
    private int maxResolution = 0;
    private String imageName;
    private String acquiredDate;
    private String description;
    private String userDisplayName;
    private String userName;
    private String userFirstName;
    private String userLastName;
    private String userMiddleName;
    private String userEmail;
    private String userInstitution;
    private String temperature;
    private String airPressure;
    private String humidity;
    private String co2Percent;
    private String correctionCollar;
    private String medium;
    private String refractiveIndex;
    private transient Time timeIncrement;
    private String zoom;
    private String gain;
    private ArrayList<Channel> channels = new ArrayList();
    private ArrayList<String> binnings = new ArrayList();
    private ArrayList<String> detectorRefs = new ArrayList();
    private ArrayList<Double> timestamps = new ArrayList();
    private transient ArrayList<String> gains = new ArrayList();
    private Length[] positionsX;
    private Length[] positionsY;
    private Length[] positionsZ;
    private int previousChannel = 0;
    private Boolean prestitched = null;
    private String objectiveSettingsID;
    private boolean hasDetectorSettings = false;
    private int scanDim = 1;
    private String[] rotationLabels;
    private String[] phaseLabels;
    private String[] illuminationLabels;
    private transient DocumentBuilder parser;
    private ArrayList<Attachment> extraImages = new ArrayList();
    private int[] tileWidth;
    private int[] tileHeight;
    private int scaleFactor;

    public ZeissCZIReader() {
        super("Zeiss CZI", "czi");
        this.domains = new String[]{"Light Microscopy", "Histology"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 10;
        if (!FormatTools.validStream(stream, 10, true)) {
            return false;
        }
        String check = stream.readString(10);
        return check.equals(CZI_MAGIC_STRING);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.pixels == null || this.pixels.size() == 0 && noPixels) {
            return null;
        }
        if (noPixels) {
            return null;
        }
        String[] files = new String[this.pixels.size() + 1];
        files[0] = this.currentId;
        Object[] keys = this.pixels.keySet().toArray(new Integer[this.pixels.size()]);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            files[i + 1] = this.pixels.get(keys[i]);
        }
        return files;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.getPixelType() != 0 && this.getPixelType() != 1 || this.previousChannel == -1 || this.previousChannel >= this.channels.size()) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        String color = this.channels.get((int)this.previousChannel).color;
        if (color != null) {
            color = color.replaceAll("#", "");
            try {
                int colorValue = Integer.parseInt(color, 16);
                int redMax = (colorValue & 0xFF0000) >> 16;
                int greenMax = (colorValue & 0xFF00) >> 8;
                int blueMax = colorValue & 0xFF;
                for (int i = 0; i < lut[0].length; ++i) {
                    lut[0][i] = (byte)((double)redMax * ((double)i / 255.0));
                    lut[1][i] = (byte)((double)greenMax * ((double)i / 255.0));
                    lut[2][i] = (byte)((double)blueMax * ((double)i / 255.0));
                }
                return lut;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.getPixelType() != 2 && this.getPixelType() != 3 || this.previousChannel == -1 || this.previousChannel >= this.channels.size()) {
            return null;
        }
        short[][] lut = new short[3][65536];
        String color = this.channels.get((int)this.previousChannel).color;
        if (color != null) {
            color = color.replaceAll("#", "");
            try {
                int colorValue = Integer.parseInt(color, 16);
                int redMax = (colorValue & 0xFF0000) >> 16;
                int greenMax = (colorValue & 0xFF00) >> 8;
                int blueMax = colorValue & 0xFF;
                redMax = (int)(65535.0 * ((double)redMax / 255.0));
                greenMax = (int)(65535.0 * ((double)greenMax / 255.0));
                blueMax = (int)(65535.0 * ((double)blueMax / 255.0));
                for (int i = 0; i < lut[0].length; ++i) {
                    lut[0][i] = (short)((int)((double)redMax * ((double)i / 65535.0)) & 0xFFFF);
                    lut[1][i] = (short)((int)((double)greenMax * ((double)i / 65535.0)) & 0xFFFF);
                    lut[2][i] = (short)((int)((double)blueMax * ((double)i / 65535.0)) & 0xFFFF);
                }
                return lut;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int baseResolution;
        boolean validScanDim;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.isThumbnailSeries()) {
            int index = this.getCoreIndex() - (this.core.size() - this.extraImages.size());
            byte[] fullPlane = this.extraImages.get((int)index).attachmentData;
            try (RandomAccessInputStream s = new RandomAccessInputStream(fullPlane);){
                this.readPlane(s, x, y, w, h, buf);
            }
            return buf;
        }
        this.previousChannel = this.getZCTCoords(no)[1];
        int currentIndex = this.getCoreIndex();
        Region image = new Region(x, y, w, h);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = this.getRGBChannelCount() * bpp;
        int outputRowLen = w * pixel;
        int outputRow = 0;
        int outputCol = 0;
        boolean bl = validScanDim = this.scanDim == this.getImageCount() / (this.getSizeC() * this.phases) && this.scanDim > 1;
        if (this.planes.size() == this.getImageCount()) {
            validScanDim = false;
        }
        Arrays.fill(buf, (byte)0);
        boolean emptyTile = true;
        int minTileX = Integer.MAX_VALUE;
        int minTileY = Integer.MAX_VALUE;
        for (baseResolution = currentIndex; baseResolution > 0 && ((CoreMetadata)this.core.get((int)(baseResolution - 1))).sizeX > ((CoreMetadata)this.core.get((int)baseResolution)).sizeX; --baseResolution) {
        }
        for (SubBlock plane : this.planes) {
            if (!(plane.planeIndex == no && (this.maxResolution == 0 && plane.coreIndex == currentIndex || this.maxResolution > 0 && plane.coreIndex == baseResolution)) && (plane.planeIndex != this.previousChannel || !validScanDim)) continue;
            if (plane.row < minTileY) {
                minTileY = plane.row;
            }
            if (plane.col >= minTileX) continue;
            minTileX = plane.col;
        }
        for (SubBlock plane : this.planes) {
            if ((plane.coreIndex != currentIndex || plane.planeIndex != no) && (plane.planeIndex != this.previousChannel || !validScanDim)) continue;
            int res = (int)Math.pow(this.scaleFactor, plane.resolutionIndex);
            int realX = plane.x / res;
            int realY = plane.y / res;
            if (this.prestitched != null && this.prestitched.booleanValue() || validScanDim) {
                Region tile = new Region(plane.col, plane.row, realX, realY);
                if (validScanDim) {
                    tile.y += no / this.getSizeC();
                    image.height = this.scanDim;
                }
                if (this.prestitched != null && this.prestitched.booleanValue() && realX == this.getSizeX() && realY == this.getSizeY()) {
                    tile.x = 0;
                    tile.y = 0;
                } else if (this.prestitched != null && this.prestitched.booleanValue()) {
                    tile.x -= minTileX;
                    tile.y -= minTileY;
                }
                tile.x /= res;
                tile.y /= res;
                if (!tile.intersects(image)) continue;
                emptyTile = false;
                byte[] rawData = new SubBlock(plane).readPixelData();
                Region intersection = tile.intersection(image);
                int intersectionX = 0;
                if (tile.x < image.x) {
                    intersectionX = image.x - tile.x;
                }
                outputCol = (intersection.x - x) * pixel;
                outputRow = intersection.y - y;
                if (validScanDim) {
                    outputRow -= tile.y;
                }
                if (rawData.length < realX * realY * pixel) {
                    realX = rawData.length / (realY * pixel);
                } else if (rawData.length == (realX + 1) * (realY + 1) * pixel) {
                    ++realX;
                    ++realY;
                }
                int rowLen = pixel * Math.min(intersection.width, realX);
                int outputOffset = outputRow * outputRowLen + outputCol;
                for (int trow = 0; trow < intersection.height; ++trow) {
                    int realRow = trow + intersection.y - tile.y;
                    if (validScanDim) {
                        realRow += tile.y;
                    }
                    int inputOffset = pixel * (realRow * realX + intersectionX);
                    System.arraycopy(rawData, inputOffset, buf, outputOffset, rowLen);
                    outputOffset += outputRowLen;
                }
                continue;
            }
            byte[] rawData = null;
            rawData = this.pixels.size() == 0 ? new SubBlock(plane).readPixelData(this.in, new Region(x, y, w, h), buf) : new SubBlock(plane).readPixelData();
            if (rawData.length > buf.length || this.pixels.size() > 0) {
                try (RandomAccessInputStream s = new RandomAccessInputStream(rawData);){
                    this.readPlane(s, x, y, w, h, realX - this.getSizeX(), buf);
                    emptyTile = false;
                    break;
                }
            }
            emptyTile = false;
            break;
        }
        if (this.isRGB() && !emptyTile) {
            int redOffset = bpp * 2;
            for (int i = 0; i < buf.length / pixel; ++i) {
                int index = i * pixel;
                for (int b = 0; b < bpp; ++b) {
                    int blueIndex = index + b;
                    int redIndex = index + redOffset + b;
                    byte red = buf[redIndex];
                    buf[redIndex] = buf[blueIndex];
                    buf[blueIndex] = red;
                }
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixels = null;
            this.segments = null;
            this.planes = null;
            this.rotations = 1;
            this.positions = 1;
            this.illuminations = 1;
            this.acquisitions = 1;
            this.mosaics = 1;
            this.phases = 1;
            this.angles = 1;
            this.store = null;
            this.acquiredDate = null;
            this.userDisplayName = null;
            this.userName = null;
            this.userFirstName = null;
            this.userLastName = null;
            this.userMiddleName = null;
            this.userEmail = null;
            this.userInstitution = null;
            this.temperature = null;
            this.airPressure = null;
            this.humidity = null;
            this.co2Percent = null;
            this.correctionCollar = null;
            this.medium = null;
            this.refractiveIndex = null;
            this.positionsX = null;
            this.positionsY = null;
            this.positionsZ = null;
            this.zoom = null;
            this.gain = null;
            this.timeIncrement = null;
            this.channels.clear();
            this.binnings.clear();
            this.detectorRefs.clear();
            this.timestamps.clear();
            this.gains.clear();
            this.previousChannel = 0;
            this.prestitched = null;
            this.objectiveSettingsID = null;
            this.imageName = null;
            this.hasDetectorSettings = false;
            this.scanDim = 1;
            this.rotationLabels = null;
            this.illuminationLabels = null;
            this.phaseLabels = null;
            this.indexIntoPlanes.clear();
            this.parser = null;
            this.extraImages.clear();
            this.maxResolution = 0;
            this.tileWidth = null;
            this.tileHeight = null;
            this.scaleFactor = 0;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        if (this.maxResolution > 0 && this.getCoreIndex() < this.core.size() - this.extraImages.size()) {
            return Math.min(1024, this.getSizeX());
        }
        if (this.tileWidth != null && this.getCoreIndex() < this.tileWidth.length) {
            int width = this.tileWidth[this.getCoreIndex()];
            if (width == 0 && this.getCoreIndex() > 0) {
                width = this.tileWidth[this.getCoreIndex() - 1] / 2;
            }
            return width == 0 ? 1024 : width;
        }
        return super.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        if (this.maxResolution > 0 && this.getCoreIndex() < this.core.size() - this.extraImages.size()) {
            return Math.min(1024, this.getSizeY());
        }
        if (this.tileHeight != null && this.getCoreIndex() < this.tileHeight.length) {
            int height = this.tileHeight[this.getCoreIndex()];
            if (height == 0 && this.getCoreIndex() > 0) {
                height = this.tileHeight[this.getCoreIndex() - 1] / 2;
            }
            return height == 0 ? 1024 : height;
        }
        return super.getOptimalTileHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        String[] list;
        super.initFile(id);
        this.parser = XMLTools.createBuilder();
        String base = id.substring(0, id.lastIndexOf("."));
        if (base.endsWith(")") && this.isGroupFiles()) {
            LOGGER.info("Checking for master file");
            int lastFileSeparator = base.lastIndexOf(File.separator);
            int end = base.lastIndexOf(" (");
            if (end < 0 || end < lastFileSeparator) {
                end = base.lastIndexOf("(");
            }
            if (end > 0 && end > lastFileSeparator && new Location(base = base.substring(0, end) + ".czi").exists()) {
                LOGGER.info("Initializing master file {}", (Object)base);
                this.initFile(base);
                return;
            }
        }
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        ms0.littleEndian = true;
        this.pixels = new HashMap();
        this.segments = new ArrayList();
        this.planes = new ArrayList();
        this.readSegments(id);
        Location file2 = new Location(id).getAbsoluteFile();
        base = file2.getName();
        base = base.substring(0, base.lastIndexOf("."));
        Location parent = file2.getParentFile();
        for (String f : list = parent.list(true)) {
            if (!f.startsWith(base + "(") && !f.startsWith(base + " (")) continue;
            String part = f.substring(f.lastIndexOf("(") + 1, f.lastIndexOf(")"));
            try {
                this.pixels.put(Integer.parseInt(part), new Location(parent, f).getAbsolutePath());
            }
            catch (NumberFormatException e) {
                LOGGER.debug("{} not included in multi-file dataset", (Object)f);
            }
        }
        Object[] keys = this.pixels.keySet().toArray(new Integer[this.pixels.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            this.readSegments(this.pixels.get(key));
        }
        this.calculateDimensions();
        if (this.planes.size() == 0) {
            throw new FormatException("Pixel data could not be found; this file may be corrupted");
        }
        int firstX = this.planes.get((int)0).x;
        int firstY = this.planes.get((int)0).y;
        if (this.getSizeC() == 0) {
            ms0.sizeC = 1;
        }
        if (this.getSizeZ() == 0) {
            ms0.sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            ms0.sizeT = 1;
        }
        if (this.getImageCount() == 0) {
            ms0.imageCount = ms0.sizeZ * ms0.sizeT;
        }
        int originalC = this.getSizeC();
        this.convertPixelType(this.planes.get((int)0).directoryEntry.pixelType);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (this.isRGB()) {
            bpp *= this.getSizeC() / originalC;
        }
        int fullResBlockCount = this.planes.size();
        for (int i2 = 0; i2 < this.planes.size(); ++i2) {
            long planeSize = (long)this.planes.get((int)i2).x * (long)this.planes.get((int)i2).y * (long)bpp;
            int compression = this.planes.get((int)i2).directoryEntry.compression;
            if (compression == 0 || compression == 4) {
                long size = this.planes.get((int)i2).dataSize;
                if (size < planeSize || planeSize >= Integer.MAX_VALUE || size < 0L) {
                    DimensionEntry[] entries = this.planes.get((int)i2).directoryEntry.dimensionEntries;
                    byte pyramidType = this.planes.get((int)i2).directoryEntry.pyramidType;
                    if (!(pyramidType != 1 && pyramidType != 2 && compression != 4 || compression != 4 && size != (long)(entries[0].storedSize * entries[1].storedSize * bpp))) {
                        int scale = this.planes.get((int)i2).x / entries[0].storedSize;
                        if (scale == 1 || (scale % 2 == 0 || scale % 3 == 0) && this.allowAutostitching()) {
                            if (scale > 1 && this.scaleFactor == 0) {
                                this.scaleFactor = scale % 2 == 0 ? 2 : 3;
                            }
                            this.planes.get((int)i2).coreIndex = 0;
                            while (scale > 1) {
                                scale /= this.scaleFactor;
                                ++this.planes.get((int)i2).coreIndex;
                            }
                            if (this.planes.get((int)i2).coreIndex > this.maxResolution) {
                                this.maxResolution = this.planes.get((int)i2).coreIndex;
                            }
                        } else {
                            LOGGER.trace("removing block #{}; calculated size = {}, recorded size = {}, scale = {}", i2, planeSize, size, scale);
                            this.planes.remove(i2);
                            --i2;
                        }
                    } else {
                        LOGGER.trace("removing block #{}; calculated size = {}, recorded size = {}", i2, planeSize, size);
                        this.planes.remove(i2);
                        --i2;
                    }
                    --fullResBlockCount;
                    continue;
                }
                this.scanDim = (int)(size / planeSize);
                continue;
            }
            byte[] pixels = this.planes.get(i2).readPixelData();
            if ((long)pixels.length < planeSize || planeSize >= Integer.MAX_VALUE) {
                LOGGER.trace("removing block #{}; calculated size = {}, decoded size = {}", i2, planeSize, pixels.length);
                this.planes.remove(i2);
                --i2;
                continue;
            }
            this.scanDim = (int)((long)pixels.length / planeSize);
        }
        if (this.getSizeZ() == 0) {
            ms0.sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            ms0.sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            ms0.sizeT = 1;
        }
        LOGGER.trace("rotations = {}", (Object)this.rotations);
        LOGGER.trace("illuminations = {}", (Object)this.illuminations);
        LOGGER.trace("phases = {}", (Object)this.phases);
        LOGGER.trace("positions = {}", (Object)this.positions);
        LOGGER.trace("acquisitions = {}", (Object)this.acquisitions);
        LOGGER.trace("mosaics = {}", (Object)this.mosaics);
        LOGGER.trace("angles = {}", (Object)this.angles);
        ms0.moduloZ.step = ms0.sizeZ;
        ms0.moduloZ.end = ms0.sizeZ * (this.rotations - 1);
        ms0.moduloZ.type = "Rotation";
        ms0.sizeZ *= this.rotations;
        ms0.moduloC.step = ms0.sizeC;
        ms0.moduloC.end = ms0.sizeC * (this.illuminations - 1);
        ms0.moduloC.type = "Illumination";
        ms0.moduloC.parentType = "Channel";
        ms0.sizeC *= this.illuminations;
        ms0.moduloT.step = ms0.sizeT;
        ms0.moduloT.end = ms0.sizeT * (this.phases - 1);
        ms0.moduloT.type = "Phase";
        ms0.sizeT *= this.phases;
        int seriesCount = this.positions * this.acquisitions * this.angles;
        int originalMosaicCount = this.mosaics;
        if (this.maxResolution == 0) {
            seriesCount *= this.mosaics;
        } else {
            this.prestitched = true;
        }
        ms0.imageCount = this.getSizeZ() * (this.isRGB() ? this.getSizeC() / 3 : this.getSizeC()) * this.getSizeT();
        LOGGER.trace("Size Z = {}", (Object)this.getSizeZ());
        LOGGER.trace("Size C = {}", (Object)this.getSizeC());
        LOGGER.trace("Size T = {}", (Object)this.getSizeT());
        LOGGER.trace("is RGB = {}", (Object)this.isRGB());
        LOGGER.trace("calculated image count = {}", (Object)ms0.imageCount);
        LOGGER.trace("number of available planes = {}", (Object)this.planes.size());
        LOGGER.trace("prestitched = {}", (Object)this.prestitched);
        LOGGER.trace("scanDim = {}", (Object)this.scanDim);
        int calculatedSeries = fullResBlockCount / this.getImageCount();
        if ((this.mosaics == seriesCount || this.positions == seriesCount) && (seriesCount == calculatedSeries || this.maxResolution > 0 && seriesCount * this.mosaics == calculatedSeries) && this.prestitched != null && this.prestitched.booleanValue()) {
            boolean equalTiles = true;
            for (SubBlock plane : this.planes) {
                if (plane.x == this.planes.get((int)0).x && plane.y == this.planes.get((int)0).y) continue;
                equalTiles = false;
                break;
            }
            if ((this.getSizeX() > this.planes.get((int)0).x || this.getSizeX() == this.planes.get((int)0).x && calculatedSeries == seriesCount * this.mosaics * this.positions) && !equalTiles && this.allowAutostitching()) {
                seriesCount = 1;
                this.positions = 1;
                this.acquisitions = 1;
                this.mosaics = 1;
                this.angles = 1;
            } else {
                int newX = this.planes.get((int)(this.planes.size() - 1)).x;
                int newY = this.planes.get((int)(this.planes.size() - 1)).y;
                if (this.allowAutostitching() && (ms0.sizeX < newX || ms0.sizeY < newY)) {
                    this.prestitched = true;
                    this.mosaics = 1;
                } else {
                    this.prestitched = this.maxResolution > 0;
                }
                ms0.sizeX = newX;
                ms0.sizeY = newY;
            }
        } else if (!this.allowAutostitching() && calculatedSeries > seriesCount) {
            ms0.sizeX = firstX;
            ms0.sizeY = firstY;
            this.prestitched = true;
        }
        if (ms0.imageCount * seriesCount > this.planes.size() * this.scanDim && this.planes.size() > 0) {
            if (this.planes.size() != ms0.imageCount && this.planes.size() != ms0.sizeT && this.planes.size() % (seriesCount * this.getSizeZ()) == 0) {
                if (!this.isGroupFiles() && this.planes.size() == ms0.imageCount * seriesCount / this.positions) {
                    seriesCount /= this.positions;
                    this.positions = 1;
                }
            } else if (this.planes.size() == ms0.sizeT || this.planes.size() == ms0.imageCount || !this.isGroupFiles() && this.positions > 1) {
                this.positions = 1;
                this.acquisitions = 1;
                this.mosaics = 1;
                this.angles = 1;
                seriesCount = 1;
            } else if (seriesCount > this.mosaics && this.mosaics > 1 && this.prestitched != null && this.prestitched.booleanValue()) {
                seriesCount /= this.mosaics;
                this.mosaics = 1;
            }
        }
        ms0.dimensionOrder = "XYCZT";
        ArrayList<Integer> pixelTypes = new ArrayList<Integer>();
        pixelTypes.add(this.planes.get((int)0).directoryEntry.pixelType);
        if (this.maxResolution == 0) {
            for (SubBlock plane : this.planes) {
                if (!pixelTypes.contains(plane.directoryEntry.pixelType)) {
                    pixelTypes.add(plane.directoryEntry.pixelType);
                }
                plane.pixelTypeIndex = pixelTypes.indexOf(plane.directoryEntry.pixelType);
            }
            if (seriesCount * pixelTypes.size() > 1) {
                this.core.clear();
                for (int j = 0; j < pixelTypes.size(); ++j) {
                    for (int i3 = 0; i3 < seriesCount; ++i3) {
                        CoreMetadata add = new CoreMetadata(ms0);
                        if (pixelTypes.size() > 1) {
                            int newC;
                            add.sizeC = newC = originalC / pixelTypes.size();
                            add.imageCount = add.sizeZ * add.sizeT;
                            add.rgb = false;
                            this.convertPixelType(add, (Integer)pixelTypes.get(j));
                        }
                        this.core.add(add);
                    }
                }
            }
        }
        if (seriesCount > 1 || this.maxResolution > 0) {
            this.core.clear();
            for (int i4 = 0; i4 < seriesCount; ++i4) {
                CoreMetadata add = new CoreMetadata(ms0);
                add.resolutionCount = this.maxResolution + 1;
                this.core.add(add);
                for (int r = 0; r < this.maxResolution; ++r) {
                    CoreMetadata resolution = new CoreMetadata(add);
                    resolution.resolutionCount = 1;
                    this.core.add(resolution);
                }
            }
        }
        this.assignPlaneIndices();
        if (this.maxResolution > 0) {
            this.tileWidth = new int[this.core.size()];
            this.tileHeight = new int[this.core.size()];
            for (int s = 0; s < this.core.size(); s += ((CoreMetadata)this.core.get((int)s)).resolutionCount) {
                if (s > 0) {
                    ((CoreMetadata)this.core.get((int)s)).sizeX = 0;
                    ((CoreMetadata)this.core.get((int)s)).sizeY = 0;
                    this.calculateDimensions(s, true);
                }
                if (originalMosaicCount > 1) {
                    int minRow = Integer.MAX_VALUE;
                    int maxRow = Integer.MIN_VALUE;
                    int minCol = Integer.MAX_VALUE;
                    int maxCol = Integer.MIN_VALUE;
                    int x = 0;
                    int y = 0;
                    int lastX = 0;
                    int lastY = 0;
                    for (SubBlock plane : this.planes) {
                        if (plane.coreIndex != s) continue;
                        if (x == 0 && y == 0) {
                            x = plane.x;
                            y = plane.y;
                        }
                        if (plane.row < minRow) {
                            minRow = plane.row;
                        }
                        if (plane.row > maxRow) {
                            maxRow = plane.row;
                        }
                        if (plane.col < minCol) {
                            minCol = plane.col;
                        }
                        if (plane.col > maxCol) {
                            maxCol = plane.col;
                        }
                        if (plane.x > this.tileWidth[s]) {
                            this.tileWidth[s] = plane.x;
                        }
                        if (plane.y > this.tileHeight[s]) {
                            this.tileHeight[s] = plane.y;
                        }
                        if (plane.row != maxRow || plane.col != maxCol) continue;
                        lastX = plane.x;
                        lastY = plane.y;
                    }
                    if (((CoreMetadata)this.core.get((int)s)).sizeX == x && ((CoreMetadata)this.core.get((int)s)).sizeY == y) {
                        ((CoreMetadata)this.core.get((int)s)).sizeX = lastX + maxCol - minCol;
                        ((CoreMetadata)this.core.get((int)s)).sizeY = lastY + maxRow - minRow;
                    }
                }
                boolean keepMissingPyramid = false;
                for (int r = 0; r < ((CoreMetadata)this.core.get((int)s)).resolutionCount; ++r) {
                    boolean hasValidPlane = false;
                    for (SubBlock plane : this.planes) {
                        if (plane.coreIndex != s + r) continue;
                        hasValidPlane = true;
                        break;
                    }
                    if (!hasValidPlane && r > 0 && !keepMissingPyramid) {
                        this.core.remove(s + r);
                        --((CoreMetadata)this.core.get((int)s)).resolutionCount;
                        for (SubBlock plane : this.planes) {
                            if (plane.coreIndex <= s + r) continue;
                            --plane.coreIndex;
                        }
                        --r;
                    } else {
                        int div = (int)Math.pow(this.scaleFactor, r);
                        if (r == 0 && s > 0 && ((CoreMetadata)this.core.get((int)s)).sizeX == 1) {
                            ((CoreMetadata)this.core.get((int)s)).sizeX = ((CoreMetadata)this.core.get((int)(s - this.maxResolution))).sizeX;
                            ((CoreMetadata)this.core.get((int)s)).sizeY = ((CoreMetadata)this.core.get((int)(s - this.maxResolution))).sizeY;
                        } else {
                            ((CoreMetadata)this.core.get((int)(s + r))).sizeX = ((CoreMetadata)this.core.get((int)s)).sizeX / div;
                            ((CoreMetadata)this.core.get((int)(s + r))).sizeY = ((CoreMetadata)this.core.get((int)s)).sizeY / div;
                        }
                        this.tileWidth[s + r] = this.tileWidth[s] / div;
                        this.tileHeight[s + r] = this.tileHeight[s] / div;
                    }
                    if (r != 0 || hasValidPlane) continue;
                    keepMissingPyramid = true;
                }
            }
        }
        String firstXML = null;
        boolean canSkipXML = true;
        String currentPath = new Location(this.currentId).getAbsolutePath();
        boolean isPALM = false;
        if (this.planes.size() <= 2 && this.getImageCount() <= 2) {
            for (Segment segment : this.segments) {
                String path = new Location(segment.filename).getAbsolutePath();
                if (!currentPath.equals(path) || !(segment instanceof Metadata)) continue;
                segment.fillInData();
                String xml = ((Metadata)segment).xml;
                xml = XMLTools.sanitizeXML(xml);
                if (firstXML == null && canSkipXML) {
                    firstXML = xml;
                }
                if (canSkipXML && firstXML.equals(xml)) {
                    isPALM = this.checkPALM(xml);
                } else if (!firstXML.equals(xml)) {
                    canSkipXML = false;
                }
                ((Metadata)segment).clearXML();
            }
        }
        if (isPALM) {
            int i5;
            LOGGER.debug("Detected PALM data");
            ((CoreMetadata)this.core.get((int)0)).sizeC = 1;
            ((CoreMetadata)this.core.get((int)0)).imageCount = ((CoreMetadata)this.core.get((int)0)).sizeZ * ((CoreMetadata)this.core.get((int)0)).sizeT;
            for (i5 = 0; i5 < this.planes.size(); ++i5) {
                SubBlock p = this.planes.get(i5);
                int storedX = p.directoryEntry.dimensionEntries[0].storedSize;
                int storedY = p.directoryEntry.dimensionEntries[1].storedSize;
                if (p.planeIndex >= this.getImageCount()) {
                    if (this.core.size() == 1) {
                        CoreMetadata second = new CoreMetadata((CoreMetadata)this.core.get(0));
                        this.core.add(second);
                    }
                    p.coreIndex = 1;
                    p.planeIndex -= this.planes.size() / 2;
                    ((CoreMetadata)this.core.get((int)1)).sizeX = storedX;
                    ((CoreMetadata)this.core.get((int)1)).sizeY = storedY;
                    continue;
                }
                ((CoreMetadata)this.core.get((int)0)).sizeX = storedX;
                ((CoreMetadata)this.core.get((int)0)).sizeY = storedY;
            }
            if (this.core.size() == 2 && ((CoreMetadata)this.core.get((int)0)).sizeX == ((CoreMetadata)this.core.get((int)1)).sizeX && ((CoreMetadata)this.core.get((int)0)).sizeY == ((CoreMetadata)this.core.get((int)1)).sizeY) {
                isPALM = false;
                this.core.remove(1);
                ((CoreMetadata)this.core.get((int)0)).sizeC = 2;
                ((CoreMetadata)this.core.get((int)0)).imageCount *= this.getSizeC();
                for (i5 = 0; i5 < this.planes.size(); ++i5) {
                    SubBlock p = this.planes.get(i5);
                    if (p.coreIndex != 1) continue;
                    p.coreIndex = 0;
                    p.planeIndex += this.planes.size() / 2;
                }
            }
        }
        this.readAttachments();
        this.store = this.makeFilterMetadata();
        MetadataTools.populatePixels(this.store, this, true);
        firstXML = null;
        canSkipXML = true;
        for (Segment segment : this.segments) {
            String path = new Location(segment.filename).getAbsolutePath();
            if (currentPath.equals(path) && segment instanceof Metadata) {
                segment.fillInData();
                String xml = ((Metadata)segment).xml;
                xml = XMLTools.sanitizeXML(xml);
                if (firstXML == null && canSkipXML) {
                    firstXML = xml;
                }
                if (canSkipXML && firstXML.equals(xml)) {
                    this.translateMetadata(xml);
                } else if (!firstXML.equals(xml)) {
                    canSkipXML = false;
                }
                ((Metadata)segment).clearXML();
            } else if (segment instanceof Attachment) {
                AttachmentEntry entry = ((Attachment)segment).attachment;
                String name = entry.name.trim();
                if (name.equals("TimeStamps")) {
                    segment.fillInData();
                    try (DimensionEntry[] s = new RandomAccessInputStream(((Attachment)segment).attachmentData);){
                        s.order(this.isLittleEndian());
                        s.seek(8L);
                        while (s.getFilePointer() + 8L <= s.length()) {
                            this.timestamps.add(s.readDouble());
                        }
                    }
                }
            }
            segment.close();
        }
        if (this.rotationLabels != null) {
            ms0.moduloZ.labels = this.rotationLabels;
            ms0.moduloZ.end = ms0.moduloZ.start;
        }
        if (this.illuminationLabels != null) {
            ms0.moduloC.labels = this.illuminationLabels;
            ms0.moduloC.end = ms0.moduloC.start;
        }
        if (this.phaseLabels != null) {
            ms0.moduloT.labels = this.phaseLabels;
            ms0.moduloT.end = ms0.moduloT.start;
        }
        for (i = 0; i < this.planes.size(); ++i) {
            SubBlock p = this.planes.get(i);
            Coordinate c = new Coordinate(p.coreIndex, p.planeIndex, this.getImageCount());
            ArrayList<Integer> indices = new ArrayList<Integer>();
            if (this.indexIntoPlanes.containsKey(c)) {
                indices = this.indexIntoPlanes.get(c);
            }
            indices.add(i);
            this.indexIntoPlanes.put(c, indices);
            int nameWidth = String.valueOf(this.getSeriesCount()).length();
            for (DimensionEntry dimension : p.directoryEntry.dimensionEntries) {
                if (dimension == null) continue;
                switch (dimension.dimension.charAt(0)) {
                    case 'S': {
                        this.setCoreIndex(p.coreIndex);
                        int seriesId = p.coreIndex + 1;
                        String sIndex = String.format("Positions|Series %0" + nameWidth + "d|", seriesId);
                        this.addSeriesMetaList(sIndex, dimension.start);
                    }
                }
            }
            this.setCoreIndex(0);
        }
        if (this.channels.size() > 0 && this.channels.get((int)0).color != null && !this.isRGB()) {
            for (i = 0; i < seriesCount; ++i) {
                ((CoreMetadata)this.core.get((int)i)).indexed = true;
            }
        }
        String experimenterID = MetadataTools.createLSID("Experimenter", 0);
        this.store.setExperimenterID(experimenterID, 0);
        this.store.setExperimenterEmail(this.userEmail, 0);
        this.store.setExperimenterFirstName(this.userFirstName, 0);
        this.store.setExperimenterInstitution(this.userInstitution, 0);
        this.store.setExperimenterLastName(this.userLastName, 0);
        this.store.setExperimenterMiddleName(this.userMiddleName, 0);
        this.store.setExperimenterUserName(this.userName, 0);
        String name = new Location(this.getCurrentFile()).getName();
        if (this.imageName != null && this.imageName.trim().length() > 0) {
            name = this.imageName;
        }
        this.store.setInstrumentID(MetadataTools.createLSID("Instrument", 0), 0);
        int indexLength = String.valueOf(this.getSeriesCount()).length();
        for (int i6 = 0; i6 < this.getSeriesCount(); ++i6) {
            Timestamp t;
            this.store.setImageInstrumentRef(MetadataTools.createLSID("Instrument", 0), i6);
            if (this.acquiredDate != null) {
                this.store.setImageAcquisitionDate(new Timestamp(this.acquiredDate), i6);
            } else if (this.planes.get(0).timestamp != null) {
                long timestamp = (long)(this.planes.get(0).timestamp * 1000.0);
                String date = DateTools.convertDate(timestamp, 0);
                this.store.setImageAcquisitionDate(new Timestamp(date), i6);
            }
            if (experimenterID != null) {
                this.store.setImageExperimenterRef(experimenterID, i6);
            }
            if (this.timeIncrement != null) {
                this.store.setPixelsTimeIncrement(this.timeIncrement, i6);
            }
            String imageIndex = String.valueOf(i6 + 1);
            while (imageIndex.length() < indexLength) {
                imageIndex = "0" + imageIndex;
            }
            int extraIndex = i6 - (this.getSeriesCount() - this.extraImages.size());
            if (extraIndex < 0) {
                if (this.hasFlattenedResolutions()) {
                    this.store.setImageName(name + " #" + imageIndex, i6);
                } else if (this.positions == 1) {
                    this.store.setImageName("", i6);
                } else {
                    this.store.setImageName("Scene #" + i6, i6);
                }
            } else if (extraIndex == 0) {
                this.store.setImageName("label image", i6);
            } else if (extraIndex == 1) {
                this.store.setImageName("macro image", i6);
            } else {
                this.store.setImageName("thumbnail image", i6);
            }
            if (extraIndex >= 0) continue;
            if (this.description != null && this.description.length() > 0) {
                this.store.setImageDescription(this.description, i6);
            }
            if (this.airPressure != null) {
                this.store.setImagingEnvironmentAirPressure(new Pressure(new Double(this.airPressure), UNITS.MILLIBAR), i6);
            }
            if (this.co2Percent != null) {
                this.store.setImagingEnvironmentCO2Percent(PercentFraction.valueOf(this.co2Percent), i6);
            }
            if (this.humidity != null) {
                this.store.setImagingEnvironmentHumidity(PercentFraction.valueOf(this.humidity), i6);
            }
            if (this.temperature != null) {
                this.store.setImagingEnvironmentTemperature(new Temperature(new Double(this.temperature), UNITS.CELSIUS), i6);
            }
            if (this.objectiveSettingsID != null) {
                this.store.setObjectiveSettingsID(this.objectiveSettingsID, i6);
                if (this.correctionCollar != null) {
                    this.store.setObjectiveSettingsCorrectionCollar(new Double(this.correctionCollar), i6);
                }
                if (this.medium != null) {
                    this.store.setObjectiveSettingsMedium(this.getMedium(this.medium), i6);
                }
                if (this.refractiveIndex != null) {
                    this.store.setObjectiveSettingsRefractiveIndex(new Double(this.refractiveIndex), i6);
                }
            }
            Double startTime = null;
            if (this.acquiredDate != null && (t = Timestamp.valueOf(this.acquiredDate)) != null) {
                startTime = (double)t.asInstant().getMillis() / 1000.0;
            }
            for (int plane = 0; plane < this.getImageCount(); ++plane) {
                int t2;
                Coordinate coordinate = new Coordinate(i6, plane, this.getImageCount());
                ArrayList<Integer> index = this.indexIntoPlanes.get(coordinate);
                if (index == null) continue;
                SubBlock p = this.planes.get(index.get(0));
                if (startTime == null) {
                    startTime = p.timestamp;
                }
                if (p.stageX != null) {
                    this.store.setPlanePositionX(p.stageX, i6, plane);
                } else if (this.positionsX != null && i6 < this.positionsX.length && this.positionsX[i6] != null) {
                    this.store.setPlanePositionX(this.positionsX[i6], i6, plane);
                } else {
                    this.store.setPlanePositionX(new Length(p.col, UNITS.REFERENCEFRAME), i6, plane);
                }
                if (p.stageY != null) {
                    this.store.setPlanePositionY(p.stageY, i6, plane);
                } else if (this.positionsY != null && i6 < this.positionsY.length && this.positionsY[i6] != null) {
                    this.store.setPlanePositionY(this.positionsY[i6], i6, plane);
                } else {
                    this.store.setPlanePositionY(new Length(p.row, UNITS.REFERENCEFRAME), i6, plane);
                }
                if (p.stageZ != null) {
                    this.store.setPlanePositionZ(p.stageZ, i6, plane);
                } else if (this.positionsZ != null && i6 < this.positionsZ.length) {
                    this.store.setPlanePositionZ(this.positionsZ[i6], i6, plane);
                }
                if (p.timestamp != null) {
                    this.store.setPlaneDeltaT(new Time(p.timestamp - startTime, UNITS.SECOND), i6, plane);
                } else if (plane < this.timestamps.size() && this.timestamps.size() == this.getImageCount()) {
                    if (this.timestamps.get(plane) != null) {
                        this.store.setPlaneDeltaT(new Time(this.timestamps.get(plane), UNITS.SECOND), i6, plane);
                    }
                } else if (this.getZCTCoords(plane)[2] < this.timestamps.size() && this.timestamps.get(t2 = this.getZCTCoords(plane)[2]) != null) {
                    this.store.setPlaneDeltaT(new Time(this.timestamps.get(t2), UNITS.S), i6, plane);
                }
                if (p.exposureTime != null) {
                    this.store.setPlaneExposureTime(new Time(p.exposureTime, UNITS.SECOND), i6, plane);
                    continue;
                }
                int channel = this.getZCTCoords(plane)[1];
                if (channel >= this.channels.size() || this.channels.get((int)channel).exposure == null) continue;
                this.store.setPlaneExposureTime(new Time(this.channels.get((int)channel).exposure, UNITS.SECOND), i6, plane);
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (c < this.channels.size()) {
                    Double wave;
                    Length ex;
                    String exWave;
                    Double wave2;
                    Length em;
                    String emWave;
                    String color;
                    if (isPALM && i6 < this.channels.size()) {
                        this.store.setChannelName(this.channels.get((int)i6).name, i6, c);
                    } else {
                        this.store.setChannelName(this.channels.get((int)c).name, i6, c);
                    }
                    this.store.setChannelFluor(this.channels.get((int)c).fluor, i6, c);
                    if (this.channels.get((int)c).filterSetRef != null) {
                        this.store.setChannelFilterSetRef(this.channels.get((int)c).filterSetRef, i6, c);
                    }
                    if ((color = this.channels.get((int)c).color) != null && !this.isRGB()) {
                        if ((color = color.replaceAll("#", "")).length() > 6) {
                            color = color.substring(2, color.length());
                        }
                        try {
                            this.store.setChannelColor(new Color(Integer.parseInt(color, 16) << 8 | 0xFF), i6, c);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn("", e);
                        }
                    }
                    if ((emWave = this.channels.get((int)c).emission) != null && (em = FormatTools.getEmissionWavelength(wave2 = new Double(emWave))) != null) {
                        this.store.setChannelEmissionWavelength(em, i6, c);
                    }
                    if ((exWave = this.channels.get((int)c).excitation) != null && (ex = FormatTools.getExcitationWavelength(wave = new Double(exWave))) != null) {
                        this.store.setChannelExcitationWavelength(ex, i6, c);
                    }
                    if (this.channels.get((int)c).illumination != null) {
                        this.store.setChannelIlluminationType(this.channels.get((int)c).illumination, i6, c);
                    }
                    if (this.channels.get((int)c).pinhole != null) {
                        this.store.setChannelPinholeSize(new Length(new Double(this.channels.get((int)c).pinhole), UNITS.MICROMETER), i6, c);
                    }
                    if (this.channels.get((int)c).acquisitionMode != null) {
                        this.store.setChannelAcquisitionMode(this.channels.get((int)c).acquisitionMode, i6, c);
                    }
                }
                if (c < this.detectorRefs.size()) {
                    String detector = this.detectorRefs.get(c);
                    this.store.setDetectorSettingsID(detector, i6, c);
                    if (c < this.binnings.size()) {
                        this.store.setDetectorSettingsBinning(this.getBinning(this.binnings.get(c)), i6, c);
                    }
                    if (c < this.channels.size()) {
                        this.store.setDetectorSettingsGain(this.channels.get((int)c).gain, i6, c);
                    }
                }
                if (c >= this.channels.size() || !this.hasDetectorSettings) continue;
                this.store.setDetectorSettingsGain(this.channels.get((int)c).gain, i6, c);
            }
        }
        this.segments = null;
    }

    public boolean allowAutostitching() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(ALLOW_AUTOSTITCHING_KEY, true);
        }
        return true;
    }

    public boolean canReadAttachments() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(INCLUDE_ATTACHMENTS_KEY, true);
        }
        return true;
    }

    private void readSegments(String id) throws IOException {
        Segment segment;
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(id, 512);
        this.in.order(this.isLittleEndian());
        while (this.in.getFilePointer() < this.in.length() && (segment = this.readSegment(id)) != null) {
            this.segments.add(segment);
            if (segment instanceof SubBlock) {
                this.planes.add((SubBlock)segment);
                LOGGER.trace("plane #{} = {}", (Object)(this.planes.size() - 1), (Object)segment);
            }
            segment.close();
        }
    }

    private void readAttachments() throws FormatException, IOException {
        if (!this.canReadAttachments()) {
            return;
        }
        boolean foundLabel = false;
        boolean foundPreview = false;
        for (Segment segment : this.segments) {
            if (segment instanceof Attachment) {
                AttachmentEntry entry = ((Attachment)segment).attachment;
                String name = entry.name.trim();
                if (name.equals("Label") && !foundLabel || name.equals("SlidePreview") && !foundPreview) {
                    if (!foundLabel) {
                        foundLabel = name.equals("Label");
                    }
                    if (!foundPreview) {
                        foundPreview = name.equals("SlidePreview");
                    }
                    segment.fillInData();
                    ZeissCZIReader thumbReader = new ZeissCZIReader();
                    thumbReader.setMetadataOptions(this.getMetadataOptions());
                    ByteArrayHandle stream = new ByteArrayHandle(((Attachment)segment).attachmentData);
                    Location.mapFile("image.czi", stream);
                    thumbReader.setId("image.czi");
                    CoreMetadata c = thumbReader.getCoreMetadataList().get(0);
                    if (c.sizeZ > 1 || c.sizeT > 1) continue;
                    this.core.add(new CoreMetadata(c));
                    ((CoreMetadata)this.core.get((int)(this.core.size() - 1))).thumbnail = true;
                    ((Attachment)segment).attachmentData = thumbReader.openBytes(0);
                    thumbReader.close();
                    stream.close();
                    Location.mapFile("image.czi", null);
                    this.extraImages.add((Attachment)segment);
                }
            }
            segment.close();
        }
    }

    private void calculateDimensions() {
        this.calculateDimensions(0, false);
    }

    private void calculateDimensions(int coreIndex, boolean xyOnly) {
        CoreMetadata ms0 = (CoreMetadata)this.core.get(coreIndex);
        int previousCoreIndex = this.getCoreIndex();
        this.setCoreIndex(coreIndex);
        ArrayList<Integer> uniqueT = new ArrayList<Integer>();
        for (SubBlock plane : this.planes) {
            if (xyOnly && plane.coreIndex != coreIndex) continue;
            block15: for (DimensionEntry dimension : plane.directoryEntry.dimensionEntries) {
                if (dimension == null || xyOnly && dimension.dimension.charAt(0) != 'X' && dimension.dimension.charAt(0) != 'Y') continue;
                switch (dimension.dimension.charAt(0)) {
                    case 'X': {
                        plane.x = dimension.size;
                        plane.col = dimension.start;
                        if ((this.prestitched == null || this.prestitched.booleanValue()) && this.getSizeX() > 0 && dimension.size != this.getSizeX() && this.allowAutostitching()) {
                            this.prestitched = true;
                            continue block15;
                        }
                        if (!this.allowAutostitching() && ms0.sizeX != 0 && dimension.size != dimension.storedSize) continue block15;
                        ms0.sizeX = dimension.size;
                        continue block15;
                    }
                    case 'Y': {
                        plane.y = dimension.size;
                        plane.row = dimension.start;
                        if ((this.prestitched == null || this.prestitched.booleanValue()) && this.getSizeY() > 0 && dimension.size != this.getSizeY() && this.allowAutostitching()) {
                            this.prestitched = true;
                            continue block15;
                        }
                        if (!this.allowAutostitching() && ms0.sizeY != 0 && dimension.size != dimension.storedSize) continue block15;
                        ms0.sizeY = dimension.size;
                        continue block15;
                    }
                    case 'C': {
                        if (dimension.start < this.getSizeC()) continue block15;
                        ms0.sizeC = dimension.start + 1;
                        continue block15;
                    }
                    case 'Z': {
                        if (dimension.start > 0 && dimension.start >= this.getSizeZ()) {
                            ms0.sizeZ = dimension.start + 1;
                            continue block15;
                        }
                        if (dimension.size <= this.getSizeZ()) continue block15;
                        ms0.sizeZ = dimension.size;
                        continue block15;
                    }
                    case 'T': {
                        if (!uniqueT.contains(dimension.start)) {
                            uniqueT.add(dimension.start);
                            ms0.sizeT = uniqueT.size();
                        }
                        if (dimension.size <= this.getSizeT()) continue block15;
                        ms0.sizeT = dimension.size;
                        continue block15;
                    }
                    case 'R': {
                        if (dimension.start < this.rotations) continue block15;
                        this.rotations = dimension.start + 1;
                        continue block15;
                    }
                    case 'S': {
                        if (dimension.start < this.positions) continue block15;
                        this.positions = dimension.start + 1;
                        continue block15;
                    }
                    case 'I': {
                        if (dimension.start < this.illuminations) continue block15;
                        this.illuminations = dimension.start + 1;
                        continue block15;
                    }
                    case 'B': {
                        if (dimension.start < this.acquisitions) continue block15;
                        this.acquisitions = dimension.start + 1;
                        continue block15;
                    }
                    case 'M': {
                        if (dimension.start < this.mosaics) continue block15;
                        this.mosaics = dimension.start + 1;
                        continue block15;
                    }
                    case 'H': {
                        if (dimension.start < this.phases) continue block15;
                        this.phases = dimension.start + 1;
                        continue block15;
                    }
                    case 'V': {
                        if (dimension.start < this.angles) continue block15;
                        this.angles = dimension.start + 1;
                        continue block15;
                    }
                    default: {
                        LOGGER.warn("Unknown dimension '{}'", (Object)dimension.dimension);
                    }
                }
            }
        }
        this.setCoreIndex(previousCoreIndex);
    }

    /*
     * WARNING - void declaration
     */
    private void assignPlaneIndices() {
        void var8_11;
        LOGGER.trace("assignPlaneIndices:");
        if (this.core.size() == this.mosaics && this.maxResolution == 0) {
            LOGGER.trace("  reset position, acquisition, and angle count");
            this.positions = 1;
            this.acquisitions = 1;
            this.angles = 1;
        }
        ArrayList<Character> extraDimOrder = new ArrayList<Character>();
        int[] extraLengths = new int[4];
        int prevS = 0;
        int prevB = 0;
        int prevM = 0;
        int prevV = 0;
        for (int p = 0; p < this.planes.size(); ++p) {
            SubBlock subBlock = this.planes.get(p);
            DimensionEntry[] dimensionEntryArray = subBlock.directoryEntry.dimensionEntries;
            int n = dimensionEntryArray.length;
            block19: for (int i = 0; i < n; ++i) {
                DimensionEntry dimension = dimensionEntryArray[i];
                if (dimension == null) continue;
                switch (dimension.dimension.charAt(0)) {
                    case 'S': {
                        if (dimension.start > prevS && !extraDimOrder.contains(Character.valueOf('S'))) {
                            extraLengths[extraDimOrder.size()] = this.positions;
                            extraDimOrder.add(Character.valueOf('S'));
                        }
                        prevS = dimension.start;
                        continue block19;
                    }
                    case 'B': {
                        if (dimension.start > prevB && !extraDimOrder.contains(Character.valueOf('B'))) {
                            extraLengths[extraDimOrder.size()] = this.acquisitions;
                            extraDimOrder.add(Character.valueOf('B'));
                        }
                        prevB = dimension.start;
                        continue block19;
                    }
                    case 'M': {
                        if (!(dimension.start <= prevM || extraDimOrder.contains(Character.valueOf('M')) || this.mosaics > this.getSeriesCount() || this.prestitched != null && this.prestitched.booleanValue() && this.allowAutostitching())) {
                            extraLengths[extraDimOrder.size()] = this.mosaics;
                            extraDimOrder.add(Character.valueOf('M'));
                        }
                        prevM = dimension.start;
                        continue block19;
                    }
                    case 'V': {
                        if (dimension.start > prevV && !extraDimOrder.contains(Character.valueOf('V'))) {
                            extraLengths[extraDimOrder.size()] = this.angles;
                            extraDimOrder.add(Character.valueOf('V'));
                        }
                        prevV = dimension.start;
                    }
                }
            }
        }
        int allLengths = 1;
        for (int len : extraLengths) {
            if (len <= 0) continue;
            allLengths *= len;
        }
        boolean bl = false;
        while (var8_11 < this.planes.size()) {
            LOGGER.trace("  processing plane #{} of {}", (Object)((int)var8_11), (Object)this.planes.size());
            SubBlock plane = this.planes.get((int)var8_11);
            int z = 0;
            int c = 0;
            int t = 0;
            int r = 0;
            int i = 0;
            int phase = 0;
            int[] extra = new int[4];
            boolean noAngle = true;
            block22: for (DimensionEntry dimension : plane.directoryEntry.dimensionEntries) {
                LOGGER.trace("    procession dimension '{}'", (Object)dimension.dimension);
                LOGGER.trace("      dimension size = {}", (Object)dimension.size);
                LOGGER.trace("      dimension start = {}", (Object)dimension.start);
                if (dimension == null) continue;
                int extraIndex = extraDimOrder.indexOf(Character.valueOf(dimension.dimension.charAt(0)));
                switch (dimension.dimension.charAt(0)) {
                    case 'C': {
                        c = dimension.start - plane.pixelTypeIndex;
                        continue block22;
                    }
                    case 'Z': {
                        z = dimension.start;
                        if (z < this.getSizeZ()) continue block22;
                        z = this.getSizeZ() - 1;
                        continue block22;
                    }
                    case 'T': {
                        t = dimension.start;
                        if (t < this.getSizeT()) continue block22;
                        t = this.getSizeT() - 1;
                        continue block22;
                    }
                    case 'R': {
                        r = dimension.start;
                        continue block22;
                    }
                    case 'S': {
                        if (extraIndex < 0) continue block22;
                        extra[extraIndex] = dimension.start;
                        if (extra[extraIndex] < extraLengths[extraIndex]) continue block22;
                        extra[extraIndex] = 0;
                        continue block22;
                    }
                    case 'I': {
                        i = dimension.start;
                        continue block22;
                    }
                    case 'B': {
                        if (extraIndex < 0) continue block22;
                        extra[extraIndex] = dimension.start;
                        if (extra[extraIndex] < extraLengths[extraIndex]) continue block22;
                        extra[extraIndex] = 0;
                        continue block22;
                    }
                    case 'M': {
                        if (extraIndex < 0) continue block22;
                        extra[extraIndex] = dimension.start;
                        if (extra[extraIndex] < extraLengths[extraIndex]) continue block22;
                        extra[extraIndex] = 0;
                        continue block22;
                    }
                    case 'H': {
                        phase = dimension.start;
                        continue block22;
                    }
                    case 'V': {
                        if (extraIndex >= 0) {
                            extra[extraIndex] = dimension.start;
                            if (extra[extraIndex] >= extraLengths[extraIndex]) {
                                extra[extraIndex] = 0;
                            }
                        }
                        noAngle = false;
                    }
                }
            }
            if (this.angles > 1 && noAngle) {
                extra[extraDimOrder.indexOf((Object)Character.valueOf((char)'V'))] = var8_11 / (this.getImageCount() * (this.getSeriesCount() / this.angles));
            }
            if (this.rotations > 0) {
                z = r * (this.getSizeZ() / this.rotations) + z;
            }
            if (this.illuminations > 0) {
                c = i * (this.getSizeC() / this.illuminations) + c;
            }
            if (this.phases > 0) {
                t = phase * (this.getSizeT() / this.phases) + t;
            }
            plane.planeIndex = this.getIndex(z, c, t);
            int seriesIndex = FormatTools.positionToRaster(extraLengths, extra);
            plane.resolutionIndex = plane.coreIndex;
            plane.coreIndex += seriesIndex * (this.maxResolution + 1);
            LOGGER.trace("    assigned plane index = {}; series index = {}; coreIndex = {}", plane.planeIndex, seriesIndex, plane.coreIndex);
            ++var8_11;
        }
    }

    private void translateMetadata(String xml) throws FormatException, IOException {
        Element root = null;
        try {
            ByteArrayInputStream s = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            root = this.parser.parse(s).getDocumentElement();
            s.close();
        }
        catch (SAXException e) {
            throw new FormatException(e);
        }
        if (root == null) {
            throw new FormatException("Could not parse the XML metadata.");
        }
        NodeList children = root.getChildNodes();
        Element realRoot = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            realRoot = (Element)children.item(i);
            break;
        }
        this.translateExperiment(realRoot);
        this.translateInformation(realRoot);
        this.translateScaling(realRoot);
        this.translateDisplaySettings(realRoot);
        this.translateLayers(realRoot);
        this.translateHardwareSettings(realRoot);
        ArrayDeque<String> nameStack = new ArrayDeque<String>();
        this.populateOriginalMetadata(realRoot, nameStack);
    }

    private boolean checkPALM(String xml) throws FormatException, IOException {
        NodeList experiments;
        NodeList lsmTags;
        Element attributes;
        Element root = null;
        try {
            ByteArrayInputStream s = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            root = this.parser.parse(s).getDocumentElement();
            s.close();
        }
        catch (SAXException e) {
            throw new FormatException(e);
        }
        if (root == null) {
            throw new FormatException("Could not parse the XML metadata.");
        }
        NodeList customAttributes = root.getElementsByTagName("CustomAttributes");
        if (customAttributes != null && customAttributes.getLength() > 0 && (attributes = (Element)customAttributes.item(0)) != null && (lsmTags = attributes.getElementsByTagName("LsmTag")) != null) {
            for (int i = 0; i < lsmTags.getLength(); ++i) {
                Element tag = (Element)lsmTags.item(i);
                String name = tag.getAttribute("Name");
                if (!name.toLowerCase().startsWith("palm")) continue;
                return true;
            }
        }
        if ((experiments = root.getElementsByTagName("Experiment")) == null || experiments.getLength() == 0) {
            return false;
        }
        Element experimentBlock = this.getFirstNode((Element)experiments.item(0), "ExperimentBlocks");
        Element acquisition = this.getFirstNode(experimentBlock, "AcquisitionBlock");
        if (acquisition == null) {
            return false;
        }
        Element multiTrack = this.getFirstNode(acquisition, "MultiTrackSetup");
        if (multiTrack == null) {
            return false;
        }
        Element trackSetup = this.getFirstNode(multiTrack, "TrackSetup");
        if (trackSetup == null) {
            return false;
        }
        Element palmSlider = this.getFirstNode(trackSetup, "PalmSlider");
        if (palmSlider == null) {
            return false;
        }
        return Boolean.parseBoolean(palmSlider.getTextContent());
    }

    private void translateInformation(Element root) throws FormatException {
        NodeList informations = root.getElementsByTagName("Information");
        if (informations == null || informations.getLength() == 0) {
            return;
        }
        Element information = (Element)informations.item(0);
        Element image = this.getFirstNode(information, "Image");
        Element user = this.getFirstNode(information, "User");
        Element environment = this.getFirstNode(information, "Environment");
        Element instrument = this.getFirstNode(information, "Instrument");
        Element document = this.getFirstNode(information, "Document");
        if (image != null) {
            NodeList channelNodes;
            Element sNode;
            Element incrementNode;
            Element interval;
            Element positions;
            Element dimensions;
            Element tNode;
            String bitCount = this.getFirstNodeValue(image, "ComponentBitCount");
            if (bitCount != null) {
                ((CoreMetadata)this.core.get((int)0)).bitsPerPixel = Integer.parseInt(bitCount);
            }
            this.acquiredDate = this.getFirstNodeValue(image, "AcquisitionDateAndTime");
            Element objectiveSettings = this.getFirstNode(image, "ObjectiveSettings");
            this.correctionCollar = this.getFirstNodeValue(objectiveSettings, "CorrectionCollar");
            this.medium = this.getFirstNodeValue(objectiveSettings, "Medium");
            this.refractiveIndex = this.getFirstNodeValue(objectiveSettings, "RefractiveIndex");
            String sizeV = this.getFirstNodeValue(image, "SizeV");
            if (sizeV != null && this.angles == 1) {
                this.angles = Integer.parseInt(sizeV);
            }
            if ((tNode = this.getFirstNode(dimensions = this.getFirstNode(image, "Dimensions"), "T")) != null && (positions = this.getFirstNode(tNode, "Positions")) != null && (interval = this.getFirstNode(positions, "Interval")) != null && (incrementNode = this.getFirstNode(interval, "Increment")) != null) {
                String increment = incrementNode.getTextContent();
                this.timeIncrement = new Time(DataTools.parseDouble(increment), UNITS.SECOND);
            }
            if ((sNode = this.getFirstNode(dimensions, "S")) != null) {
                NodeList scenes = sNode.getElementsByTagName("Scene");
                int nextPosition = 0;
                for (int i = 0; i < scenes.getLength(); ++i) {
                    Element scene = (Element)scenes.item(i);
                    NodeList positions2 = scene.getElementsByTagName("Position");
                    for (int p = 0; p < positions2.getLength(); ++p) {
                        Element position = (Element)positions2.item(p);
                        String x = position.getAttribute("X");
                        String y = position.getAttribute("Y");
                        String z = position.getAttribute("Z");
                        if (nextPosition >= this.positionsX.length || this.positionsX[nextPosition] != null) continue;
                        this.positionsX[nextPosition] = new Length(DataTools.parseDouble(x), UNITS.MICROM);
                        this.positionsY[nextPosition] = new Length(DataTools.parseDouble(y), UNITS.MICROM);
                        this.positionsZ[nextPosition] = new Length(DataTools.parseDouble(z), UNITS.MICROM);
                        ++nextPosition;
                    }
                }
            }
            if ((channelNodes = this.getGrandchildren(dimensions, "Channel")) == null) {
                channelNodes = image.getElementsByTagName("Channel");
            }
            if (channelNodes != null) {
                for (int i = 0; i < channelNodes.getLength(); ++i) {
                    Element filterSet;
                    Element detector;
                    Element scanInfo;
                    Element detectorSettings;
                    String binning;
                    String acquisition;
                    Element channel = (Element)channelNodes.item(i);
                    while (this.channels.size() <= i) {
                        this.channels.add(new Channel());
                    }
                    this.channels.get((int)i).emission = this.getFirstNodeValue(channel, "EmissionWavelength");
                    this.channels.get((int)i).excitation = this.getFirstNodeValue(channel, "ExcitationWavelength");
                    this.channels.get((int)i).pinhole = this.getFirstNodeValue(channel, "PinholeSize");
                    this.channels.get((int)i).name = channel.getAttribute("Name");
                    String illumination = this.getFirstNodeValue(channel, "IlluminationType");
                    if (illumination != null) {
                        this.channels.get((int)i).illumination = this.getIlluminationType(illumination);
                    }
                    if ((acquisition = this.getFirstNodeValue(channel, "AcquisitionMode")) != null) {
                        this.channels.get((int)i).acquisitionMode = this.getAcquisitionMode(acquisition);
                    }
                    if ((binning = this.getFirstNodeValue(detectorSettings = this.getFirstNode(channel, "DetectorSettings"), "Binning")) != null) {
                        binning = binning.replaceAll(",", "x");
                        this.binnings.add(binning);
                    }
                    if ((scanInfo = this.getFirstNode(channel, "LaserScanInfo")) != null) {
                        this.zoom = this.getFirstNodeValue(scanInfo, "ZoomX");
                    }
                    if ((detector = this.getFirstNode(detectorSettings, "Detector")) != null) {
                        String detectorID = detector.getAttribute("Id");
                        if (detectorID.indexOf(32) != -1) {
                            detectorID = detectorID.substring(detectorID.lastIndexOf(" ") + 1);
                        }
                        if (!detectorID.startsWith("Detector:")) {
                            detectorID = "Detector:" + detectorID;
                        }
                        this.detectorRefs.add(detectorID);
                    }
                    if ((filterSet = this.getFirstNode(channel, "FilterSetRef")) == null) continue;
                    this.channels.get((int)i).filterSetRef = filterSet.getAttribute("Id");
                }
            }
        }
        if (user != null) {
            this.userDisplayName = this.getFirstNodeValue(user, "DisplayName");
            this.userFirstName = this.getFirstNodeValue(user, "FirstName");
            this.userLastName = this.getFirstNodeValue(user, "LastName");
            this.userMiddleName = this.getFirstNodeValue(user, "MiddleName");
            this.userEmail = this.getFirstNodeValue(user, "Email");
            this.userInstitution = this.getFirstNodeValue(user, "Institution");
            this.userName = this.getFirstNodeValue(user, "UserName");
        }
        if (environment != null) {
            this.temperature = this.getFirstNodeValue(environment, "Temperature");
            this.airPressure = this.getFirstNodeValue(environment, "AirPressure");
            this.humidity = this.getFirstNodeValue(environment, "Humidity");
            this.co2Percent = this.getFirstNodeValue(environment, "CO2Percent");
        }
        if (instrument != null) {
            NodeList dichroics;
            NodeList filters;
            NodeList detectors;
            NodeList lightSources;
            NodeList microscopes = this.getGrandchildren(instrument, "Microscope");
            Element manufacturerNode = null;
            this.store.setInstrumentID(MetadataTools.createLSID("Instrument", 0), 0);
            if (microscopes != null) {
                Element microscope = (Element)microscopes.item(0);
                manufacturerNode = this.getFirstNode(microscope, "Manufacturer");
                this.store.setMicroscopeManufacturer(this.getFirstNodeValue(manufacturerNode, "Manufacturer"), 0);
                this.store.setMicroscopeModel(this.getFirstNodeValue(manufacturerNode, "Model"), 0);
                this.store.setMicroscopeSerialNumber(this.getFirstNodeValue(manufacturerNode, "SerialNumber"), 0);
                this.store.setMicroscopeLotNumber(this.getFirstNodeValue(manufacturerNode, "LotNumber"), 0);
                String microscopeType = this.getFirstNodeValue(microscope, "Type");
                if (microscopeType != null) {
                    this.store.setMicroscopeType(this.getMicroscopeType(microscopeType), 0);
                }
            }
            if ((lightSources = this.getGrandchildren(instrument, "LightSource")) != null) {
                for (int i = 0; i < lightSources.getLength(); ++i) {
                    Element lightSource = (Element)lightSources.item(i);
                    manufacturerNode = this.getFirstNode(lightSource, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    String type = this.getFirstNodeValue(lightSource, "LightSourceType");
                    String power = this.getFirstNodeValue(lightSource, "Power");
                    if ("Laser".equals(type)) {
                        if (power != null) {
                            this.store.setLaserPower(new Power(new Double(power), UNITS.MILLIWATT), 0, i);
                        }
                        this.store.setLaserLotNumber(lotNumber, 0, i);
                        this.store.setLaserManufacturer(manufacturer, 0, i);
                        this.store.setLaserModel(model, 0, i);
                        this.store.setLaserSerialNumber(serialNumber, 0, i);
                        continue;
                    }
                    if ("Arc".equals(type)) {
                        if (power != null) {
                            this.store.setArcPower(new Power(new Double(power), UNITS.MILLIWATT), 0, i);
                        }
                        this.store.setArcLotNumber(lotNumber, 0, i);
                        this.store.setArcManufacturer(manufacturer, 0, i);
                        this.store.setArcModel(model, 0, i);
                        this.store.setArcSerialNumber(serialNumber, 0, i);
                        continue;
                    }
                    if ("LightEmittingDiode".equals(type)) {
                        if (power != null) {
                            this.store.setLightEmittingDiodePower(new Power(new Double(power), UNITS.MILLIWATT), 0, i);
                        }
                        this.store.setLightEmittingDiodeLotNumber(lotNumber, 0, i);
                        this.store.setLightEmittingDiodeManufacturer(manufacturer, 0, i);
                        this.store.setLightEmittingDiodeModel(model, 0, i);
                        this.store.setLightEmittingDiodeSerialNumber(serialNumber, 0, i);
                        continue;
                    }
                    if (!"Filament".equals(type)) continue;
                    if (power != null) {
                        this.store.setFilamentPower(new Power(new Double(power), UNITS.MILLIWATT), 0, i);
                    }
                    this.store.setFilamentLotNumber(lotNumber, 0, i);
                    this.store.setFilamentManufacturer(manufacturer, 0, i);
                    this.store.setFilamentModel(model, 0, i);
                    this.store.setFilamentSerialNumber(serialNumber, 0, i);
                }
            }
            if ((detectors = this.getGrandchildren(instrument, "Detector")) != null) {
                HashSet<String> uniqueDetectors = new HashSet<String>();
                for (int i = 0; i < detectors.getLength(); ++i) {
                    String detectorType;
                    String ampGain;
                    Element detector = (Element)detectors.item(i);
                    manufacturerNode = this.getFirstNode(detector, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    String detectorID = detector.getAttribute("Id");
                    if (detectorID.indexOf(32) != -1) {
                        detectorID = detectorID.substring(detectorID.lastIndexOf(" ") + 1);
                    }
                    if (!detectorID.startsWith("Detector:")) {
                        detectorID = "Detector:" + detectorID;
                    }
                    if (uniqueDetectors.contains(detectorID)) continue;
                    uniqueDetectors.add(detectorID);
                    int detectorIndex = uniqueDetectors.size() - 1;
                    this.store.setDetectorID(detectorID, 0, detectorIndex);
                    this.store.setDetectorManufacturer(manufacturer, 0, detectorIndex);
                    this.store.setDetectorModel(model, 0, detectorIndex);
                    this.store.setDetectorSerialNumber(serialNumber, 0, detectorIndex);
                    this.store.setDetectorLotNumber(lotNumber, 0, detectorIndex);
                    if (this.gain == null || this.gain.equals("0")) {
                        this.gain = this.getFirstNodeValue(detector, "Gain");
                    }
                    if (detectorIndex == 0 || detectorIndex >= this.gains.size()) {
                        this.store.setDetectorGain(DataTools.parseDouble(this.gain), 0, detectorIndex);
                    } else {
                        this.store.setDetectorGain(DataTools.parseDouble(this.gains.get(detectorIndex)), 0, detectorIndex);
                    }
                    String offset = this.getFirstNodeValue(detector, "Offset");
                    if (offset != null && !offset.equals("")) {
                        this.store.setDetectorOffset(new Double(offset), 0, detectorIndex);
                    }
                    if (this.zoom == null) {
                        this.zoom = this.getFirstNodeValue(detector, "Zoom");
                    }
                    if (this.zoom != null && !this.zoom.equals("")) {
                        this.store.setDetectorZoom(new Double(this.zoom), 0, detectorIndex);
                    }
                    if ((ampGain = this.getFirstNodeValue(detector, "AmplificationGain")) != null && !ampGain.equals("")) {
                        this.store.setDetectorAmplificationGain(new Double(ampGain), 0, detectorIndex);
                    }
                    if ((detectorType = this.getFirstNodeValue(detector, "Type")) == null || detectorType.equals("")) continue;
                    this.store.setDetectorType(this.getDetectorType(detectorType), 0, detectorIndex);
                }
            }
            NodeList objectives = this.getGrandchildren(instrument, "Objective");
            this.parseObjectives(objectives);
            NodeList filterSets = this.getGrandchildren(instrument, "FilterSet");
            if (filterSets != null) {
                for (int i = 0; i < filterSets.getLength(); ++i) {
                    String ref;
                    Element ref2;
                    Element filterSet = (Element)filterSets.item(i);
                    manufacturerNode = this.getFirstNode(filterSet, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    String dichroicRef = this.getFirstNodeValue(filterSet, "DichroicRef");
                    NodeList excitations = this.getGrandchildren(filterSet, "ExcitationFilters", "ExcitationFilterRef");
                    NodeList emissions = this.getGrandchildren(filterSet, "EmissionFilters", "EmissionFilterRef");
                    if ((dichroicRef == null || dichroicRef.length() <= 0) && (ref2 = this.getFirstNode(filterSet, "DichroicRef")) != null) {
                        dichroicRef = ref2.getAttribute("Id");
                    }
                    if (excitations == null) {
                        excitations = filterSet.getElementsByTagName("ExcitationFilterRef");
                    }
                    if (emissions == null) {
                        emissions = filterSet.getElementsByTagName("EmissionFilterRef");
                    }
                    if (dichroicRef != null || excitations != null || emissions != null) {
                        this.store.setFilterSetID(filterSet.getAttribute("Id"), 0, i);
                        this.store.setFilterSetManufacturer(manufacturer, 0, i);
                        this.store.setFilterSetModel(model, 0, i);
                        this.store.setFilterSetSerialNumber(serialNumber, 0, i);
                        this.store.setFilterSetLotNumber(lotNumber, 0, i);
                    }
                    if (dichroicRef != null && dichroicRef.length() > 0) {
                        this.store.setFilterSetDichroicRef(dichroicRef, 0, i);
                    }
                    if (excitations != null) {
                        for (int ex = 0; ex < excitations.getLength(); ++ex) {
                            Element excitation = (Element)excitations.item(ex);
                            ref = excitation.getTextContent();
                            if (ref == null || ref.length() <= 0) {
                                ref = excitation.getAttribute("Id");
                            }
                            if (ref == null || ref.length() <= 0) continue;
                            this.store.setFilterSetExcitationFilterRef(ref, 0, i, ex);
                        }
                    }
                    if (emissions == null) continue;
                    for (int em = 0; em < emissions.getLength(); ++em) {
                        Element emission = (Element)emissions.item(em);
                        ref = emission.getTextContent();
                        if (ref == null || ref.length() <= 0) {
                            ref = emission.getAttribute("Id");
                        }
                        if (ref == null || ref.length() <= 0) continue;
                        this.store.setFilterSetEmissionFilterRef(ref, 0, i, em);
                    }
                }
            }
            if ((filters = this.getGrandchildren(instrument, "Filter")) != null) {
                for (int i = 0; i < filters.getLength(); ++i) {
                    String transmittancePercent;
                    Element filter = (Element)filters.item(i);
                    manufacturerNode = this.getFirstNode(filter, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    this.store.setFilterID(filter.getAttribute("Id"), 0, i);
                    this.store.setFilterManufacturer(manufacturer, 0, i);
                    this.store.setFilterModel(model, 0, i);
                    this.store.setFilterSerialNumber(serialNumber, 0, i);
                    this.store.setFilterLotNumber(lotNumber, 0, i);
                    String filterType = this.getFirstNodeValue(filter, "Type");
                    if (filterType != null) {
                        this.store.setFilterType(this.getFilterType(filterType), 0, i);
                    }
                    this.store.setFilterFilterWheel(this.getFirstNodeValue(filter, "FilterWheel"), 0, i);
                    Element transmittance = this.getFirstNode(filter, "TransmittanceRange");
                    String cutIn = this.getFirstNodeValue(transmittance, "CutIn");
                    String cutOut = this.getFirstNodeValue(transmittance, "CutOut");
                    Double inWave = cutIn == null ? 0.0 : new Double(cutIn);
                    Double outWave = cutOut == null ? 0.0 : new Double(cutOut);
                    Length in = FormatTools.getCutIn(inWave);
                    Length out = FormatTools.getCutOut(outWave);
                    if (in != null) {
                        this.store.setTransmittanceRangeCutIn(in, 0, i);
                    }
                    if (out != null) {
                        this.store.setTransmittanceRangeCutOut(out, 0, i);
                    }
                    String inTolerance = this.getFirstNodeValue(transmittance, "CutInTolerance");
                    String outTolerance = this.getFirstNodeValue(transmittance, "CutOutTolerance");
                    if (inTolerance != null) {
                        Double cutInTolerance = new Double(inTolerance);
                        this.store.setTransmittanceRangeCutInTolerance(new Length(cutInTolerance, UNITS.NANOMETER), 0, i);
                    }
                    if (outTolerance != null) {
                        Double cutOutTolerance = new Double(outTolerance);
                        this.store.setTransmittanceRangeCutOutTolerance(new Length(cutOutTolerance, UNITS.NANOMETER), 0, i);
                    }
                    if ((transmittancePercent = this.getFirstNodeValue(transmittance, "Transmittance")) == null) continue;
                    this.store.setTransmittanceRangeTransmittance(PercentFraction.valueOf(transmittancePercent), 0, i);
                }
            }
            if ((dichroics = this.getGrandchildren(instrument, "Dichroic")) != null) {
                for (int i = 0; i < dichroics.getLength(); ++i) {
                    Element dichroic = (Element)dichroics.item(i);
                    manufacturerNode = this.getFirstNode(dichroic, "Manufacturer");
                    String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                    String model = this.getFirstNodeValue(manufacturerNode, "Model");
                    String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                    String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                    this.store.setDichroicID(dichroic.getAttribute("Id"), 0, i);
                    this.store.setDichroicManufacturer(manufacturer, 0, i);
                    this.store.setDichroicModel(model, 0, i);
                    this.store.setDichroicSerialNumber(serialNumber, 0, i);
                    this.store.setDichroicLotNumber(lotNumber, 0, i);
                }
            }
        }
        if (document != null) {
            this.description = this.getFirstNodeValue(document, "Description");
            if (this.userName == null) {
                this.userName = this.getFirstNodeValue(document, "UserName");
            }
            this.imageName = this.getFirstNodeValue(document, "Name");
        }
    }

    private void translateScaling(Element root) {
        NodeList scalings = root.getElementsByTagName("Scaling");
        if (scalings == null || scalings.getLength() == 0) {
            return;
        }
        Element scaling = (Element)scalings.item(0);
        NodeList distances = this.getGrandchildren(scaling, "Items", "Distance");
        if (distances != null) {
            for (int i = 0; i < distances.getLength(); ++i) {
                Element distance = (Element)distances.item(i);
                String id = distance.getAttribute("Id");
                String originalValue = this.getFirstNodeValue(distance, "Value");
                if (originalValue == null) continue;
                Double value = new Double(originalValue) * 1000000.0;
                if (value > 0.0) {
                    int series;
                    PositiveFloat size = new PositiveFloat(value);
                    if (id.equals("X")) {
                        for (series = 0; series < this.getSeriesCount(); ++series) {
                            this.store.setPixelsPhysicalSizeX(FormatTools.createLength(size, UNITS.MICROMETER), series);
                        }
                        continue;
                    }
                    if (id.equals("Y")) {
                        for (series = 0; series < this.getSeriesCount(); ++series) {
                            this.store.setPixelsPhysicalSizeY(FormatTools.createLength(size, UNITS.MICROMETER), series);
                        }
                        continue;
                    }
                    if (!id.equals("Z")) continue;
                    for (series = 0; series < this.getSeriesCount(); ++series) {
                        this.store.setPixelsPhysicalSizeZ(FormatTools.createLength(size, UNITS.MICROMETER), series);
                    }
                    continue;
                }
                LOGGER.debug("Expected positive value for PhysicalSize; got {}", (Object)value);
            }
        }
    }

    private void translateDisplaySettings(Element root) throws FormatException {
        NodeList displaySettings = root.getElementsByTagName("DisplaySetting");
        if (displaySettings == null || displaySettings.getLength() == 0) {
            return;
        }
        for (int display = 0; display < displaySettings.getLength(); ++display) {
            Element displaySetting = (Element)displaySettings.item(display);
            NodeList channelNodes = this.getGrandchildren(displaySetting, "Channel");
            if (channelNodes == null) continue;
            for (int i = 0; i < channelNodes.getLength(); ++i) {
                String illumination;
                String excitation;
                String emission;
                String name;
                Element channel = (Element)channelNodes.item(i);
                String color = this.getFirstNodeValue(channel, "Color");
                if (color == null) {
                    color = this.getFirstNodeValue(channel, "OriginalColor");
                }
                while (this.channels.size() <= i) {
                    this.channels.add(new Channel());
                }
                this.channels.get((int)i).color = color;
                String fluor = this.getFirstNodeValue(channel, "DyeName");
                if (fluor != null) {
                    this.channels.get((int)i).fluor = fluor;
                }
                if ((name = channel.getAttribute("Name")) != null) {
                    this.channels.get((int)i).name = name;
                }
                if ((emission = this.getFirstNodeValue(channel, "DyeMaxEmission")) != null) {
                    this.channels.get((int)i).emission = emission;
                }
                if ((excitation = this.getFirstNodeValue(channel, "DyeMaxExcitation")) != null) {
                    this.channels.get((int)i).excitation = excitation;
                }
                if ((illumination = this.getFirstNodeValue(channel, "IlluminationType")) == null) continue;
                this.channels.get((int)i).illumination = this.getIlluminationType(illumination);
            }
        }
    }

    private void translateLayers(Element root) {
        NodeList layerses = root.getElementsByTagName("Layers");
        if (layerses == null || layerses.getLength() == 0) {
            return;
        }
        Element layersNode = (Element)layerses.item(0);
        NodeList layers = layersNode.getElementsByTagName("Layer");
        if (layers != null) {
            for (int i = 0; i < layers.getLength(); ++i) {
                NodeList text;
                NodeList textBoxes;
                NodeList rectRoi;
                NodeList beziers;
                NodeList closedPolylines;
                NodeList openPolylines;
                NodeList polylines;
                NodeList polygons;
                NodeList pointsCircles;
                NodeList outInCircles;
                NodeList inOutCircles;
                NodeList circles;
                NodeList ellipses;
                Element layer = (Element)layers.item(i);
                NodeList elementses = layer.getElementsByTagName("Elements");
                if (elementses.getLength() == 0) continue;
                NodeList allGrandchildren = elementses.item(0).getChildNodes();
                int shape = 0;
                NodeList lines = this.getGrandchildren(layer, "Elements", "Line");
                shape = this.populateLines(lines, i, shape);
                NodeList arrows = this.getGrandchildren(layer, "Elements", "OpenArrow");
                shape = this.populateLines(arrows, i, shape);
                NodeList crosses = this.getGrandchildren(layer, "Elements", "Cross");
                int s = 0;
                while (s < crosses.getLength()) {
                    Element cross = (Element)crosses.item(s);
                    Element geometry = this.getFirstNode(cross, "Geometry");
                    Element textElements = this.getFirstNode(cross, "TextElements");
                    Element attributes = this.getFirstNode(cross, "Attributes");
                    this.store.setLineID(MetadataTools.createLSID("Shape", i, shape), i, shape);
                    this.store.setLineID(MetadataTools.createLSID("Shape", i, shape + 1), i, shape + 1);
                    String length = this.getFirstNodeValue(geometry, "Length");
                    String centerX = this.getFirstNodeValue(geometry, "CenterX");
                    String centerY = this.getFirstNodeValue(geometry, "CenterY");
                    if (length != null) {
                        Double halfLen = new Double(length) / 2.0;
                        if (centerX != null) {
                            this.store.setLineX1(new Double(centerX) - halfLen, i, shape);
                            this.store.setLineX2(new Double(centerX) + halfLen, i, shape);
                            this.store.setLineX1(new Double(centerX), i, shape + 1);
                            this.store.setLineX2(new Double(centerX), i, shape + 1);
                        }
                        if (centerY != null) {
                            this.store.setLineY1(new Double(centerY), i, shape);
                            this.store.setLineY2(new Double(centerY), i, shape);
                            this.store.setLineY1(new Double(centerY) - halfLen, i, shape + 1);
                            this.store.setLineY2(new Double(centerY) + halfLen, i, shape + 1);
                        }
                    }
                    this.store.setLineText(this.getFirstNodeValue(textElements, "Text"), i, shape);
                    this.store.setLineText(this.getFirstNodeValue(textElements, "Text"), i, shape + 1);
                    ++s;
                    shape += 2;
                }
                NodeList rectangles = this.getGrandchildren(layer, "Elements", "Rectangle");
                if (rectangles != null) {
                    shape = this.populateRectangles(rectangles, i, shape);
                }
                if ((ellipses = this.getGrandchildren(layer, "Elements", "Ellipse")) != null) {
                    int s2 = 0;
                    while (s2 < ellipses.getLength()) {
                        Element ellipse = (Element)ellipses.item(s2);
                        Element geometry = this.getFirstNode(ellipse, "Geometry");
                        Element textElements = this.getFirstNode(ellipse, "TextElements");
                        Element attributes = this.getFirstNode(ellipse, "Attributes");
                        this.store.setEllipseID(MetadataTools.createLSID("Shape", i, shape), i, shape);
                        String radiusX = this.getFirstNodeValue(geometry, "RadiusX");
                        String radiusY = this.getFirstNodeValue(geometry, "RadiusY");
                        String centerX = this.getFirstNodeValue(geometry, "CenterX");
                        String centerY = this.getFirstNodeValue(geometry, "CenterY");
                        if (radiusX != null) {
                            this.store.setEllipseRadiusX(new Double(radiusX), i, shape);
                        }
                        if (radiusY != null) {
                            this.store.setEllipseRadiusY(new Double(radiusY), i, shape);
                        }
                        if (centerX != null) {
                            this.store.setEllipseX(new Double(centerX), i, shape);
                        }
                        if (centerY != null) {
                            this.store.setEllipseY(new Double(centerY), i, shape);
                        }
                        this.store.setEllipseText(this.getFirstNodeValue(textElements, "Text"), i, shape);
                        ++s2;
                        ++shape;
                    }
                }
                if ((circles = this.getGrandchildren(layer, "Elements", "Circle")) != null) {
                    shape = this.populateCircles(circles, i, shape);
                }
                if ((inOutCircles = this.getGrandchildren(layer, "Elements", "InOutCircle")) != null) {
                    shape = this.populateCircles(inOutCircles, i, shape);
                }
                if ((outInCircles = this.getGrandchildren(layer, "Elements", "OutInCircle")) != null) {
                    shape = this.populateCircles(outInCircles, i, shape);
                }
                if ((pointsCircles = this.getGrandchildren(layer, "Elements", "PointsCircle")) != null) {
                    shape = this.populateCircles(pointsCircles, i, shape);
                }
                if ((polygons = this.getGrandchildren(layer, "Elements", "Polygon")) != null) {
                    shape = this.populatePolylines(polygons, i, shape, true);
                }
                if ((polylines = this.getGrandchildren(layer, "Elements", "Polyline")) != null) {
                    shape = this.populatePolylines(polylines, i, shape, false);
                }
                if ((openPolylines = this.getGrandchildren(layer, "Elements", "OpenPolyline")) != null) {
                    shape = this.populatePolylines(openPolylines, i, shape, false);
                }
                if ((closedPolylines = this.getGrandchildren(layer, "Elements", "ClosedPolyline")) != null) {
                    shape = this.populatePolylines(closedPolylines, i, shape, true);
                }
                if ((beziers = this.getGrandchildren(layer, "Elements", "Bezier")) != null) {
                    shape = this.populatePolylines(beziers, i, shape, true);
                }
                if ((rectRoi = this.getGrandchildren(layer, "Elements", "RectRoi")) != null) {
                    shape = this.populateRectangles(rectRoi, i, shape);
                }
                if ((textBoxes = this.getGrandchildren(layer, "Elements", "TextBox")) != null) {
                    shape = this.populateRectangles(textBoxes, i, shape);
                }
                if ((text = this.getGrandchildren(layer, "Elements", "Text")) != null) {
                    shape = this.populateRectangles(text, i, shape);
                }
                if (shape <= 0) continue;
                String roiID = MetadataTools.createLSID("ROI", i);
                this.store.setROIID(roiID, i);
                this.store.setROIName(layer.getAttribute("Name"), i);
                this.store.setROIDescription(this.getFirstNodeValue(layer, "Usage"), i);
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    this.store.setImageROIRef(roiID, series, i);
                }
            }
        }
    }

    private void translateHardwareSettings(Element root) throws FormatException {
        Element objectiveChanger;
        NodeList hardwareSettings = root.getElementsByTagName("HardwareSetting");
        if (hardwareSettings == null || hardwareSettings.getLength() == 0) {
            return;
        }
        Element hardware = (Element)hardwareSettings.item(0);
        this.store.setInstrumentID(MetadataTools.createLSID("Instrument", 0), 0);
        Element microscope = this.getFirstNode(hardware, "Microscope");
        if (microscope != null) {
            String model = microscope.getAttribute("Name");
            this.store.setMicroscopeModel(model, 0);
        }
        if ((objectiveChanger = this.getFirstNode(hardware, "ObjectiveChanger")) != null) {
            NodeList objectives;
            String position = this.getFirstNodeValue(objectiveChanger, "Position");
            int positionIndex = -1;
            if (position != null) {
                try {
                    positionIndex = Integer.parseInt(position) - 1;
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Could not parse ObjectiveSettings", e);
                }
            }
            if ((objectives = objectiveChanger.getElementsByTagName("Objective")) != null) {
                for (int i = 0; i < objectives.getLength(); ++i) {
                    Element objective = (Element)objectives.item(i);
                    String objectiveID = MetadataTools.createLSID("Objective", 0, i);
                    if (i == positionIndex || objectives.getLength() == 1 && this.objectiveSettingsID != null) {
                        this.objectiveSettingsID = objectiveID;
                    }
                    this.store.setObjectiveID(objectiveID, 0, i);
                    this.store.setObjectiveModel(objective.getAttribute("Model"), 0, i);
                    this.store.setObjectiveSerialNumber(objective.getAttribute("UniqueName"), 0, i);
                    String immersion = this.getFirstNodeValue(objective, "Immersions");
                    this.store.setObjectiveImmersion(this.getImmersion(immersion), 0, i);
                    this.store.setObjectiveCorrection(this.getCorrection("Other"), 0, i);
                    String magnification = this.getFirstNodeValue(objective, "Magnification");
                    String na = this.getFirstNodeValue(objective, "NumericalAperture");
                    String wd = this.getFirstNodeValue(objective, "WorkingDistance");
                    if (magnification != null) {
                        try {
                            this.store.setObjectiveNominalMagnification(new Double(magnification), 0, i);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse magnification", e);
                        }
                    }
                    if (na != null) {
                        try {
                            this.store.setObjectiveLensNA(new Double(na), 0, i);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse numerical aperture", e);
                        }
                    }
                    if (wd == null) continue;
                    try {
                        this.store.setObjectiveWorkingDistance(new Length(new Double(wd), UNITS.MICROMETER), 0, i);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.debug("Could not parse working distance", e);
                    }
                }
            }
        }
    }

    private int populateRectangles(NodeList rectangles, int roi, int shape) {
        for (int s = 0; s < rectangles.getLength(); ++s) {
            Element rectangle = (Element)rectangles.item(s);
            Element geometry = this.getFirstNode(rectangle, "Geometry");
            Element textElements = this.getFirstNode(rectangle, "TextElements");
            Element attributes = this.getFirstNode(rectangle, "Attributes");
            String left = this.getFirstNodeValue(geometry, "Left");
            String top = this.getFirstNodeValue(geometry, "Top");
            String width = this.getFirstNodeValue(geometry, "Width");
            String height = this.getFirstNodeValue(geometry, "Height");
            if (left == null || top == null || width == null || height == null) continue;
            this.store.setRectangleID(MetadataTools.createLSID("Shape", roi, shape), roi, shape);
            this.store.setRectangleX(new Double(left), roi, shape);
            this.store.setRectangleY(new Double(top), roi, shape);
            this.store.setRectangleWidth(new Double(width), roi, shape);
            this.store.setRectangleHeight(new Double(height), roi, shape);
            String name = this.getFirstNodeValue(attributes, "Name");
            String label = this.getFirstNodeValue(textElements, "Text");
            if (label != null) {
                this.store.setRectangleText(label, roi, shape);
            }
            ++shape;
        }
        return shape;
    }

    private int populatePolylines(NodeList polylines, int roi, int shape, boolean closed) {
        int s = 0;
        while (s < polylines.getLength()) {
            Element polyline = (Element)polylines.item(s);
            Element geometry = this.getFirstNode(polyline, "Geometry");
            Element textElements = this.getFirstNode(polyline, "TextElements");
            Element attributes = this.getFirstNode(polyline, "Attributes");
            String shapeID = MetadataTools.createLSID("Shape", roi, shape);
            if (closed) {
                this.store.setPolygonID(shapeID, roi, shape);
                this.store.setPolygonPoints(this.getFirstNodeValue(geometry, "Points"), roi, shape);
                this.store.setPolygonText(this.getFirstNodeValue(textElements, "Text"), roi, shape);
            } else {
                this.store.setPolylineID(shapeID, roi, shape);
                this.store.setPolylinePoints(this.getFirstNodeValue(geometry, "Points"), roi, shape);
                this.store.setPolylineText(this.getFirstNodeValue(textElements, "Text"), roi, shape);
            }
            ++s;
            ++shape;
        }
        return shape;
    }

    private int populateLines(NodeList lines, int roi, int shape) {
        int s = 0;
        while (s < lines.getLength()) {
            Element line = (Element)lines.item(s);
            Element geometry = this.getFirstNode(line, "Geometry");
            Element textElements = this.getFirstNode(line, "TextElements");
            Element attributes = this.getFirstNode(line, "Attributes");
            String x1 = this.getFirstNodeValue(geometry, "X1");
            String x2 = this.getFirstNodeValue(geometry, "X2");
            String y1 = this.getFirstNodeValue(geometry, "Y1");
            String y2 = this.getFirstNodeValue(geometry, "Y2");
            this.store.setLineID(MetadataTools.createLSID("Shape", roi, shape), roi, shape);
            if (x1 != null) {
                this.store.setLineX1(new Double(x1), roi, shape);
            }
            if (x2 != null) {
                this.store.setLineX2(new Double(x2), roi, shape);
            }
            if (y1 != null) {
                this.store.setLineY1(new Double(y1), roi, shape);
            }
            if (y2 != null) {
                this.store.setLineY2(new Double(y2), roi, shape);
            }
            this.store.setLineText(this.getFirstNodeValue(textElements, "Text"), roi, shape);
            ++s;
            ++shape;
        }
        return shape;
    }

    private int populateCircles(NodeList circles, int roi, int shape) {
        int s = 0;
        while (s < circles.getLength()) {
            Element circle = (Element)circles.item(s);
            Element geometry = this.getFirstNode(circle, "Geometry");
            Element textElements = this.getFirstNode(circle, "TextElements");
            Element attributes = this.getFirstNode(circle, "Attributes");
            this.store.setEllipseID(MetadataTools.createLSID("Shape", roi, shape), roi, shape);
            String radius = this.getFirstNodeValue(geometry, "Radius");
            String centerX = this.getFirstNodeValue(geometry, "CenterX");
            String centerY = this.getFirstNodeValue(geometry, "CenterY");
            if (radius != null) {
                this.store.setEllipseRadiusX(new Double(radius), roi, shape);
                this.store.setEllipseRadiusY(new Double(radius), roi, shape);
            }
            if (centerX != null) {
                this.store.setEllipseX(new Double(centerX), roi, shape);
            }
            if (centerY != null) {
                this.store.setEllipseY(new Double(centerY), roi, shape);
            }
            this.store.setEllipseText(this.getFirstNodeValue(textElements, "Text"), roi, shape);
            ++s;
            ++shape;
        }
        return shape;
    }

    private void translateExperiment(Element root) throws FormatException {
        Element multiTrack;
        NodeList experiments = root.getElementsByTagName("Experiment");
        if (experiments == null || experiments.getLength() == 0) {
            return;
        }
        Element experimentBlock = this.getFirstNode((Element)experiments.item(0), "ExperimentBlocks");
        Element acquisition = this.getFirstNode(experimentBlock, "AcquisitionBlock");
        Element tilesSetup = this.getFirstNode(acquisition, "TilesSetup");
        NodeList groups = this.getGrandchildren(tilesSetup, "PositionGroup");
        this.positionsX = new Length[this.core.size()];
        this.positionsY = new Length[this.core.size()];
        this.positionsZ = new Length[this.core.size()];
        if (groups != null) {
            for (int i = 0; i < groups.getLength(); ++i) {
                Element group = (Element)groups.item(i);
                Element position = this.getFirstNode(group, "Position");
                String tilesXValue = this.getFirstNodeValue(group, "TilesX");
                String tilesYValue = this.getFirstNodeValue(group, "TilesY");
                if (position == null || tilesXValue == null || tilesXValue.isEmpty() || tilesYValue == null || tilesYValue.isEmpty()) continue;
                Integer tilesX = DataTools.parseInteger(tilesXValue);
                Integer tilesY = DataTools.parseInteger(tilesYValue);
                String x = position.getAttribute("X");
                String y = position.getAttribute("Y");
                String z = position.getAttribute("Z");
                Length xPos = FormatTools.getStagePosition(DataTools.parseDouble(x), UNITS.REFERENCEFRAME);
                Length yPos = FormatTools.getStagePosition(DataTools.parseDouble(y), UNITS.REFERENCEFRAME);
                Length zPos = FormatTools.getStagePosition(DataTools.parseDouble(z), UNITS.REFERENCEFRAME);
                int numTiles = tilesX == null || tilesY == null ? 0 : tilesX * tilesY;
                for (int tile = 0; tile < numTiles; ++tile) {
                    int index = i * tilesX * tilesY + tile;
                    if (index >= this.positionsX.length) continue;
                    this.positionsX[index] = xPos;
                    this.positionsY[index] = yPos;
                    this.positionsZ[index] = zPos;
                }
            }
        } else {
            NodeList regions;
            Element sampleHolder;
            Element regionsSetup = this.getFirstNode(acquisition, "RegionsSetup");
            if (regionsSetup != null && (sampleHolder = this.getFirstNode(regionsSetup, "SampleHolder")) != null && (regions = this.getGrandchildren(sampleHolder, "SingleTileRegionArray", "SingleTileRegion")) != null) {
                for (int i = 0; i < regions.getLength(); ++i) {
                    Double number;
                    Element region = (Element)regions.item(i);
                    String x = this.getFirstNode(region, "X").getTextContent();
                    String y = this.getFirstNode(region, "Y").getTextContent();
                    String z = this.getFirstNode(region, "Z").getTextContent();
                    if (i >= this.positionsX.length) continue;
                    if (x == null) {
                        this.positionsX[i] = null;
                    } else {
                        number = Double.valueOf(x);
                        this.positionsX[i] = new Length(number, UNITS.REFERENCEFRAME);
                    }
                    if (y == null) {
                        this.positionsY[i] = null;
                    } else {
                        number = Double.valueOf(y);
                        this.positionsY[i] = new Length(number, UNITS.REFERENCEFRAME);
                    }
                    if (z == null) {
                        this.positionsZ[i] = null;
                        continue;
                    }
                    number = Double.valueOf(z);
                    this.positionsZ[i] = new Length(number, UNITS.REFERENCEFRAME);
                }
            }
        }
        NodeList detectors = this.getGrandchildren(acquisition, "Detector");
        Element setup = this.getFirstNode(acquisition, "AcquisitionModeSetup");
        String cameraModel = this.getFirstNodeValue(setup, "SelectedCamera");
        if (detectors != null) {
            for (int i = 0; i < detectors.getLength(); ++i) {
                Element detector = (Element)detectors.item(i);
                String id = MetadataTools.createLSID("Detector", 0, i);
                this.store.setDetectorID(id, 0, i);
                String model = detector.getAttribute("Id");
                this.store.setDetectorModel(model, 0, i);
                String bin = this.getFirstNodeValue(detector, "Binning");
                if (bin == null) continue;
                bin = bin.replaceAll(",", "x");
                Binning binning = this.getBinning(bin);
                if (model == null || !model.equals(cameraModel)) continue;
                for (int image = 0; image < this.getSeriesCount(); ++image) {
                    for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                        this.store.setDetectorSettingsID(id, image, c);
                        this.store.setDetectorSettingsBinning(binning, image, c);
                    }
                }
                this.hasDetectorSettings = true;
            }
        }
        if ((multiTrack = this.getFirstNode(acquisition, "MultiTrackSetup")) == null) {
            return;
        }
        NodeList detectorGroups = multiTrack.getElementsByTagName("Detectors");
        for (int d = 0; d < detectorGroups.getLength(); ++d) {
            Element detectorGroup = (Element)detectorGroups.item(d);
            detectors = detectorGroup.getElementsByTagName("Detector");
            if (detectors == null || detectors.getLength() <= 0) continue;
            for (int i = 0; i < detectors.getLength(); ++i) {
                Element detector = (Element)detectors.item(i);
                String voltage = this.getFirstNodeValue(detector, "Voltage");
                if (i == 0 && d == 0) {
                    this.gain = voltage;
                }
                this.gains.add(voltage);
            }
        }
        NodeList tracks = multiTrack.getElementsByTagName("Track");
        if (tracks != null && tracks.getLength() > 0) {
            for (int i = 0; i < tracks.getLength(); ++i) {
                Element track = (Element)tracks.item(i);
                Element channel = this.getFirstNode(track, "Channel");
                String exposure = this.getFirstNodeValue(channel, "ExposureTime");
                String gain = this.getFirstNodeValue(channel, "EMGain");
                while (this.channels.size() <= i) {
                    this.channels.add(new Channel());
                }
                try {
                    if (exposure != null) {
                        this.channels.get((int)i).exposure = new Double(exposure);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Could not parse exposure time", e);
                }
                try {
                    if (gain == null) continue;
                    this.channels.get((int)i).gain = new Double(gain);
                    continue;
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Could not parse gain", e);
                }
            }
        }
    }

    private Element getFirstNode(Element root, String name) {
        if (root == null) {
            return null;
        }
        NodeList list = root.getElementsByTagName(name);
        if (list == null) {
            return null;
        }
        return (Element)list.item(0);
    }

    private NodeList getGrandchildren(Element root, String name) {
        return this.getGrandchildren(root, name + "s", name);
    }

    private NodeList getGrandchildren(Element root, String child, String name) {
        if (root == null) {
            return null;
        }
        NodeList children = root.getElementsByTagName(child);
        if (children != null && children.getLength() > 0) {
            Element childNode = (Element)children.item(0);
            return childNode.getElementsByTagName(name);
        }
        return null;
    }

    private String getFirstNodeValue(Element root, String name) {
        if (root == null) {
            return null;
        }
        NodeList nodes = root.getElementsByTagName(name);
        if (nodes != null && nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return null;
    }

    private void populateOriginalMetadata(Element root, Deque<String> nameStack) {
        String value;
        String name = root.getNodeName();
        if (name.equals("DisplaySetting")) {
            return;
        }
        nameStack.push(name);
        StringBuilder key = new StringBuilder();
        String k = null;
        Iterator<String> keys = nameStack.descendingIterator();
        while (keys.hasNext()) {
            k = keys.next();
            if (k.equals("Metadata") || k.endsWith("s") && !k.equals(name)) continue;
            key.append(k);
            key.append("|");
        }
        if (root.getChildNodes().getLength() == 1 && (value = root.getTextContent()) != null && key.length() > 0) {
            String s = key.toString();
            if (s.endsWith("|")) {
                s = s.substring(0, s.length() - 1);
            }
            this.addGlobalMetaList(s, value);
            if (key.toString().endsWith("|Rotations|")) {
                this.rotationLabels = value.split(" ");
            } else if (key.toString().endsWith("|Phases|")) {
                this.phaseLabels = value.split(" ");
            } else if (key.toString().endsWith("|Illuminations|")) {
                this.illuminationLabels = value.split(" ");
            }
        }
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            String attrName = attr.getNodeName();
            String attrValue = attr.getNodeValue();
            String keyString = key.toString();
            if (attrName.endsWith("|")) {
                attrName = attrName.substring(0, attrName.length() - 1);
            } else if (attrName.length() == 0 && keyString.endsWith("|")) {
                keyString = keyString.substring(0, keyString.length() - 1);
            }
            this.addGlobalMetaList(keyString + attrName, attrValue);
        }
        NodeList children = root.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                this.populateOriginalMetadata((Element)child, nameStack);
            }
        }
        nameStack.pop();
    }

    private Segment readSegment(String filename) throws IOException {
        long pos;
        int skip = (32 - (int)(this.in.getFilePointer() % 32L)) % 32;
        this.in.skipBytes(skip);
        long startingPosition = this.in.getFilePointer();
        String segmentID = this.in.readString(16).trim();
        Segment segment = null;
        boolean skipData = false;
        if (segmentID.equals(CZI_MAGIC_STRING)) {
            segment = new FileHeader();
        } else if (segmentID.equals("ZISRAWMETADATA")) {
            segment = new Metadata();
        } else if (segmentID.equals("ZISRAWSUBBLOCK")) {
            segment = new SubBlock();
        } else if (segmentID.equals("ZISRAWATTACH")) {
            segment = new Attachment(filename, startingPosition);
            skipData = true;
        } else if (segmentID.equals("ZISRAWDIRECTORY")) {
            segment = new Directory();
        } else if (segmentID.equals("ZISRAWATTDIR")) {
            segment = new AttachmentDirectory();
        } else if (segmentID.equals("DELETED")) {
            segment = new Segment();
        } else if (segmentID.length() == 0) {
            segment = new Segment();
            skipData = true;
        } else {
            LOGGER.info("Unknown segment type: {}", (Object)segmentID);
            segment = new Segment();
        }
        segment.startingPosition = startingPosition;
        segment.id = segmentID;
        segment.filename = filename;
        segment.stream = this.in;
        if (!(segment instanceof Metadata)) {
            if (!skipData) {
                segment.fillInData();
            }
        } else {
            ((Metadata)segment).skipData();
        }
        if ((pos = segment.startingPosition + segment.allocatedSize + 32L) < this.in.length()) {
            this.in.seek(pos);
        } else {
            this.in.seek(this.in.length());
        }
        if (skipData && !(segment instanceof Attachment)) {
            segment.close();
            return null;
        }
        return segment;
    }

    private void convertPixelType(int pixelType) throws FormatException {
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        this.convertPixelType(ms0, pixelType);
    }

    private void convertPixelType(CoreMetadata ms0, int pixelType) throws FormatException {
        switch (pixelType) {
            case 0: {
                ms0.pixelType = 1;
                break;
            }
            case 1: {
                ms0.pixelType = 3;
                break;
            }
            case 12: {
                ms0.pixelType = 5;
                break;
            }
            case 2: {
                ms0.pixelType = 6;
                break;
            }
            case 13: {
                ms0.pixelType = 7;
                break;
            }
            case 3: {
                ms0.pixelType = 1;
                ms0.sizeC *= 3;
                ms0.rgb = true;
                ms0.interleaved = true;
                break;
            }
            case 4: {
                ms0.pixelType = 3;
                ms0.sizeC *= 3;
                ms0.rgb = true;
                ms0.interleaved = true;
                break;
            }
            case 9: {
                ms0.pixelType = 1;
                ms0.sizeC *= 4;
                ms0.rgb = true;
                ms0.interleaved = true;
                break;
            }
            case 8: {
                ms0.pixelType = 6;
                ms0.sizeC *= 3;
                ms0.rgb = true;
                ms0.interleaved = true;
                break;
            }
            case 10: 
            case 11: {
                throw new FormatException("Sorry, complex pixel data not supported.");
            }
            default: {
                throw new FormatException("Unknown pixel type: " + pixelType);
            }
        }
        ms0.interleaved = ms0.rgb;
    }

    private void parseObjectives(NodeList objectives) throws FormatException {
        if (objectives != null) {
            for (int i = 0; i < objectives.getLength(); ++i) {
                String iris;
                String wd;
                String calibratedMag;
                Double mag;
                String magnification;
                Element objective = (Element)objectives.item(i);
                Element manufacturerNode = this.getFirstNode(objective, "Manufacturer");
                String manufacturer = this.getFirstNodeValue(manufacturerNode, "Manufacturer");
                String model = this.getFirstNodeValue(manufacturerNode, "Model");
                String serialNumber = this.getFirstNodeValue(manufacturerNode, "SerialNumber");
                String lotNumber = this.getFirstNodeValue(manufacturerNode, "LotNumber");
                if (this.objectiveSettingsID == null) {
                    this.objectiveSettingsID = objective.getAttribute("Id");
                }
                this.store.setObjectiveID(objective.getAttribute("Id"), 0, i);
                this.store.setObjectiveManufacturer(manufacturer, 0, i);
                this.store.setObjectiveModel(model, 0, i);
                this.store.setObjectiveSerialNumber(serialNumber, 0, i);
                this.store.setObjectiveLotNumber(lotNumber, 0, i);
                String correction = this.getFirstNodeValue(objective, "Correction");
                if (correction != null) {
                    this.store.setObjectiveCorrection(this.getCorrection(correction), 0, i);
                }
                this.store.setObjectiveImmersion(this.getImmersion(this.getFirstNodeValue(objective, "Immersion")), 0, i);
                String lensNA = this.getFirstNodeValue(objective, "LensNA");
                if (lensNA != null) {
                    this.store.setObjectiveLensNA(new Double(lensNA), 0, i);
                }
                if ((magnification = this.getFirstNodeValue(objective, "NominalMagnification")) == null) {
                    magnification = this.getFirstNodeValue(objective, "Magnification");
                }
                Double d = mag = magnification == null ? null : new Double(magnification);
                if (mag != null) {
                    this.store.setObjectiveNominalMagnification(mag, 0, i);
                }
                if ((calibratedMag = this.getFirstNodeValue(objective, "CalibratedMagnification")) != null) {
                    this.store.setObjectiveCalibratedMagnification(new Double(calibratedMag), 0, i);
                }
                if ((wd = this.getFirstNodeValue(objective, "WorkingDistance")) != null) {
                    this.store.setObjectiveWorkingDistance(new Length(new Double(wd), UNITS.MICROMETER), 0, i);
                }
                if ((iris = this.getFirstNodeValue(objective, "Iris")) == null) continue;
                this.store.setObjectiveIris(new Boolean(iris), 0, i);
            }
        }
    }

    private byte[] decode12BitCamera(byte[] data, int maxBytes) throws IOException {
        byte[] decoded = new byte[maxBytes];
        RandomAccessInputStream bb = new RandomAccessInputStream(new ByteArrayHandle(data));
        byte[] fourBits = new byte[maxBytes / 2 * 3];
        int pt = 0;
        while (pt < fourBits.length) {
            fourBits[pt++] = (byte)bb.readBits(4);
        }
        bb.close();
        for (int index = 0; index < fourBits.length - 1; ++index) {
            if ((index - 3) % 6 != 0) continue;
            byte middle = fourBits[index];
            byte last = fourBits[index + 1];
            byte first = fourBits[index - 1];
            fourBits[index + 1] = middle;
            fourBits[index] = first;
            fourBits[index - 1] = last;
        }
        int currentByte = 0;
        int index = 0;
        while (index < fourBits.length) {
            if (index % 3 == 0) {
                decoded[currentByte++] = fourBits[index++];
                continue;
            }
            decoded[currentByte++] = (byte)(fourBits[index++] << 4 | fourBits[index++]);
        }
        if (this.isLittleEndian()) {
            ((CoreMetadata)this.core.get((int)0)).littleEndian = false;
        }
        return decoded;
    }

    static class Coordinate {
        public int series;
        public int plane;
        private int imageCount;

        public Coordinate(int series, int plane, int imageCount) {
            this.series = series;
            this.plane = plane;
            this.imageCount = imageCount;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Coordinate)) {
                return false;
            }
            return ((Coordinate)o).series == this.series && ((Coordinate)o).plane == this.plane;
        }

        public int hashCode() {
            return this.series * this.imageCount + this.plane;
        }

        public String toString() {
            return "[series = " + this.series + ", plane = " + this.plane + "]";
        }
    }

    static class Channel {
        public String name;
        public String color;
        public IlluminationType illumination;
        public AcquisitionMode acquisitionMode;
        public String emission;
        public String excitation;
        public String pinhole;
        public Double exposure;
        public Double gain;
        public String fluor;
        public String filterSetRef;

        Channel() {
        }
    }

    static class AttachmentEntry {
        public String schemaType;
        public long filePosition;
        public int filePart;
        public String contentGUID;
        public String contentFileType;
        public String name;

        public AttachmentEntry(RandomAccessInputStream s) throws IOException {
            this.schemaType = s.readString(2);
            s.skipBytes(10);
            this.filePosition = s.readLong();
            this.filePart = s.readInt();
            this.contentGUID = s.readString(16);
            this.contentFileType = s.readString(8);
            this.name = s.readString(80);
        }

        public String toString() {
            return "schemaType = " + this.schemaType + ", filePosition = " + this.filePosition + ", filePart = " + this.filePart + ", contentGUID = " + this.contentGUID + ", contentFileType = " + this.contentFileType;
        }
    }

    static class DimensionEntry {
        public String dimension;
        public int start;
        public int size;
        public float startCoordinate;
        public int storedSize;

        public DimensionEntry(RandomAccessInputStream s) throws IOException {
            this.dimension = s.readString(4).trim();
            this.start = s.readInt();
            this.size = s.readInt();
            this.startCoordinate = s.readFloat();
            this.storedSize = s.readInt();
        }

        public String toString() {
            return "dimension=" + this.dimension + ", start=" + this.start + ", size=" + this.size + ", startCoordinate=" + this.startCoordinate + ", storedSize=" + this.storedSize;
        }
    }

    class DirectoryEntry {
        public String schemaType;
        public int pixelType;
        public long filePosition;
        public int filePart;
        public int compression;
        public byte pyramidType;
        public int dimensionCount;
        public DimensionEntry[] dimensionEntries;

        public DirectoryEntry(RandomAccessInputStream s) throws IOException {
            this.schemaType = s.readString(2);
            this.pixelType = s.readInt();
            this.filePosition = s.readLong();
            this.filePart = s.readInt();
            this.compression = s.readInt();
            this.pyramidType = s.readByte();
            if (this.pyramidType == 1) {
                ZeissCZIReader.this.prestitched = false;
            }
            s.skipBytes(1);
            s.skipBytes(4);
            this.dimensionCount = s.readInt();
            this.dimensionEntries = new DimensionEntry[this.dimensionCount];
            for (int i = 0; i < this.dimensionEntries.length; ++i) {
                this.dimensionEntries[i] = new DimensionEntry(s);
                if (this.dimensionEntries[i].dimension.length() <= 1) continue;
                this.dimensionEntries[i] = null;
                if (i <= 0) continue;
                this.dimensionEntries[i - 1] = null;
            }
        }

        public String toString() {
            String s = "schemaType = " + this.schemaType + ", pixelType = " + this.pixelType + ", filePosition = " + this.filePosition + ", filePart = " + this.filePart + ", compression = " + this.compression + ", pyramidType = " + this.pyramidType + ", dimensionCount = " + this.dimensionCount;
            if (this.dimensionCount > 0) {
                s = s + ", dimensions = [";
                for (int i = 0; i < this.dimensionCount; ++i) {
                    s = s + this.dimensionEntries[i];
                    if (i >= this.dimensionCount - 1) continue;
                    s = s + "; ";
                }
                s = s + ']';
            }
            return s;
        }
    }

    class Attachment
    extends Segment {
        public int dataSize;
        public AttachmentEntry attachment;
        public byte[] attachmentData;
        public long dataOffset;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Attachment(String filename, long position) throws IOException {
            super(filename);
            this.startingPosition = position;
            super.fillInData();
            RandomAccessInputStream s = this.getStream();
            try {
                s.order(ZeissCZIReader.this.isLittleEndian());
                s.seek(this.startingPosition + 32L);
                this.dataSize = s.readInt();
                s.skipBytes(12);
                this.attachment = new AttachmentEntry(s);
                this.dataOffset = s.getFilePointer() + 112L;
            }
            finally {
                if (this.stream == null) {
                    s.close();
                }
            }
        }

        @Override
        public void fillInData() throws IOException {
            RandomAccessInputStream s = this.getStream();
            try {
                s.order(ZeissCZIReader.this.isLittleEndian());
                s.seek(this.dataOffset);
                this.attachmentData = new byte[this.dataSize];
                s.read(this.attachmentData);
            }
            finally {
                if (this.stream == null) {
                    s.close();
                }
            }
        }
    }

    class AttachmentDirectory
    extends Segment {
        public AttachmentEntry[] entries;

        AttachmentDirectory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fillInData() throws IOException {
            super.fillInData();
            RandomAccessInputStream s = this.getStream();
            try {
                s.order(ZeissCZIReader.this.isLittleEndian());
                s.seek(this.startingPosition + 32L);
                int entryCount = s.readInt();
                s.skipBytes(252);
                this.entries = new AttachmentEntry[entryCount];
                for (int i = 0; i < entryCount; ++i) {
                    this.entries[i] = new AttachmentEntry(s);
                }
            }
            finally {
                if (this.stream == null) {
                    s.close();
                }
            }
        }
    }

    class Directory
    extends Segment {
        public DirectoryEntry[] entries;

        Directory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fillInData() throws IOException {
            super.fillInData();
            RandomAccessInputStream s = this.getStream();
            try {
                s.order(ZeissCZIReader.this.isLittleEndian());
                s.seek(this.startingPosition + 32L);
                int entryCount = s.readInt();
                s.skipBytes(124);
                this.entries = new DirectoryEntry[entryCount];
                for (int i = 0; i < entryCount; ++i) {
                    this.entries[i] = new DirectoryEntry(s);
                }
            }
            finally {
                if (this.stream == null) {
                    s.close();
                }
            }
        }
    }

    class SubBlock
    extends Segment {
        public int metadataSize;
        public int attachmentSize;
        public long dataSize;
        public DirectoryEntry directoryEntry;
        public String metadata;
        public int coreIndex;
        public int resolutionIndex;
        public int planeIndex;
        public int pixelTypeIndex;
        private long dataOffset;
        private Length stageX;
        private Length stageY;
        private Length stageZ;
        private Double timestamp;
        private Double exposureTime;
        public int x;
        public int y;
        public int row;
        public int col;

        public SubBlock() {
        }

        public SubBlock(SubBlock model) {
            super(model);
            this.metadataSize = model.metadataSize;
            this.attachmentSize = model.attachmentSize;
            this.dataSize = model.dataSize;
            this.directoryEntry = model.directoryEntry;
            this.metadata = model.metadata;
            this.coreIndex = model.coreIndex;
            this.planeIndex = model.planeIndex;
            this.dataOffset = model.dataOffset;
            this.stageX = model.stageX;
            this.stageY = model.stageY;
            this.timestamp = model.timestamp;
            this.exposureTime = model.exposureTime;
            this.stageZ = model.stageZ;
            this.x = model.x;
            this.y = model.y;
        }

        public String toString() {
            return "coreIndex=" + this.coreIndex + ", planeIndex=" + this.planeIndex + ", resolutionIndex=" + this.resolutionIndex + ", x=" + this.x + ", y=" + this.y + ", row=" + this.row + ", col=" + this.col + ", metadata=" + this.metadata + ", attachmentSize=" + this.attachmentSize + ", directoryEntry=" + this.directoryEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fillInData() throws IOException {
            super.fillInData();
            RandomAccessInputStream s = this.getStream();
            try {
                s.order(ZeissCZIReader.this.isLittleEndian());
                s.seek(this.startingPosition + 32L);
                long fp = s.getFilePointer();
                this.metadataSize = s.readInt();
                this.attachmentSize = s.readInt();
                this.dataSize = s.readLong();
                this.directoryEntry = new DirectoryEntry(s);
                s.skipBytes((int)Math.max(256L - (s.getFilePointer() - fp), 0L));
                this.metadata = s.readString(this.metadataSize).trim();
                this.dataOffset = s.getFilePointer();
                if (s.getFilePointer() + this.dataSize + (long)this.attachmentSize < s.length()) {
                    s.seek(s.getFilePointer() + this.dataSize + (long)this.attachmentSize);
                    this.parseMetadata();
                }
            }
            finally {
                if (this.stream == null) {
                    s.close();
                }
            }
        }

        public byte[] readPixelData() throws FormatException, IOException {
            try (RandomAccessInputStream s = new RandomAccessInputStream(this.filename, (int)this.dataSize);){
                byte[] byArray = this.readPixelData(s);
                return byArray;
            }
        }

        public byte[] readPixelData(RandomAccessInputStream s) throws FormatException, IOException {
            return this.readPixelData(s, null, null);
        }

        public byte[] readPixelData(RandomAccessInputStream s, Region tile, byte[] buf) throws FormatException, IOException {
            s.order(ZeissCZIReader.this.isLittleEndian());
            s.seek(this.dataOffset);
            if (this.directoryEntry.compression == 0) {
                if (buf == null) {
                    buf = new byte[(int)this.dataSize];
                }
                if (tile != null) {
                    ZeissCZIReader.this.readPlane(s, tile.x, tile.y, tile.width, tile.height, buf);
                } else {
                    s.readFully(buf);
                }
                return buf;
            }
            byte[] data = new byte[(int)this.dataSize];
            s.read(data);
            int bytesPerPixel = FormatTools.getBytesPerPixel(ZeissCZIReader.this.getPixelType());
            CodecOptions options = new CodecOptions();
            options.interleaved = ZeissCZIReader.this.isInterleaved();
            options.littleEndian = ZeissCZIReader.this.isLittleEndian();
            options.bitsPerSample = bytesPerPixel * 8;
            options.maxBytes = ZeissCZIReader.this.getSizeX() * ZeissCZIReader.this.getSizeY() * ZeissCZIReader.this.getRGBChannelCount() * bytesPerPixel;
            switch (this.directoryEntry.compression) {
                case 1: {
                    data = new JPEGCodec().decompress(data, options);
                    break;
                }
                case 2: {
                    data = new LZWCodec().decompress(data, options);
                    break;
                }
                case 4: {
                    options.width = this.directoryEntry.dimensionEntries[0].storedSize;
                    options.height = this.directoryEntry.dimensionEntries[1].storedSize;
                    options.maxBytes = options.width * options.height * ZeissCZIReader.this.getRGBChannelCount() * bytesPerPixel;
                    data = new JPEGXRCodec().decompress(data, options);
                    break;
                }
                case 104: {
                    data = ZeissCZIReader.this.decode12BitCamera(data, options.maxBytes);
                    for (int row = 0; row < ZeissCZIReader.this.getSizeY(); ++row) {
                        for (int col = 0; col < ZeissCZIReader.this.getSizeX() / 2; ++col) {
                            int left = row * ZeissCZIReader.this.getSizeX() * 2 + col * 2;
                            int right = row * ZeissCZIReader.this.getSizeX() * 2 + (ZeissCZIReader.this.getSizeX() - col - 1) * 2;
                            byte left1 = data[left];
                            byte left2 = data[left + 1];
                            data[left] = data[right];
                            data[left + 1] = data[right + 1];
                            data[right] = left1;
                            data[right + 1] = left2;
                        }
                    }
                    break;
                }
                case 504: {
                    data = ZeissCZIReader.this.decode12BitCamera(data, options.maxBytes);
                }
            }
            if (buf != null && buf.length >= data.length) {
                System.arraycopy(data, 0, buf, 0, data.length);
                return buf;
            }
            return data;
        }

        private void parseMetadata() throws IOException {
            if (this.metadata.length() <= 16) {
                return;
            }
            Element root = null;
            try {
                ByteArrayInputStream s = new ByteArrayInputStream(this.metadata.getBytes("UTF-8"));
                root = ZeissCZIReader.this.parser.parse(s).getDocumentElement();
                s.close();
            }
            catch (SAXException e) {
                this.metadata = null;
                return;
            }
            if (root == null) {
                this.metadata = null;
                return;
            }
            NodeList children = root.getChildNodes();
            if (children == null) {
                this.metadata = null;
                return;
            }
            for (int i = 0; i < children.getLength(); ++i) {
                NodeList tags;
                Element child;
                if (!(children.item(i) instanceof Element) || !(child = (Element)children.item(i)).getNodeName().equals("Tags") || (tags = child.getChildNodes()) == null) continue;
                for (int tag = 0; tag < tags.getLength(); ++tag) {
                    Double number;
                    Element tagNode;
                    String text;
                    if (!(tags.item(tag) instanceof Element) || (text = (tagNode = (Element)tags.item(tag)).getTextContent()) == null) continue;
                    if (tagNode.getNodeName().equals("StageXPosition")) {
                        number = Double.valueOf(text);
                        this.stageX = new Length(number, UNITS.REFERENCEFRAME);
                        continue;
                    }
                    if (tagNode.getNodeName().equals("StageYPosition")) {
                        number = Double.valueOf(text);
                        this.stageY = new Length(number, UNITS.REFERENCEFRAME);
                        continue;
                    }
                    if (tagNode.getNodeName().equals("FocusPosition")) {
                        number = Double.valueOf(text);
                        this.stageZ = new Length(number, UNITS.REFERENCEFRAME);
                        continue;
                    }
                    if (tagNode.getNodeName().equals("AcquisitionTime")) {
                        Timestamp t = Timestamp.valueOf(text);
                        if (t == null) continue;
                        this.timestamp = (double)t.asInstant().getMillis() / 1000.0;
                        continue;
                    }
                    if (!tagNode.getNodeName().equals("ExposureTime")) continue;
                    this.exposureTime = new Double(text);
                }
            }
            this.metadata = null;
        }
    }

    class Metadata
    extends Segment {
        public String xml;
        public byte[] attachment;

        Metadata() {
        }

        public void skipData() throws IOException {
            super.fillInData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fillInData() throws IOException {
            super.fillInData();
            RandomAccessInputStream s = this.getStream();
            try {
                s.order(true);
                s.seek(this.startingPosition + 32L);
                int xmlSize = s.readInt();
                int attachmentSize = s.readInt();
                s.skipBytes(248);
                this.xml = s.readString(xmlSize);
                this.attachment = new byte[attachmentSize];
                s.read(this.attachment);
            }
            finally {
                if (this.stream == null) {
                    s.close();
                }
            }
        }

        public void clearXML() {
            this.xml = null;
        }
    }

    class FileHeader
    extends Segment {
        public int majorVersion;
        public int minorVersion;
        public long primaryFileGUID;
        public long fileGUID;
        public int filePart;
        public long directoryPosition;
        public long metadataPosition;
        public boolean updatePending;
        public long attachmentDirectoryPosition;

        FileHeader() {
        }

        @Override
        public void fillInData() throws IOException {
            super.fillInData();
            RandomAccessInputStream s = this.getStream();
            try {
                s.order(ZeissCZIReader.this.isLittleEndian());
                s.seek(this.startingPosition + 32L);
                this.majorVersion = s.readInt();
                this.minorVersion = s.readInt();
                s.skipBytes(4);
                s.skipBytes(4);
                this.primaryFileGUID = s.readLong();
                this.fileGUID = s.readLong();
                this.filePart = s.readInt();
                this.directoryPosition = s.readLong();
                this.metadataPosition = s.readLong();
                this.updatePending = s.readInt() != 0;
                this.attachmentDirectoryPosition = s.readLong();
            }
            finally {
                if (this.stream == null) {
                    s.close();
                }
            }
        }
    }

    class Segment {
        public String filename;
        public long startingPosition;
        public String id;
        public long allocatedSize;
        public long usedSize;
        public RandomAccessInputStream stream;

        public Segment() {
            this.filename = null;
            this.startingPosition = 0L;
            this.id = null;
            this.allocatedSize = 0L;
            this.usedSize = 0L;
            this.stream = null;
        }

        public Segment(String filename) {
            this();
            this.filename = filename;
        }

        public Segment(Segment model) {
            this.filename = model.filename;
            this.startingPosition = model.startingPosition;
            this.id = model.id;
            this.allocatedSize = model.allocatedSize;
            this.usedSize = model.usedSize;
        }

        public void fillInData() throws IOException {
            RandomAccessInputStream s = this.getStream();
            try {
                s.order(ZeissCZIReader.this.isLittleEndian());
                s.seek(this.startingPosition + 16L);
                this.allocatedSize = s.readLong();
                this.usedSize = s.readLong();
                if (this.usedSize == 0L) {
                    this.usedSize = this.allocatedSize;
                }
            }
            finally {
                if (this.stream == null) {
                    s.close();
                }
            }
        }

        public void close() throws IOException {
            this.stream = null;
        }

        public RandomAccessInputStream getStream() throws IOException {
            if (this.stream != null) {
                return this.stream;
            }
            return new RandomAccessInputStream(this.filename, 512);
        }
    }
}

