/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.macro;

import ij.IJ;
import ij.ImagePlus;
import java.io.IOException;
import loci.common.Region;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Modulo;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.services.OMEXMLService;
import loci.plugins.BF;
import loci.plugins.in.Calibrator;
import loci.plugins.in.ImagePlusReader;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterOptions;
import loci.plugins.macro.MacroFunctions;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.LociPrefs;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;

public class LociFunctions
extends MacroFunctions {
    public static final String URL_JAVADOCS = "https://downloads.openmicroscopy.org/bio-formats/" + FormatTools.VERSION + "/api/";
    private ImageProcessorReader r;
    private int series = 0;

    public LociFunctions() {
        boolean groupFiles = true;
        try {
            ImporterOptions options = new ImporterOptions();
            groupFiles = options.isGroupFiles();
        }
        catch (IOException exc) {
            IJ.handleException((Throwable)exc);
        }
        this.r = groupFiles ? new ImageProcessorReader(new ChannelSeparator(new FileStitcher(LociPrefs.makeImageReader(), true))) : new ImageProcessorReader(new ChannelSeparator(LociPrefs.makeImageReader()));
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = factory.getInstance(OMEXMLService.class);
            this.r.setMetadataStore(service.createOMEXMLMetadata());
        }
        catch (DependencyException dependencyException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public void getRevision(String[] revision) {
        revision[0] = FormatTools.VCS_REVISION;
    }

    public void getBuildDate(String[] date) {
        date[0] = FormatTools.DATE;
    }

    public void getVersionNumber(String[] version) {
        version[0] = FormatTools.VERSION;
    }

    public void getImageCount(Double[] imageCount) {
        imageCount[0] = new Double(this.r.getImageCount());
    }

    public void getSizeX(Double[] sizeX) {
        sizeX[0] = new Double(this.r.getSizeX());
    }

    public void getSizeY(Double[] sizeY) {
        sizeY[0] = new Double(this.r.getSizeY());
    }

    public void getSizeZ(Double[] sizeZ) {
        sizeZ[0] = new Double(this.r.getSizeZ());
    }

    public void getSizeC(Double[] sizeC) {
        sizeC[0] = new Double(this.r.getSizeC());
    }

    public void getSizeT(Double[] sizeT) {
        sizeT[0] = new Double(this.r.getSizeT());
    }

    public void getPixelType(String[] pixelType) {
        pixelType[0] = FormatTools.getPixelTypeString(this.r.getPixelType());
    }

    public void getEffectiveSizeC(Double[] effectiveSizeC) {
        effectiveSizeC[0] = new Double(this.r.getEffectiveSizeC());
    }

    public void getRGBChannelCount(Double[] rgbChannelCount) {
        rgbChannelCount[0] = new Double(this.r.getRGBChannelCount());
    }

    public void isIndexed(String[] indexed) {
        indexed[0] = this.r.isIndexed() ? "true" : "false";
    }

    public void getChannelDimCount(Double[] channelDimCount) {
        Modulo moduloC = this.r.getModuloC();
        channelDimCount[0] = new Double(moduloC.length() > 1 ? 2.0 : 1.0);
    }

    public void getChannelDimLength(Double i, Double[] channelDimLength) {
        Modulo moduloC = this.r.getModuloC();
        channelDimLength[0] = i.intValue() == 0 ? new Double(moduloC.length() > 1 ? (double)(this.r.getSizeC() / moduloC.length()) : (double)this.r.getSizeC()) : new Double(moduloC.length());
    }

    public void getChannelDimType(Double i, Double[] channelDimType) {
        Modulo moduloC = this.r.getModuloC();
        channelDimType[0] = i.intValue() == 0 ? new Double(moduloC.length() > 1 ? moduloC.parentType : "Channel") : new Double(moduloC.type);
    }

    public void isLittleEndian(String[] littleEndian) {
        littleEndian[0] = this.r.isLittleEndian() ? "true" : "false";
    }

    public void getDimensionOrder(String[] dimOrder) {
        dimOrder[0] = this.r.getDimensionOrder();
    }

    public void isOrderCertain(String[] orderCertain) {
        orderCertain[0] = this.r.isOrderCertain() ? "true" : "false";
    }

    public void isInterleaved(String[] interleaved) {
        interleaved[0] = this.r.isInterleaved() ? "true" : "false";
    }

    public void isInterleavedSubC(Double subC, String[] interleaved) {
        interleaved[0] = this.r.isInterleaved(subC.intValue()) ? "true" : "false";
    }

    public void openImagePlus(String path) {
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setId(path);
            options.setSeriesOn(this.series, true);
            for (ImagePlus imp : imps = BF.openImagePlus(options)) {
                imp.show();
            }
        }
        catch (IOException exc) {
            IJ.handleException((Throwable)exc);
        }
        catch (FormatException exc) {
            IJ.handleException((Throwable)exc);
        }
    }

    public void openThumbImagePlus(String path) {
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setId(path);
            options.setSeriesOn(this.series, true);
            for (ImagePlus imp : imps = BF.openThumbImagePlus(options)) {
                imp.show();
            }
        }
        catch (IOException exc) {
            IJ.handleException((Throwable)exc);
        }
        catch (FormatException exc) {
            IJ.handleException((Throwable)exc);
        }
    }

    public void openThumbImage(String title, Double no) throws FormatException, IOException {
        ImporterOptions options = new ImporterOptions();
        options.setWindowless(true);
        options.setId(this.r.getCurrentFile());
        options.setCrop(true);
        options.setSpecifyRanges(true);
        options.setSeriesOn(this.r.getSeries(), true);
        int[] zct = this.r.getZCTCoords(no.intValue());
        options.setCBegin(this.r.getSeries(), zct[1]);
        options.setZBegin(this.r.getSeries(), zct[0]);
        options.setTBegin(this.r.getSeries(), zct[2]);
        options.setCEnd(this.r.getSeries(), zct[1]);
        options.setZEnd(this.r.getSeries(), zct[0]);
        options.setTEnd(this.r.getSeries(), zct[2]);
        ImportProcess process = new ImportProcess(options);
        process.execute();
        ImagePlusReader reader = new ImagePlusReader(process);
        ImagePlus imp = reader.openThumbImagePlus()[0];
        Calibrator calibrator = new Calibrator(process);
        calibrator.applyCalibration(imp);
        process.getReader().close();
        imp.show();
    }

    public void openImage(String title, Double no) throws FormatException, IOException {
        this.openSubImage(title, no, 0.0, 0.0, new Double(this.r.getSizeX()), new Double(this.r.getSizeY()));
    }

    public void openSubImage(String title, Double no, Double x, Double y, Double w, Double h) throws FormatException, IOException {
        ImporterOptions options = new ImporterOptions();
        options.setWindowless(true);
        options.setId(this.r.getCurrentFile());
        options.setCrop(true);
        options.setSpecifyRanges(true);
        options.setSeriesOn(this.r.getSeries(), true);
        int[] zct = this.r.getZCTCoords(no.intValue());
        options.setCBegin(this.r.getSeries(), zct[1]);
        options.setZBegin(this.r.getSeries(), zct[0]);
        options.setTBegin(this.r.getSeries(), zct[2]);
        options.setCEnd(this.r.getSeries(), zct[1]);
        options.setZEnd(this.r.getSeries(), zct[0]);
        options.setTEnd(this.r.getSeries(), zct[2]);
        Region region = new Region(x.intValue(), y.intValue(), w.intValue(), h.intValue());
        options.setCropRegion(this.r.getSeries(), region);
        ImportProcess process = new ImportProcess(options);
        process.execute();
        ImagePlusReader reader = new ImagePlusReader(process);
        ImagePlus imp = reader.openImagePlus()[0];
        Calibrator calibrator = new Calibrator(process);
        calibrator.applyCalibration(imp);
        process.getReader().close();
        imp.show();
    }

    public void close() throws IOException {
        this.r.close();
    }

    public void closeFileOnly() throws IOException {
        this.r.close(true);
    }

    public void getSeriesCount(Double[] seriesCount) {
        seriesCount[0] = new Double(this.r.getSeriesCount());
    }

    public void setSeries(Double seriesNum) {
        if (seriesNum != null && seriesNum >= 0.0) {
            this.series = seriesNum.intValue();
            if (this.r.getCurrentFile() != null) {
                this.r.setSeries(this.series);
            }
        }
    }

    public void getSeries(Double[] seriesNum) {
        seriesNum[0] = new Double(this.r.getSeries());
    }

    public void setNormalized(Boolean normalize) {
        this.r.setNormalized(normalize);
    }

    public void isNormalized(Boolean[] normalize) {
        normalize[0] = new Boolean(this.r.isNormalized());
    }

    public void setOriginalMetadataPopulated(Boolean populate) {
        this.r.setOriginalMetadataPopulated(populate);
    }

    public void isOriginalMetadataPopulated(Boolean[] populate) {
        populate[0] = new Boolean(this.r.isOriginalMetadataPopulated());
    }

    public void setGroupFiles(String groupFiles) {
        this.r.setGroupFiles("true".equalsIgnoreCase(groupFiles));
    }

    public void isGroupFiles(String[] groupFiles) {
        groupFiles[0] = this.r.isGroupFiles() ? "true" : "false";
    }

    public void isMetadataComplete(String[] complete) {
        complete[0] = this.r.isMetadataComplete() ? "true" : "false";
    }

    public void fileGroupOption(String id, String[] fileGroupOption) throws FormatException, IOException {
        switch (this.r.fileGroupOption(id)) {
            case 0: {
                fileGroupOption[0] = "must";
                break;
            }
            case 1: {
                fileGroupOption[0] = "can";
                break;
            }
            case 2: {
                fileGroupOption[0] = "cannot";
                break;
            }
            default: {
                fileGroupOption[0] = "unknown";
            }
        }
    }

    public void getUsedFileCount(Double[] count) {
        count[0] = new Double(this.r.getUsedFiles().length);
    }

    public void getUsedFile(Double i, String[] used) {
        used[0] = this.r.getUsedFiles()[i.intValue()];
    }

    public void getCurrentFile(String[] file2) {
        file2[0] = this.r.getCurrentFile();
    }

    public void getIndex(Double z, Double c, Double t, Double[] index) {
        index[0] = new Double(this.r.getIndex(z.intValue(), c.intValue(), t.intValue()));
    }

    public void getZCTCoords(Double index, Double[] z, Double[] c, Double[] t) {
        int[] zct = this.r.getZCTCoords(index.intValue());
        z[0] = new Double(zct[0]);
        c[0] = new Double(zct[1]);
        t[0] = new Double(zct[2]);
    }

    public void getMetadataValue(String field, String[] value) {
        Object o = this.r.getMetadataValue(field);
        value[0] = o == null ? null : o.toString();
    }

    public void getSeriesMetadataValue(String field, String[] value) {
        Object o = this.r.getSeriesMetadataValue(field);
        value[0] = o == null ? null : o.toString();
    }

    public void setMetadataFiltered(String metadataFiltered) {
        this.r.setMetadataFiltered("true".equalsIgnoreCase(metadataFiltered));
    }

    public void isMetadataFiltered(String[] metadataFiltered) {
        metadataFiltered[0] = this.r.isMetadataFiltered() ? "true" : "false";
    }

    public void getFormat(String id, String[] format) throws FormatException, IOException {
        try (ImageReader reader = new ImageReader();){
            format[0] = reader.getFormat(id);
        }
    }

    public void setId(String id) throws FormatException, IOException {
        this.r.setId(id);
    }

    public void isThisType(String name, String[] thisType) {
        thisType[0] = this.r.isThisType(name) ? "true" : "false";
    }

    public void isThisTypeFast(String name, String[] thisType) {
        thisType[0] = this.r.isThisType(name, false) ? "true" : "false";
    }

    public void getSeriesName(String[] seriesName) {
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        seriesName[0] = retrieve.getImageName(this.r.getSeries());
    }

    public void getImageCreationDate(String[] creationDate) {
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        if (retrieve.getImageAcquisitionDate(this.r.getSeries()) != null) {
            creationDate[0] = (String)retrieve.getImageAcquisitionDate(this.r.getSeries()).getValue();
        }
    }

    public void getPlaneTimingDeltaT(Double[] deltaT, Double no) {
        Time valTime;
        int imageIndex = this.r.getSeries();
        int planeIndex = LociFunctions.getPlaneIndex(this.r, no.intValue());
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Double val = Double.NaN;
        if (planeIndex >= 0 && (valTime = retrieve.getPlaneDeltaT(imageIndex, planeIndex)) != null) {
            val = valTime.value(UNITS.SECOND).doubleValue();
        }
        deltaT[0] = val;
    }

    public void getPlaneTimingExposureTime(Double[] exposureTime, Double no) {
        int imageIndex = this.r.getSeries();
        int planeIndex = LociFunctions.getPlaneIndex(this.r, no.intValue());
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Double val = null;
        if (planeIndex >= 0) {
            val = retrieve.getPlaneExposureTime(imageIndex, planeIndex).value(UNITS.SECOND).doubleValue();
        }
        exposureTime[0] = val == null ? new Double(Double.NaN) : val;
    }

    public void getPlanePositionX(Double[] positionX, Double no) {
        int imageIndex = this.r.getSeries();
        int planeIndex = LociFunctions.getPlaneIndex(this.r, no.intValue());
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Length val = null;
        if (planeIndex >= 0) {
            val = retrieve.getPlanePositionX(imageIndex, planeIndex);
        }
        positionX[0] = val == null ? Double.NaN : val.value(UNITS.REFERENCEFRAME).doubleValue();
    }

    public void getPlanePositionY(Double[] positionY, Double no) {
        int imageIndex = this.r.getSeries();
        int planeIndex = LociFunctions.getPlaneIndex(this.r, no.intValue());
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Length val = null;
        if (planeIndex >= 0) {
            val = retrieve.getPlanePositionY(imageIndex, planeIndex);
        }
        if (val == null) {
            val = new Length(Double.NaN, UNITS.REFERENCEFRAME);
        }
        positionY[0] = val == null ? Double.NaN : val.value(UNITS.REFERENCEFRAME).doubleValue();
    }

    public void getPlanePositionZ(Double[] positionZ, Double no) {
        int imageIndex = this.r.getSeries();
        int planeIndex = LociFunctions.getPlaneIndex(this.r, no.intValue());
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Length val = null;
        if (planeIndex >= 0) {
            val = retrieve.getPlanePositionZ(imageIndex, planeIndex);
        }
        if (val == null) {
            val = new Length(Double.NaN, UNITS.REFERENCEFRAME);
        }
        positionZ[0] = val == null ? Double.NaN : val.value(UNITS.REFERENCEFRAME).doubleValue();
    }

    public void getPixelsPhysicalSizeX(Double[] sizeX) {
        int imageIndex = this.r.getSeries();
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Length x = retrieve.getPixelsPhysicalSizeX(imageIndex);
        if (x != null) {
            sizeX[0] = x.value(UNITS.MICROMETER).doubleValue();
        }
        if (sizeX[0] == null) {
            sizeX[0] = new Double(Double.NaN);
        }
    }

    public void getPixelsPhysicalSizeY(Double[] sizeY) {
        int imageIndex = this.r.getSeries();
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Length y = retrieve.getPixelsPhysicalSizeY(imageIndex);
        if (y != null) {
            sizeY[0] = y.value(UNITS.MICROMETER).doubleValue();
        }
        if (sizeY[0] == null) {
            sizeY[0] = new Double(Double.NaN);
        }
    }

    public void getPixelsPhysicalSizeZ(Double[] sizeZ) {
        int imageIndex = this.r.getSeries();
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        Length z = retrieve.getPixelsPhysicalSizeZ(imageIndex);
        if (z != null) {
            sizeZ[0] = z.value(UNITS.MICROMETER).doubleValue();
        }
        if (sizeZ[0] == null) {
            sizeZ[0] = new Double(Double.NaN);
        }
    }

    public void getPixelsTimeIncrement(Double[] sizeT) {
        int imageIndex = this.r.getSeries();
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)this.r.getMetadataStore());
        sizeT[0] = retrieve.getPixelsTimeIncrement(imageIndex).value(UNITS.SECOND).doubleValue();
        if (sizeT[0] == null) {
            sizeT[0] = new Double(Double.NaN);
        }
    }

    @Override
    public void run(String arg) {
        if (IJ.macroRunning()) {
            super.run(arg);
        } else {
            IJ.showMessage((String)"Bio-Formats Plugins for ImageJ", (String)"The macro extensions are designed to be used within a macro.\nInstructions on doing so will be printed to the Results window.");
            IJ.log((String)"To gain access to more advanced features of Bio-Formats");
            IJ.log((String)"from within a macro, put the following line at the");
            IJ.log((String)"beginning of your macro:");
            IJ.log((String)"");
            IJ.log((String)"run(\"Bio-Formats Macro Extensions\");");
            IJ.log((String)"");
            IJ.log((String)"This will enable the following macro functions:");
            IJ.log((String)"");
            IJ.log((String)"-= Usable any time =-");
            IJ.log((String)"");
            IJ.log((String)"Ext.openImagePlus(path)");
            IJ.log((String)"-- Opens the image at the given path with the default options.");
            IJ.log((String)"Ext.openThumbImagePlus(path)");
            IJ.log((String)"-- Opens the thumbnail image at the given path");
            IJ.log((String)"-- with the default options.");
            IJ.log((String)"Ext.getFormat(id, format)");
            IJ.log((String)"-- Retrieves the file format of the given id (filename).");
            IJ.log((String)"Ext.setId(id)");
            IJ.log((String)"-- Initializes the given id (filename).");
            IJ.log((String)"Ext.isThisType(name, thisType)");
            IJ.log((String)"-- True if Bio-Formats recognizes the given file as a");
            IJ.log((String)"-- supported image file format; if necessary, will ");
            IJ.log((String)"-- examine the file contents to decide for sure.");
            IJ.log((String)"Ext.isThisTypeFast(name, thisType)");
            IJ.log((String)"-- True if Bio-Formats recognizes the given filename as a");
            IJ.log((String)"-- supported image file format; will decide based on file");
            IJ.log((String)"-- extension only, without examining file contents.");
            IJ.log((String)"Ext.isMetadataComplete(complete)");
            IJ.log((String)"-- True if Bio-Formats completely parses the current");
            IJ.log((String)"-- dataset's file format. If this function returns false,");
            IJ.log((String)"-- there are known limitations or missing features in how");
            IJ.log((String)"-- Bio-Formats handles this file format.");
            IJ.log((String)"Ext.fileGroupOption(id, fileGroupOption)");
            IJ.log((String)"-- Returns a code indicating the file grouping policy for");
            IJ.log((String)"-- for the current dataset. Possible values are:");
            IJ.log((String)"--   must, can, cannot, unknown");
            IJ.log((String)"Ext.getVersionNumber(version)");
            IJ.log((String)"-- Returns the version number of the currently installed");
            IJ.log((String)"-- version of Bio-Formats.");
            IJ.log((String)"Ext.getRevision(revision)");
            IJ.log((String)"-- Returns the revision number of the currently");
            IJ.log((String)"-- installed version of Bio-Formats.");
            IJ.log((String)"Ext.getBuildDate(date)");
            IJ.log((String)"-- Returns the build date of the currently installed");
            IJ.log((String)"-- version of Bio-Formats.");
            IJ.log((String)"");
            IJ.log((String)"-= Usable before initializing a file =-");
            IJ.log((String)"");
            IJ.log((String)"Ext.setNormalized(normalize)");
            IJ.log((String)"-- Sets whether to normalize floating point data to [0-1].");
            IJ.log((String)"Ext.isNormalized(normalize)");
            IJ.log((String)"-- Gets whether float data is being normalized to [0-1].");
            IJ.log((String)"Ext.setOriginalMetadataPopulated(populate)");
            IJ.log((String)"-- Sets whether Bio-Formats should save proprietary metadata");
            IJ.log((String)"-- to the OME metadata store as custom attributes.");
            IJ.log((String)"Ext.isOriginalMetadataPopulated(populate)");
            IJ.log((String)"-- Sets whether Bio-Formats is saving proprietary metadata");
            IJ.log((String)"-- to the OME metadata store as custom attributes.");
            IJ.log((String)"Ext.setGroupFiles(group)");
            IJ.log((String)"-- For multi-file formats, sets whether to force grouping.");
            IJ.log((String)"Ext.isGroupFiles(group)");
            IJ.log((String)"-- Gets whether grouping is forced for multi-file formats..");
            IJ.log((String)"Ext.setMetadataFiltered(filter)");
            IJ.log((String)"-- Sets whether to filter out ugly metadata from the table");
            IJ.log((String)"-- (i.e., entries with unprintable characters, and extremely");
            IJ.log((String)"-- long values).");
            IJ.log((String)"Ext.isMetadataFiltered(filter)");
            IJ.log((String)"-- Gets whether ugly metadata is being filtered out.");
            IJ.log((String)"");
            IJ.log((String)"-== Usable after initializing a file ==-");
            IJ.log((String)"");
            IJ.log((String)"Ext.getSeriesCount(seriesCount)");
            IJ.log((String)"-- Gets the number of image series in the active dataset.");
            IJ.log((String)"Ext.setSeries(seriesNum)");
            IJ.log((String)"-- Sets the current series within the active dataset.");
            IJ.log((String)"Ext.getSeries(seriesNum)");
            IJ.log((String)"-- Gets the current series within the active dataset.");
            IJ.log((String)"Ext.getUsedFileCount(count)");
            IJ.log((String)"-- Gets the number of files that are part of this dataset.");
            IJ.log((String)"Ext.getUsedFile(i, used)");
            IJ.log((String)"-- Gets the i'th filename part of this dataset.");
            IJ.log((String)"Ext.getCurrentFile(file)");
            IJ.log((String)"-- Gets the base filename used to initialize this dataset.");
            IJ.log((String)"Ext.openImage(title, no)");
            IJ.log((String)"-- Opens the no'th plane in a new window named 'title'.");
            IJ.log((String)"Ext.openSubImage(title, no, x, y, width, height)");
            IJ.log((String)"-- Opens a subset of the no'th plane in a new window");
            IJ.log((String)"-- named 'title'.");
            IJ.log((String)"Ext.openThumbImage(title, no)");
            IJ.log((String)"-- Opens the no'th thumbnail in a new window named 'title'.");
            IJ.log((String)"Ext.close()");
            IJ.log((String)"-- Closes the active dataset.");
            IJ.log((String)"Ext.closeFileOnly()");
            IJ.log((String)"-- Closes open files, leaving the current dataset active.");
            IJ.log((String)"");
            IJ.log((String)"-== Applying to the current series ==-");
            IJ.log((String)"");
            IJ.log((String)"Ext.getImageCount(imageCount)");
            IJ.log((String)"-- Gets the total number of planes in the current dataset.");
            IJ.log((String)"Ext.getSizeX(sizeX)");
            IJ.log((String)"-- Gets the width of each image plane in pixels.");
            IJ.log((String)"Ext.getSizeY(sizeY)");
            IJ.log((String)"-- Gets the height of each image plane in pixels.");
            IJ.log((String)"Ext.getSizeZ(sizeZ)");
            IJ.log((String)"-- Gets the number of focal planes in the dataset.");
            IJ.log((String)"Ext.getSizeC(sizeC)");
            IJ.log((String)"-- Gets the number of channels in the dataset.");
            IJ.log((String)"Ext.getSizeT(sizeT)");
            IJ.log((String)"-- Gets the number of time points in the dataset.");
            IJ.log((String)"Ext.getPixelType(pixelType)");
            IJ.log((String)"-- Gets a code representing the pixel type of the image.");
            IJ.log((String)"-- Possible values include:");
            IJ.log((String)"--   int8, uint8, int16, uint16, int32, uint32, float, double");
            IJ.log((String)"Ext.getEffectiveSizeC(effectiveSizeC)");
            IJ.log((String)"-- Gets the 'effective' number of channels, such that:");
            IJ.log((String)"-- effectiveSizeC * sizeZ * sizeT == imageCount");
            IJ.log((String)"Ext.getRGBChannelCount(rgbChannelCount)");
            IJ.log((String)"-- Gets the number of channels per composite image plane:");
            IJ.log((String)"-- sizeC / rgbChannelCount == effectiveSizeC");
            IJ.log((String)"Ext.isIndexed(indexed)");
            IJ.log((String)"-- Gets whether the image planes are stored as indexed color");
            IJ.log((String)"-- (i.e., whether they have embedded LUTs).");
            IJ.log((String)"Ext.getChannelDimCount(channelDimCount)");
            IJ.log((String)"-- For highly multidimensional image data, the C dimension");
            IJ.log((String)"-- may consist of multiple embedded 'sub' dimensions.");
            IJ.log((String)"-- This function returns the number of such dimensions.");
            IJ.log((String)"Ext.getChannelDimLength(i, channelDimLength)");
            IJ.log((String)"-- Gets the length of the i'th embedded 'sub' dimension.");
            IJ.log((String)"Ext.getChannelDimType(i, channelDimType)");
            IJ.log((String)"-- Gets a string label for the i'th embedded 'sub' channel.");
            IJ.log((String)"Ext.isLittleEndian(littleEndian)");
            IJ.log((String)"-- For multi-byte pixel types, get the data's endianness.");
            IJ.log((String)"Ext.getDimensionOrder(dimOrder)");
            IJ.log((String)"-- Gets a five-character string representing the dimensional");
            IJ.log((String)"-- rasterization order within the dataset. Valid orders are:");
            IJ.log((String)"--   XYCTZ, XYCZT, XYTCZ, XYTZC, XYZCT, XYZTC");
            IJ.log((String)"-- In cases where the channels are interleaved (e.g., CXYTZ),");
            IJ.log((String)"-- C will be the first dimension after X and Y (e.g., XYCTZ)");
            IJ.log((String)"-- and the isInterleaved function will return true.");
            IJ.log((String)"Ext.isOrderCertain(orderCertain)");
            IJ.log((String)"-- Gets whether the dimension order and sizes are known,");
            IJ.log((String)"-- or merely guesses.");
            IJ.log((String)"Ext.isInterleaved(interleaved)");
            IJ.log((String)"-- Gets whether or not the channels are interleaved.");
            IJ.log((String)"-- This function exists because X and Y must appear first");
            IJ.log((String)"-- in the dimension order. For interleaved data, XYCTZ or");
            IJ.log((String)"-- XYCZT is used, and this method returns true.");
            IJ.log((String)"Ext.isInterleavedSubC(subC, interleaved)");
            IJ.log((String)"-- Gets whether the given 'sub' channel is interleaved.");
            IJ.log((String)"-- This method exists because some data with multiple");
            IJ.log((String)"-- rasterized sub-dimensions within C have one sub-dimension");
            IJ.log((String)"-- interleaved, and the other not -- e.g., the SDT reader");
            IJ.log((String)"-- handles spectral-lifetime data with interleaved lifetime");
            IJ.log((String)"-- bins and non-interleaved spectral channels.");
            IJ.log((String)"Ext.getIndex(z, c, t, index)");
            IJ.log((String)"-- Gets the rasterized index corresponding to the given");
            IJ.log((String)"-- Z, C and T coordinates, according to the dataset's");
            IJ.log((String)"-- dimension order.");
            IJ.log((String)"Ext.getZCTCoords(index, z, c, t)");
            IJ.log((String)"-- Gets the Z, C and T coordinates corresponding to the given");
            IJ.log((String)"-- rasterized index value, according to the dataset's");
            IJ.log((String)"-- dimension order.");
            IJ.log((String)"Ext.getMetadataValue(field, value)");
            IJ.log((String)"-- Obtains the specified metadata field's value.");
            IJ.log((String)"Ext.getSeriesMetadataValue(field, value)");
            IJ.log((String)"-- Obtains the specified series metadata field's value.");
            IJ.log((String)"Ext.getSeriesName(seriesName)");
            IJ.log((String)"-- Obtains the name of the current series.");
            IJ.log((String)"Ext.getImageCreationDate(creationDate)");
            IJ.log((String)"-- Obtains the creation date of the dataset");
            IJ.log((String)"-- in ISO 8601 format.");
            IJ.log((String)"Ext.getPlaneTimingDeltaT(deltaT, no)");
            IJ.log((String)"-- Obtains the time offset (seconds since the beginning ");
            IJ.log((String)"-- of the experiment) for the no'th plane, or NaN if none.");
            IJ.log((String)"Ext.getPlaneTimingExposureTime(exposureTime, no)");
            IJ.log((String)"-- Obtains the exposure time (in seconds) for the no'th");
            IJ.log((String)"-- plane, or NaN if none.");
            IJ.log((String)"Ext.getPlanePositionX(positionX, no)");
            IJ.log((String)"-- Obtains the X coordinate of the stage for the no'th plane");
            IJ.log((String)"-- or NaN if none.");
            IJ.log((String)"Ext.getPlanePositionY(positionY, no)");
            IJ.log((String)"-- Obtains the Y coordinate of the stage for the no'th plane");
            IJ.log((String)"-- or NaN if none.");
            IJ.log((String)"Ext.getPlanePositionZ(positionZ, no)");
            IJ.log((String)"-- Obtains the Z coordinate of the stage for the no'th plane");
            IJ.log((String)"-- or NaN if none.");
            IJ.log((String)"Ext.getPixelsPhysicalSizeX(sizeX)");
            IJ.log((String)"-- Obtains the width of a pixel in microns, or NaN if the");
            IJ.log((String)"-- the width is not stored in the original file.");
            IJ.log((String)"Ext.getPixelsPhysicalSizeY(sizeY)");
            IJ.log((String)"-- Obtains the height of a pixel in microns, or NaN if the");
            IJ.log((String)"-- the height is not stored in the original file.");
            IJ.log((String)"Ext.getPixelsPhysicalSizeZ(sizeZ)");
            IJ.log((String)"-- Obtains the spacing between Z sections in microns, or NaN");
            IJ.log((String)"-- if the spacing is not stored in the original file.");
            IJ.log((String)"Ext.getPixelsTimeIncrement(sizeT)");
            IJ.log((String)"-- Obtains the spacing between time points in seconds, or");
            IJ.log((String)"-- NaN if the spacing is not stored in the original file.");
            IJ.log((String)"");
            IJ.log((String)"For more information, see the online Javadocs");
            IJ.log((String)"for the loci.formats.IFormatReader and ");
            IJ.log((String)"loci.formats.meta.MetadataRetrieve interfaces:");
            IJ.log((String)URL_JAVADOCS);
        }
    }

    private static int getPlaneIndex(IFormatReader r, int no) {
        MetadataRetrieve retrieve = (MetadataRetrieve)((Object)r.getMetadataStore());
        int imageIndex = r.getSeries();
        int planeCount = retrieve.getPlaneCount(imageIndex);
        int[] zct = r.getZCTCoords(no);
        for (int i = 0; i < planeCount; ++i) {
            Integer theC = (Integer)retrieve.getPlaneTheC(imageIndex, i).getValue();
            Integer theT = (Integer)retrieve.getPlaneTheT(imageIndex, i).getValue();
            Integer theZ = (Integer)retrieve.getPlaneTheZ(imageIndex, i).getValue();
            if (zct[0] != theZ || zct[1] != theC || zct[2] != theT) continue;
            return i;
        }
        return -1;
    }
}

