/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLByteBuffer;
import com.nativelibs4java.opencl.CLCharBuffer;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLDoubleBuffer;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLFloatBuffer;
import com.nativelibs4java.opencl.CLImage2D;
import com.nativelibs4java.opencl.CLImage3D;
import com.nativelibs4java.opencl.CLImageFormat;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLIntBuffer;
import com.nativelibs4java.opencl.CLLongBuffer;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.CLSampler;
import com.nativelibs4java.opencl.CLShortBuffer;
import com.nativelibs4java.opencl.ImageIOUtils;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.opencl.library.OpenGLContextUtils;
import com.nativelibs4java.opencl.library.cl_image_format;
import com.nativelibs4java.util.EnumValues;
import com.nativelibs4java.util.JNAUtils;
import com.nativelibs4java.util.NIOUtils;
import com.nativelibs4java.util.ValuedEnum;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.ochafik.util.listenable.Pair;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class CLContext
extends CLAbstractEntity<OpenCLLibrary.cl_context> {
    volatile Boolean cacheBinaries;
    private static CLInfoGetter<OpenCLLibrary.cl_context> infos = new CLInfoGetter<OpenCLLibrary.cl_context>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_context entity, int infoTypeEnum, NativeSize size, Pointer out, NativeSizeByReference sizeOut) {
            return JavaCL.CL.clGetContextInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    CLPlatform platform;
    protected OpenCLLibrary.cl_device_id[] deviceIds;
    private static final int GL_TEXTURE_2D = 3553;
    private static final int GL_TEXTURE_3D = 32879;
    private static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    private static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    private static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    private static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    private static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    private static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    private static final int GL_TEXTURE_RECTANGLE = 34037;
    private volatile int addressBits = -2;

    public synchronized void setCacheBinaries(boolean cacheBinaries) {
        this.cacheBinaries = cacheBinaries;
    }

    public synchronized boolean getCacheBinaries() {
        if (this.cacheBinaries == null) {
            String plat;
            String prop = System.getProperty("javacl.cacheBinaries");
            String env = System.getenv("JAVACL_CACHE_BINARIES");
            this.cacheBinaries = "true".equals(prop) || "1".equals(env) ? Boolean.valueOf(true) : ("false".equals(prop) || "0".equals(env) ? Boolean.valueOf(false) : Boolean.valueOf(!"ATI Stream".equals(plat = this.getPlatform().getName())));
        }
        return this.cacheBinaries;
    }

    CLContext(CLPlatform platform, OpenCLLibrary.cl_device_id[] deviceIds, OpenCLLibrary.cl_context context) {
        super(context);
        this.platform = platform;
        this.deviceIds = deviceIds;
    }

    public CLEvent createUserEvent() {
        try {
            IntByReference pErr = new IntByReference();
            OpenCLLibrary.cl_event evt = JavaCL.CL.clCreateUserEvent((OpenCLLibrary.cl_context)this.getEntity(), pErr);
            CLException.error(pErr.getValue());
            return CLEvent.createEvent(null, evt, true);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public CLQueue createDefaultQueue(CLDevice.QueueProperties ... queueProperties) {
        return new CLDevice(this.platform, this.deviceIds[0]).createQueue(this, queueProperties);
    }

    public CLQueue createDefaultOutOfOrderQueue() {
        return new CLDevice(this.platform, this.deviceIds[0]).createOutOfOrderQueue(this);
    }

    public CLQueue createDefaultOutOfOrderQueueIfPossible() {
        try {
            return this.createDefaultOutOfOrderQueue();
        }
        catch (CLException.InvalidQueueProperties ex) {
            return this.createDefaultQueue(new CLDevice.QueueProperties[0]);
        }
    }

    public CLQueue createDefaultProfilingQueue() {
        return new CLDevice(this.platform, this.deviceIds[0]).createProfilingQueue(this);
    }

    public CLImageFormat[] getSupportedImageFormats(CLMem.Flags flags, CLMem.ObjectType imageType) {
        IntByReference pCount = new IntByReference();
        int memFlags = (int)flags.value();
        int imTyp = (int)imageType.value();
        Memory memCount = new Memory(16L);
        pCount.setPointer(memCount);
        JavaCL.CL.clGetSupportedImageFormats((OpenCLLibrary.cl_context)this.getEntity(), (long)memFlags, imTyp, 0, null, pCount);
        cl_image_format ft = new cl_image_format();
        int sz = ft.size();
        int n = pCount.getValue();
        if (n == 0) {
            n = 30;
        }
        Memory mem = new Memory(n * sz);
        ft.use(mem);
        JavaCL.CL.clGetSupportedImageFormats((OpenCLLibrary.cl_context)this.getEntity(), (long)memFlags, imTyp, n, ft, (IntByReference)null);
        ArrayList<CLImageFormat> ret = new ArrayList<CLImageFormat>(n);
        for (int i = 0; i < n; ++i) {
            ft.use(mem, (long)(i * sz));
            ft.read();
            if (ft.image_channel_data_type == 0 && ft.image_channel_order == 0) break;
            ret.add(new CLImageFormat(ft));
        }
        return ret.toArray(new CLImageFormat[ret.size()]);
    }

    public CLSampler createSampler(boolean normalized_coords, CLSampler.AddressingMode addressing_mode, CLSampler.FilterMode filter_mode) {
        IntByReference pErr = new IntByReference();
        OpenCLLibrary.cl_sampler sampler = JavaCL.CL.clCreateSampler((OpenCLLibrary.cl_context)this.getEntity(), normalized_coords ? 1 : 0, (int)addressing_mode.value(), (int)filter_mode.value(), pErr);
        CLException.error(pErr.getValue());
        return new CLSampler(sampler);
    }

    public int getDeviceCount() {
        return infos.getOptionalFeatureInt((OpenCLLibrary.cl_context)this.getEntity(), 4227);
    }

    public synchronized CLDevice[] getDevices() {
        if (this.deviceIds == null) {
            Memory ptrs = infos.getMemory((OpenCLLibrary.cl_context)this.getEntity(), 4225);
            int n = (int)(ptrs.getSize() / (long)Native.POINTER_SIZE);
            this.deviceIds = new OpenCLLibrary.cl_device_id[n];
            for (int i = 0; i < n; ++i) {
                this.deviceIds[i] = new OpenCLLibrary.cl_device_id(ptrs.getPointer(i * Native.POINTER_SIZE));
            }
        }
        CLDevice[] devices = new CLDevice[this.deviceIds.length];
        int i = devices.length;
        while (i-- != 0) {
            devices[i] = new CLDevice(this.platform, this.deviceIds[i]);
        }
        return devices;
    }

    public CLProgram createProgram(String ... srcs) {
        return this.createProgram((CLDevice[])null, srcs);
    }

    public CLProgram createProgram(CLDevice[] devices, String ... srcs) {
        CLProgram program = new CLProgram(this, devices);
        for (String src : srcs) {
            program.addSource(src);
        }
        return program;
    }

    public CLProgram loadProgram(InputStream in) throws IOException {
        Pair<Map<CLDevice, byte[]>, String> binaries = CLProgram.readBinaries(Arrays.asList(this.getDevices()), null, in);
        return this.createProgram(binaries.getFirst(), binaries.getSecond());
    }

    public CLProgram createProgram(Map<CLDevice, byte[]> binaries, String source) {
        return new CLProgram(this, binaries, source);
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseContext((OpenCLLibrary.cl_context)this.getEntity()));
    }

    @Deprecated
    public CLDevice guessCurrentGLDevice() {
        long[] props = CLPlatform.getContextProps(CLPlatform.getGLContextProperties(this.getPlatform()));
        Memory propsMem = JNAUtils.toNSArray(props);
        NativeSizeByReference propsRef = new NativeSizeByReference();
        propsRef.setPointer(propsMem);
        NativeSizeByReference pCount = new NativeSizeByReference();
        Memory mem = new Memory(Pointer.SIZE);
        if (Platform.isMac()) {
            CLException.error(JavaCL.CL.clGetGLContextInfoAPPLE((OpenCLLibrary.cl_context)this.getEntity(), OpenGLContextUtils.INSTANCE.CGLGetCurrentContext(), 8198, JNAUtils.toNS(Pointer.SIZE), mem, pCount));
        } else {
            CLException.error(JavaCL.CL.clGetGLContextInfoKHR(propsRef, 8198, JNAUtils.toNS(Pointer.SIZE), mem, pCount));
        }
        if (pCount.getValue().intValue() != Pointer.SIZE) {
            throw new RuntimeException("Not a device : len = " + pCount.getValue().intValue());
        }
        Pointer p = mem.getPointer(0L);
        if (p.equals(Pointer.NULL)) {
            return null;
        }
        return new CLDevice(null, new OpenCLLibrary.cl_device_id(p));
    }

    private static <T extends CLMem> T markAsGL(T mem) {
        mem.isGL = true;
        return mem;
    }

    public CLByteBuffer createBufferFromGLBuffer(CLMem.Usage usage, int openGLBufferObject) {
        OpenCLLibrary.cl_mem mem;
        IntByReference pErr = new IntByReference();
        int previousAttempts = 0;
        do {
            mem = JavaCL.CL.clCreateFromGLBuffer((OpenCLLibrary.cl_context)this.getEntity(), (long)usage.getIntFlags(), openGLBufferObject, pErr);
        } while (CLException.failedForLackOfMemory(pErr.getValue(), previousAttempts++));
        return CLContext.markAsGL(new CLByteBuffer(this, -1L, mem, null));
    }

    public CLImage2D createImage2DFromGLRenderBuffer(CLMem.Usage usage, int openGLRenderBuffer) {
        OpenCLLibrary.cl_mem mem;
        IntByReference pErr = new IntByReference();
        int previousAttempts = 0;
        do {
            mem = JavaCL.CL.clCreateFromGLRenderbuffer((OpenCLLibrary.cl_context)this.getEntity(), (long)usage.getIntFlags(), openGLRenderBuffer, pErr);
        } while (CLException.failedForLackOfMemory(pErr.getValue(), previousAttempts++));
        return CLContext.markAsGL(new CLImage2D(this, mem, null));
    }

    public CLImage2D createImage2DFromGLTexture2D(CLMem.Usage usage, GLTextureTarget textureTarget, int texture, int mipLevel) {
        OpenCLLibrary.cl_mem mem;
        IntByReference pErr = new IntByReference();
        int previousAttempts = 0;
        do {
            mem = JavaCL.CL.clCreateFromGLTexture2D((OpenCLLibrary.cl_context)this.getEntity(), (long)usage.getIntFlags(), (int)textureTarget.value(), mipLevel, texture, pErr);
        } while (CLException.failedForLackOfMemory(pErr.getValue(), previousAttempts++));
        return CLContext.markAsGL(new CLImage2D(this, mem, null));
    }

    public CLPlatform getPlatform() {
        return this.platform;
    }

    public CLImage3D createImage3DFromGLTexture3D(CLMem.Usage usage, int texture, int mipLevel) {
        OpenCLLibrary.cl_mem mem;
        IntByReference pErr = new IntByReference();
        int previousAttempts = 0;
        do {
            mem = JavaCL.CL.clCreateFromGLTexture3D((OpenCLLibrary.cl_context)this.getEntity(), (long)usage.getIntFlags(), 32879, mipLevel, texture, pErr);
        } while (CLException.failedForLackOfMemory(pErr.getValue(), previousAttempts++));
        return CLContext.markAsGL(new CLImage3D(this, mem, null));
    }

    public CLImage2D createImage2D(CLMem.Usage usage, Image image, boolean allowUnoptimizingDirectRead) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        ImageIOUtils.ImageInfo<?> info = ImageIOUtils.getImageInfo(image);
        return this.createImage2D(usage, info.clImageFormat, width, height, 0L, info.dataGetter.getData(image, null, true, allowUnoptimizingDirectRead, this.getByteOrder()), true);
    }

    public CLImage2D createImage2D(CLMem.Usage usage, CLImageFormat format, long width, long height, long rowPitch, Buffer buffer, boolean copy) {
        OpenCLLibrary.cl_mem mem;
        long memFlags = usage.getIntFlags();
        if (buffer != null) {
            memFlags |= copy ? 32L : 8L;
        }
        IntByReference pErr = new IntByReference();
        int previousAttempts = 0;
        do {
            mem = JavaCL.CL.clCreateImage2D((OpenCLLibrary.cl_context)this.getEntity(), memFlags, format.to_cl_image_format(), JNAUtils.toNS(width), JNAUtils.toNS(height), JNAUtils.toNS(rowPitch), buffer == null ? null : Native.getDirectBufferPointer(buffer), pErr);
        } while (CLException.failedForLackOfMemory(pErr.getValue(), previousAttempts++));
        return new CLImage2D(this, mem, format);
    }

    public CLImage2D createImage2D(CLMem.Usage usage, CLImageFormat format, long width, long height, long rowPitch) {
        return this.createImage2D(usage, format, width, height, rowPitch, null, false);
    }

    public CLImage2D createImage2D(CLMem.Usage usage, CLImageFormat format, long width, long height) {
        return this.createImage2D(usage, format, width, height, 0L, null, false);
    }

    public CLImage3D createImage3D(CLMem.Usage usage, CLImageFormat format, long width, long height, long depth, long rowPitch, long slicePitch, Buffer buffer, boolean copy) {
        OpenCLLibrary.cl_mem mem;
        long memFlags = usage.getIntFlags();
        if (buffer != null) {
            memFlags |= copy ? 32L : 8L;
        }
        IntByReference pErr = new IntByReference();
        int previousAttempts = 0;
        do {
            mem = JavaCL.CL.clCreateImage3D((OpenCLLibrary.cl_context)this.getEntity(), memFlags, format.to_cl_image_format(), JNAUtils.toNS(width), JNAUtils.toNS(height), JNAUtils.toNS(depth), JNAUtils.toNS(rowPitch), JNAUtils.toNS(slicePitch), buffer == null ? null : Native.getDirectBufferPointer(buffer), pErr);
        } while (CLException.failedForLackOfMemory(pErr.getValue(), previousAttempts++));
        return new CLImage3D(this, mem, format);
    }

    public CLImage3D createImage3D(CLMem.Usage usage, CLImageFormat format, long width, long height, long depth, long rowPitch, long slicePitch) {
        return this.createImage3D(usage, format, width, height, depth, rowPitch, slicePitch, null, false);
    }

    public CLImage3D createImage3D(CLMem.Usage usage, CLImageFormat format, long width, long height, long depth) {
        return this.createImage3D(usage, format, width, height, depth, 0L, 0L, null, false);
    }

    public CLIntBuffer createIntBuffer(CLMem.Usage kind, IntBuffer buffer, boolean copy) {
        return this.createByteBuffer(kind, buffer, copy).asCLIntBuffer();
    }

    public CLIntBuffer createIntBuffer(CLMem.Usage kind, long count) {
        return this.createByteBuffer(kind, count * 4L).asCLIntBuffer();
    }

    public CLLongBuffer createLongBuffer(CLMem.Usage kind, LongBuffer buffer, boolean copy) {
        return this.createByteBuffer(kind, buffer, copy).asCLLongBuffer();
    }

    public CLLongBuffer createLongBuffer(CLMem.Usage kind, long count) {
        return this.createByteBuffer(kind, count * 8L).asCLLongBuffer();
    }

    public CLShortBuffer createShortBuffer(CLMem.Usage kind, ShortBuffer buffer, boolean copy) {
        return this.createByteBuffer(kind, buffer, copy).asCLShortBuffer();
    }

    public CLShortBuffer createShortBuffer(CLMem.Usage kind, long count) {
        return this.createByteBuffer(kind, count * 2L).asCLShortBuffer();
    }

    public CLCharBuffer createCharBuffer(CLMem.Usage kind, CharBuffer buffer, boolean copy) {
        return this.createByteBuffer(kind, buffer, copy).asCLCharBuffer();
    }

    public CLCharBuffer createCharBuffer(CLMem.Usage kind, long count) {
        return this.createByteBuffer(kind, count * 2L).asCLCharBuffer();
    }

    public CLFloatBuffer createFloatBuffer(CLMem.Usage kind, FloatBuffer buffer, boolean copy) {
        return this.createByteBuffer(kind, buffer, copy).asCLFloatBuffer();
    }

    public CLFloatBuffer createFloatBuffer(CLMem.Usage kind, long count) {
        return this.createByteBuffer(kind, count * 4L).asCLFloatBuffer();
    }

    public CLDoubleBuffer createDoubleBuffer(CLMem.Usage kind, DoubleBuffer buffer, boolean copy) {
        return this.createByteBuffer(kind, buffer, copy).asCLDoubleBuffer();
    }

    public CLDoubleBuffer createDoubleBuffer(CLMem.Usage kind, long count) {
        return this.createByteBuffer(kind, count * 8L).asCLDoubleBuffer();
    }

    public CLByteBuffer createByteBuffer(CLMem.Usage kind, long count) {
        return this.createBuffer(null, count, kind.getIntFlags(), false);
    }

    public <B extends Buffer> CLBuffer<B> createBuffer(CLMem.Usage kind, long count, Class<B> bufferClass) {
        if (IntBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createIntBuffer(kind, count);
        }
        if (LongBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createLongBuffer(kind, count);
        }
        if (ShortBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createShortBuffer(kind, count);
        }
        if (ByteBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createByteBuffer(kind, count);
        }
        if (CharBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createCharBuffer(kind, count);
        }
        if (DoubleBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createDoubleBuffer(kind, count);
        }
        if (FloatBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createFloatBuffer(kind, count);
        }
        throw new UnsupportedOperationException("Cannot create OpenCL buffers of Java type " + bufferClass.getName());
    }

    public <B extends Buffer> CLBuffer<B> createBuffer(CLMem.Usage kind, B buffer, boolean copy) {
        Class<?> bufferClass = buffer.getClass();
        if (IntBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createIntBuffer(kind, (IntBuffer)buffer, copy);
        }
        if (LongBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createLongBuffer(kind, (LongBuffer)buffer, copy);
        }
        if (ShortBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createShortBuffer(kind, (ShortBuffer)buffer, copy);
        }
        if (ByteBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createByteBuffer(kind, (ByteBuffer)buffer, copy);
        }
        if (CharBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createCharBuffer(kind, (CharBuffer)buffer, copy);
        }
        if (DoubleBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createDoubleBuffer(kind, (DoubleBuffer)buffer, copy);
        }
        if (FloatBuffer.class.isAssignableFrom(bufferClass)) {
            return this.createFloatBuffer(kind, (FloatBuffer)buffer, copy);
        }
        throw new UnsupportedOperationException("Cannot create OpenCL buffers of Java type " + bufferClass.getName());
    }

    public CLByteBuffer createByteBuffer(CLMem.Usage kind, Buffer buffer, boolean copy) {
        if (!buffer.isDirect()) {
            if (!copy) {
                throw new IllegalArgumentException("Cannot create an OpenCL buffer object out of a non-direct NIO buffer without copy.");
            }
            if (kind == CLMem.Usage.Output) {
                throw new IllegalArgumentException("Output NIO buffers must be direct.");
            }
            buffer = NIOUtils.directCopy(buffer, this.getKernelsDefaultByteOrder());
        }
        return this.createBuffer(buffer, -1L, kind.getIntFlags() | (copy ? 32 : 8), copy);
    }

    private CLByteBuffer createBuffer(Buffer buffer, long byteCount, int CLBufferFlags, boolean retainBufferReference) {
        OpenCLLibrary.cl_mem mem;
        if (buffer != null) {
            byteCount = NIOUtils.getSizeInBytes(buffer);
        } else if (retainBufferReference) {
            throw new IllegalArgumentException("Cannot retain reference to null pointer !");
        }
        if (byteCount <= 0L) {
            throw new IllegalArgumentException("Buffer size must be greater than zero (asked for size " + byteCount + ")");
        }
        IntByReference pErr = new IntByReference();
        int previousAttempts = 0;
        do {
            mem = JavaCL.CL.clCreateBuffer((OpenCLLibrary.cl_context)this.getEntity(), (long)CLBufferFlags, JNAUtils.toNS(byteCount), buffer == null ? null : Native.getDirectBufferPointer(buffer), pErr);
        } while (CLException.failedForLackOfMemory(pErr.getValue(), previousAttempts++));
        return new CLByteBuffer(this, byteCount, mem, buffer);
    }

    public ByteOrder getKernelsDefaultByteOrder() {
        ByteOrder order = null;
        for (CLDevice device : this.getDevices()) {
            ByteOrder devOrder = device.getKernelsDefaultByteOrder();
            if (order != null && devOrder != order) {
                return null;
            }
            order = devOrder;
        }
        return order;
    }

    public ByteOrder getByteOrder() {
        ByteOrder order = null;
        for (CLDevice device : this.getDevices()) {
            ByteOrder devOrder = device.getByteOrder();
            if (order != null && devOrder != order) {
                return null;
            }
            order = devOrder;
        }
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAddressBits() {
        if (this.addressBits == -2) {
            CLContext cLContext = this;
            synchronized (cLContext) {
                if (this.addressBits == -2) {
                    for (CLDevice device : this.getDevices()) {
                        int bits = device.getAddressBits();
                        if (this.addressBits != -2 && bits != this.addressBits) {
                            this.addressBits = -1;
                            break;
                        }
                        this.addressBits = bits;
                    }
                }
            }
        }
        return this.addressBits;
    }

    public boolean isDoubleSupported() {
        for (CLDevice device : this.getDevices()) {
            if (device.isDoubleSupported()) continue;
            return false;
        }
        return true;
    }

    public boolean isHalfSupported() {
        for (CLDevice device : this.getDevices()) {
            if (device.isHalfSupported()) continue;
            return false;
        }
        return true;
    }

    public boolean isByteAddressableStoreSupported() {
        for (CLDevice device : this.getDevices()) {
            if (device.isByteAddressableStoreSupported()) continue;
            return false;
        }
        return true;
    }

    public static enum GLTextureTarget implements ValuedEnum
    {
        Texture2D(3553L),
        CubeMapPositiveX(34069L),
        CubeMapNegativeX(34070L),
        CubeMapPositiveY(34071L),
        CubeMapNegativeY(34072L),
        CubeMapPositiveZ(34073L),
        CubeMapNegativeZ(34074L),
        Rectangle(34037L);

        long value;

        private GLTextureTarget(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static GLTextureTarget getEnum(int v) {
            return EnumValues.getEnum(v, GLTextureTarget.class);
        }
    }
}

