package plugins.lagache.colocmanders;


import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

import javassist.expr.NewArray;
import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.Plugin;

import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI2DRectangle;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import icy.util.StringUtil;
import icy.util.ShapeUtil.BooleanOperator;


import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;

// Colocalisation with Ripley function K
// Significant 

public class MandersBlock extends Plugin implements Block {
	
			
	
	VarSequence	sequence1	= new VarSequence("sequence", null);
	VarSequence	sequence2	= new VarSequence("sequence", null);

	VarBoolean	surface		= new VarBoolean("Surface based overlap", false);
	
	VarDouble M1=new VarDouble("Manders Coefficient M1",0);
	VarDouble M2=new VarDouble("Manders Coefficient M2",0);
	
	
	VarDouble P1=new VarDouble("p value (M1)",0);
	VarDouble P2=new VarDouble("p value (M2)",0);
			
	VarBoolean                          exportExcel        = new VarBoolean("Export results in excel",false);	
	VarFile                             exportExcelFile        = new VarFile("Excel File", null);
	
		// AIRE
	private double Roiarea(ROI2D roi) {
		BooleanMask2D roiMask = roi.getAsBooleanMask(true);
		int minx = Math.max(0, roiMask.bounds.x);
		int maxx = roiMask.bounds.x + roiMask.bounds.width;
		int miny = Math.max(0, roiMask.bounds.y);
		int maxy = roiMask.bounds.y + roiMask.bounds.height;

		int areaR = 0;// size Cell
		for (int ix = minx; ix < maxx; ix++)
			for (int y = miny; y < maxy; y++) {
				if (roiMask.contains(ix, y)) {
					areaR++;
				}

			}
		return areaR;
	}

	private void performAnalysis(VarSequence sequence_1,
			VarSequence sequence_2, VarBoolean exportExcel) {

		//initialisation excel dans tous les cas
		
		// initialisation xls
				int row = 0;
				XlsManager xlsManager = null;
				if (exportExcel.getValue()) {
					int page = 1;
					try {
						File f = exportExcelFile.getValue(true);
						if (!FileUtil.getFileExtension(f.getPath(), false)
								.equalsIgnoreCase("xls"))
							f = new File(f.getPath() + ".xls");
						xlsManager = new XlsManager(f);
						xlsManager.createNewPage("Page " + page);
					} catch (Exception e) {
						e.printStackTrace();
						return;
					}

					xlsManager.setLabel(0, 0, "Date of XLS page:");
					row++;
					xlsManager.setLabel(0, row, new Date().toString());
					row++;
					
					xlsManager.setLabel(0, row, "Time");
					xlsManager.setLabel(1, row, "M1");
					xlsManager.setLabel(2, row, "M2");
					xlsManager.setLabel(3, row, "p value (M1)");
					xlsManager.setLabel(4, row, "p value (M2)");
					row++;}		
									
	//initialisation boucle en temps
		// temps total de la sequence
		int T;
		if (sequence_1.getValue()!=null){T=sequence_1.getValue().getLength();}
		else{return;}
					
			//dmarrage boucle en temps
			for (int t = 0; t < T; t += 1) {
				if (exportExcel.getValue()){
				xlsManager.setNumber(0, row, t);}
										
			
			double manders[] = MandersCoeff(sequence_1, sequence_2, t);
			M1.setValue(manders[0]);			
			M2.setValue(manders[1]);			
			P1.setValue(manders[2]);			
			P2.setValue(manders[3]);
						
			//gerer l'export excel
			if (exportExcel.getValue()) {
			xlsManager.setNumber(1, row, M1.getValue());
			xlsManager.setNumber(2, row, M2.getValue());
			xlsManager.setNumber(3, row, P1.getValue());
			xlsManager.setNumber(4, row, P2.getValue());						
			}
			
			row++;
			}
			
			
		if (exportExcel.getValue()) {
			xlsManager.SaveAndClose();}	
		}
		

	private double[] MandersCoeff(VarSequence sequence1,
			VarSequence sequence2, int t) {
		
		double[] Manders = new double[4];
		double manders1=0;double manders2=0;			
				
		Sequence seq1 = sequence1.getValue();
		Sequence seq2 = sequence2.getValue();
		IcyBufferedImage img1 = seq1.getAllImage().get(t);
		IcyBufferedImage img2 = seq2.getAllImage().get(t);

		//cration des 2 ROIs pour les 2 signaux
		//List<ROI2D> roiArrayList1 = seq1.getROI2Ds();
		//calcul de la ROI 1 
		ArrayList<ROI2D> roiArrayList1 = seq1.getROI2Ds();
		ArrayList<ROI2D> roiArrayList1_t = new ArrayList<ROI2D>();		
				for (ROI2D roi:roiArrayList1){
					if (roi.getT()==t||roi.getT()==-1){
						roi.setC(0);roi.setZ(0);
						if (roi.getT()==-1){
							ROI2D roiclone=(ROI2D) roi.getCopy();roiclone.setT(t);roiArrayList1_t.add(roiclone);roiclone.delete();}
						else{
							roiArrayList1_t.add(roi);}							
					}	
				}
							
				
				if (roiArrayList1_t.isEmpty())
					roiArrayList1_t.add(new ROI2DRectangle(seq1.getBounds2D()));
						//roiArrayList1_t.add(new ROI2DRectangle());						
					
					//calcul de l'union des ROIs en forcant le canal  0
				ROI2D roiUnion1 = roiArrayList1_t.get(0);
				for (ROI2D roi:roiArrayList1_t){						
					roiUnion1=(ROI2D)roiUnion1.getUnion(roi);
					roiUnion1.setC(0);roiUnion1.setZ(0);roiUnion1.setT(t);
				}
				
					//ROI roiUnion1 = ROIUtil.getUnion(roiArrayList1_t);
					Rectangle2D roiBounds1 = roiUnion1.getBounds5D().toRectangle2D();
					
					//calcul ROI 2
				 
					ArrayList<ROI2D> roiArrayList2 = seq2.getROI2Ds();
					ArrayList<ROI2D> roiArrayList2_t = new ArrayList<ROI2D>();		
							for (ROI2D roi:roiArrayList2){
								if (roi.getT()==t||roi.getT()==-1){
									roi.setC(0);roi.setZ(0);
									if (roi.getT()==-1){
										ROI2D roiclone=(ROI2D) roi.getCopy();roiclone.setT(t);roiArrayList2_t.add(roiclone);roiclone.delete();}
									else{
										roiArrayList2_t.add(roi);}							
								}	
							}
										
							
							if (roiArrayList2_t.isEmpty())
								roiArrayList2_t.add(new ROI2DRectangle(seq2.getBounds2D()));
									//roiArrayList2_t.add(new ROI2DRectangle());						
								
								//calcul de l'union des ROIs en forcant le canal  0
								//ROI roiUnion2 = ROIUtil.getUnion(roiArrayList2_t);
							ROI2D roiUnion2 = roiArrayList2_t.get(0);
							for (ROI2D roi:roiArrayList2_t){						
								roiUnion2 = (ROI2D)roiUnion2.getUnion(roi);
								roiUnion2.setC(0);roiUnion2.setZ(0);roiUnion2.setT(t);
							}
								Rectangle2D roiBounds2 = roiUnion2.getBounds5D().toRectangle2D();
			

											
		if ((roiUnion1 instanceof ROI2D)&&(roiUnion2 instanceof ROI2D)) {
			ROI2D roi2d1 = (ROI2D) roiUnion1;
			ROI2D roi2d2 = (ROI2D) roiUnion2;
			
			double[] tab1 = Array1DUtil.arrayToDoubleArray(img1.getDataXY(0),
					img1.isSignedDataType());
			double[] tab2 = Array1DUtil.arrayToDoubleArray(img2.getDataXY(0),
					img2.isSignedDataType());

			int sizeX = img1.getSizeX();
			
			int minX1 = (int) roiBounds1.getMinX();
			int minY1 = (int) roiBounds1.getMinY();
			int maxX1 = (int) roiBounds1.getMaxX();
			int maxY1 = (int) roiBounds1.getMaxY();
			
			
			int minX2 = (int) roiBounds2.getMinX();
			int minY2 = (int) roiBounds2.getMinY();
			int maxX2 = (int) roiBounds2.getMaxX();
			int maxY2 = (int) roiBounds2.getMaxY();
			
			int minX = Math.min(minX1, minX2);
			int minY = Math.min(minY1, minY2);
			int maxX=  Math.max(maxX1, maxX2);
			int maxY=  Math.max(maxY1, maxY2);
			
			
			double intensite1 = 0;
			double intensite_2_1 = 0;
			
			double intensite2 = 0;
			double intensite_2_2 = 0;
			
			double inter1 = 0;
			double inter2 = 0;
			double inter1_2 = 0;
			double inter2_2 = 0;
			
			double surface_inter=0;
			double surface1 = 0;
			double surface2 = 0;

						
			Rectangle2D rect = seq1.getBounds2D();
			double minXSequence = rect.getMinX()+1;
			double maxXSequence = rect.getMaxX()-1;
			double minYSequence = rect.getMinY()+1;
			double maxYSequence = rect.getMaxY()-1;
			
			minX = Math.max(minX, (int)minXSequence);
			maxX = Math.min(maxX, (int)maxXSequence);
			minY = Math.max(minY, (int)minYSequence);
			maxY = Math.min(maxY, (int)maxYSequence);
			
			for (int x = minX; x <= maxX; x++) {
				for (int y = minY; y <= maxY; y++) {
					int off = (y * sizeX) + x;
					if (roi2d1.contains(x, y)) {							
						intensite1 += tab1[off];
						intensite_2_1 += Math.pow(tab1[off],2);
						surface1+=1;
						if (roi2d2.contains(x, y)) {
							inter1+= tab1[off];
							inter1_2+=Math.pow(tab1[off],2);
							
							inter2+= tab2[off];
							inter2_2+=Math.pow(tab2[off],2);
							
							surface_inter+=1;
							
						}}
					if (roi2d2.contains(x, y)){
						intensite2+=tab2[off];
						intensite_2_2 += Math.pow(tab2[off],2);
						surface2+=1;							}
					}
				}
			
											
			if (intensite1 != 0) 
			manders1=inter1/intensite1;
			else
			manders1=0;	
			
			if (intensite2 != 0)
			manders2=inter2/intensite2;
			else
			manders2=0;	
				
			
			Manders[0]=manders1;
			Manders[1]=manders2;
			
			//calcul des p_vallues par TCL sur pixel scrambling
			//int blocksize = block.getValue();
			double p2=surface2/(seq1.getWidth()*seq1.getHeight());												
			double p1=surface1/(seq2.getWidth()*seq2.getHeight());
			
			double variance_M1=0,variance_M2=0;
			double mean_1 = p2;double mean_2 = p1;
			
			if (intensite1>0)
				variance_M1 = (p2*(1-p2)*intensite_2_1)/(Math.pow(intensite1,2));
			
			
			if (intensite2>0)
				variance_M2 = (p1*(1-p1)*intensite_2_2)/(Math.pow(intensite2,2));
			
			
			//sous l'hypothese nulle, M1-mu/sigma est normal-centre-reduit
			double R1=0;double R2=0;
			
			if (variance_M1>0)
				R1=(manders1-mean_1)/Math.sqrt(variance_M1);
							
							
			if (variance_M2>0)
				R2=(manders2-mean_2)/Math.sqrt(variance_M2);
							
														
			ErrorFunction er = new ErrorFunction();
			
			Manders[2]=0.5*(1+er.erf(R1/Math.sqrt(2)));				
			if (manders1==1)
				Manders[2]=0;				
			
			Manders[3]=0.5*(1+er.erf(R1/Math.sqrt(2)));				
			if (manders2==1)
				Manders[3]=0;}
						
		return Manders;
	}


	
				
		@Override
	public void run()
	{
			if (sequence1.getValue() == null || sequence2.getValue() == null) {
				new AnnounceFrame("Please first select sequences");
				return;} 
			else {performAnalysis(sequence1, sequence2, exportExcel);}}
	    
	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add("input sequence 1", sequence1);
		inputMap.add("input sequence 2", sequence2);
		inputMap.add( exportExcel );
		inputMap.add( exportExcelFile );
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add("Manders coefficient M1", M1);
		outputMap.add("Manders coefficient M2", M2);
		outputMap.add("p value M1", P1);
		outputMap.add("p value M2", P2);
		

	}
}
