/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block;

public class BlockInnerTriangularSolver {
    public static void invertLower(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            double d = dArray[n2 + i * n + i];
            for (int j = 0; j < i; ++j) {
                double d2 = 0.0;
                for (int k = j; k < i; ++k) {
                    d2 += dArray[n2 + i * n + k] * dArray2[n3 + k * n + j];
                }
                dArray2[n3 + i * n + j] = -d2 / d;
            }
            dArray2[n3 + i * n + i] = 1.0 / d;
        }
    }

    public static void invertLower(double[] dArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            double d = dArray[n2 + i * n + i];
            for (int j = 0; j < i; ++j) {
                double d2 = 0.0;
                for (int k = j; k < i; ++k) {
                    d2 += dArray[n2 + i * n + k] * dArray[n2 + k * n + j];
                }
                dArray[n2 + i * n + j] = -d2 / d;
            }
            dArray[n2 + i * n + i] = 1.0 / d;
        }
    }

    public static void solveL(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = dArray2[n5 + j * n2 + i];
                for (int k = 0; k < j; ++k) {
                    d -= dArray[n4 + j * n3 + k] * dArray2[n5 + k * n2 + i];
                }
                dArray2[n5 + j * n2 + i] = d / dArray[n4 + j * n3 + j];
            }
        }
    }

    public static void solveTransL(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n2; ++i) {
            for (int j = n - 1; j >= 0; --j) {
                double d = dArray2[n5 + j * n2 + i];
                for (int k = j + 1; k < n; ++k) {
                    d -= dArray[n4 + k * n3 + j] * dArray2[n5 + k * n2 + i];
                }
                dArray2[n5 + j * n2 + i] = d / dArray[n4 + j * n3 + j];
            }
        }
    }

    public static void solveLTransB(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = dArray2[n5 + i * n + j];
                int n6 = n4 + j * n3;
                int n7 = n5 + i * n;
                int n8 = n6 + j;
                while (n6 != n8) {
                    d -= dArray[n6++] * dArray2[n7++];
                }
                dArray2[n5 + i * n + j] = d / dArray[n4 + j * n3 + j];
            }
        }
    }

    public static void solveU(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n2; ++i) {
            for (int j = n - 1; j >= 0; --j) {
                double d = dArray2[n5 + j * n2 + i];
                for (int k = j + 1; k < n; ++k) {
                    d -= dArray[n4 + j * n3 + k] * dArray2[n5 + k * n2 + i];
                }
                dArray2[n5 + j * n2 + i] = d / dArray[n4 + j * n3 + j];
            }
        }
    }

    public static void solveTransU(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = dArray2[n5 + j * n2 + i];
                for (int k = 0; k < j; ++k) {
                    d -= dArray[n4 + k * n3 + j] * dArray2[n5 + k * n2 + i];
                }
                dArray2[n5 + j * n2 + i] = d / dArray[n4 + j * n3 + j];
            }
        }
    }
}

