/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.DecompositionFactory;
import org.ejml.alg.dense.decomposition.SingularValueDecomposition;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.SingularOps;

public class NormOps {
    public static void normalizeF(DenseMatrix64F denseMatrix64F) {
        double d = NormOps.normF(denseMatrix64F);
        if (d == 0.0) {
            return;
        }
        int n = denseMatrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            denseMatrix64F.div(i, d);
        }
    }

    public static double conditionP(DenseMatrix64F denseMatrix64F, double d) {
        if (d == 2.0) {
            return NormOps.conditionP2(denseMatrix64F);
        }
        if (denseMatrix64F.numRows == denseMatrix64F.numCols) {
            DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(denseMatrix64F.numRows, denseMatrix64F.numCols);
            if (!CommonOps.invert(denseMatrix64F, denseMatrix64F2)) {
                throw new IllegalArgumentException("A can't be inverted.");
            }
            return NormOps.normP(denseMatrix64F, d) * NormOps.normP(denseMatrix64F2, d);
        }
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(denseMatrix64F.numCols, denseMatrix64F.numRows);
        CommonOps.pinv(denseMatrix64F, denseMatrix64F3);
        return NormOps.normP(denseMatrix64F, d) * NormOps.normP(denseMatrix64F3, d);
    }

    public static double conditionP2(DenseMatrix64F denseMatrix64F) {
        SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition = DecompositionFactory.svd(denseMatrix64F.numRows, denseMatrix64F.numCols);
        singularValueDecomposition.decompose(denseMatrix64F);
        double[] dArray = singularValueDecomposition.getSingularValues();
        int n = SingularOps.rank(singularValueDecomposition, 1.0E-12);
        if (n == 0) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (double d3 : dArray) {
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return d2 / d;
    }

    public static double fastNormF(D1Matrix64F d1Matrix64F) {
        double d = 0.0;
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            double d2 = d1Matrix64F.get(i);
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double normF(D1Matrix64F d1Matrix64F) {
        double d = 0.0;
        double d2 = CommonOps.elementMaxAbs(d1Matrix64F);
        if (d2 == 0.0) {
            return 0.0;
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            double d3 = d1Matrix64F.get(i) / d2;
            d += d3 * d3;
        }
        return d2 * Math.sqrt(d);
    }

    public static double elementP(RowD1Matrix64F rowD1Matrix64F, double d) {
        if (d == 1.0) {
            return CommonOps.elementSumAbs(rowD1Matrix64F);
        }
        if (d == 2.0) {
            return NormOps.normF(rowD1Matrix64F);
        }
        double d2 = CommonOps.elementMaxAbs(rowD1Matrix64F);
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = 0.0;
        int n = rowD1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            double d4 = rowD1Matrix64F.get(i) / d2;
            d3 += Math.pow(Math.abs(d4), d);
        }
        return d2 * Math.pow(d3, 1.0 / d);
    }

    public static double fastElementP(D1Matrix64F d1Matrix64F, double d) {
        if (d == 2.0) {
            return NormOps.fastNormF(d1Matrix64F);
        }
        double d2 = 0.0;
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            double d3 = d1Matrix64F.get(i);
            d2 += Math.pow(Math.abs(d3), d);
        }
        return Math.pow(d2, 1.0 / d);
    }

    public static double normP(DenseMatrix64F denseMatrix64F, double d) {
        if (d == 1.0) {
            return NormOps.normP1(denseMatrix64F);
        }
        if (d == 2.0) {
            return NormOps.normP2(denseMatrix64F);
        }
        if (Double.isInfinite(d)) {
            return NormOps.normPInf(denseMatrix64F);
        }
        if (MatrixFeatures.isVector(denseMatrix64F)) {
            return NormOps.elementP(denseMatrix64F, d);
        }
        throw new IllegalArgumentException("Doesn't support induced norms yet.");
    }

    public static double fastNormP(DenseMatrix64F denseMatrix64F, double d) {
        if (d == 1.0) {
            return NormOps.normP1(denseMatrix64F);
        }
        if (d == 2.0) {
            return NormOps.fastNormP2(denseMatrix64F);
        }
        if (Double.isInfinite(d)) {
            return NormOps.normPInf(denseMatrix64F);
        }
        if (MatrixFeatures.isVector(denseMatrix64F)) {
            return NormOps.fastElementP(denseMatrix64F, d);
        }
        throw new IllegalArgumentException("Doesn't support induced norms yet.");
    }

    public static double normP1(DenseMatrix64F denseMatrix64F) {
        if (MatrixFeatures.isVector(denseMatrix64F)) {
            return CommonOps.elementSumAbs(denseMatrix64F);
        }
        return NormOps.inducedP1(denseMatrix64F);
    }

    public static double normP2(DenseMatrix64F denseMatrix64F) {
        if (MatrixFeatures.isVector(denseMatrix64F)) {
            return NormOps.normF(denseMatrix64F);
        }
        return NormOps.inducedP2(denseMatrix64F);
    }

    public static double fastNormP2(DenseMatrix64F denseMatrix64F) {
        if (MatrixFeatures.isVector(denseMatrix64F)) {
            return NormOps.fastNormF(denseMatrix64F);
        }
        return NormOps.inducedP2(denseMatrix64F);
    }

    public static double normPInf(DenseMatrix64F denseMatrix64F) {
        if (MatrixFeatures.isVector(denseMatrix64F)) {
            return CommonOps.elementMaxAbs(denseMatrix64F);
        }
        return NormOps.inducedPInf(denseMatrix64F);
    }

    public static double inducedP1(DenseMatrix64F denseMatrix64F) {
        double d = 0.0;
        int n = denseMatrix64F.numRows;
        int n2 = denseMatrix64F.numCols;
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                d2 += Math.abs(denseMatrix64F.get(j, i));
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double inducedP2(DenseMatrix64F denseMatrix64F) {
        SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition = DecompositionFactory.svd(denseMatrix64F.numRows, denseMatrix64F.numCols, false, false, true);
        if (!singularValueDecomposition.decompose(denseMatrix64F)) {
            throw new RuntimeException("Decomposition failed");
        }
        double[] dArray = singularValueDecomposition.getSingularValues();
        return UtilEjml.max(dArray, 0, dArray.length);
    }

    public static double inducedPInf(DenseMatrix64F denseMatrix64F) {
        double d = 0.0;
        int n = denseMatrix64F.numRows;
        int n2 = denseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n2; ++j) {
                d2 += Math.abs(denseMatrix64F.get(i, j));
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }
}

