/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class SaveRecalcRecord
extends Record {
    public static final short sid = 95;
    private short field_1_recalc;

    public SaveRecalcRecord() {
    }

    public SaveRecalcRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 95) {
            throw new RecordFormatException("NOT A Save Recalc RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_recalc = in.readShort();
    }

    public void setRecalc(boolean recalc) {
        this.field_1_recalc = (short)(recalc ? 1 : 0);
    }

    public boolean getRecalc() {
        return this.field_1_recalc == 1;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SAVERECALC]\n");
        buffer.append("    .recalc         = ").append(this.getRecalc()).append("\n");
        buffer.append("[/SAVERECALC]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)95);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_recalc);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 6;
    }

    @Override
    public short getSid() {
        return 95;
    }

    @Override
    public Object clone() {
        SaveRecalcRecord rec = new SaveRecalcRecord();
        rec.field_1_recalc = this.field_1_recalc;
        return rec;
    }
}

