/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list.tobject;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.AbstractList;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DRand;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;

public class ObjectArrayList
extends AbstractList {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;
    protected int size;

    public ObjectArrayList() {
        this(10);
    }

    public ObjectArrayList(Object[] elements) {
        this.elements(elements);
    }

    public ObjectArrayList(int initialCapacity) {
        this(new Object[initialCapacity]);
        this.size = 0;
    }

    public void add(Object element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    public void addAllOfFromTo(ObjectArrayList other, int from, int to) {
        this.beforeInsertAllOfFromTo(this.size, other, from, to);
    }

    public void beforeInsert(int index, Object element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    public void beforeInsertAllOfFromTo(int index, ObjectArrayList other, int from, int to) {
        int length = to - from + 1;
        this.beforeInsertDummies(index, length);
        this.replaceFromToWithFrom(index, index + length - 1, other, from);
    }

    @Override
    protected void beforeInsertDummies(int index, int length) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (length > 0) {
            this.ensureCapacity(this.size + length);
            System.arraycopy(this.elements, index, this.elements, index + length, this.size - index);
            this.size += length;
        }
    }

    public int binarySearch(Object key) {
        return this.binarySearchFromTo(key, 0, this.size - 1);
    }

    public int binarySearchFromTo(Object key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int mid = (low + high) / 2;
            Object midVal = this.elements[mid];
            int cmp = ((Comparable)midVal).compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int binarySearchFromTo(Object key, int from, int to, Comparator comparator) {
        return Sorting.binarySearchFromTo(this.elements, key, from, to, comparator);
    }

    @Override
    public Object clone() {
        ObjectArrayList v = (ObjectArrayList)super.clone();
        v.elements = (Object[])this.elements.clone();
        return v;
    }

    public boolean contains(Object elem, boolean testForEquality) {
        return this.indexOfFromTo(elem, 0, this.size - 1, testForEquality) >= 0;
    }

    public ObjectArrayList copy() {
        return (ObjectArrayList)this.clone();
    }

    public void delete(Object element, boolean testForEquality) {
        int index = this.indexOfFromTo(element, 0, this.size - 1, testForEquality);
        if (index >= 0) {
            this.removeFromTo(index, index);
        }
    }

    public Object[] elements() {
        return this.elements;
    }

    public ObjectArrayList elements(Object[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    public boolean equals(Object otherObj) {
        return this.equals(otherObj, true);
    }

    public boolean equals(Object otherObj, boolean testForEquality) {
        if (!(otherObj instanceof ObjectArrayList)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        ObjectArrayList other = (ObjectArrayList)otherObj;
        if (this.elements == other.elements()) {
            return true;
        }
        if (this.size != other.size()) {
            return false;
        }
        Object[] otherElements = other.elements();
        Object[] theElements = this.elements;
        if (!testForEquality) {
            int i = this.size;
            while (--i >= 0) {
                if (theElements[i] == otherElements[i]) continue;
                return false;
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (!(theElements[i] == null ? otherElements[i] != null : !theElements[i].equals(otherElements[i]))) continue;
                return false;
            }
        }
        return true;
    }

    public void fillFromToWith(int from, int to, Object val) {
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        int i = from;
        while (i <= to) {
            this.setQuick(i++, val);
        }
    }

    public boolean forEach(ObjectProcedure procedure) {
        Object[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    public Object getQuick(int index) {
        return this.elements[index];
    }

    public int indexOf(Object element, boolean testForEquality) {
        return this.indexOfFromTo(element, 0, this.size - 1, testForEquality);
    }

    public int indexOfFromTo(Object element, int from, int to, boolean testForEquality) {
        if (this.size == 0) {
            return -1;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        Object[] theElements = this.elements;
        if (testForEquality && element != null) {
            int i = from;
            while (i <= to) {
                if (element.equals(theElements[i])) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = from;
            while (i <= to) {
                if (element == theElements[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean isSortedFromTo(int from, int to) {
        if (this.size == 0) {
            return true;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        Object[] theElements = this.elements;
        int i = from + 1;
        while (i <= to) {
            if (((Comparable)theElements[i]).compareTo(theElements[i - 1]) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int lastIndexOf(Object element, boolean testForEquality) {
        return this.lastIndexOfFromTo(element, 0, this.size - 1, testForEquality);
    }

    public int lastIndexOfFromTo(Object element, int from, int to, boolean testForEquality) {
        if (this.size == 0) {
            return -1;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        Object[] theElements = this.elements;
        if (testForEquality && element != null) {
            int i = to;
            while (i >= from) {
                if (element.equals(theElements[i])) {
                    return i;
                }
                --i;
            }
        } else {
            int i = to;
            while (i >= from) {
                if (element == theElements[i]) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    @Override
    public void mergeSortFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        java.util.Arrays.sort(this.elements, from, to + 1);
    }

    public void mergeSortFromTo(int from, int to, Comparator c) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        java.util.Arrays.sort(this.elements, from, to + 1, c);
    }

    public ObjectArrayList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new ObjectArrayList(0);
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        Object[] part = new Object[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new ObjectArrayList(part);
    }

    @Override
    public void quickSortFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        Sorting.quickSort(this.elements, from, to + 1);
    }

    public void quickSortFromTo(int from, int to, Comparator c) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        Sorting.quickSort(this.elements, from, to + 1, c);
    }

    public boolean removeAll(ObjectArrayList other, boolean testForEquality) {
        if (other.size == 0) {
            return false;
        }
        int limit = other.size - 1;
        int j = 0;
        Object[] theElements = this.elements;
        int i = 0;
        while (i < this.size) {
            if (other.indexOfFromTo(theElements[i], 0, limit, testForEquality) < 0) {
                theElements[j++] = theElements[i];
            }
            ++i;
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void removeFromTo(int from, int to) {
        int width;
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        int numMoved = this.size - to - 1;
        if (numMoved >= 0) {
            System.arraycopy(this.elements, to + 1, this.elements, from, numMoved);
            this.fillFromToWith(from + numMoved, this.size - 1, null);
        }
        if ((width = to - from + 1) > 0) {
            this.size -= width;
        }
    }

    public void replaceFromToWithFrom(int from, int to, ObjectArrayList other, int otherFrom) {
        int length = to - from + 1;
        if (length > 0) {
            ObjectArrayList.checkRangeFromTo(from, to, this.size);
            ObjectArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size);
            System.arraycopy(other.elements, otherFrom, this.elements, from, length);
        }
    }

    public void replaceFromToWithFromTo(int from, int to, ObjectArrayList other, int otherFrom, int otherTo) {
        int length;
        if (otherFrom > otherTo) {
            throw new IndexOutOfBoundsException("otherFrom: " + otherFrom + ", otherTo: " + otherTo);
        }
        if (this == other && to - from != otherTo - otherFrom) {
            this.replaceFromToWithFromTo(from, to, this.partFromTo(otherFrom, otherTo), 0, otherTo - otherFrom);
            return;
        }
        int diff = length = otherTo - otherFrom + 1;
        int theLast = from - 1;
        if (to >= from) {
            diff -= to - from + 1;
            theLast = to;
        }
        if (diff > 0) {
            this.beforeInsertDummies(theLast + 1, diff);
        } else if (diff < 0) {
            this.removeFromTo(theLast + diff, theLast - 1);
        }
        if (length > 0) {
            System.arraycopy(other.elements, otherFrom, this.elements, from, length);
        }
    }

    @Override
    public void replaceFromWith(int from, Collection other) {
        ObjectArrayList.checkRange(from, this.size);
        Iterator e = other.iterator();
        int index = from;
        int limit = Math.min(this.size - from, other.size());
        int i = 0;
        while (i < limit) {
            this.elements[index++] = e.next();
            ++i;
        }
    }

    public boolean retainAll(ObjectArrayList other, boolean testForEquality) {
        if (other.size == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int limit = other.size - 1;
        int j = 0;
        Object[] theElements = this.elements;
        int i = 0;
        while (i < this.size) {
            if (other.indexOfFromTo(theElements[i], 0, limit, testForEquality) >= 0) {
                theElements[j++] = theElements[i];
            }
            ++i;
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        Object[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            Object tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    public void set(int index, Object element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    public void setQuick(int index, Object element) {
        this.elements[index] = element;
    }

    public void setSizeRaw(int newSize) {
        this.size = newSize;
    }

    @Override
    public void shuffleFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        DoubleUniform gen = new DoubleUniform(new DRand(new Date()));
        Object[] theElements = this.elements;
        int i = from;
        while (i < to) {
            int random = gen.nextIntFromTo(i, to);
            Object tmpElement = theElements[random];
            theElements[random] = theElements[i];
            theElements[i] = tmpElement;
            ++i;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public ObjectArrayList times(int times) {
        ObjectArrayList newList = new ObjectArrayList(times * this.size);
        int i = times;
        while (--i >= 0) {
            newList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return newList;
    }

    public Object[] toArray(Object[] array) {
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        }
        Object[] theElements = this.elements;
        int i = this.size;
        while (--i >= 0) {
            array[i] = theElements[i];
        }
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    @Override
    public ArrayList toList() {
        int mySize = this.size();
        Object[] theElements = this.elements;
        ArrayList<Object> list = new ArrayList<Object>(mySize);
        int i = 0;
        while (i < mySize) {
            list.add(theElements[i]);
            ++i;
        }
        return list;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

