/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;

public class DefaultFloatIterationMonitor
extends AbstractFloatIterationMonitor {
    float initR;
    float rtol;
    float atol;
    float dtol;
    int maxIter;

    public DefaultFloatIterationMonitor(int maxIter, float rtol, float atol, float dtol) {
        this.maxIter = maxIter;
        this.rtol = rtol;
        this.atol = atol;
        this.dtol = dtol;
    }

    public DefaultFloatIterationMonitor() {
        this.maxIter = 100000;
        this.rtol = 0.001f;
        this.atol = 1.0E-25f;
        this.dtol = 1000.0f;
    }

    @Override
    public void setMaxIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    @Override
    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setRelativeTolerance(float rtol) {
        this.rtol = rtol;
    }

    public float getRelativeTolerance() {
        return this.rtol;
    }

    public void setAbsoluteTolerance(float atol) {
        this.atol = atol;
    }

    public float getAbsoluteTolerance() {
        return this.atol;
    }

    public void setDivergenceTolerance(float dtol) {
        this.dtol = dtol;
    }

    public float getDivergenceTolerance() {
        return this.dtol;
    }

    @Override
    protected boolean convergedI(float r) throws IterativeSolverFloatNotConvergedException {
        if (this.isFirst()) {
            this.initR = r;
        }
        if (r < Math.max(this.rtol * this.initR, this.atol)) {
            return true;
        }
        if (r > this.dtol * this.initR) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Iterations, this);
        }
        if (Float.isNaN(r)) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    @Override
    protected boolean convergedI(float r, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        return this.convergedI(r);
    }
}

