/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat.sampling;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.colt.list.tboolean.BooleanArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.FloatRandomSampler;

public class FloatRandomSamplingAssistant
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected FloatRandomSampler sampler;
    protected long[] buffer;
    protected int bufferPosition;
    protected long skip;
    protected long n;
    static final int MAX_BUFFER_SIZE = 200;

    public FloatRandomSamplingAssistant(long n, long N, FloatRandomEngine randomGenerator) {
        this.n = n;
        this.sampler = new FloatRandomSampler(n, N, 0L, randomGenerator);
        this.buffer = new long[(int)Math.min(n, 200L)];
        if (n > 0L) {
            this.buffer[0] = -1L;
        }
        this.fetchNextBlock();
    }

    @Override
    public Object clone() {
        FloatRandomSamplingAssistant copy = (FloatRandomSamplingAssistant)super.clone();
        copy.sampler = (FloatRandomSampler)this.sampler.clone();
        return copy;
    }

    protected void fetchNextBlock() {
        if (this.n > 0L) {
            long last = this.buffer[this.bufferPosition];
            this.sampler.nextBlock((int)Math.min(this.n, 200L), this.buffer, 0);
            this.skip = this.buffer[0] - last - 1L;
            this.bufferPosition = 0;
        }
    }

    public FloatRandomEngine getRandomGenerator() {
        return this.sampler.my_RandomGenerator;
    }

    public static void main(String[] args) {
        long n = Long.parseLong(args[0]);
        long N = Long.parseLong(args[1]);
        FloatRandomSamplingAssistant.testArraySampling((int)n, (int)N);
    }

    public static int[] sampleArray(int n, int[] elements) {
        FloatRandomSamplingAssistant assistant = new FloatRandomSamplingAssistant(n, elements.length, null);
        int[] sample = new int[n];
        int j = 0;
        int length = elements.length;
        int i = 0;
        while (i < length) {
            if (assistant.sampleNextElement()) {
                sample[j++] = elements[i];
            }
            ++i;
        }
        return sample;
    }

    public boolean sampleNextElement() {
        if (this.n == 0L) {
            return false;
        }
        if (this.skip-- > 0L) {
            return false;
        }
        --this.n;
        if (this.bufferPosition < this.buffer.length - 1) {
            this.skip = this.buffer[this.bufferPosition + 1] - this.buffer[this.bufferPosition++];
            --this.skip;
        } else {
            this.fetchNextBlock();
        }
        return true;
    }

    public static void test(long n, long N) {
        FloatRandomSamplingAssistant assistant = new FloatRandomSamplingAssistant(n, N, null);
        LongArrayList sample = new LongArrayList((int)n);
        Timer timer = new Timer().start();
        long i = 0L;
        while (i < N) {
            if (assistant.sampleNextElement()) {
                sample.add(i);
            }
            ++i;
        }
        timer.stop().display();
        System.out.println("sample=" + sample);
        System.out.println("Good bye.\n");
    }

    public static void testArraySampling(int n, int N) {
        int[] elements = new int[N];
        int i = 0;
        while (i < N) {
            elements[i] = i;
            ++i;
        }
        Timer timer = new Timer().start();
        int[] sample = FloatRandomSamplingAssistant.sampleArray(n, elements);
        timer.stop().display();
        System.out.println("Good bye.\n");
    }

    private void xsampleNextElements(BooleanArrayList acceptList) {
        int length = acceptList.size();
        boolean[] accept = acceptList.elements();
        int i = 0;
        while (i < length) {
            if (this.n == 0L) {
                accept[i] = false;
            } else if (this.skip-- > 0L) {
                accept[i] = false;
            } else {
                --this.n;
                if (this.bufferPosition < this.buffer.length - 1) {
                    this.skip = this.buffer[this.bufferPosition + 1] - this.buffer[this.bufferPosition++];
                    --this.skip;
                } else {
                    this.fetchNextBlock();
                }
                accept[i] = true;
            }
            ++i;
        }
    }
}

