/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.benchmark;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import org.netlib.lapack.Dposv;
import org.netlib.util.intW;

public class DposvBenchmark {
    private static void dposvBenchmarkJPlasma(int n, int n2, int n3, int n4) {
        ConcurrencyUtils.setNumberOfThreads((int)n4);
        int n5 = n;
        int n6 = n;
        double[] dArray = new double[n * n];
        double[] dArray2 = new double[n * n2];
        double d = 0.0;
        Dplasma.plasma_Init(n, n, 1);
        for (int i = 0; i < n3 + 2; ++i) {
            int n7;
            int n8;
            for (n8 = 0; n8 < n; ++n8) {
                for (n7 = 0; n7 < n; ++n7) {
                    dArray[n5 * n7 + n8] = 0.5 - Math.random();
                }
            }
            for (n8 = 0; n8 < n; ++n8) {
                dArray[n5 * n8 + n8] = dArray[n5 * n8 + n8] + (double)n;
            }
            for (n8 = 0; n8 < n; ++n8) {
                for (n7 = 0; n7 < n; ++n7) {
                    dArray[n5 * n7 + n8] = dArray[n5 * n8 + n7];
                }
            }
            for (n8 = 0; n8 < n; ++n8) {
                for (n7 = 0; n7 < n2; ++n7) {
                    dArray2[n * n7 + n8] = Math.random();
                }
            }
            double d2 = System.nanoTime();
            int n9 = Dplasma.plasma_DPOSV(121, n, n2, dArray, 0, n5, dArray2, 0, n6);
            d2 = (double)System.nanoTime() - d2;
            if (i >= 2) {
                d += d2;
            }
            if (n9 == 0) continue;
            System.err.println("failure with error " + n9);
        }
        System.out.println("Average execution time of JPlasma DPOSV (" + n + "x" + n + ", " + n2 + " right-hand sides, " + n4 + " threads): " + d / (double)n3 / 1000000.0 + " milliseconds");
        Dplasma.plasma_Finalize();
    }

    private static void dposvBenchmarkJLAPACK(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n;
        double[] dArray = new double[n * n];
        double[] dArray2 = new double[n * n2];
        double d = 0.0;
        for (int i = 0; i < n3 + 2; ++i) {
            int n6;
            int n7;
            for (n7 = 0; n7 < n; ++n7) {
                for (n6 = 0; n6 < n; ++n6) {
                    dArray[n4 * n6 + n7] = 0.5 - Math.random();
                }
            }
            for (n7 = 0; n7 < n; ++n7) {
                dArray[n4 * n7 + n7] = dArray[n4 * n7 + n7] + (double)n;
            }
            for (n7 = 0; n7 < n; ++n7) {
                for (n6 = 0; n6 < n; ++n6) {
                    dArray[n4 * n6 + n7] = dArray[n4 * n7 + n6];
                }
            }
            for (n7 = 0; n7 < n; ++n7) {
                for (n6 = 0; n6 < n2; ++n6) {
                    dArray2[n * n6 + n7] = Math.random();
                }
            }
            intW intW2 = new intW(0);
            double d2 = System.nanoTime();
            Dposv.dposv((String)"U", (int)n, (int)n2, (double[])dArray, (int)0, (int)n4, (double[])dArray2, (int)0, (int)n5, (intW)intW2);
            d2 = (double)System.nanoTime() - d2;
            if (i >= 2) {
                d += d2;
            }
            if (intW2.val == 0) continue;
            System.err.println("failure with error " + intW2);
        }
        System.out.println("Average execution time of JLAPACK DPOSV (" + n + "x" + n + ", " + n2 + " right-hand sides): " + d / (double)n3 / 1000000.0 + " milliseconds");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            System.out.println("Usage: java edu.emory.mathcs.jplasma.benchmark.DposvBenchmark N NRHS NITERS NTHREADS");
            System.exit(1);
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        DposvBenchmark.dposvBenchmarkJPlasma(n, n2, n3, n4);
        System.exit(0);
    }
}

