/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.macro.Functions;
import ij.macro.Interpreter;
import ij.macro.MacroExtension;
import ij.macro.Variable;

public class ExtensionDescriptor {
    public String name;
    public int[] argTypes;
    public MacroExtension handler;

    public ExtensionDescriptor(String theName, int[] theArgTypes, MacroExtension theHandler) {
        this.name = theName;
        this.argTypes = theArgTypes;
        this.handler = theHandler;
    }

    public static ExtensionDescriptor newDescriptor(String theName, MacroExtension theHandler, int[] types) {
        int[] argTypes = new int[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = types[i];
        }
        return new ExtensionDescriptor(theName, argTypes, theHandler);
    }

    public static ExtensionDescriptor newDescriptor(String theName, MacroExtension theHandler) {
        return ExtensionDescriptor.newDescriptor(theName, theHandler, new int[0]);
    }

    public static ExtensionDescriptor newDescriptor(String theName, MacroExtension theHandler, int type) {
        return ExtensionDescriptor.newDescriptor(theName, theHandler, new int[]{type});
    }

    public static ExtensionDescriptor newDescriptor(String theName, MacroExtension theHandler, int t1, int t2) {
        return ExtensionDescriptor.newDescriptor(theName, theHandler, new int[]{t1, t2});
    }

    public static ExtensionDescriptor newDescriptor(String theName, MacroExtension theHandler, int t1, int t2, int t3) {
        return ExtensionDescriptor.newDescriptor(theName, theHandler, new int[]{t1, t2, t3});
    }

    public static ExtensionDescriptor newDescriptor(String theName, MacroExtension theHandler, int t1, int t2, int t3, int t4) {
        return ExtensionDescriptor.newDescriptor(theName, theHandler, new int[]{t1, t2, t3, t4});
    }

    public static ExtensionDescriptor newDescriptor(String theName, MacroExtension theHandler, Integer[] types) {
        int[] argTypes = new int[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = types[i];
        }
        return new ExtensionDescriptor(theName, argTypes, theHandler);
    }

    public static boolean isOptionalArg(int argType) {
        return (argType & 0x20) == 32;
    }

    public static boolean isOutputArg(int argType) {
        return (argType & 0x10) == 16;
    }

    public static int getRawType(int argType) {
        return argType & 0xFFFFFFCF;
    }

    public boolean checkArguments(Object[] args) {
        block5: for (int i = 0; i < this.argTypes.length; ++i) {
            boolean optional = ExtensionDescriptor.isOptionalArg(this.argTypes[i]);
            boolean output = ExtensionDescriptor.isOutputArg(this.argTypes[i]);
            int rawType = ExtensionDescriptor.getRawType(this.argTypes[i]);
            if (args.length < i) {
                return optional;
            }
            switch (rawType) {
                case 1: {
                    if (output ? !(args[i] instanceof String[]) : !(args[i] instanceof String)) {
                        return false;
                    }
                }
                case 2: {
                    if (output ? !(args[i] instanceof Double[]) : !(args[i] instanceof Double)) {
                        return false;
                    }
                }
                case 4: {
                    if (args[i] instanceof Object[]) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    public static String getTypeName(int argType) {
        switch (ExtensionDescriptor.getRawType(argType)) {
            case 1: {
                return "string";
            }
            case 2: {
                return "number";
            }
            case 4: {
                return "array";
            }
        }
        return "unknown";
    }

    private static String getVariableTypename(int type) {
        switch (type) {
            case 2: {
                return "string";
            }
            case 130: {
                return "number";
            }
            case 1: {
                return "array";
            }
        }
        return "unknown";
    }

    private static Object[] convertArray(Variable[] array) {
        Object[] oArray = new Object[array.length];
        block5: for (int i = 0; i < array.length; ++i) {
            switch (array[i].getType()) {
                case 2: {
                    oArray[i] = array[i].getString();
                    continue block5;
                }
                case 0: {
                    oArray[i] = new Double(array[i].getValue());
                    continue block5;
                }
                case 1: {
                    oArray[i] = ExtensionDescriptor.convertArray(array[i].getArray());
                    continue block5;
                }
                default: {
                    oArray[i] = null;
                }
            }
        }
        return oArray;
    }

    Variable[] parseArgumentList(Functions func) {
        Interpreter interp = func.interp;
        Variable[] vArray = new Variable[this.argTypes.length];
        int i = 0;
        do {
            Variable v;
            if (i >= this.argTypes.length) {
                interp.error("too many arguments (expected " + this.argTypes.length + ")");
                return null;
            }
            boolean output = ExtensionDescriptor.isOutputArg(this.argTypes[i]);
            if (output) {
                v = func.getVariable();
            } else {
                v = new Variable();
                switch (ExtensionDescriptor.getRawType(this.argTypes[i])) {
                    case 1: {
                        v.setString(func.getString());
                        break;
                    }
                    case 2: {
                        v.setValue(interp.getExpression());
                        break;
                    }
                    case 4: {
                        v.setArray(func.getArray());
                    }
                }
            }
            vArray[i] = v;
            ++i;
            interp.getToken();
        } while (interp.token == 44);
        if (interp.token != 41) {
            interp.error("')' expected");
        }
        if (i < this.argTypes.length && !ExtensionDescriptor.isOptionalArg(this.argTypes[i])) {
            interp.error("too few arguments, expected " + this.argTypes.length + " but found " + i);
        }
        return vArray;
    }

    public static Object convertVariable(Interpreter interp, int rawType, Variable var) {
        int type = ExtensionDescriptor.getRawType(rawType);
        boolean output = ExtensionDescriptor.isOutputArg(rawType);
        if (var == null) {
            return null;
        }
        switch (type) {
            case 1: {
                if (!output && var.getType() != 2) {
                    interp.error("Expected string, but variable type is " + ExtensionDescriptor.getVariableTypename(var.getType()));
                    return null;
                }
                if (output) {
                    String s = var.getString();
                    if (s == null) {
                        s = "";
                    }
                    return new String[]{s};
                }
                return var.getString();
            }
            case 2: {
                if (var.getType() != 0) {
                    interp.error("Expected number, but variable type is " + ExtensionDescriptor.getVariableTypename(var.getType()));
                    return null;
                }
                if (output) {
                    return new Double[]{new Double(var.getValue())};
                }
                return new Double(var.getValue());
            }
            case 4: {
                if (var.getType() != 1) {
                    interp.error("Expected array, but variable type is " + ExtensionDescriptor.getVariableTypename(var.getType()));
                    return null;
                }
                return ExtensionDescriptor.convertArray(var.getArray());
            }
        }
        interp.error("Unknown descriptor type " + type + " (" + rawType + ")");
        return null;
    }

    public static void convertOutputType(Variable variable, Object object) {
        if (object instanceof String[]) {
            String[] str = (String[])object;
            variable.setString(str[0]);
        } else if (object instanceof Double[]) {
            Double[] dbl = (Double[])object;
            variable.setValue(dbl[0]);
        } else if (object instanceof Object[]) {
            Object[] arr = (Object[])object;
            Variable[] vArr = new Variable[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                vArr[i] = new Variable();
                ExtensionDescriptor.convertOutputType(vArr[i], arr[i]);
            }
            variable.setArray(vArr);
        }
    }

    public String dispatch(Functions func) {
        Interpreter interp = func.interp;
        if (this.argTypes.length == 0) {
            interp.getParens();
            return this.handler.handleExtension(this.name, null);
        }
        interp.getLeftParen();
        Variable[] vArgs = null;
        int next = interp.nextToken();
        if (next != 41) {
            vArgs = this.parseArgumentList(func);
        }
        Object[] args = new Object[this.argTypes.length];
        if (vArgs == null && this.argTypes.length > 0) {
            interp.error("Argument expected");
            return null;
        }
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (i >= vArgs.length) {
                if (ExtensionDescriptor.isOptionalArg(this.argTypes[i])) break;
                interp.error("Expected argument " + (i + 1) + " of type " + ExtensionDescriptor.getTypeName(this.argTypes[i]));
                return null;
            }
            args[i] = ExtensionDescriptor.convertVariable(interp, this.argTypes[i], vArgs[i]);
        }
        String retVal = this.handler.handleExtension(this.name, args);
        for (int i = 0; i < this.argTypes.length && i < vArgs.length; ++i) {
            if (!ExtensionDescriptor.isOutputArg(this.argTypes[i])) continue;
            ExtensionDescriptor.convertOutputType(vArgs[i], args[i]);
        }
        return retVal;
    }
}

