/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;

public class Translator
implements ExtendedPlugInFilter,
DialogListener {
    private int flags = 32799;
    private static double xOffset = 15.0;
    private static double yOffset = 15.0;
    private ImagePlus imp;
    private GenericDialog gd;
    private PlugInFilterRunner pfr;
    private static int interpolationMethod = 0;
    private String[] methods = ImageProcessor.getInterpolationMethods();

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return this.flags;
    }

    @Override
    public void run(ImageProcessor ip) {
        ip.setInterpolationMethod(interpolationMethod);
        ip.translate(xOffset, yOffset);
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        int digits;
        this.pfr = pfr;
        int n = digits = xOffset == (double)((int)xOffset) && yOffset == (double)((int)yOffset) ? 1 : 3;
        if (IJ.isMacro()) {
            interpolationMethod = 0;
        }
        this.gd = new GenericDialog("Translate");
        this.gd.addNumericField("X offset (pixels): ", xOffset, digits, 8, "");
        this.gd.addNumericField("Y offset (pixels): ", yOffset, digits, 8, "");
        this.gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        this.gd.addPreviewCheckbox(pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return 4096;
        }
        return IJ.setupDialog(imp, this.flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        xOffset = gd.getNextNumber();
        yOffset = gd.getNextNumber();
        interpolationMethod = gd.getNextChoiceIndex();
        if (gd.invalidNumber()) {
            if (gd.wasOKed()) {
                IJ.error("Offset is invalid.");
            }
            return false;
        }
        return true;
    }

    @Override
    public void setNPasses(int nPasses) {
    }
}

