/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.tool;

import ij.IJ;
import ij.ImageJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.tool.PixelInspectionTool;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class PixelInspector
extends PlugInFrame
implements ImageListener,
KeyListener,
MouseListener,
Runnable {
    static final String PREFS_KEY = "pixelinspector.";
    static int radius = (int)Prefs.get("pixelinspector.radius", 3.0);
    private static final String LOC_KEY = "inspector.loc";
    static final int MAX_RADIUS = 10;
    int grayDisplayType = 0;
    static final String[] GRAY_DISPLAY_TYPES = new String[]{"Raw", "Calibrated", "Hex"};
    static final int GRAY_RAW = 0;
    static final int GRAY_CAL = 1;
    static final int GRAY_HEX = 2;
    int rgbDisplayType = 0;
    static final String[] RGB_DISPLAY_TYPES = new String[]{"R,G,B", "Gray Value", "Hex"};
    static final int RGB_RGB = 0;
    static final int RGB_GRAY = 1;
    static final int RGB_HEX = 2;
    int copyType = 0;
    static final String[] COPY_TYPES = new String[]{"Data Only", "x y and Data", "Header and Data"};
    static final int COPY_DATA = 0;
    static final int COPY_XY = 1;
    static final int COPY_HEADER = 2;
    int colorNumber = 0;
    static final String[] COLOR_STRINGS = new String[]{"red", "orange", "yellow", "green", "cyan", "blue", "magenta"};
    static final Color[] COLORS = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.CYAN, Color.BLUE, Color.MAGENTA};
    int fixKey = 33;
    static final int KEYCODE_OFFSET = 65536;
    private int x0;
    private int y0;
    int nextUpdate;
    static final int POSITION_UPDATE = 1;
    static final int FULL_UPDATE = 2;
    static final String TITLE = "Pixel Inspector";
    static PixelInspector instance;
    PixelInspectionTool tool;
    ImageJ ij;
    ImagePlus imp;
    int id;
    int bitDepth;
    int digits;
    boolean expMode;
    ImageCanvas canvas;
    Thread bgThread;
    Label[] labels;
    Label prefsLabel = new Label("Prefs");

    public PixelInspector(ImagePlus imp, PixelInspectionTool tool) {
        super("Pixel Values");
        instance = this;
        this.imp = imp;
        this.tool = tool;
        this.ij = IJ.getInstance();
        if (this.ij == null) {
            return;
        }
        if (imp == null) {
            IJ.noImage();
            return;
        }
        this.id = imp.getID();
        this.bitDepth = imp.getBitDepth();
        WindowManager.addWindow(this);
        this.prefsLabel.addMouseListener(this);
        this.addKeyListener(this);
        this.init();
        Point loc = Prefs.getLocation("pixelinspector.loc");
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.center(this);
        }
        this.setResizable(false);
        this.show();
        this.toFront();
        this.addImageListeners();
        this.bgThread = new Thread((Runnable)this, TITLE);
        this.bgThread.start();
        this.bgThread.setPriority(Math.max(this.bgThread.getPriority() - 3, 1));
        this.update(2);
    }

    private void init() {
        this.removeAll();
        int size = 2 * radius + 2;
        this.labels = new Label[size * size];
        for (int i = 1; i < this.labels.length; ++i) {
            this.labels[i] = new Label();
        }
        this.initializeLabels();
        this.setLayout(new GridLayout(size, size, 0, 0));
        int p = 0;
        for (int row = 0; row < size; ++row) {
            int col = 0;
            while (col < size) {
                if (row == 0 && col == 0) {
                    this.add(this.prefsLabel);
                } else {
                    this.add(this.labels[p]);
                }
                ++col;
                ++p;
            }
        }
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Prefs.saveLocation("pixelinspector.loc", this.getLocation());
        this.removeImageListeners();
        PixelInspector pixelInspector = this;
        synchronized (pixelInspector) {
            this.bgThread.interrupt();
        }
        instance = null;
        this.tool.pi = null;
        this.removeOutline();
    }

    private void removeOutline() {
        Overlay overlay = this.imp.getOverlay();
        if (overlay == null) {
            return;
        }
        int index = PixelInspector.getIndex(overlay, TITLE);
        if (index >= 0) {
            overlay.remove(index);
            this.imp.setOverlay(overlay);
        }
    }

    private void addImageListeners() {
        ImagePlus.addImageListener(this);
        ImageWindow win = this.imp.getWindow();
        if (win == null) {
            this.close();
        }
        this.canvas = win.getCanvas();
        this.canvas.addKeyListener(this);
    }

    private void removeImageListeners() {
        ImagePlus.removeImageListener(this);
        this.canvas.removeKeyListener(this);
    }

    @Override
    public void imageUpdated(ImagePlus imp) {
        this.update(2);
    }

    @Override
    public void imageOpened(ImagePlus imp) {
    }

    @Override
    public void imageClosed(ImagePlus imp) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean thisPanel = e.getSource() instanceof PixelInspector;
        if (thisPanel && e.getKeyCode() == 67) {
            this.copyToClipboard();
            return;
        }
        if (e.getKeyCode() == 38 && this.y0 > 0) {
            --this.y0;
            this.update(2);
        } else if (e.getKeyCode() == 40 && this.y0 < this.imp.getHeight() - 1) {
            ++this.y0;
            this.update(2);
        } else if (e.getKeyCode() == 37 && this.x0 > 0) {
            --this.x0;
            this.update(2);
        } else if (e.getKeyCode() == 39 && this.x0 < this.imp.getWidth() - 1) {
            ++this.x0;
            this.update(2);
        } else if (e.getSource() instanceof Button) {
            this.ij.keyPressed(e);
        }
        Overlay overlay = this.imp.getOverlay();
        if (overlay == null) {
            return;
        }
        int index = PixelInspector.getIndex(overlay, TITLE);
        if (index >= 0) {
            overlay.remove(index);
            Roi roi = new Roi(this.x0 - radius, this.y0 - radius, radius * 2 + 1, radius * 2 + 1);
            roi.setName(TITLE);
            roi.setStrokeColor(Color.red);
            overlay.add(roi);
            this.imp.setOverlay(overlay);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showDialog();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    static int getIndex(Overlay overlay, String name) {
        if (name == null) {
            return -1;
        }
        Roi[] rois = overlay.toArray();
        for (int i = rois.length - 1; i >= 0; --i) {
            if (!name.equals(rois[i].getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    void update(ImagePlus imp, int whichUpdate, int x, int y) {
        if (imp != this.imp) {
            this.removeImageListeners();
            this.removeOutline();
            this.imp = imp;
            this.addImageListeners();
        }
        this.x0 = x;
        this.y0 = y;
        this.update(whichUpdate);
    }

    synchronized void update(int whichUpdate) {
        if (this.nextUpdate < whichUpdate) {
            this.nextUpdate = whichUpdate;
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean doFullUpdate = false;
        while (true) {
            if (doFullUpdate) {
                this.setCalibration();
            }
            this.writeNumbers();
            IJ.wait(50);
            PixelInspector pixelInspector = this;
            synchronized (pixelInspector) {
                if (this.nextUpdate == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                } else {
                    doFullUpdate = this.nextUpdate == 2;
                    this.nextUpdate = 0;
                }
            }
        }
    }

    void writeNumbers() {
        if (this.imp.getID() != this.id || this.imp.getBitDepth() != this.bitDepth) {
            this.removeImageListeners();
            this.addImageListeners();
            this.initializeLabels();
            this.pack();
            this.id = this.imp.getID();
            this.bitDepth = this.imp.getBitDepth();
            this.nextUpdate = 2;
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        if (ip == null) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        int x0 = this.x0;
        int y0 = this.y0;
        int p = 1;
        int x = x0 - radius;
        while (x <= x0 + radius) {
            this.labels[p].setText(x >= 0 && x < width ? Integer.toString(x) : " ");
            ++x;
            ++p;
        }
        for (int y = y0 - radius; y <= y0 + radius; ++y) {
            boolean yInside = y >= 0 && y < height;
            int yDisplay = (Analyzer.getMeasurements() & 0x1000) != 0 ? height - y - 1 : y;
            this.labels[p].setText(yInside ? Integer.toString(yDisplay) : " ");
            ++p;
            int x2 = x0 - radius;
            while (x2 <= x0 + radius) {
                if (x2 >= 0 && x2 < width && yInside) {
                    if (ip instanceof ColorProcessor && this.rgbDisplayType == 0) {
                        int c = ip.getPixel(x2, y);
                        int r = (c & 0xFF0000) >> 16;
                        int g = (c & 0xFF00) >> 8;
                        int b = c & 0xFF;
                        this.labels[p].setText(r + "," + g + "," + b);
                    } else if (ip instanceof ColorProcessor && this.rgbDisplayType == 2) {
                        this.labels[p].setText(PixelInspector.int2hex(ip.getPixel(x2, y), 6));
                    } else if ((ip instanceof ByteProcessor || ip instanceof ShortProcessor) && this.grayDisplayType == 0) {
                        this.labels[p].setText(Integer.toString(ip.getPixel(x2, y)));
                    } else if ((ip instanceof ByteProcessor || ip instanceof ShortProcessor) && this.grayDisplayType == 2) {
                        this.labels[p].setText(PixelInspector.int2hex(ip.getPixel(x2, y), ip instanceof ByteProcessor ? 2 : 4));
                    } else {
                        this.labels[p].setText(this.stringOf(ip.getPixelValue(x2, y), this.digits, this.expMode));
                    }
                } else {
                    this.labels[p].setText(" ");
                }
                ++x2;
                ++p;
            }
        }
    }

    void initializeLabels() {
        int i;
        Color bgColor = new Color(0xCCCCCC);
        String placeHolder = "000000.00";
        ImageProcessor ip = this.imp.getProcessor();
        if (ip instanceof ByteProcessor && this.grayDisplayType == 0) {
            placeHolder = "000";
        } else if (ip instanceof ByteProcessor || ip instanceof ShortProcessor) {
            if (this.grayDisplayType == 0 || this.grayDisplayType == 2) {
                placeHolder = "00000";
            }
        } else if (ip instanceof ColorProcessor) {
            if (this.rgbDisplayType == 0) {
                placeHolder = "000,000,000";
            }
            if (this.rgbDisplayType == 1) {
                placeHolder = "000.00";
            } else if (this.rgbDisplayType == 2) {
                placeHolder = "CCCCCC";
            }
        }
        if (placeHolder.length() < 5 && (ip.getWidth() > 9999 || ip.getHeight() > 9999)) {
            placeHolder = "00000";
        }
        if (placeHolder.length() < 4 && (ip.getWidth() > 999 || ip.getHeight() > 999)) {
            placeHolder = "0000";
        }
        int p = 0;
        int size = 2 * radius + 1;
        for (int y = 0; y < size + 1; ++y) {
            if (y > 0) {
                this.labels[p].setText(placeHolder);
            }
            ++p;
            int x = 0;
            while (x < size) {
                this.labels[p].setText(placeHolder);
                ++x;
                ++p;
            }
        }
        this.labels[radius + 1].setForeground(Color.RED);
        this.labels[(2 * radius + 2) * (radius + 1)].setForeground(Color.RED);
        this.labels[(2 * radius + 2) * (radius + 1) + radius + 1].setForeground(Color.RED);
        for (i = 0; i < size; ++i) {
            this.labels[i + 1].setBackground(bgColor);
            this.labels[(2 * radius + 2) * (i + 1)].setBackground(bgColor);
        }
        for (i = 1; i < this.labels.length; ++i) {
            this.labels[i].setAlignment(2);
        }
    }

    void setCalibration() {
        Calibration cal = this.imp.getCalibration();
        float[] cTable = cal.getFunction() == 20 ? null : cal.getCTable();
        ImageProcessor ip = this.imp.getProcessor();
        if (ip != null) {
            ip.setCalibrationTable(cTable);
        }
        if (ip instanceof FloatProcessor || cTable != null) {
            float[] data = ip instanceof FloatProcessor ? (float[])ip.getPixels() : cTable;
            double[] minmax = Tools.getMinMax(data);
            double maxDataValue = Math.max(Math.abs(minmax[0]), Math.abs(minmax[1]));
            this.digits = (int)(6.0 - Math.log(maxDataValue) / Math.log(10.0));
            if (maxDataValue == 0.0) {
                this.digits = 6;
            }
            boolean bl = this.expMode = this.digits < -1 || this.digits > 7;
            if (Math.min(minmax[0], minmax[1]) < 0.0) {
                --this.digits;
            }
        } else {
            this.digits = 2;
            this.expMode = false;
        }
    }

    String stringOf(float v, int digits, boolean expMode) {
        if (expMode) {
            int exp = (int)Math.floor(Math.log(Math.abs(v)) / Math.log(10.0));
            double mant = (double)v / Math.pow(10.0, exp);
            int n = digits = exp > 0 && exp < 10 ? 5 : 4;
            if (v < 0.0f) {
                --digits;
            }
            return IJ.d2s(mant, digits) + "e" + exp;
        }
        return IJ.d2s(v, digits);
    }

    void copyToClipboard() {
        int delim = 9;
        int size = 2 * radius + 1;
        int p = 1;
        StringBuffer sb = new StringBuffer();
        if (this.copyType == 1) {
            sb.append(this.labels[radius + 1].getText());
            sb.append('\t');
            sb.append(this.labels[(2 * radius + 2) * (radius + 1)].getText());
            sb.append('\n');
        } else if (this.copyType == 2) {
            int x = 0;
            while (x < size) {
                sb.append('\t');
                sb.append(this.labels[p].getText());
                ++x;
                ++p;
            }
            sb.append('\n');
        }
        p = size + 1;
        for (int y = 0; y < size; ++y) {
            if (this.copyType == 2) {
                sb.append(this.labels[p].getText());
                sb.append('\t');
            }
            ++p;
            int x = 0;
            while (x < size) {
                if (x > 0) {
                    sb.append('\t');
                }
                sb.append(this.labels[p].getText());
                ++x;
                ++p;
            }
            sb.append('\n');
        }
        String s = new String(sb);
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip == null) {
            return;
        }
        StringSelection contents = new StringSelection(s);
        clip.setContents(contents, contents);
        IJ.showStatus(size * size + " pixel values copied to clipboard");
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("Pixel Inspector Prefs...");
        gd.addNumericField("Radius:", radius, 0, 6, "(1-10)");
        gd.addChoice("Grayscale readout:", GRAY_DISPLAY_TYPES, GRAY_DISPLAY_TYPES[this.grayDisplayType]);
        gd.addChoice("RGB readout:", RGB_DISPLAY_TYPES, RGB_DISPLAY_TYPES[this.rgbDisplayType]);
        gd.addChoice("Copy to clipboard:", COPY_TYPES, COPY_TYPES[this.copyType]);
        gd.addMessage("Use arrow keys to move red outline.\nPress 'c' to copy data to clipboard.", null, Color.darkGray);
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            gd.centerDialog(false);
            gd.setLocation(loc);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        radius = (int)gd.getNextNumber();
        if (radius < 1) {
            radius = 1;
        }
        if (radius > 10) {
            radius = 10;
        }
        this.grayDisplayType = gd.getNextChoiceIndex();
        this.rgbDisplayType = gd.getNextChoiceIndex();
        this.copyType = gd.getNextChoiceIndex();
        boolean keyOK = false;
        this.init();
        this.update(1);
        Prefs.set("pixelinspector.radius", radius);
        Prefs.saveLocation(LOC_KEY, gd.getLocation());
    }

    static String int2hex(int i, int digits) {
        boolean addHexSign = digits < 6;
        char[] buf = new char[addHexSign ? digits + 1 : digits];
        for (int pos = buf.length - 1; pos >= buf.length - digits; --pos) {
            buf[pos] = Tools.hexDigits[i & 0xF];
            i >>>= 4;
            if (!addHexSign) continue;
            buf[0] = 120;
        }
        return new String(buf);
    }
}

