package plugins.ylemontag.sequencecomparator.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;

import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Component to select the options associated to the various comparators
 */
public class OptionButton extends JButton
{
	private static final long serialVersionUID = 1L;
	
	/**
	 * Listener to implement to watch at events forwarded by this component
	 */
	public interface OptionButtonListener
	{	
		/**
		 * Click on the PSNR options item
		 */
		public void onPSNRClicked();
		
		/**
		 * Click on the SSIM options item
		 */
		public void onSSIMClicked();
	}
	
	private JPopupMenu _popupMenu;
	private JMenuItem _itemPSNR;
	private JMenuItem _itemSSIM;
	private LinkedList<OptionButtonListener> _listeners;
	
	/**
	 * Constructor
	 */
	public OptionButton()
	{
		super("Options");
		_listeners = new LinkedList<OptionButtonListener>();
		_popupMenu = new JPopupMenu();
		_itemPSNR = new JMenuItem("PSNR");
		_itemSSIM = new JMenuItem("SSIM");
		_popupMenu.add(_itemPSNR);
		_popupMenu.add(_itemSSIM);
		_itemPSNR.addActionListener(new ActionListener()
		{
			@Override
			public void actionPerformed(ActionEvent e) {
				fireClickOnMenuItem(_itemPSNR);
			}
		});
		_itemSSIM.addActionListener(new ActionListener()
		{
			@Override
			public void actionPerformed(ActionEvent e) {
				fireClickOnMenuItem(_itemSSIM);
			}
		});
		addActionListener(new ActionListener()
		{	
			@Override
			public void actionPerformed(ActionEvent e) {
				showPopup();
			}
		});
	}
	
	/**
	 * Add a new listener
	 */
	public void addListener(OptionButtonListener l)
	{
		_listeners.add(l);
	}
	
	/**
	 * Display the popup menu
	 */
	private void showPopup()
	{
		_popupMenu.show(this, 0, getHeight());
	}
	
	/**
	 * Respond to a click on a menu item
	 */
	private void fireClickOnMenuItem(JMenuItem item)
	{
		if(item==_itemPSNR) {
			for(OptionButtonListener l : _listeners) {
				l.onPSNRClicked();
			}
		}
		else if(item==_itemSSIM) {
			for(OptionButtonListener l : _listeners) {
				l.onSSIMClicked();
			}
		}
	}
}
