/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function.string;

import java.util.ArrayList;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionHelper;
import net.sourceforge.jeval.function.FunctionResult;

public class CharAt
implements Function {
    public String getName() {
        return "charAt";
    }

    public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
        String result = null;
        String exceptionMessage = "One string and one integer argument are required.";
        ArrayList values = FunctionHelper.getOneStringAndOneInteger(arguments, ',');
        if (values.size() != 2) {
            throw new FunctionException(exceptionMessage);
        }
        try {
            String argumentOne = FunctionHelper.trimAndRemoveQuoteChars((String)values.get(0), evaluator.getQuoteCharacter());
            int index = (Integer)values.get(1);
            char[] character = new char[]{argumentOne.charAt(index)};
            result = new String(character);
        }
        catch (FunctionException fe) {
            throw new FunctionException(fe.getMessage(), fe);
        }
        catch (Exception e) {
            throw new FunctionException(exceptionMessage, e);
        }
        return new FunctionResult(result, 1);
    }
}

