/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.util.Iterator;
import java.util.List;

public final class HDF5EnumerationType
extends HDF5DataType
implements Iterable<String> {
    private final EnumerationType enumType;

    int getIntStorageTypeId() {
        return this.getStorageForm().getIntStorageTypeId();
    }

    int getIntNativeTypeId() {
        return this.getStorageForm().getIntNativeTypeId();
    }

    HDF5EnumerationType(int fileId, int storageTypeId, int nativeTypeId, String nameOrNull, String[] values, HDF5BaseReader baseReader) {
        super(fileId, storageTypeId, nativeTypeId, baseReader);
        assert (values != null);
        this.enumType = new EnumerationType(nameOrNull, values);
    }

    HDF5EnumerationType(int fileId, int storageTypeId, int nativeTypeId, EnumerationType enumType, HDF5BaseReader baseReader) {
        super(fileId, storageTypeId, nativeTypeId, baseReader);
        assert (enumType != null);
        this.enumType = enumType;
    }

    EnumerationType getEnumType() {
        return this.enumType;
    }

    public Integer tryGetIndexForValue(String value) {
        return this.enumType.tryGetIndexForValue(value);
    }

    @Override
    public String tryGetName() {
        return this.enumType.tryGetName();
    }

    public List<String> getValues() {
        return this.enumType.getValues();
    }

    public EnumerationType getEnumerationType() {
        return this.enumType;
    }

    public EnumStorageForm getStorageForm() {
        return this.enumType.getStorageForm();
    }

    HDF5EnumerationValue createFromStorageForm(byte[] data, int offset) {
        return new HDF5EnumerationValue(this, this.getOrdinalFromStorageForm(data, offset));
    }

    String createStringFromStorageForm(byte[] data, int offset) {
        return this.enumType.createStringFromStorageForm(data, offset);
    }

    int getOrdinalFromStorageForm(byte[] data, int offset) {
        switch (this.getStorageForm()) {
            case BYTE: {
                return data[offset];
            }
            case SHORT: {
                return HDFNativeData.byteToShort(data, offset);
            }
            case INT: {
                return HDFNativeData.byteToInt(data, offset);
            }
        }
        throw new Error("Illegal storage form (" + (Object)((Object)this.getStorageForm()) + ".)");
    }

    @Override
    public Iterator<String> iterator() {
        return this.enumType.iterator();
    }

    @Override
    public int hashCode() {
        return this.enumType.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5EnumerationType other = (HDF5EnumerationType)obj;
        return this.enumType.equals(other.enumType);
    }

    public static enum EnumStorageForm {
        BYTE(1, HDF5Constants.H5T_NATIVE_INT8, HDF5Constants.H5T_STD_U8LE),
        SHORT(2, HDF5Constants.H5T_NATIVE_INT16, HDF5Constants.H5T_STD_U16LE),
        INT(4, HDF5Constants.H5T_NATIVE_INT32, HDF5Constants.H5T_STD_U32LE);

        private final byte storageSize;
        private final int intNativeType;
        private final int intStorageType;

        private EnumStorageForm(int storageSize, int intNativeType, int intStorageType) {
            this.storageSize = (byte)storageSize;
            this.intNativeType = intNativeType;
            this.intStorageType = intStorageType;
        }

        public byte getStorageSize() {
            return this.storageSize;
        }

        int getIntNativeTypeId() {
            return this.intNativeType;
        }

        int getIntStorageTypeId() {
            return this.intStorageType;
        }
    }
}

