/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class I2IReader
extends FormatReader {
    private static final int HEADER_SIZE = 1024;

    public I2IReader() {
        super("I2I", new String[]{"i2i"});
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return FormatTools.validStream(stream, 1024, false);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        long planeSize = FormatTools.getPlaneSize(this);
        long offset = 1024L + (long)no * planeSize;
        if (offset + planeSize <= this.in.length() && offset >= 0L) {
            this.in.seek(offset);
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    @Override
    public void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        char pixelType = (char)this.in.readByte();
        switch (pixelType) {
            case 'I': {
                m.pixelType = 2;
                break;
            }
            case 'R': {
                m.pixelType = 6;
                break;
            }
            case 'C': {
                throw new FormatException("Complex pixel data not yet supported");
            }
            default: {
                throw new FormatException("Invalid pixel type: " + pixelType);
            }
        }
        if ((char)this.in.readByte() != ' ') {
            throw new FormatException("Expected space after pixel type character");
        }
        String x = this.in.readString(6).trim();
        String y = this.in.readString(6).trim();
        String z = this.in.readString(6).trim();
        m.littleEndian = (char)this.in.readByte() != 'B';
        m.sizeX = Integer.parseInt(x);
        m.sizeY = Integer.parseInt(y);
        m.sizeZ = Integer.parseInt(z);
        this.in.order(this.isLittleEndian());
        short minPixelValue = this.in.readShort();
        short maxPixelValue = this.in.readShort();
        short xCoordinate = this.in.readShort();
        short yCoordinate = this.in.readShort();
        short n = this.in.readShort();
        this.in.skipBytes(33);
        for (int i = 0; i < 15; ++i) {
            String history = this.in.readString(64);
            this.addGlobalMetaList("Image history", history.trim());
        }
        this.addGlobalMeta("Minimum intensity value", minPixelValue);
        this.addGlobalMeta("Maximum intensity value", maxPixelValue);
        this.addGlobalMeta("Image position X", xCoordinate);
        this.addGlobalMeta("Image position Y", yCoordinate);
        if (n > 0) {
            m.sizeZ /= n;
        }
        m.sizeT = n;
        m.imageCount = this.getSizeZ() * this.getSizeT();
        m.sizeC = 1;
        m.rgb = false;
        m.dimensionOrder = "XYZTC";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

