/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ChannelSeparator;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.NDPIReader;
import loci.formats.meta.MetadataStore;

public class NDPISReader
extends FormatReader {
    private String[] ndpiFiles;
    private ChannelSeparator[] readers;

    public NDPISReader() {
        super("Hamamatsu NDPIS", "ndpis");
        this.domains = new String[]{"Histology"};
        this.datasetDescription = "One .ndpis file and at least one .ndpi file";
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return true;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.readers[0].getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.readers[0].getOptimalTileHeight();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] zct = this.getZCTCoords(no);
        int channel = zct[1];
        this.readers[channel].setId(this.ndpiFiles[channel]);
        this.readers[channel].setSeries(this.getSeries());
        this.readers[channel].setResolution(this.getResolution());
        int cIndex = channel < this.readers[channel].getSizeC() ? channel : 0;
        int plane = this.readers[channel].getIndex(zct[0], cIndex, zct[2]);
        this.readers[channel].openBytes(plane, buf, x, y, w, h);
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] files = new String[this.ndpiFiles.length + 1];
        files[0] = this.currentId;
        System.arraycopy(this.ndpiFiles, 0, files, 1, this.ndpiFiles.length);
        return files;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.ndpiFiles = null;
            if (this.readers != null) {
                for (ChannelSeparator reader : this.readers) {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        String[] lines;
        super.initFile(id);
        Location parent = new Location(id).getAbsoluteFile().getParentFile();
        for (String line : lines = DataTools.readFile(this.currentId).split("\r\n")) {
            int eq = line.indexOf(61);
            if (eq < 0) continue;
            String key = line.substring(0, eq).trim();
            String value = line.substring(eq + 1).trim();
            if (key.equals("NoImages")) {
                this.ndpiFiles = new String[Integer.parseInt(value)];
                this.readers = new ChannelSeparator[this.ndpiFiles.length];
                continue;
            }
            if (!key.startsWith("Image")) continue;
            int index = Integer.parseInt(key.replaceAll("Image", ""));
            this.ndpiFiles[index] = new Location(parent, value).getAbsolutePath();
            this.readers[index] = new ChannelSeparator(new NDPIReader());
            this.readers[index].setFlattenedResolutions(this.hasFlattenedResolutions());
        }
        this.readers[0].setMetadataStore(this.getMetadataStore());
        this.readers[0].setId(this.ndpiFiles[0]);
        this.core = new ArrayList<CoreMetadata>(this.readers[0].getCoreMetadataList());
        for (int i = 0; i < this.core.size(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.sizeC = this.readers.length;
            ms.rgb = false;
            ms.imageCount = ms.sizeC * ms.sizeZ * ms.sizeT;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

