/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Resizer
implements PlugIn,
TextListener,
ItemListener {
    public static final int IN_PLACE = 16;
    public static final int SCALE_T = 32;
    private static int newWidth;
    private static int newHeight;
    private static boolean constrain;
    private static boolean averageWhenDownsizing;
    private static int interpolationMethod;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private Vector fields;
    private Vector checkboxes;
    private double origWidth;
    private double origHeight;
    private boolean sizeToHeight;

    public void run(String arg) {
        boolean restoreRoi;
        boolean crop = arg.equals("crop");
        ImagePlus imp = IJ.getImage();
        ImageProcessor ip = imp.getProcessor();
        Roi roi = imp.getRoi();
        if ((roi == null || !roi.isArea()) && crop) {
            IJ.error(crop ? "Crop" : "Resize", "Area selection required");
            return;
        }
        if (!imp.lock()) {
            IJ.log("<<Resizer: image is locked (" + imp + ")>>");
            return;
        }
        Rectangle r = ip.getRoi();
        this.origWidth = r.width;
        this.origHeight = r.height;
        this.sizeToHeight = false;
        boolean bl = restoreRoi = crop && roi != null && roi.getType() != 0;
        if (roi != null) {
            Rectangle b = roi.getBounds();
            int w = ip.getWidth();
            int h = ip.getHeight();
            if (b.x < 0 || b.y < 0 || b.x + b.width > w || b.y + b.height > h) {
                ShapeRoi shape1 = new ShapeRoi(roi);
                ShapeRoi shape2 = new ShapeRoi(new Roi(0, 0, w, h));
                roi = shape2.and(shape1);
                if (roi.getBounds().width == 0 || roi.getBounds().height == 0) {
                    throw new IllegalArgumentException("Selection is outside the image");
                }
                if (restoreRoi) {
                    imp.setRoi(roi);
                }
            }
        }
        int stackSize = imp.getStackSize();
        int z1 = imp.getStackSize();
        int t1 = 0;
        int z2 = 0;
        int t2 = 0;
        int saveMethod = interpolationMethod;
        if (crop) {
            Rectangle bounds = roi.getBounds();
            newWidth = bounds.width;
            newHeight = bounds.height;
            interpolationMethod = 0;
        } else {
            if (newWidth == 0 || newHeight == 0) {
                newWidth = (int)this.origWidth / 2;
                newHeight = (int)this.origHeight / 2;
            }
            if (constrain) {
                newHeight = (int)((double)newWidth * (this.origHeight / this.origWidth));
            }
            if (stackSize > 1) {
                newWidth = (int)this.origWidth;
                newHeight = (int)this.origHeight;
            }
            GenericDialog gd = new GenericDialog("Resize");
            gd.addNumericField("Width (pixels):", newWidth, 0);
            gd.addNumericField("Height (pixels):", newHeight, 0);
            if (imp.isHyperStack()) {
                z1 = imp.getNSlices();
                t1 = imp.getNFrames();
            }
            if (z1 > 1 && z1 == stackSize) {
                gd.addNumericField("Depth (images):", z1, 0);
            } else if (z1 > 1 && z1 < stackSize) {
                gd.addNumericField("Depth (slices):", z1, 0);
            }
            if (t1 > 1) {
                gd.addNumericField("Time (frames):", t1, 0);
            }
            gd.addCheckbox("Constrain aspect ratio", constrain);
            gd.addCheckbox("Average when downsizing", averageWhenDownsizing);
            gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
            this.fields = gd.getNumericFields();
            if (!IJ.macroRunning()) {
                for (int i = 0; i < 2; ++i) {
                    ((TextField)this.fields.elementAt(i)).addTextListener(this);
                }
            }
            this.checkboxes = gd.getCheckboxes();
            if (!IJ.macroRunning()) {
                ((Checkbox)this.checkboxes.elementAt(0)).addItemListener(this);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                imp.unlock();
                return;
            }
            newWidth = (int)gd.getNextNumber();
            newHeight = (int)gd.getNextNumber();
            if (z1 > 1) {
                z2 = (int)gd.getNextNumber();
            }
            if (t1 > 1) {
                t2 = (int)gd.getNextNumber();
            }
            if (gd.invalidNumber()) {
                IJ.error("Width or height are invalid.");
                imp.unlock();
                return;
            }
            constrain = gd.getNextBoolean();
            averageWhenDownsizing = gd.getNextBoolean();
            interpolationMethod = gd.getNextChoiceIndex();
            if (constrain && newWidth == 0) {
                this.sizeToHeight = true;
            }
            if ((double)newWidth <= 0.0 && !constrain) {
                newWidth = 50;
            }
            if ((double)newHeight <= 0.0) {
                newHeight = 50;
            }
        }
        if (!crop && constrain) {
            if (this.sizeToHeight) {
                newWidth = (int)Math.round((double)newHeight * (this.origWidth / this.origHeight));
            } else {
                newHeight = (int)Math.round((double)newWidth * (this.origHeight / this.origWidth));
            }
        }
        ip.setInterpolationMethod(interpolationMethod);
        if (stackSize == 1) {
            Undo.setup(crop ? 6 : 2, imp);
        }
        if (roi != null || (double)newWidth != this.origWidth || (double)newHeight != this.origHeight) {
            try {
                StackProcessor sp = new StackProcessor(imp.getStack(), ip);
                ImageStack s2 = sp.resize(newWidth, newHeight, averageWhenDownsizing);
                int newSize = s2.getSize();
                if (s2.getWidth() > 0 && newSize > 0) {
                    Calibration cal;
                    if (restoreRoi) {
                        imp.deleteRoi();
                    }
                    if ((cal = imp.getCalibration()).scaled()) {
                        cal.pixelWidth *= this.origWidth / (double)newWidth;
                        cal.pixelHeight *= this.origHeight / (double)newHeight;
                    }
                    if (crop && roi != null && (cal.xOrigin != 0.0 || cal.yOrigin != 0.0)) {
                        cal.xOrigin -= (double)roi.getBounds().x;
                        cal.yOrigin -= (double)roi.getBounds().y;
                    }
                    imp.setStack(null, s2);
                    if (crop && roi != null) {
                        Overlay overlay = imp.getOverlay();
                        if (overlay != null && !imp.getHideOverlay()) {
                            Overlay overlay2 = overlay.crop(roi.getBounds());
                            imp.setOverlay(overlay2);
                        }
                    } else {
                        Overlay overlay = imp.getOverlay();
                        Overlay overlay2 = new Overlay();
                        if (overlay != null && !imp.getHideOverlay()) {
                            for (int i = 0; i < overlay.size(); ++i) {
                                Roi roi2 = overlay.get(i);
                                Rectangle bounds = roi2.getBounds();
                                if (!(roi2 instanceof ImageRoi) || bounds.x != 0 || bounds.y != 0) continue;
                                ImageRoi iroi = (ImageRoi)roi2;
                                ImageProcessor ip2 = iroi.getProcessor();
                                ip2.setInterpolationMethod(interpolationMethod);
                                ip2 = ip2.resize(newWidth, newHeight, averageWhenDownsizing);
                                iroi.setProcessor(ip2);
                                overlay2.add(iroi);
                            }
                            if (overlay2.size() > 0) {
                                imp.setOverlay(overlay2);
                            } else {
                                imp.setOverlay(null);
                            }
                        } else {
                            imp.setOverlay(null);
                        }
                    }
                    if (restoreRoi && roi != null) {
                        roi.setLocation(0, 0);
                        imp.setRoi(roi);
                        imp.draw();
                    }
                }
                if (stackSize > 1 && newSize < stackSize) {
                    IJ.error("ImageJ ran out of memory causing \nthe last " + (stackSize - newSize) + " slices to be lost.");
                }
            }
            catch (OutOfMemoryError o) {
                IJ.outOfMemory("Resize");
            }
            imp.changes = true;
            if (crop) {
                interpolationMethod = saveMethod;
            }
        }
        ImagePlus imp2 = null;
        if (z2 > 0 && z2 != z1) {
            imp2 = this.zScale(imp, z2, interpolationMethod + 16);
        }
        if (t2 > 0 && t2 != t1) {
            imp2 = this.zScale(imp2 != null ? imp2 : imp, t2, interpolationMethod + 16 + 32);
        }
        imp.unlock();
        if (imp2 != null && imp2 != imp) {
            imp.changes = false;
            imp.close();
            imp2.show();
        }
    }

    public ImagePlus zScale(ImagePlus imp, int newDepth, int interpolationMethod) {
        Object info;
        ImagePlus imp2 = null;
        if (imp.isHyperStack()) {
            imp2 = this.zScaleHyperstack(imp, newDepth, interpolationMethod);
        } else {
            boolean inPlace = (interpolationMethod & 0x10) != 0;
            int stackSize = imp.getStackSize();
            int bitDepth = imp.getBitDepth();
            imp2 = this.resizeZ(imp, newDepth, interpolationMethod &= 0xF);
            if (imp2 == null) {
                return null;
            }
            double min = imp.getDisplayRangeMin();
            double max = imp.getDisplayRangeMax();
            imp2.setDisplayRange(min, max);
        }
        if (imp2 == null) {
            return null;
        }
        if (imp2 != imp && imp.isComposite()) {
            imp2 = new CompositeImage(imp2, ((CompositeImage)imp).getMode());
            ((CompositeImage)imp2).copyLuts(imp);
        }
        imp2.setCalibration(imp.getCalibration());
        Calibration cal = imp2.getCalibration();
        if (cal.scaled()) {
            cal.pixelDepth *= (double)imp.getNSlices() / (double)imp2.getNSlices();
        }
        if ((info = imp.getProperty("Info")) != null) {
            imp2.setProperty("Info", info);
        }
        if (imp.isHyperStack()) {
            imp2.setOpenAsHyperStack(imp.isHyperStack());
        }
        return imp2;
    }

    private ImagePlus zScaleHyperstack(ImagePlus imp, int depth2, int interpolationMethod) {
        boolean inPlace = (interpolationMethod & 0x10) != 0;
        boolean scaleT = (interpolationMethod & 0x20) != 0;
        interpolationMethod &= 0xF;
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int slices2 = slices;
        int frames2 = frames;
        int bitDepth = imp.getBitDepth();
        if (slices == 1 && frames > 1) {
            scaleT = true;
        }
        if (scaleT) {
            frames2 = depth2;
        } else {
            slices2 = depth2;
        }
        double scale = (double)(depth2 - 1) / (double)slices;
        if (scaleT) {
            scale = (double)(depth2 - 1) / (double)frames;
        }
        ImageStack stack1 = imp.getStack();
        int width = stack1.getWidth();
        int height = stack1.getHeight();
        ImagePlus imp2 = IJ.createImage(imp.getTitle(), bitDepth + "-bit", width, height, channels * slices2 * frames2);
        if (imp2 == null) {
            return null;
        }
        imp2.setDimensions(channels, slices2, frames2);
        ImageStack stack2 = imp2.getStack();
        ImageProcessor ip = imp.getProcessor();
        int count = 0;
        if (scaleT) {
            IJ.showStatus("T Scaling...");
            ImageProcessor xtPlane1 = ip.createProcessor(width, frames);
            xtPlane1.setInterpolationMethod(interpolationMethod);
            Object xtpixels1 = xtPlane1.getPixels();
            int last = slices * channels * height - 1;
            for (int z = 1; z <= slices; ++z) {
                for (int c = 1; c <= channels; ++c) {
                    for (int y = 0; y < height; ++y) {
                        IJ.showProgress(count++, last);
                        for (int t = 1; t <= frames; ++t) {
                            int index = imp.getStackIndex(c, z, t);
                            Object pixels1 = stack1.getPixels(index);
                            System.arraycopy(pixels1, y * width, xtpixels1, (t - 1) * width, width);
                        }
                        ImageProcessor xtPlane2 = xtPlane1.resize(width, depth2, averageWhenDownsizing);
                        Object xtpixels2 = xtPlane2.getPixels();
                        for (int t = 1; t <= frames2; ++t) {
                            int index = imp2.getStackIndex(c, z, t);
                            Object pixels2 = stack2.getPixels(index);
                            System.arraycopy(xtpixels2, (t - 1) * width, pixels2, y * width, width);
                        }
                    }
                }
            }
        } else {
            IJ.showStatus("Z Scaling...");
            ImageProcessor xzPlane1 = ip.createProcessor(width, slices);
            xzPlane1.setInterpolationMethod(interpolationMethod);
            Object xypixels1 = xzPlane1.getPixels();
            int last = frames * channels * height - 1;
            for (int t = 1; t <= frames; ++t) {
                for (int c = 1; c <= channels; ++c) {
                    for (int y = 0; y < height; ++y) {
                        IJ.showProgress(count++, last);
                        for (int z = 1; z <= slices; ++z) {
                            int index = imp.getStackIndex(c, z, t);
                            Object pixels1 = stack1.getPixels(index);
                            System.arraycopy(pixels1, y * width, xypixels1, (z - 1) * width, width);
                        }
                        ImageProcessor xzPlane2 = xzPlane1.resize(width, depth2, averageWhenDownsizing);
                        Object xypixels2 = xzPlane2.getPixels();
                        for (int z = 1; z <= slices2; ++z) {
                            int index = imp2.getStackIndex(c, z, t);
                            Object pixels2 = stack2.getPixels(index);
                            System.arraycopy(xypixels2, (z - 1) * width, pixels2, y * width, width);
                        }
                    }
                }
            }
        }
        imp2.setDimensions(channels, slices2, frames2);
        return imp2;
    }

    private ImagePlus resizeZ(ImagePlus imp, int newDepth, int interpolationMethod) {
        ImageStack stack1 = imp.getStack();
        int width = stack1.getWidth();
        int height = stack1.getHeight();
        int depth = stack1.getSize();
        int bitDepth = imp.getBitDepth();
        ImagePlus imp2 = IJ.createImage(imp.getTitle(), bitDepth + "-bit", width, height, newDepth);
        if (imp2 == null) {
            return null;
        }
        ImageStack stack2 = imp2.getStack();
        ImageProcessor ip = imp.getProcessor();
        ImageProcessor xzPlane1 = ip.createProcessor(width, depth);
        xzPlane1.setInterpolationMethod(interpolationMethod);
        Object xzpixels1 = xzPlane1.getPixels();
        IJ.showStatus("Z Scaling...");
        for (int y = 0; y < height; ++y) {
            IJ.showProgress(y, height - 1);
            for (int z = 0; z < depth; ++z) {
                Object pixels1 = stack1.getPixels(z + 1);
                System.arraycopy(pixels1, y * width, xzpixels1, z * width, width);
            }
            ImageProcessor xzPlane2 = xzPlane1.resize(width, newDepth, averageWhenDownsizing);
            Object xypixels2 = xzPlane2.getPixels();
            for (int z = 0; z < newDepth; ++z) {
                Object pixels2 = stack2.getPixels(z + 1);
                System.arraycopy(xypixels2, z * width, pixels2, y * width, width);
            }
        }
        return imp2;
    }

    public void textValueChanged(TextEvent e) {
        TextField widthField = (TextField)this.fields.elementAt(0);
        TextField heightField = (TextField)this.fields.elementAt(1);
        int width = (int)Tools.parseDouble(widthField.getText(), -99.0);
        int height = (int)Tools.parseDouble(heightField.getText(), -99.0);
        if (width == -99 || height == -99) {
            return;
        }
        if (constrain) {
            if (width != newWidth) {
                this.sizeToHeight = false;
                newWidth = width;
                this.updateFields();
            } else if (height != newHeight) {
                this.sizeToHeight = true;
                newHeight = height;
                this.updateFields();
            }
        }
    }

    void updateFields() {
        if (this.sizeToHeight) {
            newWidth = (int)Math.round((double)newHeight * (this.origWidth / this.origHeight));
            TextField widthField = (TextField)this.fields.elementAt(0);
            widthField.setText("" + newWidth);
        } else {
            newHeight = (int)Math.round((double)newWidth * (this.origHeight / this.origWidth));
            TextField heightField = (TextField)this.fields.elementAt(1);
            heightField.setText("" + newHeight);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Checkbox cb = (Checkbox)this.checkboxes.elementAt(0);
        boolean newConstrain = cb.getState();
        if (newConstrain && newConstrain != constrain) {
            this.updateFields();
        }
        constrain = newConstrain;
    }

    public void setAverageWhenDownsizing(boolean averageWhenDownsizing) {
        Resizer.averageWhenDownsizing = averageWhenDownsizing;
    }

    static {
        constrain = true;
        averageWhenDownsizing = true;
        interpolationMethod = 1;
    }
}

