/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;

public class Object3DFuzzy
extends Object3DVoxels {
    public Object3DFuzzy(int n, ArrayList<Voxel3D> arrayList) {
        this.value = n;
        this.voxels = arrayList;
        this.init();
    }

    @Override
    public ArrayList<Voxel3D> getContours() {
        return this.contours;
    }

    public void setContours(ArrayList<Voxel3D> arrayList) {
        this.contours = arrayList;
    }

    @Override
    protected void computeCenter() {
        this.bx = 0.0;
        this.by = 0.0;
        this.bz = 0.0;
        this.volume = 0;
        for (Voxel3D voxel3D : this.voxels) {
            double d = 1.0;
            this.bx += voxel3D.getX() * d;
            this.by += voxel3D.getY() * d;
            this.bz += voxel3D.getZ() * d;
            this.volume = (int)((double)this.volume + d);
        }
        if (this.volume != 0) {
            this.bx /= (double)this.volume;
            this.by /= (double)this.volume;
            this.bz /= (double)this.volume;
        }
    }

    @Override
    protected void computeMassCenter(ImageHandler imageHandler) {
        if (imageHandler != null) {
            this.cx = 0.0;
            this.cy = 0.0;
            this.cz = 0.0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            for (Voxel3D voxel3D : this.voxels) {
                double d5 = (double)imageHandler.getPixel(voxel3D) * voxel3D.getValue();
                this.cx += voxel3D.getX() * d5;
                this.cy += voxel3D.getY() * d5;
                this.cz += voxel3D.getZ() * d5;
                d += d5;
                d2 += d5 * d5;
                if (d5 > d4) {
                    d4 = d5;
                }
                if (!(d5 < d3)) continue;
                d3 = d5;
            }
            this.cx /= d;
            this.cy /= d;
            this.cz /= d;
            this.integratedDensity = d;
            this.pixmin = d3;
            this.pixmax = d4;
            int n = this.getVolumePixels();
            this.sigma = Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1));
        }
    }

    @Override
    protected void computeBounding() {
        this.xmin = Integer.MAX_VALUE;
        this.xmax = 0;
        this.ymin = Integer.MAX_VALUE;
        this.ymax = 0;
        this.zmin = Integer.MAX_VALUE;
        this.zmax = 0;
        for (Voxel3D voxel3D : this.voxels) {
            if (voxel3D.getX() < (double)this.xmin) {
                this.xmin = (int)voxel3D.getX();
            }
            if (voxel3D.getX() > (double)this.xmax) {
                this.xmax = (int)voxel3D.getX();
            }
            if (voxel3D.getY() < (double)this.ymin) {
                this.ymin = (int)voxel3D.getY();
            }
            if (voxel3D.getY() > (double)this.ymax) {
                this.ymax = (int)voxel3D.getY();
            }
            if (voxel3D.getZ() < (double)this.zmin) {
                this.zmin = (int)voxel3D.getZ();
            }
            if (!(voxel3D.getZ() > (double)this.zmax)) continue;
            this.zmax = (int)voxel3D.getZ();
        }
    }

    @Override
    public void computeContours() {
    }

    @Override
    public void computeMoments2(boolean bl) {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        for (Voxel3D voxel3D : this.voxels) {
            double d = voxel3D.getX();
            double d2 = voxel3D.getY();
            double d3 = voxel3D.getZ();
            this.s200 += (d - this.bx) * (d - this.bx);
            this.s020 += (d2 - this.by) * (d2 - this.by);
            this.s002 += (d3 - this.bz) * (d3 - this.bz);
            this.s110 += (d - this.bx) * (d2 - this.by);
            this.s101 += (d - this.bx) * (d3 - this.bz);
            this.s011 += (d2 - this.by) * (d3 - this.bz);
        }
        this.s200 *= this.resXY * this.resXY;
        this.s020 *= this.resXY * this.resXY;
        this.s002 *= this.resZ * this.resZ;
        this.s110 *= this.resXY * this.resXY;
        this.s101 *= this.resXY * this.resZ;
        this.s011 *= this.resXY * this.resZ;
        if (bl) {
            this.s200 /= (double)this.volume;
            this.s020 /= (double)this.volume;
            this.s002 /= (double)this.volume;
            this.s110 /= (double)this.volume;
            this.s101 /= (double)this.volume;
            this.s011 /= (double)this.volume;
        }
        this.eigen = null;
    }

    @Override
    public Voxel3D getPixelMax(ImageHandler imageHandler) {
        Voxel3D voxel3D = null;
        float f = -3.4028235E38f;
        for (Voxel3D voxel3D2 : this.voxels) {
            float f2 = imageHandler.getPixel(voxel3D2);
            if (!(f2 > f)) continue;
            f = f2;
            voxel3D = new Voxel3D(voxel3D2);
        }
        return voxel3D;
    }

    public Voxel3D getPixelMin(ImageHandler imageHandler) {
        Voxel3D voxel3D = null;
        float f = Float.MAX_VALUE;
        for (Voxel3D voxel3D2 : this.voxels) {
            float f2 = imageHandler.getPixel(voxel3D2);
            if (!(f2 < f)) continue;
            f = f2;
            voxel3D = new Voxel3D(voxel3D2);
        }
        return voxel3D;
    }

    public ArrayList listVoxels(ImageHandler imageHandler) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        Iterator iterator = this.voxels.iterator();
        while (iterator.hasNext()) {
            Voxel3D voxel3D = new Voxel3D((Voxel3D)iterator.next());
            voxel3D.setValue(imageHandler.getPixel(voxel3D));
            arrayList.add(voxel3D);
        }
        return arrayList;
    }

    @Override
    public void draw(ImageStack imageStack, int n) {
        for (Voxel3D voxel3D : this.voxels) {
            imageStack.setVoxel((int)voxel3D.getX(), (int)voxel3D.getY(), (int)voxel3D.getZ(), (double)n);
        }
    }

    @Override
    public void draw(ImageStack imageStack, int n, int n2, int n3) {
        Color color = new Color(n, n2, n3);
        for (Voxel3D voxel3D : this.voxels) {
            ImageProcessor imageProcessor = imageStack.getProcessor((int)(voxel3D.getZ() + 1.0));
            imageProcessor.setColor(color);
            imageProcessor.drawPixel((int)voxel3D.getX(), (int)voxel3D.getY());
        }
    }

    @Override
    public void draw(ByteProcessor byteProcessor, int n, int n2) {
        for (Voxel3D voxel3D : this.voxels) {
            if (!(Math.abs((double)n - voxel3D.getZ()) < 0.5)) continue;
            byteProcessor.putPixel((int)voxel3D.getX(), (int)voxel3D.getY(), n2);
        }
    }

    @Override
    public Roi createRoi(int n) {
        int n2 = this.getXmax() - this.getXmin() + 1;
        int n3 = this.getYmax() - this.getYmin() + 1;
        ByteProcessor byteProcessor = new ByteProcessor(n2, n3);
        this.draw(byteProcessor, n, 255);
        ImagePlus imagePlus = new ImagePlus("mask " + n, (ImageProcessor)byteProcessor);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        thresholdToSelection.setup("", imagePlus);
        thresholdToSelection.run((ImageProcessor)byteProcessor);
        imagePlus.updateAndDraw();
        Roi roi = imagePlus.getRoi();
        Rectangle rectangle = roi.getBounds();
        rectangle.x += this.getXmin();
        rectangle.y += this.getYmin();
        return roi;
    }

    @Override
    public ArrayList<Voxel3D> getVoxels() {
        return this.voxels;
    }

    @Override
    public void writeVoxels(String string) {
        int n = 0;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + this.value + ".3droi"));
            Iterator iterator = this.voxels.iterator();
            while (iterator.hasNext()) {
                Voxel3D voxel3D = new Voxel3D((Voxel3D)iterator.next());
                bufferedWriter.write(++n + "\t" + voxel3D.getX() + "\t" + voxel3D.getY() + "\t" + voxel3D.getZ() + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(Object3DVoxels.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }
}

