/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import java.util.ArrayList;
import java.util.HashMap;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.KDTreeC;

public class Objects3DPopulation {
    private ArrayList<Object3D> objects = new ArrayList();
    private Object3D mask = null;
    private Calibration calibration = null;
    private KDTreeC kdtree = null;
    private HashMap<Integer, Integer> hash = new HashMap();

    public Objects3DPopulation() {
        this.calibration = new Calibration();
    }

    public Objects3DPopulation(Object3D[] object3DArray) {
        this.calibration = new Calibration();
        this.addObjects(object3DArray);
    }

    public Objects3DPopulation(Object3D[] object3DArray, Calibration calibration) {
        this.calibration = calibration != null ? calibration : new Calibration();
        this.addObjects(object3DArray);
    }

    public Objects3DPopulation(ImagePlus imagePlus) {
        this.addImagePlus(imagePlus);
    }

    public Calibration getCalibration() {
        return this.calibration;
    }

    public void setCalibration(Calibration calibration) {
        this.calibration = calibration;
        if (this.objects != null && this.objects.size() > 0) {
            for (Object3D object3D : this.objects) {
                object3D.setCalibration(this.calibration);
            }
        }
    }

    public void createRandomPopulation(int n, double d) {
        double d2 = d;
        Point3D point3D = this.getRandomPointInMask();
        Voxel3D voxel3D = new Voxel3D(point3D.getX(), point3D.getY(), point3D.getZ(), 0.0);
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>(1);
        arrayList.add(voxel3D);
        Object3DVoxels object3DVoxels = new Object3DVoxels(arrayList);
        this.addObject(object3DVoxels);
        for (int i = 1; i < n; ++i) {
            double d3 = -1.0;
            while (d3 < d2) {
                point3D = this.getRandomPointInMask();
                Object3D object3D = this.closestCenter(point3D);
                d3 = object3D.distPixelCenter(point3D.getX(), point3D.getY(), point3D.getZ());
            }
            voxel3D = new Voxel3D(point3D.getX(), point3D.getY(), point3D.getZ(), (double)i);
            arrayList = new ArrayList(1);
            arrayList.add(voxel3D);
            object3DVoxels = new Object3DVoxels(arrayList);
            this.addObject(object3DVoxels);
        }
    }

    public void createRandomPopulationDistAbsMb(int n, double d, double d2) {
        for (int i = 0; i < n; ++i) {
            ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>(1);
            Point3D point3D = this.getRandomPointInMaskDistAbsMb(d, d2);
            Voxel3D voxel3D = new Voxel3D(point3D.getX(), point3D.getY(), point3D.getZ(), (double)i);
            arrayList.add(voxel3D);
            Object3DVoxels object3DVoxels = new Object3DVoxels(arrayList);
            this.addObject(object3DVoxels);
        }
    }

    public void createKDTreeCenters() {
        this.kdtree = new KDTreeC(3, this.getNbObjects());
        for (int i = 0; i < this.getNbObjects(); ++i) {
            this.kdtree.add(this.getObject(i).getCenterAsArray(), this.getObject(i));
        }
        double[] dArray = new double[]{this.calibration.pixelWidth, this.calibration.pixelHeight, this.calibration.pixelDepth};
        this.kdtree.setScale(dArray);
    }

    public void draw(ImageStack imageStack, int n) {
        for (Object3D object3D : this.objects) {
            object3D.draw(imageStack, n);
        }
    }

    public void draw(ImageStack imageStack) {
        for (Object3D object3D : this.objects) {
            object3D.draw(imageStack, object3D.getValue());
        }
    }

    public void draw(ImageHandler imageHandler) {
        for (Object3D object3D : this.objects) {
            object3D.draw(imageHandler, object3D.getValue());
        }
    }

    public void addObject(Object3D object3D) {
        object3D.setCalibration(this.calibration);
        this.objects.add(object3D);
        this.hash.put(object3D.getValue(), this.objects.size() - 1);
        if (this.kdtree != null) {
            this.createKDTreeCenters();
        }
    }

    public final void addObjects(Object3D[] object3DArray) {
        for (int i = 0; i < object3DArray.length; ++i) {
            this.addObject(object3DArray[i]);
        }
        if (this.kdtree != null) {
            this.createKDTreeCenters();
        }
    }

    public void addObjects(ArrayList<Object3D> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.addObject(arrayList.get(i));
        }
        if (this.kdtree != null) {
            this.createKDTreeCenters();
        }
    }

    public void removeObject(int n) {
        this.hash.remove(this.objects.get(n));
        this.objects.remove(n);
    }

    public void addPoints(Point3D[] point3DArray) {
        int n = this.objects.size();
        for (int i = 0; i < point3DArray.length; ++i) {
            Point3D point3D = point3DArray[i];
            Voxel3D voxel3D = new Voxel3D(point3D.getX(), point3D.getY(), point3D.getZ(), (double)((float)i + (float)n));
            ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>(1);
            arrayList.add(voxel3D);
            Object3DVoxels object3DVoxels = new Object3DVoxels(arrayList);
            object3DVoxels.setCalibration(this.calibration);
            object3DVoxels.setValue(i + 1);
            this.addObject(object3DVoxels);
        }
        if (this.kdtree != null) {
            this.createKDTreeCenters();
        }
    }

    public void addImage(ImageInt imageInt, Calibration calibration) {
        int n;
        int n2;
        int n3 = (int)imageInt.getMinAboveValue(0.0f);
        int n4 = (int)imageInt.getMax();
        if (n4 == 0) {
            IJ.log((String)"No objects found");
            return;
        }
        this.calibration = calibration;
        ArrayList[] arrayListArray = new ArrayList[n4 - n3 + 1];
        for (n2 = 0; n2 < n4 - n3 + 1; ++n2) {
            arrayListArray[n2] = new ArrayList();
        }
        int n5 = imageInt.sizeZ;
        int n6 = imageInt.sizeY;
        int n7 = imageInt.sizeX;
        for (n = 0; n < n5; ++n) {
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n7; ++j) {
                    n2 = imageInt.getPixelInt(j, i, n);
                    if (n2 <= 0) continue;
                    arrayListArray[n2 - n3].add(new Voxel3D(j, i, n, n2));
                }
            }
        }
        for (n = 0; n < n4 - n3 + 1; ++n) {
            if (arrayListArray[n].isEmpty()) continue;
            Object3DVoxels object3DVoxels = new Object3DVoxels(arrayListArray[n]);
            object3DVoxels.setLabelImage(imageInt);
            this.addObject(object3DVoxels);
        }
    }

    public void addImage(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        if (calibration == null) {
            calibration = new Calibration();
            calibration.pixelWidth = 1.0;
            calibration.pixelHeight = 1.0;
            calibration.pixelDepth = 1.0;
            calibration.setUnit("pix");
        }
        this.setCalibration(calibration);
        ImageInt imageInt = ImageInt.wrap(imagePlus);
        this.addImage(imageInt, calibration);
    }

    public Object3D getMask() {
        return this.mask;
    }

    public void setMask(Object3D object3D) {
        this.mask = object3D;
    }

    public Object3D getObject(int n) {
        return this.objects.get(n);
    }

    public Object3D getObjectByValue(int n) {
        return this.objects.get(this.hash.get(n));
    }

    public int getIndexFromValue(int n) {
        return this.hash.get(n);
    }

    public int getIndexOf(Object3D object3D) {
        return this.objects.indexOf(object3D);
    }

    public Object3D[] getObjectsArray() {
        return (Object3D[])this.objects.toArray();
    }

    public ArrayList<Object3D> getObjectsList() {
        return this.objects;
    }

    public int getNbObjects() {
        return this.objects.size();
    }

    public int[] getMaxSizeAllObjects() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Object3D object3D : this.objects) {
            if (object3D.xmax > n) {
                n = object3D.xmax;
            }
            if (object3D.ymax > n2) {
                n2 = object3D.ymax;
            }
            if (object3D.zmax <= n3) continue;
            n3 = object3D.zmax;
        }
        return new int[]{n, n2, n3};
    }

    public Point3D getRandomPointInMask() {
        int n = this.mask.getXmin();
        int n2 = this.mask.getXmax();
        int n3 = this.mask.getYmin();
        int n4 = this.mask.getYmax();
        int n5 = this.mask.getZmin();
        int n6 = this.mask.getZmax();
        double d = Math.random() * (double)(n2 - n) + (double)n;
        double d2 = Math.random() * (double)(n4 - n3) + (double)n3;
        double d3 = Math.random() * (double)(n6 - n5) + (double)n5;
        while (!this.mask.inside(d, d2, d3)) {
            d = Math.random() * (double)(n2 - n) + (double)n;
            d2 = Math.random() * (double)(n4 - n3) + (double)n3;
            d3 = Math.random() * (double)(n6 - n5) + (double)n5;
        }
        return new Point3D(d, d2, d3);
    }

    private Point3D getRandomPointInMaskDistAbsMb(double d, double d2) {
        int n = this.mask.getXmin();
        int n2 = this.mask.getXmax();
        int n3 = this.mask.getYmin();
        int n4 = this.mask.getYmax();
        int n5 = this.mask.getZmin();
        int n6 = this.mask.getZmax();
        double d3 = Math.random() * (double)(n2 - n) + (double)n;
        double d4 = Math.random() * (double)(n4 - n3) + (double)n3;
        double d5 = Math.random() * (double)(n6 - n5) + (double)n5;
        double d6 = Double.MAX_VALUE;
        while (!this.mask.inside(d3, d4, d5) || d6 < d || d6 > d2) {
            d3 = Math.random() * (double)(n2 - n) + (double)n;
            d4 = Math.random() * (double)(n4 - n3) + (double)n3;
            d5 = Math.random() * (double)(n6 - n5) + (double)n5;
            d6 = this.mask.distPixelBorderUnit(d3, d4, d5);
        }
        return new Point3D(d3, d4, d5);
    }

    public ArrayUtil computeDistances(Point3D[] point3DArray) {
        int n = point3DArray.length;
        ArrayUtil arrayUtil = new ArrayUtil(n);
        for (int i = 0; i < n; ++i) {
            Point3D point3D = point3DArray[i];
            Object3D object3D = this.closestCenter(point3D);
            arrayUtil.putValue(i, object3D.distPixelCenter(point3D.getX(), point3D.getY(), point3D.getZ()));
        }
        return arrayUtil;
    }

    public double[][] distancesAllPairsCenter() {
        int n = this.objects.size();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            Object3D object3D = this.objects.get(i);
            dArray[i][i] = 0.0;
            for (int j = i + 1; j < n; ++j) {
                double d;
                Object3D object3D2 = this.objects.get(j);
                dArray[i][j] = d = object3D.distCenterUnit(object3D2);
                dArray[j][i] = d;
            }
        }
        return dArray;
    }

    public double[][] distancesAllPairsCenter(Objects3DPopulation objects3DPopulation) {
        int n = this.objects.size();
        int n2 = objects3DPopulation.getNbObjects();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            Object3D object3D = this.objects.get(i);
            dArray[i][i] = 0.0;
            for (int j = 0; j < n2; ++j) {
                double d;
                Object3D object3D2 = objects3DPopulation.getObject(j);
                dArray[i][j] = d = object3D.distCenterUnit(object3D2);
                dArray[j][i] = d;
            }
        }
        return dArray;
    }

    public double[][] distancesAllPairsBorder(Objects3DPopulation objects3DPopulation) {
        int n = this.objects.size();
        int n2 = objects3DPopulation.getNbObjects();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            Object3D object3D = this.objects.get(i);
            dArray[i][i] = 0.0;
            for (int j = 0; j < n2; ++j) {
                double d;
                Object3D object3D2 = objects3DPopulation.getObject(j);
                dArray[i][j] = d = object3D.distBorderUnit(object3D2);
                dArray[j][i] = d;
            }
        }
        return dArray;
    }

    public ArrayUtil distancesAllCenter() {
        double[] dArray = new double[this.getNbObjects() * (this.getNbObjects() - 1) / 2];
        int n = this.getNbObjects();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object3D object3D = this.objects.get(i);
            for (int j = i + 1; j < n; ++j) {
                Object3D object3D2 = this.objects.get(j);
                dArray[n2] = object3D.distCenterUnit(object3D2);
                ++n2;
            }
        }
        return new ArrayUtil(dArray);
    }

    public ArrayUtil distancesAllClosestCenter() {
        int n = this.getNbObjects();
        ArrayUtil arrayUtil = new ArrayUtil(n);
        for (int i = 0; i < n; ++i) {
            Object3D object3D = this.closestCenter(this.getObject(i), true);
            if (object3D == null) continue;
            double d = object3D.distCenterUnit(this.getObject(i));
            arrayUtil.putValue(i, d);
        }
        return arrayUtil;
    }

    public ArrayList<double[]> getMeasuresGeometrical() {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (Object3D object3D : this.objects) {
            double[] dArray = new double[]{object3D.getValue(), object3D.getVolumePixels(), object3D.getVolumeUnit(), object3D.getAreaPixels(), object3D.getAreaUnit()};
            arrayList.add(dArray);
        }
        return arrayList;
    }

    public ArrayList<double[]> getMeasuresStats(ImageHandler imageHandler) {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (Object3D object3D : this.objects) {
            double[] dArray = new double[]{object3D.getMeanPixValue(imageHandler), object3D.getStDevPixValue(imageHandler), object3D.getPixMinValue(imageHandler), object3D.getPixMaxValue(imageHandler), object3D.getIntegratedDensity(imageHandler)};
            arrayList.add(dArray);
        }
        return arrayList;
    }

    public ArrayList<double[]> getMeasuresStats(ImageStack imageStack) {
        return this.getMeasuresStats(ImageHandler.wrap(imageStack));
    }

    public double[][] distancesAllPairsBorder() {
        int n = this.objects.size();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            Object3D object3D = this.objects.get(i);
            dArray[i][i] = 0.0;
            for (int j = i + 1; j < n; ++j) {
                double d;
                Object3D object3D2 = this.objects.get(j);
                dArray[i][j] = d = object3D.distBorderUnit(object3D2);
                dArray[j][i] = d;
            }
        }
        return dArray;
    }

    public double[][] histogramDistancesCenter(double d) {
        int n = this.objects.size();
        double[][] dArray = this.distancesAllPairsCenter();
        return this.histogramDistances(dArray, d);
    }

    public double[][] histogramDistancesBorder(double d) {
        int n = this.objects.size();
        double[][] dArray = this.distancesAllPairsBorder();
        return this.histogramDistances(dArray, d);
    }

    private double[][] histogramDistances(double[][] dArray, double d) {
        int n;
        double d2;
        int n2;
        int n3;
        double d3;
        int n4 = this.objects.size();
        double d4 = d3 = dArray[0][1];
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = n3 + 1; n2 < n4; ++n2) {
                d2 = dArray[n3][n2];
                if (d2 > d4) {
                    d4 = d2;
                }
                if (!(d2 < d3)) continue;
                d3 = d2;
            }
        }
        n3 = (int)Math.ceil((d4 - d3) / d);
        if (n3 < 1) {
            n3 = 1;
        }
        double[][] dArray2 = new double[2][n3];
        for (n = 0; n < n3; ++n) {
            dArray2[0][n] = d3 + (double)n * d;
            dArray2[1][n] = 0.0;
        }
        for (n = 0; n < n4; ++n) {
            for (int i = n + 1; i < n4; ++i) {
                d2 = dArray[n][i];
                n2 = (int)Math.floor((d2 - d3) / d);
                double[] dArray3 = dArray2[1];
                int n5 = n2;
                dArray3[n5] = dArray3[n5] + 1.0;
            }
        }
        return dArray2;
    }

    public Object3D closestCenter(double d, double d2, double d3, double d4) {
        Object3D object3D = null;
        double d5 = Double.MAX_VALUE;
        for (Object3D object3D2 : this.objects) {
            double d6 = object3D2.distPixelCenter(d, d2, d3);
            if (!(d6 < d5) || !(d6 > d4)) continue;
            d5 = d6;
            object3D = object3D2;
        }
        return object3D;
    }

    public Object3D closestBorder(double d, double d2, double d3, double d4) {
        Object3D object3D = null;
        double d5 = Double.MAX_VALUE;
        for (Object3D object3D2 : this.objects) {
            double d6 = object3D2.distPixelBorderUnit(d, d2, d3);
            if (!(d6 < d5) || !(d6 > d4)) continue;
            d5 = d6;
            object3D = object3D2;
        }
        return object3D;
    }

    public Object3D closestCenter(Object3D object3D, ArrayList<Object3D> arrayList) {
        Object3D object3D2 = null;
        double d = Double.MAX_VALUE;
        for (Object3D object3D3 : this.objects) {
            double d2;
            if (arrayList.contains(object3D3) || !((d2 = object3D.distCenterUnit(object3D3)) < d)) continue;
            d = d2;
            object3D2 = object3D3;
        }
        return object3D2;
    }

    public Object3D closestBorder(Object3D object3D, ArrayList<Object3D> arrayList) {
        Object3D object3D2 = null;
        double d = Double.MAX_VALUE;
        for (Object3D object3D3 : this.objects) {
            double d2;
            if (arrayList.contains(object3D3) || !((d2 = object3D.distBorderUnit(object3D3)) < d)) continue;
            d = d2;
            object3D2 = object3D3;
        }
        return object3D2;
    }

    public Object3D closestCenter(double d, double d2, double d3) {
        if (this.kdtree == null) {
            this.createKDTreeCenters();
        }
        double[] dArray = new double[]{d, d2, d3};
        KDTreeC.Item item = this.kdtree.getNearestNeighbor(dArray, 1)[0];
        return (Object3D)item.obj;
    }

    public Object3D closestCenter(Point3D point3D) {
        return this.closestCenter(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Object3D closestCenter(Object3D object3D, double d) {
        Point3D point3D = object3D.getCenterAsPoint();
        return this.closestCenter(point3D.getX(), point3D.getY(), point3D.getZ(), d);
    }

    public Object3D closestBorder(Object3D object3D, double d) {
        double d2 = Double.MAX_VALUE;
        Object3D object3D2 = null;
        for (Object3D object3D3 : this.objects) {
            double d3 = object3D.distBorderUnit(object3D3);
            if (!(d3 > d) || !(d3 < d2)) continue;
            d2 = d3;
            object3D2 = object3D3;
        }
        return object3D2;
    }

    public Object3D closestCenter(Object3D object3D, boolean bl) {
        return this.kClosestCenter(object3D, 1, bl);
    }

    public Object3D closestBorder(Object3D object3D) {
        return this.closestBorder(object3D, 0.0);
    }

    public Object3D kClosestCenter(Object3D object3D, int n, boolean bl) {
        if (this.kdtree == null) {
            this.createKDTreeCenters();
        }
        if (bl) {
            ++n;
        }
        KDTreeC.Item item = this.kdtree.getNearestNeighbor(object3D.getCenterAsArray(), n)[n - 1];
        return (Object3D)item.obj;
    }

    public ArrayList<Object3D> getObjectsWithinDistanceCenter(Object3D object3D, double d) {
        ArrayList<Object3D> arrayList = new ArrayList<Object3D>();
        for (int i = 0; i < this.objects.size(); ++i) {
            double d2 = object3D.distCenterUnit(this.objects.get(i));
            if (!(d2 <= d)) continue;
            arrayList.add(this.objects.get(i));
        }
        return arrayList;
    }

    public ArrayList<Object3D> getObjectsWithinDistanceBorder(Object3D object3D, double d) {
        ArrayList<Object3D> arrayList = new ArrayList<Object3D>();
        for (int i = 0; i < this.objects.size(); ++i) {
            double d2 = object3D.distBorderUnit(this.objects.get(i));
            if (!(d2 <= d)) continue;
            arrayList.add(this.objects.get(i));
        }
        return arrayList;
    }

    public Object3D kClosestBorder(Object3D object3D, int n) {
        ArrayList<Object3D> arrayList = new ArrayList<Object3D>();
        arrayList.add(object3D);
        if (n == 1) {
            return this.closestBorder(object3D, arrayList);
        }
        Object3D object3D2 = this.closestBorder(object3D, arrayList);
        arrayList.add(object3D2);
        for (int i = 1; object3D2 != null && i < n; ++i) {
            object3D2 = this.closestBorder(object3D, arrayList);
            if (object3D2 == null) continue;
            arrayList.add(object3D2);
        }
        return object3D2;
    }

    public Object3D secondClosestCenter(Object3D object3D, double d) {
        Point3D point3D = object3D.getCenterAsPoint();
        Object3D object3D2 = this.closestCenter(point3D.getX(), point3D.getY(), point3D.getZ(), d);
        return this.closestCenter(point3D.getX(), point3D.getY(), point3D.getZ(), object3D.distCenterUnit(object3D2));
    }

    public Object3D secondClosestCenter(Object3D object3D, boolean bl) {
        return this.kClosestCenter(object3D, 2, bl);
    }

    public Object3D closestBorder(double d, double d2, double d3) {
        Object3D object3D = null;
        double d4 = Double.MAX_VALUE;
        for (Object3D object3D2 : this.objects) {
            double d5 = object3D2.distPixelBorderUnit(d, d2, d3);
            if (!(d5 < d4)) continue;
            d4 = d5;
            object3D = object3D2;
        }
        return object3D;
    }

    public boolean shuffle(double d, Vector3D vector3D) {
        int n = this.getNbObjects();
        ArrayUtil arrayUtil = new ArrayUtil(n);
        for (int i = 0; i < n; ++i) {
            arrayUtil.addValue(i, i);
        }
        arrayUtil.randomize();
        double d2 = this.mask.getXmax() - this.mask.getXmin();
        double d3 = this.mask.getYmax() - this.mask.getYmin();
        double d4 = this.mask.getZmax() - this.mask.getZmin();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            Object3D object3D = this.getObject((int)arrayUtil.getValue(i));
            n2 = 0;
            block2: while (!bl && n2 < 1000) {
                bl = true;
                ++n2;
                double d5 = Math.random() * d2 + (double)this.mask.getXmin();
                double d6 = Math.random() * d3 + (double)this.mask.getYmin();
                double d7 = Math.random() * d4 + (double)this.mask.getZmin();
                object3D.setNewCenter(d5, d6, d7 + 1.0);
                if (!this.mask.includes(object3D)) {
                    bl = false;
                }
                if (!bl) continue;
                for (Object3D object3D2 : this.objects) {
                    double d8;
                    if (object3D2.equals(object3D) || !((d8 = object3D.pcColoc(object3D2)) > 0.0)) continue;
                    bl = false;
                    continue block2;
                }
            }
            if (n2 == 1000) break;
            if (d == 0.0 || vector3D == null) continue;
            ((Object3DVoxels)object3D).rotate(vector3D, d);
        }
        return n2 != 1000;
    }

    int[] k_Means(int n) {
        int n2;
        int n3 = this.objects.size();
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = 0;
        }
        Point3D[] point3DArray = new Point3D[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int[] nArray2 = new int[n];
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        double d6 = -1.7976931348623157E308;
        for (Object3D object3D : this.objects) {
            if (object3D.getCenterX() < d3) {
                d3 = object3D.getCenterX();
            }
            if (object3D.getCenterY() < d2) {
                d2 = object3D.getCenterY();
            }
            if (object3D.getCenterZ() < d) {
                d = object3D.getCenterZ();
            }
            if (object3D.getCenterX() > d6) {
                d6 = object3D.getCenterX();
            }
            if (object3D.getCenterY() > d5) {
                d5 = object3D.getCenterY();
            }
            if (!(object3D.getCenterZ() > d4)) continue;
            d4 = object3D.getCenterZ();
        }
        double d7 = (d6 - d3) / ((double)n - 1.0);
        double d8 = (d5 - d2) / ((double)n - 1.0);
        double d9 = (d4 - d) / ((double)n - 1.0);
        for (n2 = 0; n2 < n; ++n2) {
            point3DArray[n2] = new Point3D(d3 + d7 * (double)n2, d2 + (double)n2 * d8, d + (double)n2 * d9);
        }
        n2 = 1;
        while (n2 != 0) {
            int n4;
            int n5;
            Object3D object3D;
            n2 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                object3D = this.objects.get(n5);
                n4 = 0;
                double d10 = object3D.distPixelCenter(point3DArray[0].getX(), point3DArray[0].getY(), point3DArray[0].getZ());
                for (int i = 1; i < n; ++i) {
                    double d11 = object3D.distPixelCenter(point3DArray[i].getX(), point3DArray[i].getY(), point3DArray[i].getZ());
                    if (!(d11 < d10)) continue;
                    d10 = d11;
                    n4 = i;
                }
                if (n4 == nArray[n5]) continue;
                n2 = 1;
                nArray[n5] = n4;
            }
            for (n5 = 0; n5 < n; ++n5) {
                dArray[n] = 0.0;
                dArray2[n] = 0.0;
                dArray3[n] = 0.0;
                nArray2[n] = 0;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                object3D = this.objects.get(n5);
                int n6 = n4 = nArray[n5];
                dArray[n6] = dArray[n6] + object3D.getCenterX();
                int n7 = n4;
                dArray2[n7] = dArray2[n7] + object3D.getCenterY();
                int n8 = n4;
                dArray3[n8] = dArray3[n8] + object3D.getCenterZ();
                int n9 = n4;
                nArray2[n9] = nArray2[n9] + 1;
            }
            for (n5 = 0; n5 < n; ++n5) {
                point3DArray[n5] = new Point3D(dArray[n5] / (double)nArray2[n5], dArray2[n5] / (double)nArray2[n5], dArray3[n5] / (double)nArray2[n5]);
            }
        }
        return nArray;
    }

    public ArrayList<double[]> getMeasureCentroid() {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (Object3D object3D : this.objects) {
            double[] dArray = new double[]{object3D.getCenterX(), object3D.getCenterY(), object3D.getCenterZ()};
            arrayList.add(dArray);
        }
        return arrayList;
    }

    public ArrayList<double[]> getMeasuresShape() {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (Object3D object3D : this.objects) {
            double[] dArray = new double[]{object3D.getCompactness(), object3D.getFeret(), object3D.getMainElongation(), object3D.getRatioEllipsoid(), object3D.getDistCenterMean(), object3D.getDistCenterSigma()};
            arrayList.add(dArray);
        }
        return arrayList;
    }

    private void addImagePlus(ImagePlus imagePlus) {
        this.addImage(imagePlus);
    }
}

