/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.ImagePlus;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.distanceMap3d.CleanUpLocalThickness;
import mcib3d.image3d.distanceMap3d.DistanceRidge;
import mcib3d.image3d.distanceMap3d.EdtByte;
import mcib3d.image3d.distanceMap3d.EdtByteInv;
import mcib3d.image3d.distanceMap3d.EdtFloat;
import mcib3d.image3d.distanceMap3d.EdtFloatInv;
import mcib3d.image3d.distanceMap3d.EdtShort;
import mcib3d.image3d.distanceMap3d.EdtShortInv;
import mcib3d.image3d.distanceMap3d.EdtShortLabel;
import mcib3d.image3d.distanceMap3d.LocalThickness;
import mcib3d.utils.ThreadUtil;
import mcib3d.utils.exceptionPrinter;

public class EDT {
    public static ImageFloat run(ImageHandler imageHandler, float f, float f2, float f3, boolean bl, int n) {
        if (n <= 0) {
            n = ThreadUtil.getNbCpus();
        }
        try {
            if (imageHandler instanceof ImageShort) {
                return bl ? new EdtShortInv().run((ImageShort)imageHandler, (int)((double)f + 0.5), f2, f3, n) : new EdtShort().run((ImageShort)imageHandler, (int)((double)f + 0.5), f2, f3, n);
            }
            if (imageHandler instanceof ImageByte) {
                return bl ? new EdtByteInv().run((ImageByte)imageHandler, (int)((double)f + 0.5), f2, f3, n) : new EdtByte().run((ImageByte)imageHandler, (int)((double)f + 0.5), f2, f3, n);
            }
            if (imageHandler instanceof ImageFloat) {
                return bl ? new EdtFloatInv().run((ImageFloat)imageHandler, f, f2, f3, n) : new EdtFloat().run((ImageFloat)imageHandler, f, f2, f3, n);
            }
        }
        catch (Exception exception) {
            exceptionPrinter.print(exception, "distance Map ", false);
            return null;
        }
        return null;
    }

    public static ImageFloat run(ImageHandler imageHandler, float f, boolean bl, int n) {
        return EDT.run(imageHandler, f, (float)imageHandler.getScaleXY(), (float)imageHandler.getScaleZ(), bl, n);
    }

    public static ImageFloat run_includeInside(ImageHandler imageHandler, int n, float f, float f2, boolean bl, int n2) {
        ImageFloat imageFloat = EDT.run(imageHandler, n, f, f2, true, n2);
        ImageFloat imageFloat2 = EDT.run(imageHandler, n, f, f2, false, n2);
        if (!bl) {
            for (int i = 0; i < imageFloat.sizeZ; ++i) {
                for (int j = 0; j < imageFloat.sizeXY; ++j) {
                    if (imageFloat2.pixels[i][j] == 0.0f) continue;
                    imageFloat.pixels[i][j] = -imageFloat2.pixels[i][j];
                }
            }
        } else {
            for (int i = 0; i < imageFloat.sizeZ; ++i) {
                for (int j = 0; j < imageFloat.sizeXY; ++j) {
                    if (imageFloat2.pixels[i][j] == 0.0f) continue;
                    imageFloat.pixels[i][j] = imageFloat2.pixels[i][j];
                }
            }
        }
        return imageFloat;
    }

    public static ImageFloat run_includeInside(ImageHandler imageHandler, int n, boolean bl, int n2) {
        return EDT.run_includeInside(imageHandler, n, (float)imageHandler.getScaleXY(), (float)imageHandler.getScaleZ(), bl, n2);
    }

    public static ImageFloat localThickness(ImageHandler imageHandler, ImageInt imageInt, float f, float f2, float f3, boolean bl, int n) {
        Object object;
        ImageFloat imageFloat = EDT.run(imageHandler, f, f2, f3, bl, n);
        if (imageInt != null) {
            imageFloat.eraseOutsideMask(imageInt);
        }
        DistanceRidge distanceRidge = new DistanceRidge();
        ImagePlus imagePlus = distanceRidge.run(imageFloat.getImagePlus(), f2, f3, n);
        if (imageInt != null) {
            object = ImageHandler.wrap(imagePlus);
            ((ImageHandler)object).eraseOutsideMask(imageInt);
        }
        imageFloat.closeImagePlus();
        object = new LocalThickness();
        ((LocalThickness)object).run(imagePlus, f2, f3, n);
        CleanUpLocalThickness cleanUpLocalThickness = new CleanUpLocalThickness();
        ImagePlus imagePlus2 = cleanUpLocalThickness.run(imagePlus);
        imagePlus.flush();
        return (ImageFloat)ImageFloat.wrap(imagePlus2);
    }

    public static ImageFloat localThickness(ImageHandler imageHandler, ImageInt imageInt, float f, boolean bl, int n) {
        return EDT.localThickness(imageHandler, imageInt, f, (float)imageHandler.getScaleXY(), (float)imageHandler.getScaleZ(), bl, n);
    }

    public static ImageFloat runEdtLabel(ImageInt imageInt, float f, float f2, int n) {
        try {
            ImageShort imageShort = !(imageInt instanceof ImageShort) ? new ImageShort(imageInt, false) : (ImageShort)imageInt;
            return new EdtShortLabel().run(imageShort, f, f2, n);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

