/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.Barrier;
import edu.emory.mathcs.jplasma.tdouble.Dallocate;
import edu.emory.mathcs.jplasma.tdouble.Dauxiliary;
import edu.emory.mathcs.jplasma.tdouble.DbdlConvert;
import edu.emory.mathcs.jplasma.tdouble.Dcommon;
import edu.emory.mathcs.jplasma.tdouble.Pdgetrf;
import java.util.concurrent.locks.Lock;

class Dgetrf {
    private Dgetrf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int plasma_DGETRF(int n, int n2, double[] dArray, int n3, int n4, double[] dArray2, int n5, int[] nArray, int n6) {
        int n7;
        double[] dArray3;
        int n8;
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_DGETRF", "PLASMA not initialized");
            return -1;
        }
        if (n < 0) {
            Dauxiliary.plasma_error("plasma_DGETRF", "illegal value of M");
            return -4;
        }
        if (n2 < 0) {
            Dauxiliary.plasma_error("plasma_DGETRF", "illegal value of N");
            return -4;
        }
        if (n4 < Math.max(1, n)) {
            Dauxiliary.plasma_error("plasma_DGETRF", "illegal value of LDA");
            return -4;
        }
        if (Math.min(n, n2) == 0) {
            return 0;
        }
        int n9 = Dauxiliary.plasma_tune(3, n, n2, 0);
        if (n9 != 0) {
            Dauxiliary.plasma_error("plasma_DGETRF", "plasma_tune() failed");
            return n9;
        }
        int n10 = Dcommon.plasma_cntrl.NB;
        int n11 = n % n10 == 0 ? n / n10 : n / n10 + 1;
        int n12 = n11 * (n8 = n2 % n10 == 0 ? n2 / n10 : n2 / n10 + 1);
        if (Dcommon.plasma_cntrl.progress_size_elems < n12) {
            n9 = Dallocate.plasma_free_aux_progress();
            if (n9 != 0) {
                Dauxiliary.plasma_error("plasma_DGETRF", "plasma_free_aux_progress() failed");
            }
            if ((n9 = Dallocate.plasma_alloc_aux_progress(n12)) != 0) {
                Dauxiliary.plasma_error("plasma_DGETRF", "plasma_alloc_aux_progress() failed");
                return n9;
            }
        }
        double[] dArray4 = dArray3 = Dcommon.plasma_aux.bdl_mem;
        int n13 = 0;
        double[] dArray5 = dArray3;
        int n14 = n11 * n8 * Dcommon.plasma_cntrl.NBNBSIZE;
        n12 = n14 + n11 * n8 * Dcommon.plasma_cntrl.IBNBSIZE;
        if (Dcommon.plasma_cntrl.bdl_size_elems < n12) {
            n9 = Dallocate.plasma_free_aux_bdl();
            if (n9 != 0) {
                Dauxiliary.plasma_error("plasma_DGETRF", "plasma_free_aux_bdl() failed");
                return n9;
            }
            n9 = Dallocate.plasma_alloc_aux_bdl(n12);
            if (n9 != 0) {
                Dauxiliary.plasma_error("plasma_DGETRF", "plasma_alloc_aux_bdl() failed");
                return n9;
            }
            dArray4 = dArray3 = Dcommon.plasma_aux.bdl_mem;
            n13 = 0;
            dArray5 = dArray3;
            n14 = n11 * n8 * Dcommon.plasma_cntrl.NBNBSIZE;
        }
        Dcommon.plasma_args.F77 = dArray;
        Dcommon.plasma_args.F77_offset = n3;
        Dcommon.plasma_args.A = dArray4;
        Dcommon.plasma_args.A_offset = n13;
        Dcommon.plasma_args.M = n;
        Dcommon.plasma_args.N = n2;
        Dcommon.plasma_args.LDA = n4;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.MT = n11;
        Dcommon.plasma_args.NT = n8;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        Lock lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 9;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        DbdlConvert.plasma_lapack_to_bdl(Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        n12 = n6 + n8 * n8 * Dcommon.plasma_cntrl.NB;
        for (n7 = n6; n7 < n12; ++n7) {
            nArray[n7] = 0;
        }
        n12 = n14 + n8 * n8 * Dcommon.plasma_cntrl.IBNBSIZE;
        for (n7 = n14; n7 < n12; ++n7) {
            dArray5[n7] = 0.0;
        }
        Dcommon.plasma_args.M = n;
        Dcommon.plasma_args.N = n2;
        Dcommon.plasma_args.A = dArray4;
        Dcommon.plasma_args.A_offset = n13;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        Dcommon.plasma_args.IBNBSIZE = Dcommon.plasma_cntrl.IBNBSIZE;
        Dcommon.plasma_args.IB = Dcommon.plasma_cntrl.IB;
        Dcommon.plasma_args.MT = n11;
        Dcommon.plasma_args.NT = n8;
        Dcommon.plasma_args.L = dArray5;
        Dcommon.plasma_args.L_offset = n14;
        Dcommon.plasma_args.IPIV = nArray;
        Dcommon.plasma_args.IPIV_offset = n6;
        Dauxiliary.plasma_clear_aux_progress(n11 * n8, -1);
        lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 7;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        Pdgetrf.plasma_pDGETRF(Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.IBNBSIZE, Dcommon.plasma_args.IB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.L, Dcommon.plasma_args.L_offset, Dcommon.plasma_args.IPIV, Dcommon.plasma_args.IPIV_offset, Dcommon.plasma_args.INFO, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        System.arraycopy(dArray5, n14, dArray2, n5, n11 * n8 * Dcommon.plasma_cntrl.IBNBSIZE);
        Dcommon.plasma_args.A = dArray4;
        Dcommon.plasma_args.A_offset = n13;
        Dcommon.plasma_args.F77 = dArray;
        Dcommon.plasma_args.F77_offset = n3;
        Dcommon.plasma_args.M = n;
        Dcommon.plasma_args.N = n2;
        Dcommon.plasma_args.LDA = n4;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.MT = n11;
        Dcommon.plasma_args.NT = n8;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 10;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        DbdlConvert.plasma_bdl_to_lapack(Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        return Dcommon.plasma_args.INFO.val;
    }
}

