/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_happly;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ipvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_pvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_qr;
import edu.emory.mathcs.csparsej.tdouble.Dcs_sqr;
import edu.emory.mathcs.csparsej.tdouble.Dcs_usolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_utsolve;

public class SparseDoubleQRDecomposition {
    private Dcs_common.Dcss S;
    private Dcs_common.Dcsn N;
    private DoubleMatrix2D R;
    private DoubleMatrix2D V;
    private int m;
    private int n;
    private boolean rcMatrix = false;

    public SparseDoubleQRDecomposition(DoubleMatrix2D A, int order) {
        Dcs_common.Dcs dcs;
        DoubleProperty.DEFAULT.checkSparse(A);
        if (order < 0 || order > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        this.m = A.rows();
        this.n = A.columns();
        if (A instanceof SparseRCDoubleMatrix2D) {
            this.rcMatrix = true;
            dcs = this.m >= this.n ? ((SparseRCDoubleMatrix2D)A).getColumnCompressed().elements() : ((SparseRCDoubleMatrix2D)A).getColumnCompressed().getTranspose().elements();
        } else {
            dcs = this.m >= this.n ? (Dcs_common.Dcs)A.elements() : ((SparseCCDoubleMatrix2D)A).getTranspose().elements();
        }
        this.S = Dcs_sqr.cs_sqr((int)order, (Dcs_common.Dcs)dcs, (boolean)true);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = Dcs_qr.cs_qr((Dcs_common.Dcs)dcs, (Dcs_common.Dcss)this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_qr()");
        }
    }

    public DoubleMatrix2D getV() {
        if (this.V == null) {
            this.V = new SparseCCDoubleMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.V = ((SparseCCDoubleMatrix2D)this.V).getRowCompressed();
            }
        }
        return this.V.copy();
    }

    public double[] getBeta() {
        if (this.N.B == null) {
            return null;
        }
        double[] beta = new double[this.N.B.length];
        System.arraycopy(this.N.B, 0, beta, 0, this.N.B.length);
        return beta;
    }

    public DoubleMatrix2D getR() {
        if (this.R == null) {
            this.R = new SparseCCDoubleMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCDoubleMatrix2D)this.R).getRowCompressed();
            }
        }
        return this.R.copy();
    }

    public Dcs_common.Dcss getSymbolicAnalysis() {
        Dcs_common.Dcss S2 = new Dcs_common.Dcss();
        S2.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        S2.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        S2.lnz = this.S.lnz;
        S2.m2 = this.S.m2;
        S2.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        S2.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        S2.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        S2.unz = this.S.unz;
        return S2;
    }

    public boolean hasFullRank() {
        if (this.R == null) {
            this.R = new SparseCCDoubleMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCDoubleMatrix2D)this.R).getRowCompressed();
            }
        }
        int mn = Math.min(this.m, this.n);
        int j = 0;
        while (j < mn) {
            if (this.R.getQuick(j, j) == 0.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void solve(DoubleMatrix1D b) {
        if (b.size() != (long)Math.max(this.m, this.n)) {
            throw new IllegalArgumentException("The size b must be equal to max(A.rows(), A.columns()).");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        double[] x = b.isView() ? (double[])b.copy().elements() : (double[])b.elements();
        if (this.m >= this.n) {
            double[] y = new double[this.S != null ? this.S.m2 : 1];
            Dcs_ipvec.cs_ipvec((int[])this.S.pinv, (double[])x, (double[])y, (int)this.m);
            int k = 0;
            while (k < this.n) {
                Dcs_happly.cs_happly((Dcs_common.Dcs)this.N.L, (int)k, (double)this.N.B[k], (double[])y);
                ++k;
            }
            Dcs_usolve.cs_usolve((Dcs_common.Dcs)this.N.U, (double[])y);
            Dcs_ipvec.cs_ipvec((int[])this.S.q, (double[])y, (double[])x, (int)this.n);
        } else {
            double[] y = new double[this.S != null ? this.S.m2 : 1];
            Dcs_pvec.cs_pvec((int[])this.S.q, (double[])x, (double[])y, (int)this.m);
            Dcs_utsolve.cs_utsolve((Dcs_common.Dcs)this.N.U, (double[])y);
            int k = this.m - 1;
            while (k >= 0) {
                Dcs_happly.cs_happly((Dcs_common.Dcs)this.N.L, (int)k, (double)this.N.B[k], (double[])y);
                --k;
            }
            Dcs_pvec.cs_pvec((int[])this.S.pinv, (double[])y, (double[])x, (int)this.n);
        }
    }
}

