/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongLongProcedure;
import cern.colt.map.tlong.AbstractLongLongMap;
import cern.colt.map.tlong.OpenLongLongHashMap;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SelectedSparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCMLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseRCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseRCMLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultSecond;
import java.io.IOException;

public class SparseLongMatrix2D
extends LongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongLongMap elements;

    public SparseLongMatrix2D(long[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseLongMatrix2D(int rows, int columns) {
        this(rows, columns, rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseLongMatrix2D(int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongLongHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public SparseLongMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, long value) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongLongHashMap(rowIndexes.length);
        this.insert(rowIndexes, columnIndexes, value);
    }

    public SparseLongMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, long[] values) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongLongHashMap(rowIndexes.length);
        this.insert(rowIndexes, columnIndexes, values);
    }

    public SparseLongMatrix2D(MatrixVectorReader reader) throws IOException {
        block11: {
            long[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block10: {
                MatrixSize size;
                block9: {
                    info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                    if (info.isPattern()) {
                        throw new UnsupportedOperationException("Pattern matrices are not supported");
                    }
                    if (info.isDense()) {
                        throw new UnsupportedOperationException("Dense matrices are not supported");
                    }
                    if (info.isComplex()) {
                        throw new UnsupportedOperationException("Complex matrices are not supported");
                    }
                    size = reader.readMatrixSize(info);
                    try {
                        this.setUp(size.numRows(), size.numColumns());
                    }
                    catch (IllegalArgumentException exc) {
                        if ("matrix too large".equals(exc.getMessage())) break block9;
                        throw exc;
                    }
                }
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new long[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                this.elements = info.isSymmetric() || info.isSkewSymmetric() ? new OpenLongLongHashMap(2 * rowIndexes.length) : new OpenLongLongHashMap(rowIndexes.length);
                this.insert(rowIndexes, columnIndexes, values);
                if (!info.isSymmetric()) break block10;
                int i = 0;
                while (i < numEntries) {
                    if (rowIndexes[i] != columnIndexes[i]) {
                        this.set(columnIndexes[i], rowIndexes[i], values[i]);
                    }
                    ++i;
                }
                break block11;
            }
            if (!info.isSkewSymmetric()) break block11;
            int i = 0;
            while (i < numEntries) {
                if (rowIndexes[i] != columnIndexes[i]) {
                    this.set(columnIndexes[i], rowIndexes[i], -values[i]);
                }
                ++i;
            }
        }
    }

    protected SparseLongMatrix2D(int rows, int columns, AbstractLongLongMap elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        block2: {
            try {
                this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public LongMatrix2D assign(LongFunction function) {
        if (this.isNoView && function instanceof LongMult) {
            this.elements.assign(function);
        } else {
            super.assign(function);
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(long value) {
        if (this.isNoView && value == 0L) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(LongMatrix2D source) {
        if (!(source instanceof SparseLongMatrix2D)) {
            return super.assign(source);
        }
        SparseLongMatrix2D other = (SparseLongMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.isNoView && other.isNoView) {
            this.elements.assign(other.elements);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public LongMatrix2D assign(final LongMatrix2D y, LongLongFunction function) {
        if (!this.isNoView) {
            return super.assign(y, function);
        }
        this.checkShape(y);
        if (function instanceof LongPlusMultSecond) {
            final long alpha = ((LongPlusMultSecond)function).multiplicator;
            if (alpha == 0L) {
                return this;
            }
            y.forEachNonZero(new IntIntLongFunction(){

                @Override
                public long apply(int i, int j, long value) {
                    SparseLongMatrix2D.this.setQuick(i, j, SparseLongMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
        } else if (function == LongFunctions.mult) {
            this.elements.forEachPair(new LongLongProcedure(){

                @Override
                public boolean apply(long key, long value) {
                    int j;
                    int i = (int)(key / (long)SparseLongMatrix2D.this.columns);
                    long r = value * y.getQuick(i, j = (int)(key % (long)SparseLongMatrix2D.this.columns));
                    if (r != value) {
                        SparseLongMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else if (function == LongFunctions.div) {
            this.elements.forEachPair(new LongLongProcedure(){

                @Override
                public boolean apply(long key, long value) {
                    int j;
                    int i = (int)(key / (long)SparseLongMatrix2D.this.columns);
                    long r = value / y.getQuick(i, j = (int)(key % (long)SparseLongMatrix2D.this.columns));
                    if (r != value) {
                        SparseLongMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else {
            super.assign(y, function);
        }
        return this;
    }

    public SparseLongMatrix2D assign(int[] rowIndexes, int[] columnIndexes, long value, LongLongFunction function) {
        int size = rowIndexes.length;
        if (function == LongFunctions.plus) {
            int i = 0;
            while (i < size) {
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                long elem = this.elements.get(index);
                long sum = elem + value;
                if (sum != 0L) {
                    this.elements.put(index, sum);
                } else {
                    this.elements.removeKey(index);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                long elem = this.elements.get(index);
                long result = function.apply(elem, value);
                if (result != 0L) {
                    this.elements.put(index, result);
                } else {
                    this.elements.removeKey(index);
                }
                ++i;
            }
        }
        return this;
    }

    public SparseLongMatrix2D assign(int[] rowIndexes, int[] columnIndexes, long[] values, LongLongFunction function) {
        int size = rowIndexes.length;
        if (function == LongFunctions.plus) {
            int i = 0;
            while (i < size) {
                long value = values[i];
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                long elem = this.elements.get(index);
                if ((value += elem) != 0L) {
                    this.elements.put(index, value);
                } else {
                    this.elements.removeKey(index);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                long value = values[i];
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                long elem = this.elements.get(index);
                value = function.apply(elem, value);
                if (value != 0L) {
                    this.elements.put(index, value);
                } else {
                    this.elements.removeKey(index);
                }
                ++i;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public SparseCCLongMatrix2D getColumnCompressed(boolean sortRowIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        long[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        int k = 0;
        while (k < nnz) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
            ++k;
        }
        return new SparseCCLongMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, false, sortRowIndexes);
    }

    public SparseCCMLongMatrix2D getColumnCompressedModified() {
        SparseCCMLongMatrix2D A = new SparseCCMLongMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        long[] values = this.elements.values().elements();
        int i = 0;
        while (i < nnz) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
            ++i;
        }
        return A;
    }

    public SparseRCLongMatrix2D getRowCompressed(boolean sortColumnIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        long[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        int k = 0;
        while (k < nnz) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
            ++k;
        }
        return new SparseRCLongMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, false, sortColumnIndexes);
    }

    public SparseRCMLongMatrix2D getRowCompressedModified() {
        SparseRCMLongMatrix2D A = new SparseRCMLongMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        long[] values = this.elements.values().elements();
        int i = 0;
        while (i < nnz) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
            ++i;
        }
        return A;
    }

    @Override
    public AbstractLongLongMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public LongMatrix2D forEachNonZero(final IntIntLongFunction function) {
        if (this.isNoView) {
            this.elements.forEachPair(new LongLongProcedure(){

                @Override
                public boolean apply(long key, long value) {
                    int j;
                    int i = (int)(key / (long)SparseLongMatrix2D.this.columns);
                    long r = function.apply(i, j = (int)(key % (long)SparseLongMatrix2D.this.columns), value);
                    if (r != value) {
                        SparseLongMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(function);
        }
        return this;
    }

    @Override
    public synchronized long getQuick(int row, int column) {
        return this.elements.get((long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
    }

    @Override
    public long index(int row, int column) {
        return (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return new SparseLongMatrix2D(rows, columns);
    }

    @Override
    public LongMatrix1D like1D(int size) {
        return new SparseLongMatrix1D(size);
    }

    @Override
    public synchronized void setQuick(int row, int column, long value) {
        long index = (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value == 0L) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                long elem = this.getQuick(r, c);
                if (elem != 0L) {
                    builder.append('(').append(r).append(',').append(c).append(')').append('\t').append(elem).append('\n');
                }
                ++c;
            }
            ++r;
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public LongMatrix1D vectorize() {
        SparseLongMatrix1D v = new SparseLongMatrix1D((int)this.size());
        int idx = 0;
        int c = 0;
        while (c < this.columns) {
            int r = 0;
            while (r < this.rows) {
                long elem = this.getQuick(r, c);
                v.setQuick(idx++, elem);
                ++r;
            }
            ++c;
        }
        return v;
    }

    @Override
    public LongMatrix1D zMult(LongMatrix1D y, LongMatrix1D z, final long alpha, long beta, final boolean transposeA) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseLongMatrix1D(rowsA);
        }
        if (!(this.isNoView && y instanceof DenseLongMatrix1D && z instanceof DenseLongMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!ignore) {
            z.assign(LongFunctions.mult(beta));
        }
        DenseLongMatrix1D zz = (DenseLongMatrix1D)z;
        final long[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)z.index(0);
        DenseLongMatrix1D yy = (DenseLongMatrix1D)y;
        final long[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)y.index(0);
        if (elementsY == null || elementsZ == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new LongLongProcedure(){

            @Override
            public boolean apply(long key, long value) {
                int i = (int)(key / (long)SparseLongMatrix2D.this.columns);
                int j = (int)(key % (long)SparseLongMatrix2D.this.columns);
                if (transposeA) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * value * elementsY[zeroY + strideY * j];
                return true;
            }
        });
        return z;
    }

    @Override
    public LongMatrix2D zMult(LongMatrix2D B, LongMatrix2D C, final long alpha, long beta, final boolean transposeA, boolean transposeB) {
        boolean ignore;
        if (!this.isNoView) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (transposeB) {
            B = B.viewDice();
        }
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int p = B.columns();
        boolean bl = ignore = C == null;
        if (C == null) {
            C = new DenseLongMatrix2D(rowsA, p);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore) {
            C.assign(LongFunctions.mult(beta));
        }
        final LongMatrix1D[] Brows = new LongMatrix1D[columnsA];
        int i = columnsA;
        while (--i >= 0) {
            Brows[i] = B.viewRow(i);
        }
        final LongMatrix1D[] Crows = new LongMatrix1D[rowsA];
        int i2 = rowsA;
        while (--i2 >= 0) {
            Crows[i2] = C.viewRow(i2);
        }
        final LongPlusMultSecond fun = LongPlusMultSecond.plusMult(0L);
        this.elements.forEachPair(new LongLongProcedure(){

            @Override
            public boolean apply(long key, long value) {
                int i = (int)(key / (long)SparseLongMatrix2D.this.columns);
                int j = (int)(key % (long)SparseLongMatrix2D.this.columns);
                fun.multiplicator = value * alpha;
                if (!transposeA) {
                    Crows[i].assign(Brows[j], fun);
                } else {
                    Crows[j].assign(Brows[i], fun);
                }
                return true;
            }
        });
        return C;
    }

    private void insert(int[] rowIndexes, int[] columnIndexes, long value) {
        int size = rowIndexes.length;
        int i = 0;
        while (i < size) {
            long row = rowIndexes[i];
            long column = columnIndexes[i];
            if (row >= (long)this.rows || column >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
            }
            if (value != 0L) {
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                long elem = this.elements.get(index);
                if (elem == 0L) {
                    this.elements.put(index, value);
                } else {
                    long sum = elem + value;
                    if (sum == 0L) {
                        this.elements.removeKey(index);
                    } else {
                        this.elements.put(index, sum);
                    }
                }
            }
            ++i;
        }
    }

    private void insert(int[] rowIndexes, int[] columnIndexes, long[] values) {
        int size = rowIndexes.length;
        int i = 0;
        while (i < size) {
            long value = values[i];
            long row = rowIndexes[i];
            long column = columnIndexes[i];
            if (row >= (long)this.rows || column >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
            }
            if (value != 0L) {
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                long elem = this.elements.get(index);
                if (elem == 0L) {
                    this.elements.put(index, value);
                } else {
                    long sum = elem + value;
                    if (sum == 0L) {
                        this.elements.removeKey(index);
                    } else {
                        this.elements.put(index, sum);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    protected boolean haveSharedCellsRaw(LongMatrix2D other) {
        if (other instanceof SelectedSparseLongMatrix2D) {
            SelectedSparseLongMatrix2D otherMatrix = (SelectedSparseLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseLongMatrix2D) {
            SparseLongMatrix2D otherMatrix = (SparseLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected LongMatrix1D like1D(int size, int offset, int stride) {
        return new SparseLongMatrix1D(size, this.elements, offset, stride);
    }

    @Override
    protected LongMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseLongMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

