/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.map.tobject.AbstractLongObjectMap;
import cern.colt.map.tobject.OpenLongObjectHashMap;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.SelectedSparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix3D;

public class SparseObjectMatrix1D
extends ObjectMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongObjectMap elements;

    public SparseObjectMatrix1D(Object[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseObjectMatrix1D(int size) {
        this(size, size / 1000, 0.2, 0.5);
    }

    public SparseObjectMatrix1D(int size, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(size);
        this.elements = new OpenLongObjectHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseObjectMatrix1D(int size, AbstractLongObjectMap elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public AbstractLongObjectMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized Object getQuick(int index) {
        return this.elements.get((long)this.zero + (long)index * (long)this.stride);
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix1D other) {
        if (other instanceof SelectedSparseObjectMatrix1D) {
            SelectedSparseObjectMatrix1D otherMatrix = (SelectedSparseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseObjectMatrix1D) {
            SparseObjectMatrix1D otherMatrix = (SparseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return (long)this.zero + (long)rank * (long)this.stride;
    }

    @Override
    public ObjectMatrix1D like(int size) {
        return new SparseObjectMatrix1D(size);
    }

    @Override
    public ObjectMatrix2D like2D(int rows, int columns) {
        return new SparseObjectMatrix2D(rows, columns);
    }

    @Override
    public ObjectMatrix2D reshape(int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseObjectMatrix2D M = new SparseObjectMatrix2D(rows, columns);
        int idx = 0;
        int c = 0;
        while (c < columns) {
            int r = 0;
            while (r < rows) {
                Object elem;
                if ((elem = this.getQuick(idx++)) != null) {
                    ((ObjectMatrix2D)M).setQuick(r, c, elem);
                }
                ++r;
            }
            ++c;
        }
        return M;
    }

    @Override
    public ObjectMatrix3D reshape(int slices, int rows, int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseObjectMatrix3D M = new SparseObjectMatrix3D(slices, rows, columns);
        int idx = 0;
        int s = 0;
        while (s < slices) {
            int c = 0;
            while (c < columns) {
                int r = 0;
                while (r < rows) {
                    Object elem;
                    if ((elem = this.getQuick(idx++)) != null) {
                        ((ObjectMatrix3D)M).setQuick(s, r, c, elem);
                    }
                    ++r;
                }
                ++c;
            }
            ++s;
        }
        return M;
    }

    @Override
    public synchronized void setQuick(int index, Object value) {
        long i = (long)this.zero + (long)index * (long)this.stride;
        if (value == null) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    protected ObjectMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseObjectMatrix1D(this.elements, offsets);
    }
}

