/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.QRDecomposition;
import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.linsol.LinearSolverAbstract;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SpecializedOps;

public class LinearSolverQr
extends LinearSolverAbstract {
    private QRDecomposition decomposer;
    protected int maxRows = -1;
    protected int maxCols = -1;
    protected DenseMatrix64F Q;
    protected DenseMatrix64F R;
    private DenseMatrix64F Y;
    private DenseMatrix64F Z;

    public LinearSolverQr(QRDecomposition qRDecomposition) {
        this.decomposer = qRDecomposition;
    }

    public void setMaxSize(int n, int n2) {
        this.maxRows = n;
        this.maxCols = n2;
        this.Q = new DenseMatrix64F(n, n);
        this.R = new DenseMatrix64F(n, n2);
        this.Y = new DenseMatrix64F(n, 1);
        this.Z = new DenseMatrix64F(n, 1);
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows > this.maxRows || denseMatrix64F.numCols > this.maxCols) {
            this.setMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        }
        this._setA(denseMatrix64F);
        if (!this.decomposer.decompose(denseMatrix64F)) {
            return false;
        }
        this.Q.reshape(this.numRows, this.numRows, false);
        this.R.reshape(this.numRows, this.numCols, false);
        this.decomposer.getQ(this.Q, false);
        this.decomposer.getR(this.R, false);
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(true, this.R);
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int n = denseMatrix64F.numCols;
        this.Y.reshape(this.numRows, 1, false);
        this.Z.reshape(this.numRows, 1, false);
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                this.Y.data[n2] = denseMatrix64F.get(n2, i);
            }
            CommonOps.multTransA(this.Q, this.Y, this.Z);
            TriangularSolver.solveU(this.R.data, this.Z.data, this.numCols);
            for (n2 = 0; n2 < this.numCols; ++n2) {
                denseMatrix64F2.set(n2, i, this.Z.data[n2]);
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

