package plugins.lagache.colocalizationstudio;


import java.awt.geom.Point2D;


import java.util.ArrayList;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import icy.gui.frame.progress.AnnounceFrame;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.system.profile.Chronometer;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.lagache.sodasuite.*;

// Colocalisation with Ripley function K
// Significant 

public class ColocalizationStudio_Correlation extends Plugin implements Block, PluginBundled {	
				
	
	
	VarROIArray	ROIs		= new VarROIArray("Analysis ROIs");
	
	VarSequence input_sequence1 = new VarSequence("Input sequence 1", null);
	VarSequence input_sequence2 = new VarSequence("Input sequence 2", null);
	
	VarROIArray	ROIs_M1		= new VarROIArray("List of detections 1 (ROIs)");
	VarROIArray	ROIs_M2		= new VarROIArray("List of detections 2 (ROIs)");
	
			
	
	VarBoolean PCC = new VarBoolean("Pearson", true);
	VarBoolean M = new VarBoolean("Manders ", true);
	VarInteger MC = new VarInteger("Number of MC simulations", 100);	
	VarBoolean Overlap = new VarBoolean("Overlap (# with overlap>T) ", true);
	VarDouble threshold = new VarDouble("T",0.5);
	
	
	VarWorkbook                book              = new VarWorkbook("Workbook", (Workbook) null);
	
	ArrayList<ROI> list_roi = new ArrayList<ROI>();	
	@Override
	public void declareInput(VarList inputMap)
	{		
		inputMap.add("Input Sequence 1", input_sequence1);
		inputMap.add("Input Sequence 2", input_sequence2);
		inputMap.add("Analysis ROIs", ROIs);
		inputMap.add("List of detections 1 (ROIs)", ROIs_M1);
		inputMap.add("List of detections 2 (ROIs)", ROIs_M2);
		inputMap.add("Pearson correlation", PCC);		
		inputMap.add("Manders overlap", M);
		inputMap.add("Overlap (# spots with overlap > T)", Overlap);
		inputMap.add("Overlap threshold (T)", threshold);
		inputMap.add("nb. Monte-Carlo simulations (p-value computation)", MC);						
		}

	@Override
	public void declareOutput(VarList outputMap)
	{		
		outputMap.add("Workbook", book);		
	}
	
	@Override
	public String getMainPluginClassName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void run() {
		//initialisation du workbook (1 ligne per time)
		//initialisation excel
		// cr�aton du workbook
		if (book.getValue() == null) {
			book.setValue(new HSSFWorkbook());
		}
		book.getValue().setMissingCellPolicy(Row.CREATE_NULL_AS_BLANK);
		int row = 0;		
		// initialisation du workbook
		Workbook wb = book.getValue();
		// create the sheet
		String sheetName = "Colocalization Results";
		Sheet sheet = wb.getSheet(sheetName);
		if (sheet == null)
			sheet = wb.createSheet(sheetName);					
		
			Row header = sheet.createRow(0);
			header.getCell(0).setCellValue("time");			
			header.getCell(1).setCellValue("Pearson");
			header.getCell(2).setCellValue("p-value (Pearson)");
			header.getCell(3).setCellValue("log p-value");						
			header.getCell(4).setCellValue("Manders 1");					
			header.getCell(5).setCellValue("Manders 2");
			header.getCell(6).setCellValue("# MC simulations");
			header.getCell(7).setCellValue("p-value (Manders)");
			header.getCell(8).setCellValue("log p-value (Manders)");
			header.getCell(9).setCellValue("Overlap threshold T");
			header.getCell(10).setCellValue("Overlap 1 (#>T)");
			header.getCell(11).setCellValue("Overlap 2 (#>T)");						
			header.getCell(12).setCellValue("p-value (Overlap)");
			header.getCell(13).setCellValue("log p-value");			
			row++;
		
	    Sequence seq = input_sequence1.getValue();       
	   int numT = seq.getSizeT();
	   int dim = 2;
	   if (seq.getSizeZ()>1){dim=3;}
	// gestion des rois d'analyse en entr�e

			list_roi.clear();
			ROI[] roiArray = ROIs.getValue();// TODO Ou sont les ROIs???
			if (roiArray.length == 0) {
				for (int t = 0; t < seq.getSizeT(); t++) {
					ROI roi = null;

					ROI2DRectangle r = new ROI2DRectangle(seq.getBounds2D());
					for (int h = 0; h < seq.getSizeZ(); h++) {
						r.setZ(h);
						r.setT(t);
						roi = r.getUnion(roi);
					}
					list_roi.add(roi);
				}
			} else
				for (ROI roi : roiArray) {
					list_roi.add(roi);
				}

			// on teste si les dimension en c sonts compatible
			double c1 = list_roi.get(0).getPosition5D().getC();
			for (ROI r : list_roi) {
				double c = r.getPosition5D().getC();
				if ((c != c1) && (c != (-1))) {
					new AnnounceFrame("ROI channels are incompatibles");
					return;
				}
			}

			// on teste si les dimensions en temps/z sont incompatibles pour une
			// union
			boolean one_z = false;
			boolean all_z = true;

			for (ROI r : list_roi) {
				if (r.getBounds5D().isInfiniteZ() == false) {
					all_z = false;
				}
				if (r.getBounds5D().isInfiniteZ()) {
					one_z = true;
				}
			}
			// gestion de l'exception
			if (one_z == true && all_z == false) {
				new AnnounceFrame("Incompatibility in Z dimensions between ROIs");
				return;
			}
		//définition du ration pixel z/pixel x
			double ratio_zx = 1.0;
			if (seq.getSizeZ() > 1) {
				ratio_zx = seq.getPixelSizeZ() / seq.getPixelSizeX();
			}
			// init
		//on fait ensuite une boucle en temps
	   for (int t=0;t<numT;t++)
	   {
		 //computation of the cell mask at time t
		   ArrayList<ROI> roi_t = SODAblock.ROI_t(dim,list_roi,t,-1);
		   
		   if (roi_t.size()==0)
			{}
		   else{			
		//calcul du volume de la région d'étude
			   double volume_t = ROIUtil.getUnion(roi_t).getNumberOfPoints() * ratio_zx;
				if (ROIUtil.getUnion(roi_t).getBounds5D().isInfiniteZ()) {
					volume_t = volume_t * seq.getSizeZ() * ratio_zx;
				}			   
		   //Correlation computation		   
		   double[] pearson=new double[3];double[] manders=new double[4];double[] overlap=new double[4];		 		   		   
		   if (PCC.getValue()){
		   pearson = Methods_Correlation.pearson_TCL(input_sequence1.getValue(), input_sequence2.getValue(), t, roi_t);		   
		   } 
		   //overlap
		   //on selectionne les detection) ROI au temps t
		   ArrayList<ROI> spots1_t = new ArrayList<ROI>();
		   ArrayList<ROI> spots2_t = new ArrayList<ROI>();
		   for (ROI r1:ROIs_M1.getValue()){
			   if (r1.getPosition5D().getT()==t)
				   spots1_t.add(r1);
		   }
		   for (ROI r2:ROIs_M2.getValue()){
			   if (r2.getPosition5D().getT()==t)
				   spots2_t.add(r2);
		   }
		  if (M.getValue()){ 
		  manders = Methods_overlap.Manders(input_sequence1.getValue(), spots1_t, spots2_t,roi_t,MC.getValue(), t);		  
		  }
		  if (Overlap.getValue()){
		  overlap = Methods_overlap.Overlap(input_sequence1.getValue(), spots1_t, spots2_t,roi_t,MC.getValue(), t,threshold.getValue());
		  }
		   //sauvegarde workbook
		    Row ro = sheet.createRow(row);		   
		   ro.getCell(0).setCellValue(t);
		   ro.getCell(1).setCellValue(pearson[0]);
		   ro.getCell(2).setCellValue(pearson[2]);
		   ro.getCell(3).setCellValue(pearson[1]);		   
		   ro.getCell(4).setCellValue(manders[0]);
		   ro.getCell(5).setCellValue(manders[1]);
		   ro.getCell(6).setCellValue(MC.getValue());
		   ro.getCell(7).setCellValue(manders[3]);
		   ro.getCell(8).setCellValue(manders[2]);		   		   
		   ro.getCell(9).setCellValue(threshold.getValue());
		   ro.getCell(10).setCellValue(overlap[0]);
		   ro.getCell(11).setCellValue(overlap[1]);
		   ro.getCell(12).setCellValue(overlap[3]);
		   ro.getCell(13).setCellValue(overlap[2]);		   		   
		   row++;
	   }}
					
	}

}
