/*
 * Decompiled with CFR 0.152.
 */
package plugins.tboudier.watershed3D;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import icy.type.collection.array.ArrayUtil;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.image3d.regionGrowing.Watershed3D;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;

public class Watershed_3D
extends EzPlug
implements Block {
    private final EzVarDouble EZVarRad = new EzVarDouble("Radius", 2.0, 0.0, 100.0, 0.5);
    private final EzVarSequence EZSequence = new EzVarSequence("Signal");
    private final EzVarSequence EZSequence2 = new EzVarSequence("Seeds");
    private final EzVarSequence EZSequenceOut = new EzVarSequence("Watershed");
    private final EzVarDouble EZVarThSignal = new EzVarDouble("Threshold signal", 10.0, 0.0, 65535.0, 1.0);
    private final EzVarDouble EZVarThSeeds = new EzVarDouble("Threshold seeds", 100.0, 0.0, 65535.0, 1.0);

    protected void initialize() {
        this.EZVarRad.setToolTipText("The radius is used to compute seeds automatically as local maxima of the image, when no sequence is selected for seeds.");
        this.EZSequence.setToolTipText("The signal image to be processed by watershed.");
        this.EZSequence2.setToolTipText("The image containing the seeds for the watershed, if no sequence is selected, local maxima will be computed as seeds.");
        this.EZVarThSignal.setToolTipText("Only the values from the signal image above this threshold will be processed by watershed");
        this.EZVarThSeeds.setToolTipText("Only the values from the seeds image above this threshold will be used as seeds");
        super.addEzComponent((EzComponent)this.EZSequence);
        super.addEzComponent((EzComponent)this.EZSequence2);
        super.addEzComponent((EzComponent)this.EZVarThSignal);
        super.addEzComponent((EzComponent)this.EZVarThSeeds);
        super.addEzComponent((EzComponent)this.EZVarRad);
    }

    protected void execute() {
        ImageShort seedsImg;
        ImageShort signalImg;
        boolean gui;
        Sequence signal = (Sequence)this.EZSequence.getValue();
        DataType type = signal.getDataType_();
        int nbSlice = signal.getSizeZ();
        int nbPixel = signal.getSizeX() * signal.getSizeY();
        boolean bl = gui = !this.isHeadLess();
        if (type.compareTo((Enum)DataType.USHORT) == 0) {
            signalImg = new ImageShort(signal.getDataXYZAsShort(0, 0), "tmp", signal.getWidth());
        } else if (type.compareTo((Enum)DataType.UBYTE) == 0) {
            signalImg = new ImageByte(signal.getDataXYZAsByte(0, 0), "tmp", signal.getWidth());
        } else if (type.compareTo((Enum)DataType.FLOAT) == 0) {
            signalImg = new ImageFloat(signal.getDataXYZAsFloat(0, 0), "tmp", signal.getWidth());
        } else {
            float[][] arrayImg = new float[nbSlice][nbPixel];
            System.out.println("basic type " + type + " not supported; converting to float");
            for (int z = 0; z < nbSlice; ++z) {
                arrayImg[z] = (float[])ArrayUtil.arrayToFloatArray((Object)signal.getDataXY(0, z, 0), (boolean)type.isSigned());
            }
            signalImg = new ImageFloat(arrayImg, "tmp", signal.getWidth());
        }
        Sequence seeds = (Sequence)this.EZSequence2.getValue();
        if (seeds != null) {
            type = seeds.getDataType_();
            if (type.compareTo((Enum)DataType.USHORT) == 0) {
                seedsImg = new ImageShort(seeds.getDataXYZAsShort(0, 0), "tmp", signal.getWidth());
            } else if (type.compareTo((Enum)DataType.UBYTE) == 0) {
                seedsImg = new ImageByte(seeds.getDataXYZAsByte(0, 0), "tmp", signal.getWidth());
            } else if (type.compareTo((Enum)DataType.FLOAT) == 0) {
                seedsImg = new ImageFloat(seeds.getDataXYZAsFloat(0, 0), "tmp", signal.getWidth());
            } else {
                float[][] arrayImg = new float[nbSlice][nbPixel];
                System.out.println("basic type " + type + " not supported; converting to float");
                for (int z = 0; z < nbSlice; ++z) {
                    arrayImg[z] = (float[])ArrayUtil.arrayToFloatArray((Object)seeds.getDataXY(0, z, 0), (boolean)type.isSigned());
                }
                seedsImg = new ImageFloat(arrayImg, "tmp", signal.getWidth());
            }
        } else {
            seedsImg = FastFilters3D.filterImage((ImageHandler)signalImg, (int)4, (float)((Double)this.EZVarRad.getValue()).floatValue(), (float)((Double)this.EZVarRad.getValue()).floatValue(), (float)((Double)this.EZVarRad.getValue()).floatValue(), (int)0, (boolean)false);
        }
        Watershed3D water = new Watershed3D((ImageHandler)signalImg, (ImageHandler)seedsImg, ((Double)this.EZVarThSignal.getValue()).intValue(), ((Double)this.EZVarThSeeds.getValue()).intValue());
        ImageInt res = water.getWatershedImage3D();
        Sequence seqOut = new Sequence();
        VolumetricImage vol = seqOut.addVolumetricImage();
        this.createVolumeFromImageHandler((ImageHandler)res, vol);
        seqOut.setName("Watershed3D");
        seqOut.setPixelSizeX(signal.getPixelSizeX());
        seqOut.setPixelSizeY(signal.getPixelSizeY());
        seqOut.setPixelSizeZ(signal.getPixelSizeZ());
        seqOut.dataChanged();
        if (gui) {
            this.addSequence(seqOut);
        }
        this.EZSequenceOut.setValue(seqOut);
    }

    private void createVolumeFromImageHandler(ImageHandler res, VolumetricImage vol) {
        for (int z = 0; z < res.sizeZ; ++z) {
            short[] tabres = (short[])res.getArray1D(z);
            IcyBufferedImage icyimg = new IcyBufferedImage(res.sizeX, res.sizeY, (Object)tabres);
            vol.setImage(z, icyimg);
        }
    }

    public void clean() {
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Signal", (Var)this.EZSequence.getVariable());
        inputMap.add("Seeds", (Var)this.EZSequence2.getVariable());
        inputMap.add("Threshold Signal", this.EZVarThSignal.getVariable());
        inputMap.add("Threshold seeds", this.EZVarThSeeds.getVariable());
        inputMap.add("Radius", this.EZVarRad.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add((Var)this.EZSequenceOut.getVariable());
    }
}

