/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.Int1D;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.StriddenInt1D;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public class IntScalar
extends Scalar
implements IntArray {
    final int[] data;
    final int offset;
    final boolean flat;

    public IntScalar() {
        this.data = new int[1];
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public IntScalar create() {
        return new IntScalar();
    }

    public IntScalar(int[] arr, int idx) {
        this.data = arr;
        this.offset = idx;
        this.flat = idx == 0 && arr.length == 1;
        this.checkSanity();
    }

    public static IntScalar wrap(int[] arr, int idx) {
        return new IntScalar(arr, idx);
    }

    public IntScalar(int value) {
        this.data = new int[]{value};
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public final void checkSanity() {
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new IndexOutOfBoundsException("Scalar offset is out of bounds");
        }
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    final int index() {
        return this.offset;
    }

    public final int get() {
        return this.data[this.offset];
    }

    public final void set(int value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(int value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(IntGenerator generator) {
        this.data[this.offset] = generator.nextInt();
    }

    @Override
    public final void increment(int value) {
        int n = this.offset;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public final void decrement(int value) {
        int n = this.offset;
        this.data[n] = this.data[n] - value;
    }

    @Override
    public final void scale(int value) {
        int n = this.offset;
        this.data[n] = this.data[n] * value;
    }

    @Override
    public final void map(IntFunction function) {
        this.data[this.offset] = function.apply(this.data[this.offset]);
    }

    @Override
    public final void scan(IntScanner scanner) {
        scanner.initialize(this.data[this.offset]);
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public final int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public final int[] flatten(boolean forceCopy) {
        if (!forceCopy && this.flat) {
            return this.data;
        }
        return new int[]{this.data[this.offset]};
    }

    @Override
    public final int[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public int min() {
        return this.data[this.offset];
    }

    @Override
    public int max() {
        return this.data[this.offset];
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int value;
        mm[0] = value = this.data[this.offset];
        mm[1] = value;
    }

    @Override
    public int sum() {
        return this.data[this.offset];
    }

    @Override
    public double average() {
        return this.data[this.offset];
    }

    @Override
    public final ByteArray toByte() {
        return new ByteScalar((byte)this.data[this.offset]);
    }

    @Override
    public final ShortArray toShort() {
        return new ShortScalar((short)this.data[this.offset]);
    }

    @Override
    public final IntArray toInt() {
        return this;
    }

    @Override
    public final LongArray toLong() {
        return new LongScalar(this.data[this.offset]);
    }

    @Override
    public final FloatArray toFloat() {
        return new FloatScalar(this.data[this.offset]);
    }

    @Override
    public final DoubleArray toDouble() {
        return new DoubleScalar(this.data[this.offset]);
    }

    @Override
    public final Int1D as1D() {
        if (this.offset == 0) {
            return new FlatInt1D(this.data, 1);
        }
        return new StriddenInt1D(this.data, this.offset, 0, 1);
    }

    @Override
    public final void assign(ShapedArray src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        switch (src.getType()) {
            case 0: {
                this.data[this.offset] = ((ByteScalar)src).get();
                break;
            }
            case 1: {
                this.data[this.offset] = ((ShortScalar)src).get();
                break;
            }
            case 2: {
                this.data[this.offset] = ((IntScalar)src).get();
                break;
            }
            case 3: {
                this.data[this.offset] = (int)((LongScalar)src).get();
                break;
            }
            case 4: {
                this.data[this.offset] = (int)((FloatScalar)src).get();
                break;
            }
            case 5: {
                this.data[this.offset] = (int)((DoubleScalar)src).get();
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
    }

    @Override
    public final void assign(ShapedVector src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        this.data[this.offset] = (int)src.get(0);
    }

    @Override
    public final IntScalar copy() {
        return new IntScalar(this.data[this.offset]);
    }
}

