/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.mapping;

import mitiv.base.mapping.Mapping;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class DifferentiableMapping
extends Mapping {
    protected DifferentiableMapping(VectorSpace inp, VectorSpace out) {
        super(inp, out);
    }

    protected DifferentiableMapping(VectorSpace space) {
        super(space);
    }

    public void applyJacobian(Vector y, Vector x, Vector v) {
        if (!this.inputSpace.owns(y)) {
            throw new IncorrectSpaceException("Destination does not belong to the input space");
        }
        if (!this.inputSpace.owns(x)) {
            throw new IncorrectSpaceException("Variables does not belong to the input space");
        }
        if (!this.outputSpace.owns(v)) {
            throw new IncorrectSpaceException("Source does not belong to the output space");
        }
        this._applyJacobian(y, x, v);
    }

    protected abstract void _applyJacobian(Vector var1, Vector var2, Vector var3);
}

