package plugins.perrine.openimadisutilities;


import com.strandgenomics.imaging.iclient.ImageSpace;
import com.strandgenomics.imaging.iclient.ImageSpaceObject;

import icy.gui.frame.progress.AnnounceFrame;

import java.util.Iterator;

import java.util.Map;


import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;

import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarInteger;

import plugins.adufour.ezplug.EzVarText;

import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarDoubleArrayNative;



public class openimadis_annotateField extends EzPlug implements Block{



	EzVarInteger mamaguid=new EzVarInteger( "GUID from which the sequence was created");
	EzVarText annotationfield=new EzVarText("Field");

	VarDoubleArrayNative inputvalue=new VarDoubleArrayNative("Value",null);
	// for block processing
	EzVarDoubleArrayNative inputvarValue=new EzVarDoubleArrayNative("Value",null,false);



	@Override
	public void clean() {
		// TODO Auto-generated method stub

	}

	@Override
	protected void execute() {
		// TODO Auto-generated method stub
		if (!isHeadLess()){
			double[] uploadvalue=inputvarValue.getValue();
			uploadannotationstoSequence(mamaguid.getValue(), uploadvalue[0]);
		}
		else
		{
			double[] uploadvalue=inputvarValue.getValue();
			uploadannotationstoSequence(mamaguid.getValue(), uploadvalue[0]);
		}

		new AnnounceFrame("Done.");

	}

	private void uploadannotationstoSequence(final Integer mamaguid,  Double Value) {
		// TODO Auto-generated method stub

		
		
		ImageSpace ispace = ImageSpaceObject.getConnectionManager();

		com.strandgenomics.imaging.iclient.Record mamarecord = ispace.findRecordForGUID(mamaguid);
		// clean the previous one if any

		// we clean it first 
		Map<String, Object> annotations =mamarecord.getUserAnnotations();

		Iterator<String> it = annotations.keySet().iterator();

		
		while(it.hasNext())
		{
			String key = it.next();
			if (key.compareTo(annotationfield.getValue())==0){

				Object value = annotations.get(key);

				mamarecord.removeUserAnnotation(annotationfield.getValue());
				
				mamarecord.addCustomHistory("Annotation "+ annotationfield.getValue()+"=" + value+   "have been DELETED from the record by ICY client.");
			}
		}

		mamarecord.addUserAnnotation(annotationfield.getValue(), Value);
		
		mamarecord.addCustomHistory("Automatic annotation "+ annotationfield.getValue()+"=" + Value+" have been added to the record by ICY client.");
		// bonus track -> add the protocol as an attachment when headless
		
		
	

	}





	@Override
	protected void initialize() {

		addEzComponent(mamaguid);
		addEzComponent(inputvarValue);
		addEzComponent(annotationfield);



	}



	@Override
	public void declareInput(VarList inputMap) {
		// TODO Auto-generated method stub

		inputMap.add("MAMAGUID", mamaguid.getVariable());
		inputMap.add("Value", inputvarValue.getVariable());
		inputMap.add("annotationname", annotationfield.getVariable());
	}

	@Override
	public void declareOutput(VarList outputMap) {


	}




}
