/*
 * Decompiled with CFR 0.152.
 */
package plugins.ferreol.demics;

import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVectorSpace;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.mitiv.io.Icy2TiPi;
import plugins.mitiv.io.IcyImager;

public class Convolution
extends EzPlug
implements Block,
EzStoppable,
PluginBundled {
    protected EzVarSequence image;
    protected EzVarChannel imagechannel;
    protected EzVarSequence psf;
    protected EzVarChannel psfchannel;
    protected EzVarText dataSize;
    protected EzVarText outputSize;
    private EzVarInteger paddingSizeX;
    private EzVarInteger paddingSizeY;
    private int psfSizeX = 1;
    private int psfSizeY = 1;
    private int psfSizeZ = 1;
    protected EzVarSequence outputHeadlessImage = null;

    protected void initialize() {
        this.image = new EzVarSequence("Image");
        this.imagechannel = new EzVarChannel("Data channel:", (Var)this.image.getVariable(), false);
        this.psf = new EzVarSequence("PSF");
        this.psfchannel = new EzVarChannel("PSF channel:", (Var)this.psf.getVariable(), false);
        this.addEzComponent((EzComponent)this.image);
        this.addEzComponent((EzComponent)this.imagechannel);
        this.addEzComponent((EzComponent)this.psf);
        this.addEzComponent((EzComponent)this.psfchannel);
        if (this.isHeadLess()) {
            this.outputHeadlessImage = new EzVarSequence("Output Image");
        }
    }

    protected void execute() {
        Sequence seqImg = (Sequence)this.image.getValue();
        Sequence seqPSF = (Sequence)this.psf.getValue();
        int w = seqImg.getSizeX();
        int h = seqImg.getSizeY();
        int d = seqImg.getSizeZ();
        Shape myShape = d != 1 ? new Shape(w, h, d) : new Shape(w, h);
        ShapedArray imgArray = Icy2TiPi.sequenceToArray(seqImg, (Integer)this.imagechannel.getValue());
        ShapedArray psfArray = Icy2TiPi.sequenceToArray(seqPSF, (Integer)this.psfchannel.getValue());
        DoubleShapedVectorSpace space = new DoubleShapedVectorSpace(myShape);
        DoubleShapedVector xVector = space.create(imgArray);
        DoubleShapedVector y = space.create();
        mitiv.deconv.Convolution H = mitiv.deconv.Convolution.build((ShapedVectorSpace)space);
        H.setPSF(psfArray);
        H.apply((Vector)y, (Vector)xVector);
        Sequence seqY = new Sequence();
        IcyImager.show((ShapedArray)y.asShapedArray(), seqY, seqImg.getName() + "*" + seqPSF.getName(), this.isHeadLess());
        if (this.isHeadLess()) {
            if (this.outputHeadlessImage == null) {
                this.outputHeadlessImage = new EzVarSequence("Output Image");
            }
            this.outputHeadlessImage.setValue(seqY);
        }
    }

    public void clean() {
    }

    public void declareInput(VarList inputMap) {
        this.initialize();
        inputMap.add("image", (Var)this.image.getVariable());
        inputMap.add("image", this.imagechannel.getVariable());
        inputMap.add("PSF", (Var)this.psf.getVariable());
        inputMap.add("PSF", this.psfchannel.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output", (Var)this.outputHeadlessImage.getVariable());
    }

    public String getMainPluginClassName() {
        return "SimpleDEMIC";
    }
}

