/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.io;

import icy.image.IcyBufferedImage;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import java.awt.image.BufferedImage;
import mitiv.array.Array2D;
import mitiv.array.Array3D;
import mitiv.array.Array4D;
import mitiv.array.Array5D;
import mitiv.array.ArrayFactory;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;

public class Icy2TiPi {
    static final byte czt = 0;
    static final byte Czt = 1;
    static final byte cZt = 2;
    static final byte czT = 4;
    static final byte cZT = 6;
    static final byte CZt = 3;
    static final byte CzT = 5;
    static final byte CZT = 7;

    public static ShapedArray sequenceToArray(Sequence seq) {
        return Icy2TiPi.sequenceToArray(seq, -1, -1, -1);
    }

    public static ShapedArray sequenceToArray(Sequence seq, int c) {
        return Icy2TiPi.sequenceToArray(seq, c, -1, -1);
    }

    public static ShapedArray sequenceToArray(Sequence seq, int c, int t) {
        return Icy2TiPi.sequenceToArray(seq, c, -1, t);
    }

    public static ShapedArray sequenceToArray(Sequence seq, int c, int z, int t) {
        Object data;
        switch (seq.getDataType_()) {
            case UBYTE: {
                seq = SequenceUtil.convertToType((Sequence)seq, (DataType)DataType.SHORT, (boolean)false);
                break;
            }
            case USHORT: {
                seq = SequenceUtil.convertToType((Sequence)seq, (DataType)DataType.INT, (boolean)false);
                break;
            }
            case UINT: {
                seq = SequenceUtil.convertToType((Sequence)seq, (DataType)DataType.LONG, (boolean)false);
                break;
            }
            case ULONG: {
                seq = SequenceUtil.convertToType((Sequence)seq, (DataType)DataType.DOUBLE, (boolean)false);
                break;
            }
        }
        int nx = seq.getSize(DimensionId.X);
        int ny = seq.getSize(DimensionId.Y);
        int nz = seq.getSize(DimensionId.Z);
        int nc = seq.getSize(DimensionId.C);
        int nt = seq.getSize(DimensionId.T);
        byte cztSelect = 0;
        int[] dims = new int[]{1, 1, 1, 1, 1};
        int ndims = 0;
        if (nx > 1) {
            dims[ndims] = nx;
            ++ndims;
        }
        if (ny > 1) {
            dims[ndims] = ny;
            ++ndims;
        }
        if (c < 0) {
            if (nc > 1) {
                dims[ndims] = nc;
                ++ndims;
            }
        } else if (c < nc) {
            cztSelect = (byte)(cztSelect | 1);
        } else {
            throw new IllegalArgumentException("Requested channel unavailable");
        }
        if (z < 0) {
            if (nz > 1) {
                dims[ndims] = nz;
                ++ndims;
            }
        } else if (z < nz) {
            cztSelect = (byte)(cztSelect | 2);
        } else {
            throw new IllegalArgumentException("Requested z unavailable");
        }
        if (t < 0) {
            if (nt > 1) {
                dims[ndims] = nt;
                ++ndims;
            }
        } else if (t < nt) {
            cztSelect = (byte)(cztSelect | 4);
        } else {
            throw new IllegalArgumentException("Requested z unavailable");
        }
        int[] newdims = new int[ndims];
        for (int i = 0; i < ndims; ++i) {
            newdims[i] = dims[i];
        }
        Shape shape = new Shape(newdims);
        switch (cztSelect) {
            case 0: {
                data = seq.getDataCopyXYCZT();
                break;
            }
            case 1: {
                data = seq.getDataCopyXYZT(c);
                break;
            }
            case 2: {
                throw new IllegalArgumentException("seq.getDataCopyXYCT(z) is missing, ask Stephane for it");
            }
            case 4: {
                data = seq.getDataCopyXYCZ(t);
                break;
            }
            case 3: {
                throw new IllegalArgumentException("seq.getDataCopyXYT(c,z) is missing, ask Stephane for it");
            }
            case 5: {
                data = seq.getDataCopyXYZ(t, c);
                break;
            }
            case 6: {
                data = seq.getDataCopyXYC(t, z);
                break;
            }
            case 7: {
                data = seq.getDataCopyXY(t, z, c);
                break;
            }
            default: {
                throw new IllegalArgumentException("CZT Selection impossible");
            }
        }
        return ArrayFactory.wrap((Object)data, (Shape)shape);
    }

    public static Sequence arrayToSequence(ShapedArray array) {
        return Icy2TiPi.arrayToSequence(array, null);
    }

    public static Sequence arrayToSequence(ShapedArray array, Sequence sequence) {
        if (sequence == null) {
            sequence = new Sequence();
        }
        switch (array.getRank()) {
            case 1: {
                sequence.setImage(0, 0, (BufferedImage)new IcyBufferedImage(array.getDimension(0), 1, array.flatten(), true, false));
                sequence.setImage(0, 0, (BufferedImage)new IcyBufferedImage(array.getDimension(0), 1, array.flatten(), true, false));
                break;
            }
            case 2: {
                sequence.setImage(0, 0, (BufferedImage)new IcyBufferedImage(array.getDimension(0), array.getDimension(1), array.flatten(), true, false));
                break;
            }
            case 3: {
                for (int j = 0; j < array.getDimension(2); ++j) {
                    sequence.setImage(0, j, (BufferedImage)new IcyBufferedImage(array.getDimension(0), array.getDimension(1), ((Array3D)array).slice(j).flatten(), true, false));
                }
                break;
            }
            case 4: {
                for (int k = 0; k < array.getDimension(3); ++k) {
                    for (int j = 0; j < array.getDimension(2); ++j) {
                        sequence.setImage(k, j, (BufferedImage)new IcyBufferedImage(array.getDimension(0), array.getDimension(1), ((Array4D)array).slice(k).slice(j).flatten(), true, false));
                    }
                }
            }
            default: {
                throw new IllegalArgumentException(" arrayToSequence can convert only 1D to 4D arrays");
            }
        }
        return sequence;
    }

    public static Sequence arrayToSequence(ShapedArray array, int channelIndex, Sequence sequence) {
        if (channelIndex < 0) {
            return Icy2TiPi.arrayToSequence(array, sequence);
        }
        if (channelIndex > array.getRank()) {
            throw new IllegalArgumentException(" The channel index cannot be larger than the array rank");
        }
        if (sequence == null) {
            sequence = new Sequence();
        }
        int[] newdims = new int[array.getRank() - 1];
        int k = 0;
        int n = 0;
        while (k < array.getRank() - 1) {
            if (n != channelIndex) {
                newdims[k] = array.getDimension(n);
                ++k;
            }
            ++n;
        }
        double[][] t = new double[array.getDimension(channelIndex)][newdims[0] * newdims[1]];
        switch (array.getRank() - 1) {
            case 1: {
                for (n = 0; n < array.getDimension(channelIndex); ++n) {
                    t[n] = ((Array2D)array).slice(n, channelIndex).toDouble().flatten();
                }
                sequence.setImage(0, 0, (BufferedImage)new IcyBufferedImage(newdims[0], 1, (Object[])t, true, false));
                break;
            }
            case 2: {
                for (n = 0; n < array.getDimension(channelIndex); ++n) {
                    t[n] = ((Array3D)array).slice(n, channelIndex).toDouble().flatten();
                }
                sequence.setImage(0, 0, (BufferedImage)new IcyBufferedImage(newdims[0], newdims[1], (Object[])t, true, false));
                break;
            }
            case 3: {
                for (int j = 0; j < newdims[2]; ++j) {
                    for (int n2 = 0; n2 < array.getDimension(channelIndex); ++n2) {
                        t[n2] = ((Array4D)array).slice(n2, channelIndex).slice(j).toDouble().flatten();
                    }
                    sequence.setImage(0, j, (BufferedImage)new IcyBufferedImage(newdims[0], newdims[1], (Object[])t, true, false));
                }
                break;
            }
            case 4: {
                for (int k2 = 0; k2 < array.getDimension(3); ++k2) {
                    for (int j = 0; j < array.getDimension(2); ++j) {
                        for (int n3 = 0; n3 < array.getDimension(channelIndex); ++n3) {
                            t[n3] = ((Array5D)array).slice(n3, channelIndex).slice(k2).slice(j).toDouble().flatten();
                        }
                        sequence.setImage(k2, j, (BufferedImage)new IcyBufferedImage(newdims[0], newdims[1], (Object[])t, true, false));
                    }
                }
            }
            default: {
                throw new IllegalArgumentException(" arrayToSequence can convert only 1D to 4D arrays");
            }
        }
        return sequence;
    }
}

