package plugins.adufour.hcs.data;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import icy.util.StringUtil;

public class Well {
	public enum Shape {
		Circle(new Ellipse2D.Double()), 
		Square(new Rectangle2D.Double()),
		Rectangle(new Rectangle2D.Double());

		public final RectangularShape wellShape;

		private Shape(RectangularShape shape) {
			this.wellShape = shape;
			// Assign default values in case none are available
			shape.setFrame(0, 0, 5000, 5000);
		}

		public void setDimension(double width, double height) {
			wellShape.setFrame(0, 0, width, height);
		}
	}

	/**
	 * Well shape (used for display)
	 */
	final Shape shape;

	final int row;

	final int col;

	/**
	 * Map storing the field per ID
	 */
	private final Map<Integer, Field> fields = new LinkedHashMap<>();

	public Well(Shape shape, int row, int col) {
		this.row = row;
		this.col = col;
		this.shape = shape;
	}

	public String getAlphanumericID() {
		char alphaRow = 'A';
		alphaRow += row;
		return alphaRow + StringUtil.toString(col + 1, 2);
	}

	public void addField(Field field) {
		fields.put(field.getID(), field);
	}

	public boolean isEmpty() {
		return fields.isEmpty();
	}

	public Shape getShape() {
		return shape;
	}

	public int getColumn() {
		return col;
	}

	public int getRow() {
		return row;
	}

	public Field getField(int ID) {
		return fields.get(ID);
	}

	public Collection<Field> getFields() {
		return fields.values();
	}

	public Iterator<Field> fieldIterator() {
		return fields.values().iterator();
	}
}