package plugins.tprovoost.sequenceblocks.loop;

import icy.file.SequenceFileImporter;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import plugins.adufour.blocks.lang.Batch;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;

/**
 * Base abstract class for {@link SequenceFileImporter} batch loop.
 * 
 * @author Stephane
 */
public abstract class SequenceFileImporterBatch extends Batch implements SequenceBlock, PluginLibrary, PluginBundled
{
    // important to not initialize and create them in getBatchSource() and getBatchElement()
    protected Var<PositionedSequenceFileImporter> positionedImporter;
    protected Var<PositionedSequenceFileImporter> element;

    // internal
    protected int limit;

    @Override
    public Var<PositionedSequenceFileImporter> getBatchSource()
    {
        // initialize variable if needed
        if (positionedImporter == null)
            positionedImporter = new Var<PositionedSequenceFileImporter>("Importer",
                    PositionedSequenceFileImporter.class);

        return positionedImporter;
    }

    @Override
    public Var<PositionedSequenceFileImporter> getBatchElement()
    {
        // initialize element if needed
        if (element == null)
            element = new Var<PositionedSequenceFileImporter>("Loop importer", PositionedSequenceFileImporter.class);

        return element;
    }

    @Override
    public void initializeLoop()
    {
        final PositionedSequenceFileImporter value = positionedImporter.getValue();

        if (value == null)
            throw new VarException(positionedImporter, "Input importer is null !");

        final SequenceFileImporter imp = value.importer;

        if (imp.getOpened() == null)
            throw new VarException(positionedImporter, "Importer is not opened !");

        // init element with a copy of current positioned importer
        element.setValue(new PositionedSequenceFileImporter(value));
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
