package plugins.ferreol.PropagationLab;

import icy.plugin.interface_.PluginBundled;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.util.OMEUtil;
import loci.formats.ome.OMEXMLMetadataImpl;
import mitiv.array.Double3D;
import mitiv.base.Shape;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.ferreol.demics.ToolTipText;
import plugins.mitiv.io.IcyImager;

public class PlaneWave extends EzPlug implements Block, PluginBundled {

    protected EzVarInteger     npix;     // size of the output (npix x npix)

    // optical parameters
    protected EzVarDouble     dxy_nm;  //  pixels size in (x,y) in nm
    protected EzVarDouble     lambda;         //  wavelength
    protected EzVarDouble     ni;             //  refractive index of the immersion index
    protected EzVarDouble     anglex , angley;

    protected Shape outputShape;

    private EzVarSequence   outputWave=null;

    protected Sequence outputSequence;

    int Nx, Ny;

    @Override
    protected void initialize() {
        // TODO Auto-generated by Icy4Eclipse

        if (!isHeadLess()) {
            getUI().setParametersIOVisible(false);
            //    getUI().setActionPanelVisible(false);
        }
        npix = new EzVarInteger("num pixel", 128,1, Integer.MAX_VALUE ,1);
        dxy_nm = new EzVarDouble("dxy(nm):",64.5,0., Double.MAX_VALUE,1.);
        lambda = new EzVarDouble( "\u03BB(nm):",540.,10.,15000.,5);
        ni = new EzVarDouble("refractive index:",1.,1.,2.,0.1);
        anglex = new EzVarDouble("angle x:",0.,-90,90,5);
        angley = new EzVarDouble("angle y:",0.,-90,90,5);

        addEzComponent(npix);
        npix.setToolTipText("number of pixels along each dimension");
        addEzComponent(dxy_nm);
        dxy_nm.setToolTipText(ToolTipText.doubleDxy);
        addEzComponent(lambda);
        lambda.setToolTipText(ToolTipText.doubleLambda);
        addEzComponent(ni);
        ni.setToolTipText(ToolTipText.doubleNi);
        addEzComponent(anglex);
        anglex.setToolTipText("incidence angle along the first dimension");
        addEzComponent(angley);
        angley.setToolTipText("incidence angle along the first dimension");
        if (isHeadLess()) {
            outputWave = new EzVarSequence("generated plane wave");
        }

    }

    @Override
    protected void execute() {
        // TODO Auto-generated by Icy4Eclipse
        Nx = Ny =  npix.getValue(true);
        outputShape = new Shape(2,Nx, Ny);
        Double3D   imgArray =  Double3D.create(outputShape);
        for (int nx = 0; nx < Nx; nx++) {
            for (int ny = 0; ny < Ny; ny++) {
                double phase = ni.getValue()*2.*Math.PI / lambda.getValue()*dxy_nm.getValue()*(nx*Math.sin(anglex.getValue()/180*Math.PI)+ny*Math.sin(angley.getValue()/180*Math.PI));
                imgArray.set(0, nx, ny, Math.cos(phase));
                imgArray.set(1, nx, ny, Math.sin(phase));
            }
        }

        outputSequence  = new Sequence();

        ome.xml.meta.OMEXMLMetadata newMetdat = MetaDataUtil.createMetadata("plane wave");
        newMetdat.setPixelsPhysicalSizeX(OMEUtil.getLength(dxy_nm.getValue()*1E-3), 0);
        newMetdat.setPixelsPhysicalSizeY(OMEUtil.getLength(dxy_nm.getValue()*1E-3), 0);
        newMetdat.setLaserWavelength(OMEUtil.getLength(lambda.getValue()*1E-3), 0, 0);
        newMetdat.setObjectiveSettingsRefractiveIndex(ni.getValue(), 0 );
        outputSequence.setMetaData((OMEXMLMetadataImpl) newMetdat); //FIXME may not working now

        IcyImager.show(imgArray,outputSequence,0,"Incident wave" ,isHeadLess() );
        outputSequence.setChannelName(0, "Real part");
        outputSequence.setChannelName(1, "Imaginary part");

        if (isHeadLess()) {
            outputWave.setValue(outputSequence);
        }

    }

    @Override
    public void clean() {
        // TODO Auto-generated by Icy4Eclipse
    }

    /* (non-Javadoc)
     * @see plugins.adufour.blocks.lang.Block#declareInput(plugins.adufour.blocks.util.VarList)
     */
    @Override
    public void declareInput(VarList inputMap) {
        // TODO Auto-generated method stub
        initialize();
        inputMap.add("dxy", dxy_nm.getVariable());
        inputMap.add("npix", npix.getVariable());
        inputMap.add("lambda", lambda.getVariable());
        inputMap.add("refractive index", ni.getVariable());
        inputMap.add("angle X", anglex.getVariable());
        inputMap.add("angle Y", angley.getVariable());



    }

    /* (non-Javadoc)
     * @see plugins.adufour.blocks.lang.Block#declareOutput(plugins.adufour.blocks.util.VarList)
     */
    @Override
    public void declareOutput(VarList outputMap) {
        // TODO Auto-generated method stub
        outputMap.add("outputWave", outputWave.getVariable());
    }


    @Override
    public String getMainPluginClassName() {
        return "PropagationLab";
    }
}
